/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rest.client.LocalSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.exceptions.RestException;
import io.confluent.schema.exporter.client.rest.entities.CreateExporterRequest;
import io.confluent.schema.exporter.client.rest.entities.ExporterInfo;
import io.confluent.schema.exporter.client.rest.entities.ExporterStatus;
import io.confluent.schema.exporter.client.rest.entities.UpdateExporterRequest;
import io.confluent.schema.exporter.licensing.LicenseEnforcementService;
import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterClientConfig;
import io.confluent.schema.exporter.storage.SchemaExporterClientConfigEncoder;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterServerConfig;
import io.confluent.schema.exporter.storage.SchemaExporterStartingTask;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import io.confluent.schema.exporter.storage.SchemaExporterStatusCacheUpdateHandler;
import io.confluent.schema.exporter.storage.exceptions.AlreadyExistsException;
import io.confluent.schema.exporter.storage.exceptions.AlreadyRunningException;
import io.confluent.schema.exporter.storage.exceptions.AlreadyStartingException;
import io.confluent.schema.exporter.storage.exceptions.NotPausedException;
import io.confluent.schema.exporter.storage.exceptions.TooManyExportersException;
import io.confluent.schema.exporter.storage.serialization.SchemaExporterInfoSerde;
import io.confluent.schema.exporter.storage.serialization.SchemaExporterSerde;
import io.confluent.schema.exporter.storage.serialization.SchemaExporterStatusSerde;
import io.confluent.schema.exporter.util.StripedExecutorService;
import io.confluent.schema.exporter.web.rest.exceptions.ExporterErrors;
import io.kcache.Cache;
import io.kcache.CacheUpdateHandler;
import io.kcache.KafkaCache;
import io.kcache.KafkaCacheConfig;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import io.kcache.exceptions.CacheInitializationException;
import io.kcache.utils.Caches;
import io.kcache.utils.InMemoryCache;
import jakarta.ws.rs.core.UriBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaExporterService
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterService.class);
    public static final String X_FORWARD_HEADER = "X-Forward";
    public static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    private static final TypeReference<SchemaExporter> SCHEMA_EXPORTER_TYPE = new TypeReference<SchemaExporter>(){};
    private static final TypeReference<Void> VOID_TYPE = new TypeReference<Void>(){};
    private final KafkaSchemaRegistry schemaRegistry;
    private final SchemaExporterServerConfig config;
    private final SchemaExporterClientConfigEncoder encoder;
    private final int exporterAutoresumeInterval;
    private final int exporterDefaultLimit;
    private final int exporterMaxLimit;
    final Cache<SchemaExporter, SchemaExporterInfo> exporterInfos;
    final Cache<SchemaExporter, SchemaExporterStatus> exporterStatuses;
    private final Map<String, Lock> tenantToLock = new ConcurrentHashMap<String, Lock>();
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final LicenseEnforcementService licenseEnforcementService;
    private final StripedExecutorService startingStripedExecutor;
    private final StripedExecutorService runningStripedExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    public final MetricsManager metricsManager;

    @Inject
    public SchemaExporterService(SchemaRegistry schemaRegistry, MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
        try {
            this.schemaRegistry = (KafkaSchemaRegistry)schemaRegistry;
            this.config = new SchemaExporterServerConfig(schemaRegistry.config().originalProperties());
            this.exporterAutoresumeInterval = this.config.getExporterAutoresumeInterval();
            this.exporterDefaultLimit = this.config.getInt("exporter.search.default.limit");
            this.exporterMaxLimit = this.config.getInt("exporter.search.max.limit");
            this.encoder = new SchemaExporterClientConfigEncoder(this.config);
            this.exporterStatuses = this.createCache(new SchemaExporterSerde(), new SchemaExporterStatusSerde(), this.config.exporterStateTopic(), new SchemaExporterStatusCacheUpdateHandler(this.metricsManager));
            this.exporterInfos = this.createCache(new SchemaExporterSerde(), new SchemaExporterInfoSerde(), this.config.exporterConfigTopic(), null);
            LocalSchemaRegistryClient localClient = new LocalSchemaRegistryClient(this.schemaRegistry, Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider()));
            this.licenseEnforcementService = new LicenseEnforcementService((SchemaRegistryClient)localClient);
            this.startingStripedExecutor = new StripedExecutorService(this.config.exporterNumThreads());
            this.runningStripedExecutor = new StripedExecutorService(this.config.exporterNumThreads());
            this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        }
        catch (RestConfigException e) {
            this.metricsManager.exporterServiceStartFailures.increment(1L);
            throw new IllegalArgumentException("Could not instantiate SchemaExporterService", e);
        }
    }

    public KafkaSchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    protected <K, V> Cache<K, V> createCache(Serde<K> keySerde, Serde<V> valueSerde, String topic, CacheUpdateHandler<K, V> cacheUpdateHandler) throws CacheInitializationException {
        Properties props = this.getKafkaCacheProperties(topic);
        KafkaCacheConfig config = new KafkaCacheConfig((Map)props);
        Cache kafkaCache = Caches.concurrentCache((Cache)new KafkaCache(config, keySerde, valueSerde, cacheUpdateHandler, (Cache)new InMemoryCache()));
        this.getSchemaRegistry().addLeaderChangeListener(isLeader -> {
            if (isLeader.booleanValue()) {
                kafkaCache.reset();
                kafkaCache.sync();
            }
        });
        return kafkaCache;
    }

    private Properties getKafkaCacheProperties(String topic) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.schemaRegistry.config().originalProperties());
        Set<String> keys = props.stringPropertyNames();
        for (String key : keys) {
            String newKey;
            if (!key.startsWith("kafkastore.") || keys.contains(newKey = key.replace("kafkastore", "kafkacache"))) continue;
            props.put(newKey, props.get(key));
        }
        props.put("kafkacache.topic", topic);
        return props;
    }

    public Cache<SchemaExporter, SchemaExporterInfo> exporterInfos() {
        return this.exporterInfos;
    }

    public Cache<SchemaExporter, SchemaExporterStatus> exporterStatuses() {
        return this.exporterStatuses;
    }

    public SchemaExporterServerConfig config() {
        return this.config;
    }

    public SchemaExporterClientConfigEncoder encoder() {
        return this.encoder;
    }

    public List<String> getSchemaRegistryUrls(Map<String, ?> properties) {
        if (properties == null) {
            throw new ConfigException("Missing exporter properties");
        }
        Object urls = properties.get(SCHEMA_REGISTRY_URL);
        if (urls == null) {
            throw new ConfigException("Missing exporter property: schema.registry.url");
        }
        return Arrays.asList(urls.toString().split("\\s*,\\s*"));
    }

    public Map<String, String> getHttpHeaders(Map<String, ?> properties) {
        return Collections.emptyMap();
    }

    @PostConstruct
    public void init() {
        if (!this.initialized.get()) {
            this.exporterInfos.init();
            this.exporterStatuses.init();
            boolean isInitialized = this.initialized.compareAndSet(false, true);
            if (!isInitialized) {
                log.error("Exporter service was already initialized");
                throw new IllegalStateException("Exporter service was already initialized");
            }
            this.initLatch.countDown();
            if (this.isLeader()) {
                this.submitStartingTasks();
            }
            this.getSchemaRegistry().addLeaderChangeListener(isLeader -> {
                if (isLeader.booleanValue()) {
                    this.submitStartingTasks();
                }
            });
            this.scheduledExecutor.scheduleAtFixedRate(this::submitRetriablePausedTasks, this.exporterAutoresumeInterval, this.exporterAutoresumeInterval, TimeUnit.SECONDS);
        }
    }

    private void submitStartingTasks() {
        try (KeyValueIterator iter = this.exporterInfos.all();){
            log.info("Processing exporters");
            while (iter.hasNext()) {
                KeyValue kv = (KeyValue)iter.next();
                SchemaExporter exporter = (SchemaExporter)kv.key;
                SchemaExporterInfo info = (SchemaExporterInfo)kv.value;
                String name = info.getName();
                SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
                log.info("Processing {}, state {}, offset {}", new Object[]{exporter, status.getState(), status.getOffset()});
                if (status.getState() != SchemaExporterStatus.State.STARTING) continue;
                this.submit(new SchemaExporterStartingTask(this, exporter, this.metricsManager));
            }
            log.info("Done processing exporters");
        }
        catch (Throwable e) {
            log.error("Error starting exporter tasks", e);
            this.metricsManager.exporterServiceStartFailures.increment(1L);
        }
    }

    private void submitRetriablePausedTasks() {
        if (!this.isLeader()) {
            return;
        }
        try (KeyValueIterator iter = this.exporterInfos.all();){
            log.info("Resuming exporters");
            while (iter.hasNext()) {
                KeyValue kv = (KeyValue)iter.next();
                SchemaExporter exporter = (SchemaExporter)kv.key;
                SchemaExporterInfo info = (SchemaExporterInfo)kv.value;
                String name = info.getName();
                SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
                if (status.getState() != SchemaExporterStatus.State.PAUSED || status.getTrace() == null || !status.isRetriable()) continue;
                log.info("Resuming {}, state {}, offset {}", new Object[]{exporter, status.getState(), status.getOffset()});
                this.resumeExporter(exporter);
            }
            log.info("Done resuming exporters");
        }
        catch (Throwable e) {
            log.error("Error resuming exporter tasks", e);
        }
    }

    public void waitForInit() throws InterruptedException {
        this.initLatch.await();
    }

    public boolean initialized() {
        return this.initialized.get();
    }

    public boolean isLeader() {
        return this.schemaRegistry.isLeader();
    }

    private boolean isLeader(Map<String, String> headerProperties) {
        String forwardHeader = headerProperties.get(X_FORWARD_HEADER);
        return this.isLeader() && (forwardHeader == null || Boolean.parseBoolean(forwardHeader));
    }

    protected Lock lockFor(String tenant) {
        return this.tenantToLock.computeIfAbsent(tenant, k -> new ReentrantLock());
    }

    private void lock(String tenant, Map<String, String> headerProperties) {
        String forwardHeader = headerProperties.get(X_FORWARD_HEADER);
        if (forwardHeader == null || Boolean.parseBoolean(forwardHeader)) {
            this.lockFor(tenant).lock();
        }
    }

    private void unlock(String tenant) {
        if (((ReentrantLock)this.lockFor(tenant)).isHeldByCurrentThread()) {
            this.lockFor(tenant).unlock();
        }
    }

    public int normalizeExporterLimit(int suppliedLimit) {
        int limit = this.exporterDefaultLimit;
        if (suppliedLimit > 0 && suppliedLimit <= this.exporterMaxLimit) {
            limit = suppliedLimit;
        }
        return limit;
    }

    public List<String> getExporterNames() {
        String tenant = this.schemaRegistry.tenant();
        return this.getExporters(tenant).stream().map(kv -> ((SchemaExporter)kv.key).getName()).collect(Collectors.toList());
    }

    protected List<KeyValue<SchemaExporter, SchemaExporterInfo>> getExporters(String tenant) {
        ArrayList<KeyValue<SchemaExporter, SchemaExporterInfo>> result = new ArrayList<KeyValue<SchemaExporter, SchemaExporterInfo>>();
        SchemaExporter key1 = new SchemaExporter(tenant, String.valueOf('\u0000'));
        SchemaExporter key2 = new SchemaExporter(tenant, String.valueOf('\uffff'));
        try (KeyValueIterator iter = this.exporterInfos().range((Object)key1, true, (Object)key2, false);){
            while (iter.hasNext()) {
                result.add((KeyValue<SchemaExporter, SchemaExporterInfo>)((KeyValue)iter.next()));
            }
        }
        return result;
    }

    public ExporterInfo getExporterInfo(String name) {
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
        ExporterInfo.ContextType contextType = info.getContextType();
        if (contextType == null) {
            contextType = ExporterInfo.ContextType.AUTO;
        }
        String context = info.getContext();
        if (contextType == ExporterInfo.ContextType.AUTO) {
            context = SchemaExporterService.getAutoContext(this.schemaRegistry, tenant);
        }
        SchemaExporterClientConfig clientConfig = this.encoder.clientConfig(info.getConfig());
        return new ExporterInfo(name, subjects, contextType, context, info.getKekRenameFormat(), info.getSubjectRenameFormat(), clientConfig.originalsStringsWithHiddenPasswords());
    }

    protected static List<String> getSubjects(List<String> subjects) {
        return subjects == null || subjects.isEmpty() ? Collections.singletonList("*") : subjects;
    }

    protected static String getAutoContext(KafkaSchemaRegistry schemaRegistry, String tenant) {
        Object newContext = "default".equals(tenant) ? schemaRegistry.getKafkaClusterId() + "-" + schemaRegistry.getGroupId() : tenant;
        return "." + (String)newContext;
    }

    public ExporterStatus getExporterStatus(String name) {
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        ExporterStatus.State state = ExporterStatus.State.valueOf(status.getState().name());
        return new ExporterStatus(name, state, status.getOffset(), status.getTimestamp(), status.getDeksOffset(), status.getDeksTimestamp(), status.getTrace(), status.isRetriable(), status.getObjectsExported());
    }

    public SchemaExporter createExporterOrForward(CreateExporterRequest request, Map<String, String> headerProperties) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                SchemaExporter schemaExporter = this.createExporter(request);
                return schemaExporter;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                SchemaExporter schemaExporter = this.forwardCreateExporterRequestToLeader(request, headerProperties);
                return schemaExporter;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private SchemaExporter forwardCreateExporterRequestToLeader(CreateExporterRequest request, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters");
        String path = builder.build(new Object[0]).toString();
        log.debug(String.format("Forwarding create exporter request to %s", baseUrl));
        try {
            return (SchemaExporter)leaderRestService.httpRequest(path, "POST", SchemaExporterService.toJson(request), headerProperties, SCHEMA_EXPORTER_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private SchemaExporter createExporter(CreateExporterRequest request) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        String tenant = this.schemaRegistry.tenant();
        String name = request.getName();
        List<KeyValue<SchemaExporter, SchemaExporterInfo>> exporters = this.getExporters(tenant);
        if (exporters.size() >= this.config.exporterMaxExporters()) {
            throw new TooManyExportersException(name);
        }
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        if (this.exporterInfos.containsKey((Object)exporter)) {
            throw new AlreadyExistsException(name);
        }
        this.enforceLicenseCompatibility(request.getConfig());
        Map<String, String> persistentProps = this.encoder.encode(request.getConfig());
        SchemaExporterInfo info = new SchemaExporterInfo(name, request.getSubjects(), request.getContextType(), request.getContext(), request.getKekRenameFormat(), request.getSubjectRenameFormat(), persistentProps);
        SchemaExporterStatus status = SchemaExporterService.newExporterStatus(name);
        status.setState(SchemaExporterStatus.State.STARTING);
        this.exporterInfos.put((Object)exporter, (Object)info);
        this.exporterStatuses.put((Object)exporter, (Object)status);
        this.submit(new SchemaExporterStartingTask(this, exporter, this.metricsManager));
        this.metricsManager.getTenantMetrics((String)tenant).exporterStatusGauges.addExporterStatus(exporter, status);
        return exporter;
    }

    public SchemaExporter putExporterOrForward(String name, UpdateExporterRequest request, Map<String, String> headerProperties) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                SchemaExporter schemaExporter = this.putExporter(name, request);
                return schemaExporter;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                SchemaExporter schemaExporter = this.forwardPutExporterRequestToLeader(name, request, headerProperties);
                return schemaExporter;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private SchemaExporter forwardPutExporterRequestToLeader(String name, UpdateExporterRequest request, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}");
        String path = builder.build(new Object[]{name}).toString();
        log.debug(String.format("Forwarding put exporter request to %s", baseUrl));
        try {
            return (SchemaExporter)leaderRestService.httpRequest(path, "PUT", SchemaExporterService.toJson(request), headerProperties, SCHEMA_EXPORTER_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private SchemaExporter putExporter(String name, UpdateExporterRequest request) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        if (status.getState() == SchemaExporterStatus.State.RUNNING || status.getState() == SchemaExporterStatus.State.STARTING) {
            throw new NotPausedException();
        }
        List<String> subjects = request.getOptionalSubjects() != null ? request.getSubjects() : info.getSubjects();
        ExporterInfo.ContextType contextType = request.getOptionalContextType() != null ? request.getContextType() : info.getContextType();
        String context = request.getOptionalContext() != null ? request.getContext() : info.getContext();
        String subjectRenameFormat = request.getOptionalSubjectRenameFormat() != null ? request.getSubjectRenameFormat() : info.getSubjectRenameFormat();
        String kekRenameFormat = request.getOptionalKekRenameFormat() != null ? request.getKekRenameFormat() : info.getKekRenameFormat();
        Map<String, String> persistentProps = request.getOptionalConfig() != null ? this.encoder.encode(request.getConfig()) : info.getConfig();
        SchemaExporterInfo newInfo = new SchemaExporterInfo(name, subjects, contextType, context, kekRenameFormat, subjectRenameFormat, persistentProps);
        this.exporterInfos.put((Object)exporter, (Object)newInfo);
        this.metricsManager.getTenantMetrics((String)tenant).exporterStatusGauges.addExporterStatus(exporter, status);
        return exporter;
    }

    public SchemaExporter putExporterConfigOrForward(String name, Map<String, String> config, Map<String, String> headerProperties) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                SchemaExporter schemaExporter = this.putExporterConfig(name, config);
                return schemaExporter;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                SchemaExporter schemaExporter = this.forwardPutExporterConfigRequestToLeader(name, config, headerProperties);
                return schemaExporter;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private SchemaExporter forwardPutExporterConfigRequestToLeader(String name, Map<String, String> config, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/config");
        String path = builder.build(new Object[]{name}).toString();
        log.debug(String.format("Forwarding put exporter config request to %s", baseUrl));
        try {
            return (SchemaExporter)leaderRestService.httpRequest(path, "PUT", SchemaExporterService.toJson(config), headerProperties, SCHEMA_EXPORTER_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the create exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private SchemaExporter putExporterConfig(String name, Map<String, String> config) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        if (status.getState() == SchemaExporterStatus.State.RUNNING || status.getState() == SchemaExporterStatus.State.STARTING) {
            throw new NotPausedException();
        }
        this.enforceLicenseCompatibility(config);
        Map<String, String> persistentProps = this.encoder.encode(config);
        SchemaExporterInfo newInfo = new SchemaExporterInfo(name, info.getSubjects(), info.getContextType(), info.getContext(), info.getKekRenameFormat(), info.getSubjectRenameFormat(), persistentProps);
        this.exporterInfos.put((Object)exporter, (Object)newInfo);
        this.metricsManager.getTenantMetrics((String)tenant).exporterStatusGauges.addExporterStatus(exporter, status);
        return exporter;
    }

    public SchemaExporter pauseExporterOrForward(String name, Map<String, String> headerProperties) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                SchemaExporter schemaExporter = this.pauseExporter(name);
                return schemaExporter;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                SchemaExporter schemaExporter = this.forwardPauseExporterRequestToLeader(name, headerProperties);
                return schemaExporter;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private SchemaExporter forwardPauseExporterRequestToLeader(String name, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/pause");
        String path = builder.build(new Object[]{name}).toString();
        log.debug(String.format("Forwarding pause exporter request to %s", baseUrl));
        try {
            return (SchemaExporter)leaderRestService.httpRequest(path, "PUT", null, headerProperties, SCHEMA_EXPORTER_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the pause exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private SchemaExporter pauseExporter(String name) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        if (status.getState() == SchemaExporterStatus.State.STARTING) {
            throw new AlreadyStartingException(name);
        }
        status.setState(SchemaExporterStatus.State.PAUSED);
        this.exporterStatuses.put((Object)exporter, (Object)status);
        this.metricsManager.getTenantMetrics((String)tenant).exporterStatusGauges.addExporterStatus(exporter, status);
        return exporter;
    }

    public SchemaExporter resumeExporterOrForward(String name, Map<String, String> headerProperties) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                SchemaExporter schemaExporter = this.resumeExporter(name);
                return schemaExporter;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                SchemaExporter schemaExporter = this.forwardResumeExporterRequestToLeader(name, headerProperties);
                return schemaExporter;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private SchemaExporter forwardResumeExporterRequestToLeader(String name, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/resume");
        String path = builder.build(new Object[]{name}).toString();
        log.debug(String.format("Forwarding resume exporter request to %s", baseUrl));
        try {
            return (SchemaExporter)leaderRestService.httpRequest(path, "PUT", null, headerProperties, SCHEMA_EXPORTER_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the resume exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private SchemaExporter resumeExporter(String name) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        return this.resumeExporter(exporter);
    }

    private SchemaExporter resumeExporter(SchemaExporter exporter) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        String name = exporter.getName();
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        if (status.getState() == SchemaExporterStatus.State.RUNNING) {
            throw new AlreadyRunningException();
        }
        status.setState(SchemaExporterStatus.State.STARTING);
        status.setTrace(null);
        status.setRetriable(false);
        this.exporterStatuses.put((Object)exporter, (Object)status);
        String tenant = this.schemaRegistry.tenant();
        this.submit(new SchemaExporterStartingTask(this, exporter, this.metricsManager));
        this.metricsManager.getTenantMetrics((String)tenant).exporterStatusGauges.addExporterStatus(exporter, status);
        return exporter;
    }

    public SchemaExporter resetExporterOrForward(String name, Map<String, String> headerProperties) throws SchemaRegistryException {
        String tenant = this.schemaRegistry.tenant();
        this.lock(tenant, headerProperties);
        try {
            if (this.isLeader(headerProperties)) {
                SchemaExporter schemaExporter = this.resetExporter(name);
                return schemaExporter;
            }
            if (this.schemaRegistry.leaderIdentity() != null) {
                SchemaExporter schemaExporter = this.forwardResetExporterRequestToLeader(name, headerProperties);
                return schemaExporter;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.unlock(tenant);
        }
    }

    private SchemaExporter forwardResetExporterRequestToLeader(String name, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}/reset");
        String path = builder.build(new Object[]{name}).toString();
        log.debug(String.format("Forwarding reset exporter request to %s", baseUrl));
        try {
            return (SchemaExporter)leaderRestService.httpRequest(path, "PUT", null, headerProperties, SCHEMA_EXPORTER_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the reset exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private SchemaExporter resetExporter(String name) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            return null;
        }
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        if (status.getState() == SchemaExporterStatus.State.RUNNING || status.getState() == SchemaExporterStatus.State.STARTING) {
            throw new NotPausedException();
        }
        status.setOffset(-1L);
        status.setTimestamp(0L);
        status.setDeksOffset(-1L);
        status.setDeksTimestamp(0L);
        status.setObjectsExported(0L);
        this.exporterStatuses.put((Object)exporter, (Object)status);
        this.metricsManager.getTenantMetrics((String)tenant).exporterStatusGauges.addExporterStatus(exporter, status);
        return exporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExporterOrForward(String name, Map<String, String> headerProperties) throws SchemaRegistryException {
        block5: {
            String tenant = this.schemaRegistry.tenant();
            this.lock(tenant, headerProperties);
            try {
                if (this.isLeader(headerProperties)) {
                    this.deleteExporter(name);
                    break block5;
                }
                if (this.schemaRegistry.leaderIdentity() != null) {
                    this.forwardDeleteExporterRequestToLeader(name, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Request failed since leader is unknown");
            }
            finally {
                this.unlock(tenant);
            }
        }
    }

    private void forwardDeleteExporterRequestToLeader(String name, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        RestService leaderRestService = this.schemaRegistry.leaderRestService();
        UrlList baseUrl = leaderRestService.getBaseUrls();
        UriBuilder builder = UriBuilder.fromPath((String)"/exporters/{name}");
        String path = builder.build(new Object[]{name}).toString();
        log.debug(String.format("Forwarding delete exporter request to %s", baseUrl));
        try {
            leaderRestService.httpRequest(path, "DELETE", null, headerProperties, VOID_TYPE);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the reset exporter request to %s", baseUrl), (Throwable)e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void deleteExporter(String name) throws SchemaRegistryException {
        this.exporterInfos.sync();
        this.exporterStatuses.sync();
        String tenant = this.schemaRegistry.tenant();
        SchemaExporter exporter = new SchemaExporter(tenant, name);
        SchemaExporterInfo info = (SchemaExporterInfo)this.exporterInfos.get((Object)exporter);
        if (info == null) {
            throw ExporterErrors.exporterNotFoundException(name);
        }
        SchemaExporterStatus status = (SchemaExporterStatus)this.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
        if (status.getState() == SchemaExporterStatus.State.RUNNING || status.getState() == SchemaExporterStatus.State.STARTING) {
            throw new NotPausedException();
        }
        this.exporterStatuses.remove((Object)exporter);
        this.exporterInfos.remove((Object)exporter);
        this.metricsManager.getTenantMetrics(tenant).deleteExporter(exporter);
    }

    public Future<?> submit(AbstractSchemaExporterTask task) {
        if (task instanceof SchemaExporterStartingTask) {
            log.info("Submitting starting task for {}", (Object)task.exporter());
            return this.startingStripedExecutor.submit(task);
        }
        log.info("Submitting running task for {}", (Object)task.exporter());
        return this.runningStripedExecutor.submit(task);
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        log.info("Shutting down exporter service");
        if (this.exporterStatuses != null) {
            this.exporterStatuses.close();
        }
        if (this.exporterInfos != null) {
            this.exporterInfos.close();
        }
        if (this.startingStripedExecutor != null) {
            this.startingStripedExecutor.shutdown();
        }
        if (this.runningStripedExecutor != null) {
            this.runningStripedExecutor.shutdown();
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    protected static SchemaExporterStatus newExporterStatus(String name) {
        return new SchemaExporterStatus(name, SchemaExporterStatus.State.PAUSED, -1L, 0L, -1L, 0L, null, false, 0L);
    }

    private static byte[] toJson(Object o) throws JsonProcessingException {
        return JacksonMapper.INSTANCE.writeValueAsBytes(o);
    }

    private void enforceLicenseCompatibility(Map<String, String> config) throws SchemaRegistryException {
        try {
            SchemaRegistryClient destinationClient = SchemaExporterService.createDestinationClient(config, this.schemaRegistry);
            this.licenseEnforcementService.enforceLicenseCompatibility(destinationClient);
        }
        catch (Exception e) {
            log.error("License enforcement failed: {}", (Object)e.getMessage(), (Object)e);
            throw new SchemaRegistryException("License enforcement failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static SchemaRegistryClient createDestinationClient(Map<String, String> config, KafkaSchemaRegistry schemaRegistry) throws SchemaRegistryException {
        String urls = config.get(SCHEMA_REGISTRY_URL);
        if (urls == null) {
            throw new SchemaRegistryException("Missing exporter config: schema.registry.url");
        }
        List<String> urlList = Arrays.asList(urls.split("\\s*,\\s*"));
        List<SchemaProvider> providers = Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider());
        if (urlList.size() == 1 && urlList.get(0).startsWith("local:///")) {
            log.debug("Creating LocalSchemaRegistryClient for local destination");
            return new LocalSchemaRegistryClient(schemaRegistry, providers);
        }
        log.debug("Creating CachedSchemaRegistryClient for remote destination");
        return new CachedSchemaRegistryClient(urlList, 1000, providers, config);
    }
}

