/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.dekregistry.client.DekRegistryClient;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.schema.exporter.metrics.MetricTags;
import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.io.IOException;
import java.util.List;
import org.apache.kafka.common.MetricName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterStartingTask
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterStartingTask.class);
    private final MetricsManager metricsManager;

    public SchemaExporterStartingTask(SchemaExporterService exporterService, SchemaExporter exporter, MetricsManager metricsManager) {
        super(exporterService, exporter);
        this.metricsManager = metricsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SchemaExporterStatus status;
        long startTime = System.currentTimeMillis();
        if (!this.exporterService().isLeader()) {
            return;
        }
        log.info("{}: Begin starting task", (Object)this.exporter());
        if (!"default".equals(this.tenant())) {
            this.schemaRegistry().setTenant(this.tenant());
        }
        if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) == null || status.getState() != SchemaExporterStatus.State.STARTING) {
            log.warn("{}: Abort starting task", (Object)this.exporter());
            return;
        }
        try {
            log.info("{}: Starting exporter", (Object)this.exporter());
            SchemaExporterInfo info = (SchemaExporterInfo)this.exporterService().exporterInfos().get((Object)this.exporter());
            if (info == null) {
                log.warn("{}: No info for starting task", (Object)this.exporter());
                return;
            }
            List<String> subjects = SchemaExporterService.getSubjects(info.getSubjects());
            SchemaRegistryClient client = this.getSchemaRegistryClient(info.getConfig());
            this.setModes(info, client, subjects);
            SubjectValue lastSubjectValue = this.exportSchemas(client, subjects, info, status);
            DekRegistryClient dekRegistryClient = this.getDekRegistryClient(info.getConfig());
            EncryptionKey lastEncryptionKey = this.exportKeys(dekRegistryClient, subjects, info, status);
            this.saveStatus(lastSubjectValue, lastEncryptionKey, true);
            log.info("{}: All done", (Object)this.exporter());
        }
        catch (Throwable t) {
            String trace = SchemaExporterStartingTask.trace(t);
            boolean retriable = this.isRetriable(t);
            log.error("{}: Error during export ({}), is retriable ({})", new Object[]{this.exporter(), trace, retriable});
            status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter());
            if (status != null) {
                status.setState(SchemaExporterStatus.State.PAUSED);
                status.setTrace(trace);
                status.setRetriable(retriable);
                this.saveStatus(this.exporter(), status);
            }
            MetricName errorMetric = MetricTags.buildErrorMetricName(this.tenant(), this.exporter().getName(), "exportSchemas", t.getClass().getSimpleName());
            this.metricsManager.getTenantMetrics(this.tenant()).getCounter(errorMetric).increment(1L);
        }
        finally {
            long elapsed = System.currentTimeMillis() - startTime;
            this.metricsManager.getTenantMetrics(this.tenant()).getOrCreateLifecycleLatencyGauge(this.exporter().getName(), "STARTING").set(elapsed);
            log.info("{}: STARTING task execution latency recorded: {} ms", (Object)this.exporter(), (Object)elapsed);
        }
        log.info("{}: End starting task", (Object)this.exporter());
    }

    private SubjectValue exportSchemas(SchemaRegistryClient client, List<String> subjects, SchemaExporterInfo info, SchemaExporterStatus status) throws SchemaRegistryException, IOException, RestClientException {
        long lastOffset = status.getOffset();
        SubjectValue subjectValue = null;
        boolean checkMode = subjects.contains(":*:");
        log.info("{}: Exporting subject patterns {}", (Object)this.exporter(), subjects);
        int totalSubjects = subjects.size();
        for (int i = 0; i < subjects.size(); ++i) {
            String subjectOrPrefix = subjects.get(i);
            log.info("{}: processing schema subject pattern {}. Count {} out of {}", new Object[]{this.exporter(), subjectOrPrefix, i + 1, subjects.size()});
            subjectValue = this.exportValues(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, Long.MAX_VALUE, checkMode, totalSubjects, i);
        }
        return subjectValue;
    }

    private EncryptionKey exportKeys(DekRegistryClient client, List<String> subjects, SchemaExporterInfo info, SchemaExporterStatus status) throws IOException, RestClientException {
        long lastOffset = status.getDeksOffset();
        EncryptionKey key = null;
        log.info("{}: Exporting subject pattern count {} for dek/kek", (Object)this.exporter(), (Object)subjects.size());
        int count = 0;
        for (String subjectOrPrefix : subjects) {
            log.info("{}: processing dek/kek subject pattern {}. Count {} out of {}", new Object[]{this.exporter(), subjectOrPrefix, ++count, subjects.size()});
            key = this.exportKeys(this.exporter(), client, info, status, subjectOrPrefix, lastOffset, Long.MAX_VALUE);
        }
        return key;
    }

    private void setModes(SchemaExporterInfo info, SchemaRegistryClient client, List<String> subjects) throws IOException, RestClientException, SchemaRegistryException {
        block5: {
            block4: {
                boolean hasPrefix = subjects.stream().anyMatch(s -> s.endsWith("*"));
                if (!hasPrefix) break block4;
                String subjectWithoutTenant = subjects.get(0);
                String context = SchemaExporterStartingTask.translateContext(this.schemaRegistry(), SchemaExporterStartingTask.isLocal(client), info, this.tenant(), subjectWithoutTenant);
                if (context == null) break block5;
                this.setMode(this.exporter(), client, context, false);
                break block5;
            }
            if (subjects.contains(":*:")) {
                for (String ctx : this.schemaRegistry().listContexts()) {
                    QualifiedSubject qs = QualifiedSubject.create((String)"default", (String)(":" + ctx + ":"));
                    String context = SchemaExporterStartingTask.translateContext(this.schemaRegistry(), SchemaExporterStartingTask.isLocal(client), info, this.tenant(), qs.toUnqualifiedContext());
                    if (context == null) continue;
                    this.setMode(this.exporter(), client, context, false);
                }
            } else {
                for (String subjectWithoutTenant : subjects) {
                    String subject = SchemaExporterStartingTask.translateSubject(this.schemaRegistry(), SchemaExporterStartingTask.isLocal(client), info, this.tenant(), subjectWithoutTenant);
                    if (subject == null) continue;
                    this.setMode(this.exporter(), client, subject, false);
                }
            }
        }
    }
}

