/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import io.kcache.CacheUpdateHandler;
import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterStatusCacheUpdateHandler
implements CacheUpdateHandler<SchemaExporter, SchemaExporterStatus> {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterStatusCacheUpdateHandler.class);
    private MetricsManager metricsManager;

    public SchemaExporterStatusCacheUpdateHandler(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public void handleUpdate(SchemaExporter key, SchemaExporterStatus value, SchemaExporterStatus oldValue, TopicPartition tp, long offset, long timestamp) {
        String oldState = oldValue != null ? String.valueOf((Object)oldValue.getState()) : "null";
        String newState = value != null ? String.valueOf((Object)value.getState()) : "null";
        log.info("{}: Exporter status update from {} -> {}", new Object[]{key, oldState, newState});
    }

    public void close() throws IOException {
    }
}

