/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import io.confluent.schema.exporter.metrics.MetricsManager;
import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterInfo;
import io.confluent.schema.exporter.storage.SchemaExporterRunningTask;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import io.confluent.schema.exporter.storage.SchemaExporterUpdateTask;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterUpdateHandler
implements SchemaUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterUpdateHandler.class);
    public static final String KEY = "exportHandler";
    private KafkaSchemaRegistry schemaRegistry;
    private volatile SchemaExporterService exporterService;
    private final Set<SchemaExporter> exporters = ConcurrentHashMap.newKeySet();
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues = new ConcurrentHashMap<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp>();
    private final Map<SchemaExporter, Integer> counts = new ConcurrentHashMap<SchemaExporter, Integer>();
    private MetricsManager metricsManager;

    public void configure(Map<String, ?> configs) {
        this.schemaRegistry = (KafkaSchemaRegistry)configs.get("schemaRegistry");
        this.schemaRegistry.properties().put(KEY, this);
    }

    public void cacheInitialized(Map<TopicPartition, Long> checkpoints) {
    }

    public void startBatch(int count) {
    }

    public void setExporterService(SchemaExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void setMetricsManager(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
    }

    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue value, SchemaRegistryValue oldValue, TopicPartition tp, long offset, long timestamp) {
        if (this.schemaRegistry.isLeader() && this.exporterService != null) {
            try (KeyValueIterator iter = this.exporterService.exporterInfos.all();){
                while (iter.hasNext()) {
                    KeyValue kv = (KeyValue)iter.next();
                    SchemaExporter exporter = (SchemaExporter)kv.key;
                    SchemaExporterInfo info = (SchemaExporterInfo)kv.value;
                    String name = info.getName();
                    SchemaExporterStatus status = (SchemaExporterStatus)this.exporterService.exporterStatuses.getOrDefault((Object)exporter, (Object)SchemaExporterService.newExporterStatus(name));
                    if (status.getState() != SchemaExporterStatus.State.RUNNING || status.getOffset() >= offset) continue;
                    this.exporterService.submit(new SchemaExporterRunningTask(this.exporterService, exporter, key, value, offset, timestamp, this.latestValues, this.counts, this.metricsManager));
                    this.exporters.add(exporter);
                }
            }
        }
    }

    public void endBatch(int count) {
        if (this.schemaRegistry.isLeader() && !this.exporters.isEmpty()) {
            for (SchemaExporter exporter : this.exporters) {
                this.exporterService.submit(new SchemaExporterUpdateTask(this.exporterService, exporter, this.latestValues, this.counts));
            }
            this.exporters.clear();
        }
    }

    public void close() throws IOException {
    }
}

