/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage;

import io.confluent.schema.exporter.storage.AbstractSchemaExporterTask;
import io.confluent.schema.exporter.storage.SchemaExporter;
import io.confluent.schema.exporter.storage.SchemaExporterService;
import io.confluent.schema.exporter.storage.SchemaExporterStatus;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExporterUpdateTaskForKeys
extends AbstractSchemaExporterTask {
    private static final Logger log = LoggerFactory.getLogger(SchemaExporterUpdateTaskForKeys.class);
    private final Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues;
    private final Map<SchemaExporter, Integer> counts;

    public SchemaExporterUpdateTaskForKeys(SchemaExporterService exporterService, SchemaExporter exporter, Map<SchemaExporter, AbstractSchemaExporterTask.OffsetTimestamp> latestValues, Map<SchemaExporter, Integer> counts) {
        super(exporterService, exporter);
        this.latestValues = latestValues;
        this.counts = counts;
    }

    @Override
    public void run() {
        SchemaExporterStatus status;
        if (!this.exporterService().isLeader()) {
            return;
        }
        if (!"default".equals(this.tenant())) {
            this.schemaRegistry().setTenant(this.tenant());
        }
        if ((status = (SchemaExporterStatus)this.exporterService().exporterStatuses().get((Object)this.exporter())) != null && status.getState() == SchemaExporterStatus.State.RUNNING) {
            AbstractSchemaExporterTask.OffsetTimestamp latestValue = this.latestValues.remove(this.exporter());
            Integer count = this.counts.remove(this.exporter());
            if (count != null && count > 0) {
                if (latestValue.getOffset() > status.getOffset()) {
                    status.setOffset(latestValue.getOffset());
                    status.setTimestamp(latestValue.getTimestamp());
                }
                status.setObjectsExported(status.getObjectsExported() + (long)count.intValue());
                this.saveStatus(this.exporter(), status);
                log.info("{}: Updated status {}", (Object)this.exporter(), (Object)status);
            }
        }
    }
}

