/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage.security;

import io.confluent.schema.exporter.storage.security.CipherParamsEncoder;
import io.confluent.schema.exporter.storage.security.PasswordEncoder;
import java.security.AlgorithmParameters;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.GCMParameterSpec;

public class GcmParamsEncoder
implements CipherParamsEncoder {
    private static final String AUTHENTICATION_TAG_LENGTH = "authenticationTagLength";

    @Override
    public Map<String, String> toMap(AlgorithmParameters cipherParams) throws InvalidParameterSpecException {
        if (cipherParams != null) {
            GCMParameterSpec spec = cipherParams.getParameterSpec(GCMParameterSpec.class);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("initializationVector", PasswordEncoder.base64Encode(spec.getIV()));
            map.put(AUTHENTICATION_TAG_LENGTH, String.valueOf(spec.getTLen()));
            return map;
        }
        throw new IllegalStateException("Could not determine initialization vector for cipher");
    }

    @Override
    public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
        return new GCMParameterSpec(Integer.parseInt(paramMap.get(AUTHENTICATION_TAG_LENGTH)), PasswordEncoder.base64Decode(paramMap.get("initializationVector")));
    }
}

