/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.schema.exporter.storage.security;

import io.confluent.schema.exporter.storage.security.EncryptingPasswordEncoder;
import java.security.GeneralSecurityException;
import java.util.Base64;
import org.apache.kafka.common.config.types.Password;

public interface PasswordEncoder {
    public static final String KEY_FACTORY_ALGORITHM = "keyFactoryAlgorithm";
    public static final String CIPHER_ALGORITHM = "cipherAlgorithm";
    public static final String INITIALIZATION_VECTOR = "initializationVector";
    public static final String KEY_LENGTH = "keyLength";
    public static final String SALT = "salt";
    public static final String ITERATIONS = "iterations";
    public static final String ENCRYPTED_PASSWORD = "encryptedPassword";
    public static final String PASSWORD_LENGTH = "passwordLength";
    public static final PasswordEncoder NOOP = new PasswordEncoder(){

        @Override
        public String encode(Password password) {
            return password.value();
        }

        @Override
        public Password decode(String encodedPassword) {
            return new Password(encodedPassword);
        }
    };

    public static byte[] base64Decode(String encoded) {
        return Base64.getDecoder().decode(encoded);
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static EncryptingPasswordEncoder encrypting(Password secret, String keyFactoryAlgorithm, String cipherAlgorithm, int keyLength, int iterations) {
        return new EncryptingPasswordEncoder(secret, keyFactoryAlgorithm, cipherAlgorithm, keyLength, iterations);
    }

    public String encode(Password var1) throws GeneralSecurityException;

    public Password decode(String var1) throws GeneralSecurityException;
}

