/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rulehandler;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.rulehandler.license.LicenseBackgroundFetcher;
import io.confluent.kafka.schemaregistry.rulehandler.license.RestInvalidLicenseException;
import io.confluent.kafka.schemaregistry.rulehandler.license.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import jakarta.ws.rs.core.Configurable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSetResourceExtension
extends RuleSetHandler
implements SchemaRegistryResourceExtension {
    private static final Logger log = LoggerFactory.getLogger(RuleSetResourceExtension.class);
    private LicenseBackgroundFetcher licenseBackgroundFetcher;

    @VisibleForTesting
    public void setLicenseBackgroundFetcher(LicenseBackgroundFetcher licenseBackgroundFetcher) {
        this.licenseBackgroundFetcher = licenseBackgroundFetcher;
    }

    public void register(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry schemaRegistry) throws SchemaRegistryException {
        SecureSchemaRegistryConfig secureConfig;
        try {
            secureConfig = new SecureSchemaRegistryConfig(schemaRegistryConfig.originalProperties());
        }
        catch (RestConfigException e) {
            throw new SchemaRegistryException((Throwable)e);
        }
        Map<String, Object> producerProps = secureConfig.licenseProducerConfigs();
        Map<String, Object> consumerProps = secureConfig.licenseConsumerConfigs();
        Map<String, Object> adminProps = secureConfig.licenseAdminConfigs();
        if (this.licenseBackgroundFetcher == null) {
            this.licenseBackgroundFetcher = new LicenseBackgroundFetcher(secureConfig.licenseTopic(), producerProps, consumerProps, adminProps, secureConfig.licenseString(), secureConfig.csfleLicenseString());
        }
        this.licenseBackgroundFetcher.startAsync();
        ((KafkaSchemaRegistry)schemaRegistry).setRuleSetHandler((RuleSetHandler)this);
    }

    public void handle(String subject, ConfigUpdateRequest request) {
    }

    public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
        this.validateRules(request.getRuleSet());
    }

    public void handle(Schema schema, TagSchemaRequest request) {
    }

    public void validateRules(RuleSet ruleSet) {
        if (ruleSet == null) {
            return;
        }
        this.validateRules(ruleSet.getDomainRules());
        this.validateRules(ruleSet.getEncodingRules());
    }

    public void validateRules(List<Rule> rules) {
        if (rules == null || rules.isEmpty()) {
            return;
        }
        boolean hasEncryptRule = rules.stream().anyMatch(rule -> rule.getType().startsWith("ENCRYPT"));
        if (hasEncryptRule && !this.licenseBackgroundFetcher.hasValidLicense()) {
            throw new RestInvalidLicenseException("Both enterprise and add-on CSFLE licenses are required.");
        }
    }

    public io.confluent.kafka.schemaregistry.storage.RuleSet transform(RuleSet ruleSet) {
        return ruleSet != null ? new io.confluent.kafka.schemaregistry.storage.RuleSet(ruleSet) : null;
    }

    public void close() {
        if (this.licenseBackgroundFetcher != null) {
            this.licenseBackgroundFetcher.stopAsync();
        }
    }
}

