/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rulehandler.license;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractScheduledService;
import io.confluent.license.AddOnLicenseManager;
import io.confluent.license.AddOnLicenseManagerImpl;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import io.confluent.license.LicenseManagerPurpose;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseBackgroundFetcher
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(LicenseBackgroundFetcher.class);
    private static final int DEFAULT_REFRESH_INTERVAL_MS = 30000;
    private final int refreshIntervalMs;
    private final String topic;
    private final Map<String, Object> producerConfig;
    private final Map<String, Object> consumerConfig;
    private final Map<String, Object> topicConfig;
    private final String license;
    private final String addOnLicense;
    private volatile LicenseManager licenseManager;
    private volatile AddOnLicenseManager addOnLicenseManager;
    private final AtomicReference<License> cacheLicense = new AtomicReference();
    private final AtomicReference<License> cacheAddOnLicense = new AtomicReference();

    public LicenseBackgroundFetcher(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String license, String addOnLicense) {
        this(topic, producerConfig, consumerConfig, topicConfig, license, addOnLicense, 30000);
    }

    @VisibleForTesting
    LicenseBackgroundFetcher(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String license, String addOnLicense, int refreshIntervalMs) {
        this.topic = topic;
        this.producerConfig = producerConfig;
        this.consumerConfig = consumerConfig;
        this.topicConfig = topicConfig;
        this.license = license;
        this.addOnLicense = addOnLicense;
        this.refreshIntervalMs = refreshIntervalMs;
    }

    public boolean hasValidLicense() {
        License addOnLicense;
        boolean isAddOnLicenseValid;
        boolean isLicenseValid;
        License license = this.cacheLicense.get();
        boolean bl = isLicenseValid = license != null && license.isValid();
        if (!isLicenseValid) {
            log.error("Missing or invalid enterprise license");
        }
        boolean bl2 = isAddOnLicenseValid = (addOnLicense = this.cacheAddOnLicense.get()) != null && addOnLicense.isValid();
        if (!isAddOnLicenseValid) {
            log.error("Missing or invalid add-on CSFLE license");
        }
        return isLicenseValid && isAddOnLicenseValid;
    }

    @VisibleForTesting
    public void setLicenseManagers(LicenseManager licenseManager, AddOnLicenseManager addOnLicenseManager) {
        this.licenseManager = licenseManager;
        this.addOnLicenseManager = addOnLicenseManager;
        this.runOneIteration();
    }

    public void shutDown() {
        if (this.licenseManager != null) {
            log.info("Shutting down License Manager...");
            this.licenseManager.stop();
        }
        if (this.addOnLicenseManager != null) {
            log.info("Shutting down Add-On License Manager...");
            this.addOnLicenseManager.stop();
        }
    }

    protected void runOneIteration() {
        try {
            if (this.licenseManager == null) {
                log.info("Setting up License Manager...");
                this.licenseManager = new LicenseManager(this.topic, this.producerConfig, this.consumerConfig, this.topicConfig);
                log.info("Finished setting up License Manager.");
            }
            this.cacheLicense.set(this.licenseManager.registerOrValidateLicense(this.license));
        }
        catch (InvalidLicenseException e) {
            log.error("License validation failed", (Throwable)e);
            this.cacheLicense.set(null);
        }
        catch (Throwable e) {
            log.error("Can not validate license due to", e);
        }
        try {
            if (this.addOnLicenseManager == null) {
                log.info("Setting up Add-On License Manager...");
                this.addOnLicenseManager = new AddOnLicenseManagerImpl(this.topic, this.producerConfig, this.consumerConfig, this.topicConfig, LicenseManagerPurpose.CSFLE, "");
                log.info("Finished setting up Add-On License Manager.");
            }
            this.cacheAddOnLicense.set(this.addOnLicenseManager.registerOrValidateAddOnLicense(this.addOnLicense));
        }
        catch (InvalidLicenseException e) {
            log.error("Add-On License validation failed", (Throwable)e);
            this.cacheAddOnLicense.set(null);
        }
        catch (Throwable e) {
            log.error("Can not validate add-on license due to", e);
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)0L, (long)this.refreshIntervalMs, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

