/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rulehandler.license;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;

public final class SecureSchemaRegistryConfig
extends SchemaRegistryConfig {
    public static final String KAFKASTORE_PREFIX = "kafkastore.";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    protected static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use Confluent Security Plugins for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.";
    public static final String CONFLUENT_CSFLE_LICENSE_CONFIG = "confluent.license.addon.csfle";
    public static final String CONFLUENT_CSFLE_LICENSE_DEFAULT = "";
    protected static final String CONFLUENT_CSFLE_LICENSE_DOC = "Add-on license for CSFLE";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.license.topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-license";
    public static final String CONFLUENT_TOPIC_DOC = "Topic used for storing Confluent license";
    public static final String LICENSE_CONFIG_PREFIX = "confluent.license.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.license.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.license.consumer.";
    public static final String CONFLUENT_TOPIC_ADMIN_PREFIX = "confluent.license.admin.";
    private static final ConfigDef confluentConfigDef = SecureSchemaRegistryConfig.initConfigDef();

    public String licenseString() {
        return this.getPassword(CONFLUENT_LICENSE_CONFIG).value();
    }

    public String csfleLicenseString() {
        return this.getPassword(CONFLUENT_CSFLE_LICENSE_CONFIG).value();
    }

    public String licenseTopic() {
        return this.getString(CONFLUENT_TOPIC_CONFIG);
    }

    private Map<String, Object> getKafkaConnectionProps() {
        Map props = this.originals();
        props.putAll(this.originalsWithPrefix(KAFKASTORE_PREFIX));
        props.putAll(this.originalsWithPrefix(LICENSE_CONFIG_PREFIX));
        props.putIfAbsent("bootstrap.servers", this.bootstrapBrokers());
        return props;
    }

    public Map<String, Object> licenseProducerConfigs() {
        Map<String, Object> producerProperties = this.getKafkaConnectionProps();
        producerProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        producerProperties.put("client.id", "confluent-license-producer");
        return producerProperties;
    }

    public Map<String, Object> licenseConsumerConfigs() {
        Map<String, Object> consumerProperties = this.getKafkaConnectionProps();
        consumerProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        consumerProperties.put("client.id", "confluent-license-consumer");
        return consumerProperties;
    }

    public Map<String, Object> licenseAdminConfigs() {
        Map<String, Object> adminProperties = this.getKafkaConnectionProps();
        adminProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_ADMIN_PREFIX));
        adminProperties.put("client.id", "confluent-license-admin");
        return adminProperties;
    }

    public SecureSchemaRegistryConfig(Properties props) throws RestConfigException {
        super(confluentConfigDef, props);
    }

    private static ConfigDef initConfigDef() {
        return SecureSchemaRegistryConfig.baseSchemaRegistryConfigDef().define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC).define(CONFLUENT_CSFLE_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, CONFLUENT_CSFLE_LICENSE_DOC).define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_DOC);
    }
}

