/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.http;

import io.confluent.security.authentication.credential.HttpCredential;
import io.confluent.security.authentication.http.ConfluentSecurityContext;
import io.confluent.security.authentication.http.HttpAuthenticator;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=1000)
public final class HttpServerAuthFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(HttpServerAuthFilter.class);
    private final HttpAuthenticator<?> authenticator;
    private final Supplier<Collection<String>> whitelist;

    public HttpServerAuthFilter(HttpAuthenticator<?> authenticator) {
        this(authenticator, Collections::emptyList);
    }

    public HttpServerAuthFilter(HttpAuthenticator<?> authenticator, Supplier<Collection<String>> anonymousAccessWhitelist) {
        this.authenticator = authenticator;
        this.whitelist = anonymousAccessWhitelist;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            Object principal;
            Cookie cookie;
            HttpCredential credential = HttpCredential.read((String)requestContext.getHeaders().getFirst((Object)"Authorization"));
            if (credential.credential() == null && (cookie = (Cookie)requestContext.getCookies().get("auth_token")) != null) {
                Object value = cookie.getValue().startsWith("Bearer ") ? cookie.getValue() : "Bearer " + cookie.getValue();
                credential = HttpCredential.read((String)value);
            }
            if ((principal = this.authenticator.authenticate(credential)) == null && !credential.scheme().equals((Object)HttpCredential.Scheme.NONE)) {
                log.debug("Incompatible authentication scheme " + credential.scheme().toString());
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)this.authenticator.challenge()).build());
            }
            boolean isSecure = requestContext.getUriInfo().getRequestUri().toString().startsWith("https");
            requestContext.setSecurityContext((SecurityContext)new ConfluentSecurityContext(credential.scheme(), (Principal)principal, isSecure));
            this.filterWhitelist(requestContext);
        }
        catch (Throwable t) {
            log.debug("Unable to authenticate request");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private void filterWhitelist(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (securityContext != null && !securityContext.getUserPrincipal().equals(ConfluentSecurityContext.ANONYMOUS)) {
            return;
        }
        if (this.whitelist.get().stream().anyMatch(path -> requestContext.getUriInfo().getPath(true).startsWith((String)path))) {
            return;
        }
        log.debug("Authentication required to access secured path");
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)this.authenticator.challenge()).build());
    }
}

