/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import io.confluent.ksql.serde.avro.AvroSchemas;
import io.confluent.ksql.serde.avro.AvroUtil;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.ConnectSchemas;
import io.confluent.ksql.serde.connect.DataTranslator;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;

public class AvroDataTranslator
implements DataTranslator {
    private final DataTranslator innerTranslator;
    private final Schema ksqlSchema;
    private final Schema avroCompatibleSchema;

    AvroDataTranslator(Schema schema, String schemaFullName) {
        this.ksqlSchema = AvroUtil.throwOnInvalidSchema(Objects.requireNonNull(schema, "schema"));
        this.avroCompatibleSchema = AvroSchemas.getAvroCompatibleConnectSchema(schema, schemaFullName);
        this.innerTranslator = new ConnectDataTranslator(this.avroCompatibleSchema);
    }

    Schema getAvroCompatibleSchema() {
        return this.avroCompatibleSchema;
    }

    @Override
    public Object toKsqlRow(Schema connectSchema, Object connectObject) {
        Object avroCompatibleRow = this.innerTranslator.toKsqlRow(connectSchema, connectObject);
        if (avroCompatibleRow == null) {
            return null;
        }
        return ConnectSchemas.withCompatibleSchema(this.ksqlSchema, avroCompatibleRow);
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        Object compatible = ConnectSchemas.withCompatibleSchema(this.avroCompatibleSchema, ksqlData);
        return this.innerTranslator.toConnectRow(compatible);
    }
}

