/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.serde.SchemaTranslationPolicies;
import io.confluent.ksql.serde.SchemaTranslationPolicy;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConnectKsqlSchemaTranslator {
    private static final Logger log = LogManager.getLogger(ConnectSchemaTranslator.class);
    private static final SchemaTranslationPolicies DEFAULT_POLICY = SchemaTranslationPolicies.of(new SchemaTranslationPolicy[0]);
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(w -> false, new SqlSchemaFormatter.Option[]{SqlSchemaFormatter.Option.AS_COLUMN_LIST});
    private final Map<Schema.Type, Function<Schema, Schema>> connectToSql = ImmutableMap.builder().put((Object)Schema.Type.INT8, s -> Schema.OPTIONAL_INT32_SCHEMA).put((Object)Schema.Type.INT16, s -> Schema.OPTIONAL_INT32_SCHEMA).put((Object)Schema.Type.INT32, s -> this.convertInt32Schema((Schema)s)).put((Object)Schema.Type.INT64, s -> this.convertInt64Schema((Schema)s)).put((Object)Schema.Type.FLOAT32, s -> Schema.OPTIONAL_FLOAT64_SCHEMA).put((Object)Schema.Type.FLOAT64, s -> Schema.OPTIONAL_FLOAT64_SCHEMA).put((Object)Schema.Type.STRING, s -> Schema.OPTIONAL_STRING_SCHEMA).put((Object)Schema.Type.BOOLEAN, s -> Schema.OPTIONAL_BOOLEAN_SCHEMA).put((Object)Schema.Type.BYTES, s -> this.toKsqlBytesSchema((Schema)s)).put((Object)Schema.Type.ARRAY, s -> this.toKsqlArraySchema((Schema)s)).put((Object)Schema.Type.MAP, s -> this.toKsqlMapSchema((Schema)s)).put((Object)Schema.Type.STRUCT, s -> this.toKsqlStructSchema((Schema)s)).build();
    public static final Schema OPTIONAL_TIMESTAMP_SCHEMA = Timestamp.builder().optional().build();
    public static final Schema OPTIONAL_TIME_SCHEMA = Time.builder().optional().build();
    public static final Schema OPTIONAL_DATE_SCHEMA = Date.builder().optional().build();
    private final SchemaTranslationPolicies policies;

    public ConnectKsqlSchemaTranslator() {
        this(DEFAULT_POLICY);
    }

    public ConnectKsqlSchemaTranslator(SchemaTranslationPolicies policies) {
        this.policies = Objects.requireNonNull(policies, "policies");
    }

    public SchemaTranslationPolicies getPolicies() {
        return this.policies;
    }

    public Schema toKsqlSchema(Schema schema) {
        try {
            Schema rowSchema = this.toKsqlFieldSchema(schema);
            if (rowSchema.type() != Schema.Type.STRUCT) {
                throw new KsqlException("KSQL stream/table schema must be structured");
            }
            if (rowSchema.fields().isEmpty()) {
                throw new KsqlException("Schema does not include any columns with types that ksqlDB supports." + System.lineSeparator() + "schema: " + FORMATTER.format(schema));
            }
            return rowSchema;
        }
        catch (UnsupportedTypeException e) {
            throw new KsqlException("Unsupported type at root of schema: " + e.getMessage(), (Throwable)e);
        }
    }

    private Schema toKsqlFieldSchema(Schema schema) {
        Function<Schema, Schema> handler = this.connectToSql.get(schema.type());
        if (handler == null) {
            throw new UnsupportedTypeException(String.format("Unsupported type: %s", schema.type().getName()));
        }
        return handler.apply(schema);
    }

    private void checkMapKeyType(Schema.Type type) {
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case BOOLEAN: 
            case STRING: {
                return;
            }
        }
        throw new UnsupportedTypeException("Unsupported type for map key: " + type.getName());
    }

    private Schema convertInt64Schema(Schema schema) {
        if ("org.apache.kafka.connect.data.Timestamp".equals(schema.name())) {
            return OPTIONAL_TIMESTAMP_SCHEMA;
        }
        return Schema.OPTIONAL_INT64_SCHEMA;
    }

    private Schema convertInt32Schema(Schema schema) {
        if ("org.apache.kafka.connect.data.Time".equals(schema.name())) {
            return OPTIONAL_TIME_SCHEMA;
        }
        if ("org.apache.kafka.connect.data.Date".equals(schema.name())) {
            return OPTIONAL_DATE_SCHEMA;
        }
        return Schema.OPTIONAL_INT32_SCHEMA;
    }

    private Schema toKsqlBytesSchema(Schema schema) {
        if (DecimalUtil.isDecimal((Schema)schema)) {
            return schema;
        }
        return Schema.OPTIONAL_BYTES_SCHEMA;
    }

    private Schema toKsqlMapSchema(Schema schema) {
        Schema keySchema = this.toKsqlFieldSchema(schema.keySchema());
        this.checkMapKeyType(keySchema.type());
        return SchemaBuilder.map((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Schema)this.toKsqlFieldSchema(schema.valueSchema())).optional().build();
    }

    private Schema toKsqlArraySchema(Schema schema) {
        return SchemaBuilder.array((Schema)this.toKsqlFieldSchema(schema.valueSchema())).optional().build();
    }

    private Schema toKsqlStructSchema(Schema schema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        for (Field field : schema.fields()) {
            try {
                Schema fieldSchema = this.toKsqlFieldSchema(field.schema());
                if (this.policies.enabled(SchemaTranslationPolicy.UPPERCASE_FIELD_NAME)) {
                    schemaBuilder.field(field.name().toUpperCase(), fieldSchema);
                    continue;
                }
                if (this.policies.enabled(SchemaTranslationPolicy.ORIGINAL_FIELD_NAME)) {
                    schemaBuilder.field(field.name(), fieldSchema);
                    continue;
                }
                schemaBuilder.field(field.name().toUpperCase(), fieldSchema);
            }
            catch (UnsupportedTypeException e) {
                log.error("Error inferring schema at field {}: {}", (Object)field.name(), (Object)e.getMessage());
            }
        }
        return schemaBuilder.optional().build();
    }

    private static class UnsupportedTypeException
    extends RuntimeException {
        UnsupportedTypeException(String error) {
            super(error);
        }
    }
}

