/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.annotation.Nonnull;

public final class JsonSerdeUtils {
    public static final int SIZE_OF_SR_PREFIX = 5;
    public static final int MAGIC_BYTE = 0;

    private JsonSerdeUtils() {
    }

    public static <T> T readJsonSR(@Nonnull byte[] jsonWithMagic, ObjectMapper mapper, Class<? extends T> clazz) throws IOException {
        if (!JsonSerdeUtils.hasMagicByte(jsonWithMagic)) {
            throw new KsqlException("Got unexpected JSON serialization format that did not start with the magic byte. If this stream was not serialized using the JsonSchemaConverter, then make sure the stream is declared with JSON format (not JSON_SR).");
        }
        return (T)mapper.readValue(jsonWithMagic, 5, jsonWithMagic.length - 5, clazz);
    }

    static boolean hasMagicByte(@Nonnull byte[] json) {
        return json.length > 0 && json[0] == 0;
    }

    static boolean toBoolean(JsonNode object) {
        if (object instanceof BooleanNode) {
            return object.booleanValue();
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.BOOLEAN);
    }

    static int toInteger(JsonNode object) {
        if (object instanceof NumericNode) {
            return object.intValue();
        }
        if (object instanceof TextNode) {
            try {
                return Integer.parseInt(object.textValue());
            }
            catch (NumberFormatException e) {
                throw JsonSerdeUtils.failedStringCoercionException(SqlBaseType.INTEGER);
            }
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.INTEGER);
    }

    static long toLong(JsonNode object) {
        if (object instanceof NumericNode) {
            return object.asLong();
        }
        if (object instanceof TextNode) {
            try {
                return Long.parseLong(object.textValue());
            }
            catch (NumberFormatException e) {
                throw JsonSerdeUtils.failedStringCoercionException(SqlBaseType.BIGINT);
            }
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.BIGINT);
    }

    static double toDouble(JsonNode object) {
        if (object instanceof NumericNode) {
            return object.doubleValue();
        }
        if (object instanceof TextNode) {
            try {
                return Double.parseDouble(object.textValue());
            }
            catch (NumberFormatException e) {
                throw JsonSerdeUtils.failedStringCoercionException(SqlBaseType.DOUBLE);
            }
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.DOUBLE);
    }

    static Time toTime(JsonNode object) {
        if (object instanceof NumericNode) {
            return SerdeUtils.returnTimeOrThrow(object.asLong());
        }
        if (object instanceof TextNode) {
            try {
                return SerdeUtils.returnTimeOrThrow(Long.parseLong(object.textValue()));
            }
            catch (NumberFormatException e) {
                throw JsonSerdeUtils.failedStringCoercionException(SqlBaseType.TIME);
            }
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.TIME);
    }

    static Date toDate(JsonNode object) {
        if (object instanceof NumericNode) {
            return SerdeUtils.getDateFromEpochDays(object.asLong());
        }
        if (object instanceof TextNode) {
            try {
                return SerdeUtils.getDateFromEpochDays(Long.parseLong(object.textValue()));
            }
            catch (NumberFormatException e) {
                throw JsonSerdeUtils.failedStringCoercionException(SqlBaseType.DATE);
            }
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.DATE);
    }

    static Timestamp toTimestamp(JsonNode object) {
        if (object instanceof NumericNode) {
            return new Timestamp(object.asLong());
        }
        if (object instanceof TextNode) {
            try {
                return new Timestamp(Long.parseLong(object.textValue()));
            }
            catch (NumberFormatException e) {
                throw JsonSerdeUtils.failedStringCoercionException(SqlBaseType.TIMESTAMP);
            }
        }
        throw JsonSerdeUtils.invalidConversionException((Object)object, SqlBaseType.TIMESTAMP);
    }

    static IllegalArgumentException invalidConversionException(Object object, String sqlType) {
        return new IllegalArgumentException("Can't convert type. sourceType: " + object.getClass().getSimpleName() + ", requiredType: " + sqlType);
    }

    private static IllegalArgumentException invalidConversionException(Object object, SqlBaseType sqlType) {
        return JsonSerdeUtils.invalidConversionException(object, sqlType.toString());
    }

    private static IllegalArgumentException failedStringCoercionException(SqlBaseType sqlType) {
        return new IllegalArgumentException("Can't coerce string to type. targetType: " + String.valueOf(sqlType));
    }
}

