/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.tls;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class ThreadLocalCloseable<T extends Closeable>
implements Closeable {
    private final List<T> created = new LinkedList<T>();
    private final ThreadLocal<T> local = ThreadLocal.withInitial(() -> {
        ThreadLocalCloseable threadLocalCloseable = this;
        synchronized (threadLocalCloseable) {
            if (this.closed) {
                throw new IllegalStateException("ThreadLocalCloseable has been closed");
            }
            this.created.add((Closeable)initialValueSupplier.get());
            return (Closeable)this.created.get(this.created.size() - 1);
        }
    });
    private boolean closed = false;

    ThreadLocalCloseable(Supplier<T> initialValueSupplier) {
    }

    public T get() {
        return (T)((Closeable)this.local.get());
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        for (Closeable c : this.created) {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

