/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.availability;

import io.confluent.kafka.availability.NetworkAvailabilityManager$;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015t!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nI2AAJ\u000e\u0001{!Aaj\u0002B\u0001B\u0003%q\nC\u0003/\u000f\u0011\u0005a\u000bC\u0004Z\u000f\t\u0007IQB\u0019\t\ri;\u0001\u0015!\u00043\u0011\u001dYvA1A\u0005\u000eqCaaZ\u0004!\u0002\u001bi\u0006b\u00025\b\u0005\u0004%i\u0001\u0018\u0005\u0007S\u001e\u0001\u000bQB/\t\u000f)<!\u0019!C\u00079\"11n\u0002Q\u0001\u000euCq\u0001\\\u0004C\u0002\u00135Q\u000e\u0003\u0004y\u000f\u0001\u0006iA\u001c\u0005\u0006s\u001e!\tE\u001f\u0005\b\u0003\u0007:A\u0011BA#\u0011\u001d\t\tf\u0002C\u0005\u0003'Bq!a\u0016\b\t\u0003\tI\u0006C\u0004\u0002b\u001d!\t!!\u0017\t\u000f\u0005\rt\u0001\"\u0001\u0002Z\u0005Qb*\u001a;x_J\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us6\u000bg.Y4fe*\u0011A$H\u0001\rCZ\f\u0017\u000e\\1cS2LG/\u001f\u0006\u0003=}\tQa[1gW\u0006T!\u0001I\u0011\u0002\u0013\r|gN\u001a7vK:$(\"\u0001\u0012\u0002\u0005%|7\u0001\u0001\t\u0003K\u0005i\u0011a\u0007\u0002\u001b\u001d\u0016$xo\u001c:l\u0003Z\f\u0017\u000e\\1cS2LG/_'b]\u0006<WM]\n\u0003\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001%\u0003\u0015\u001auJ\u0014(F\u0007RKuJT0Q\u0013:;5kX\"M\u0013\u0016sEkX*P\rR;\u0016IU#`\u001d\u0006kU)F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003mC:<'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aa\u0015;sS:<\u0017AJ\"P\u001d:+5\tV%P\u001d~\u0003\u0016JT$T?\u000ec\u0015*\u0012(U?N{e\tV,B%\u0016{f*Q'FA\u00051\u0002*R!M)\"{6\tS#D\u0017~\u001bE*S#O)~KE)A\fI\u000b\u0006cE\u000bS0D\u0011\u0016\u001b5jX\"M\u0013\u0016sEkX%EAM\u0019qAP!\u0011\u0005Mz\u0014B\u0001!5\u0005\u0019y%M[3diB\u0011!\tT\u0007\u0002\u0007*\u0011A)R\u0001\b]\u0016$xo\u001c:l\u0015\t1u)\u0001\u0004d_6lwN\u001c\u0006\u0003=!S!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO&\u0011Qj\u0011\u0002\u0010%\u0016\fX/Z:u\u0007\u0006dGNY1dW\u000611m\u001c8gS\u001e\u0004\"\u0001\u0015+\u000e\u0003ES!AU*\u0002\rM,'O^3s\u0015\u0005q\u0012BA+R\u0005-Y\u0015MZ6b\u0007>tg-[4\u0015\u0005]C\u0006CA\u0013\b\u0011\u0015q\u0015\u00021\u0001P\u0003Q)\u0007\u0010^3s]\u0006dG*[:uK:,'OT1nK\u0006)R\r\u001f;fe:\fG\u000eT5ti\u0016tWM\u001d(b[\u0016\u0004\u0013AF2p]:,7\r^5p]BKgnZ:D_VtG/\u001a:\u0016\u0003u\u0003\"AX3\u000e\u0003}S!\u0001Y1\u0002\r\u0005$x.\\5d\u0015\t\u00117-\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u001a\u001c\u0002\tU$\u0018\u000e\\\u0005\u0003M~\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0003]\u0019wN\u001c8fGRLwN\u001c)j]\u001e\u001c8i\\;oi\u0016\u0014\b%A\ffqR,'O\\1m%\u0016\fX/Z:ug\u000e{WO\u001c;fe\u0006AR\r\u001f;fe:\fGNU3rk\u0016\u001cHo]\"pk:$XM\u001d\u0011\u00025!,\u0017\r\u001c;i\u0007\",7m\u001b*fcV,7\u000f^:D_VtG/\u001a:\u00027!,\u0017\r\u001c;i\u0007\",7m\u001b*fcV,7\u000f^:D_VtG/\u001a:!\u0003I\u0011'o\\6fe\u0012K'/Z2uK\u0012\f\u0005/[:\u0016\u00039\u00042a\u001c9s\u001b\u0005\u0019\u0017BA9d\u0005\u001d)e.^7TKR\u0004\"a\u001d<\u000e\u0003QT!!^#\u0002\u0011A\u0014x\u000e^8d_2L!a\u001e;\u0003\u000f\u0005\u0003\u0018nS3zg\u0006\u0019\"M]8lKJ$\u0015N]3di\u0016$\u0017\t]5tA\u0005IqN\u001c*fcV,7\u000f\u001e\u000b\twz\f\t\"!\t\u0002@A\u0011\u0011\u0006`\u0005\u0003{*\u0012A!\u00168ji\"1q\u0010\u0006a\u0001\u0003\u0003\t\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!\u0011-\u001e;i\u0015\r\tY!R\u0001\tg\u0016\u001cWO]5us&!\u0011qBA\u0003\u00059Y\u0015MZ6b!JLgnY5qC2Dq!a\u0005\u0015\u0001\u0004\t)\"A\u0004sKF,Xm\u001d;\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007F\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0010\u00033\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003G!\u0002\u0019AA\u0013\u0003!\u0019G.[3oi&#\u0005#B8\u0002(\u0005-\u0012bAA\u0015G\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003o\u00012!!\r+\u001b\t\t\u0019DC\u0002\u00026\r\na\u0001\u0010:p_Rt\u0014bAA\u001dU\u00051\u0001K]3eK\u001aL1!OA\u001f\u0015\r\tID\u000b\u0005\b\u0003\u0003\"\u0002\u0019AA\u0013\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0003EI7/\u0012=uKJt\u0017\r\u001c*fcV,7\u000f\u001e\u000b\u0007\u0003\u000f\ni%a\u0014\u0011\u0007%\nI%C\u0002\u0002L)\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0014U\u0001\r!!\u0006\t\u000f\u0005\u0005S\u00031\u0001\u0002&\u0005\u0019\u0012n\u001d%fC2$\bn\u00115fG.\u001cE.[3oiR!\u0011qIA+\u0011\u001d\t\u0019C\u0006a\u0001\u0003K\tqbY8o]\u0016\u001cG/[8o!&twm]\u000b\u0003\u00037\u00022!KA/\u0013\r\tyF\u000b\u0002\u0005\u0019>tw-\u0001\tfqR,'O\\1m%\u0016\fX/Z:ug\u0006\u0019\u0002.Z1mi\"\u001c\u0005.Z2l%\u0016\fX/Z:ug\u0002")
public class NetworkAvailabilityManager
implements RequestCallback {
    private final String externalListenerName;
    private final AtomicLong connectionPingsCounter;
    private final AtomicLong externalRequestsCounter;
    private final AtomicLong healthCheckRequestsCounter;
    private final EnumSet<ApiKeys> brokerDirectedApis;

    public static String HEALTH_CHECK_CLIENT_ID() {
        return NetworkAvailabilityManager$.MODULE$.HEALTH_CHECK_CLIENT_ID();
    }

    public static String CONNECTION_PINGS_CLIENT_SOFTWARE_NAME() {
        return NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME();
    }

    private final String externalListenerName() {
        return this.externalListenerName;
    }

    private final AtomicLong connectionPingsCounter() {
        return this.connectionPingsCounter;
    }

    private final AtomicLong externalRequestsCounter() {
        return this.externalRequestsCounter;
    }

    private final AtomicLong healthCheckRequestsCounter() {
        return this.healthCheckRequestsCounter;
    }

    private final EnumSet<ApiKeys> brokerDirectedApis() {
        return this.brokerDirectedApis;
    }

    public void onRequest(KafkaPrincipal principal, AbstractRequest request, Optional<String> clientID, Optional<String> listenerName) {
        if (request.apiKey() == ApiKeys.API_VERSIONS) {
            ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)request;
            String string = apiVersionsRequest.data().clientSoftwareName();
            String string2 = NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME();
            v1 = !(string != null ? !string.equals(string2) : string2 != null) ? BoxesRunTime.boxToLong(this.connectionPingsCounter().getAndIncrement()) : BoxedUnit.UNIT;
        } else {
            v1 = BoxedUnit.UNIT;
        }
        boolean bl = false;
        MultiTenantPrincipal multiTenantPrincipal = null;
        KafkaPrincipal kafkaPrincipal = principal;
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            bl = true;
            multiTenantPrincipal = (MultiTenantPrincipal)kafkaPrincipal;
            if (!multiTenantPrincipal.tenantMetadata().isHealthcheckTenant && this.isExternalRequest(request, listenerName)) {
                this.externalRequestsCounter().getAndIncrement();
                return;
            }
        }
        if (bl && multiTenantPrincipal.tenantMetadata().isHealthcheckTenant && this.isHealthCheckClient(clientID)) {
            this.healthCheckRequestsCounter().getAndIncrement();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isExternalRequest(AbstractRequest request, Optional<String> listenerName) {
        if (!this.brokerDirectedApis().contains(request.apiKey())) return false;
        if (!listenerName.isPresent()) return false;
        String string = listenerName.get();
        String string2 = this.externalListenerName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHealthCheckClient(Optional<String> clientID) {
        if (!clientID.isPresent()) return false;
        String string = clientID.get();
        String string2 = NetworkAvailabilityManager$.MODULE$.HEALTH_CHECK_CLIENT_ID();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public long connectionPings() {
        return this.connectionPingsCounter().get();
    }

    public long externalRequests() {
        return this.externalRequestsCounter().get();
    }

    public long healthCheckRequests() {
        return this.healthCheckRequestsCounter().get();
    }

    public NetworkAvailabilityManager(KafkaConfig config) {
        this.externalListenerName = config.confluentConfig().networkHealthManagerExternalListenerName().toUpperCase(Locale.ROOT);
        this.connectionPingsCounter = new AtomicLong();
        this.externalRequestsCounter = new AtomicLong();
        this.healthCheckRequestsCounter = new AtomicLong();
        this.brokerDirectedApis = EnumSet.of(ApiKeys.PRODUCE, (Enum[])new ApiKeys[]{ApiKeys.FETCH, ApiKeys.DELETE_RECORDS, ApiKeys.LIST_OFFSETS, ApiKeys.OFFSET_FOR_LEADER_EPOCH, ApiKeys.OFFSET_COMMIT, ApiKeys.OFFSET_FETCH, ApiKeys.JOIN_GROUP, ApiKeys.HEARTBEAT, ApiKeys.LEAVE_GROUP, ApiKeys.SYNC_GROUP, ApiKeys.DESCRIBE_GROUPS, ApiKeys.LIST_GROUPS, ApiKeys.TXN_OFFSET_COMMIT, ApiKeys.ADD_PARTITIONS_TO_TXN, ApiKeys.ADD_OFFSETS_TO_TXN, ApiKeys.END_TXN, ApiKeys.DESCRIBE_PRODUCERS, ApiKeys.DESCRIBE_TRANSACTIONS, ApiKeys.LIST_TRANSACTIONS});
    }
}

