/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.network.netty;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.NettyStream;

public class NettyStreamChannel
implements TransferableChannel {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final NettyStream nettyStream;
    private final int fileTransferChunkSize;
    private final int byteBufferTransferChunkSize;

    public NettyStreamChannel(NettyStream nettyStream) {
        this(nettyStream, 8192, 8192);
    }

    public NettyStreamChannel(NettyStream nettyStream, int fileTransferChunkSize, int byteBufferTransferChunkSize) {
        this.nettyStream = nettyStream;
        if (fileTransferChunkSize <= 0) {
            throw new IllegalArgumentException("fileTransferChunkSize must be greater than 0");
        }
        if (byteBufferTransferChunkSize <= 0) {
            throw new IllegalArgumentException("byteWriteChunkSize must be greater than 0");
        }
        this.fileTransferChunkSize = fileTransferChunkSize;
        this.byteBufferTransferChunkSize = byteBufferTransferChunkSize;
    }

    public boolean hasPendingWrites() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(FileChannel fileChannel, long position, long count) throws IOException {
        long writtenBytes = 0L;
        while (this.nettyStream.isReadyForSending() && count > 0L) {
            int bytesToRead = (int)Math.min(count, (long)this.fileTransferChunkSize);
            ByteBuf byteBuf = this.nettyStream.alloc().buffer(bytesToRead);
            try {
                int actualBytesRead = byteBuf.writeBytes(fileChannel, position, bytesToRead);
                if (actualBytesRead < 0) {
                    byteBuf.release();
                    break;
                }
                if (actualBytesRead != bytesToRead) {
                    byteBuf.release();
                    throw new IOException("Failed to read " + bytesToRead + " bytes from file channel, only " + actualBytesRead + " bytes read. Position: " + position + ", count: " + count + ".");
                }
                position += (long)actualBytesRead;
                writtenBytes += (long)actualBytesRead;
                this.nettyStream.send(byteBuf, false);
                byteBuf = null;
                if ((count -= (long)actualBytesRead) != 0L) continue;
                this.nettyStream.flush();
            }
            finally {
                if (byteBuf == null) continue;
                byteBuf.release();
            }
        }
        return writtenBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] byteBuffers, int offset, int length) {
        if (offset < 0 || length < 0 || offset > byteBuffers.length - length) {
            throw new IndexOutOfBoundsException();
        }
        long writtenBytes = 0L;
        while (this.nettyStream.isReadyForSending() && length > 0) {
            ByteBuf byteBuf = this.nettyStream.alloc().buffer(this.byteBufferTransferChunkSize);
            try {
                while (length > 0) {
                    int writeableBytes;
                    int readableBytes = byteBuffers[offset].remaining();
                    if (readableBytes > (writeableBytes = byteBuf.writableBytes())) {
                        int position = byteBuffers[offset].position();
                        int writableLimit = position + writeableBytes;
                        ByteBuffer src = byteBuffers[offset].duplicate();
                        src.limit(writableLimit);
                        byteBuf.writeBytes(src);
                        byteBuffers[offset].position(writableLimit);
                        writtenBytes += (long)writeableBytes;
                        break;
                    }
                    byteBuf.writeBytes(byteBuffers[offset]);
                    writtenBytes += (long)readableBytes;
                    --length;
                    ++offset;
                }
                this.nettyStream.send(byteBuf, false);
                byteBuf = null;
                if (length != 0) continue;
                this.nettyStream.flush();
            }
            finally {
                if (byteBuf == null) continue;
                byteBuf.release();
            }
        }
        return writtenBytes;
    }

    public long write(ByteBuffer[] byteBuffers) throws IOException {
        return this.write(byteBuffers, 0, byteBuffers.length);
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        return (int)this.write(new ByteBuffer[]{byteBuffer});
    }

    public boolean isOpen() {
        return !this.nettyStream.isClosed();
    }

    public void close() {
        this.nettyStream.close();
    }

    public String toString() {
        return "NettyStreamChannel{" + String.valueOf(this.nettyStream) + "}";
    }
}

