/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ReadableBuf;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Utils;

public final class ReadableByteBuf
implements ReadableBuf,
AutoCloseable {
    private final ByteBuf byteBuf;
    private final int initialPosition;
    private final InputStream byteBufInputStream;

    public ReadableByteBuf(ByteBuf byteBuf) {
        this.byteBuf = byteBuf.retain();
        this.byteBufInputStream = new ByteBufInputStream(byteBuf);
        this.initialPosition = this.position();
    }

    private InputStream asInputStream() {
        return this.byteBufInputStream;
    }

    @Override
    public void close() {
        Utils.closeQuietly((AutoCloseable)this.byteBufInputStream, (String)"ReadableByteBuf InputStream");
        this.byteBuf.release();
    }

    public int position() {
        return this.byteBuf.readerIndex();
    }

    public void position(int pos) {
        if (pos < this.initialPosition) {
            throw new IndexOutOfBoundsException("Invalid position " + pos);
        }
        this.byteBuf.readerIndex(pos);
    }

    public void rewind() {
        this.position(this.initialPosition);
    }

    public void flip() {
        this.byteBuf.writerIndex(this.byteBuf.readerIndex());
        this.rewind();
    }

    public byte readByte() {
        return this.byteBuf.readByte();
    }

    public short readShort() {
        return this.byteBuf.readShort();
    }

    public int readInt() {
        return this.byteBuf.readInt();
    }

    public long readLong() {
        return this.byteBuf.readLong();
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte[] readArray(int length) {
        byte[] result = new byte[length];
        this.byteBuf.readBytes(result);
        return result;
    }

    public int readUnsignedVarint() {
        try {
            return ByteUtils.readUnsignedVarint((InputStream)this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer readByteBuffer(int length) {
        return this.byteBuf.readSlice(length).nioBuffer();
    }

    public int readVarint() {
        try {
            return ByteUtils.readVarint((InputStream)this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long readVarlong() {
        try {
            return ByteUtils.readVarlong((InputStream)this.asInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int remaining() {
        return this.byteBuf.readableBytes();
    }
}

