/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.clients.CloudAdmin;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerHealthCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminOperationException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class BrokerHealthCommand$
implements Logging {
    public static final BrokerHealthCommand$ MODULE$ = new BrokerHealthCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerHealthCommand$ brokerHealthCommand$ = this;
        synchronized (brokerHealthCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                exitCode = 1;
                this.printException(e);
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    public void run(String[] args, Option<CloudAdmin> clientOption) {
        Option optsOption = None$.MODULE$;
        optsOption = new Some<BrokerHealthCommandOptions>(new BrokerHealthCommandOptions(args));
        BrokerHealthCommandOptions opts = (BrokerHealthCommandOptions)optsOption.get();
        try (CloudAdmin client = (CloudAdmin)clientOption.getOrElse((Function0<CloudAdmin> & Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options.has(opts.describeOpt())) {
                    this.describeBrokerHealth(client);
                } else {
                    this.alterBrokerHealth(client, opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }

    public Option<CloudAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println("Error while running broker health command : " + e.getMessage());
    }

    private void describeBrokerHealth(CloudAdmin client) {
        Collection response = (Collection)client.describeBrokerHealth(new DescribeBrokerHealthOptions()).future().get();
        response.forEach(result -> {
            Predef$.MODULE$.println("\tDegraded Broker: " + result.brokerId());
            MODULE$.printDegradedBrokerComponents(result.degradedBrokerComponents());
            Predef$.MODULE$.println();
            Predef$.MODULE$.println();
        });
    }

    private void printDegradedBrokerComponents(Set<DegradedBrokerComponent> degradedBrokerComponents) {
        degradedBrokerComponents.forEach(degradedBrokerComponent -> {
            Predef$.MODULE$.println("\t\tDegraded Component: " + degradedBrokerComponent.brokerComponent());
            Predef$.MODULE$.println("\t\tReason: " + degradedBrokerComponent.reason());
        });
    }

    private void alterBrokerHealth(CloudAdmin client, BrokerHealthCommandOptions opts) {
        int controllerId;
        ComponentHealthStatus componentHealthStatus = this.parseHealthStatus(opts.options.valueOf(opts.healthStatusOpt()).toUpperCase());
        BrokerComponent brokerComponent = this.parseBrokerComponent(opts.options.valueOf(opts.componentOpt()).toUpperCase());
        scala.collection.immutable.Set<Integer> brokerIds = this.parseBrokerIds(opts.options.valueOf(opts.brokerIdsOpt()));
        if (brokerIds.contains(controllerId = ((Node)client.describeCluster().controller().get()).id())) {
            ComponentHealthStatus componentHealthStatus2 = componentHealthStatus;
            ComponentHealthStatus componentHealthStatus3 = ComponentHealthStatus.DEGRADED;
            if (!(componentHealthStatus2 != null ? !componentHealthStatus2.equals(componentHealthStatus3) : componentHealthStatus3 != null)) {
                Predef$.MODULE$.println("The controller:(" + controllerId + ")'s " + brokerComponent.name() + " component health status is being marked as DEGRADED.");
            }
        }
        AlterBrokerHealthSpec requestData = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava(this.parseBrokerIds(opts.options.valueOf(opts.brokerIdsOpt()))).asJava(), brokerComponent, componentHealthStatus, opts.options.valueOf(opts.reasonOpt()), opts.options.has(opts.forceOpt()));
        Map futures = client.alterBrokerHealth(requestData, new AlterBrokerHealthOptions()).values();
        futures.forEach((x0$1, x1$1) -> {
            Tuple2<Integer, KafkaFuture> tuple2 = new Tuple2<Integer, KafkaFuture>((Integer)x0$1, (KafkaFuture)x1$1);
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Integer brokerId = tuple2._1();
                KafkaFuture future = tuple2._2();
                try {
                    BrokerHealthStatusResult result = (BrokerHealthStatusResult)future.get();
                    Predef$.MODULE$.print("\tBroker: " + result.brokerId());
                    Predef$.MODULE$.print("\t\tComponent: " + result.brokerComponent());
                    Predef$.MODULE$.print("\t\tState: " + result.componentHealthStatus());
                    Predef$.MODULE$.println();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        MODULE$.printBrokerFailedMessage(e.getCause(), brokerId);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        MODULE$.printBrokerFailedMessage(e, brokerId);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (InterruptedException e) {
                    MODULE$.printBrokerFailedMessage(e, brokerId);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    private void printBrokerFailedMessage(Throwable throwable, Integer brokerId) {
        Predef$.MODULE$.print("\tBroker: " + brokerId + "\tFailed: " + throwable.getMessage() + "\n");
    }

    private CloudAdmin createAdminClient(BrokerHealthCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        return CloudAdmin.create((Properties)props);
    }

    private scala.collection.immutable.Set<Integer> parseBrokerIds(String brokerIdsString) {
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(brokerIdsString), (Function1<Object, Object> & Serializable)ch -> {
            BrokerHealthCommand$.$anonfun$parseBrokerIds$1(brokerIdsString, BoxesRunTime.unboxToChar(ch));
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(brokerIdsString.split(",")), (Function1<String, Integer> & Serializable)brokerId -> Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)brokerId))), ClassTag$.MODULE$.apply(Integer.class))).toSet();
    }

    private ComponentHealthStatus parseHealthStatus(String healthStatusString) {
        ComponentHealthStatus healthStatus = ComponentHealthStatus.forString((String)healthStatusString);
        if (healthStatus.equals((Object)ComponentHealthStatus.UNKNOWN)) {
            throw new AdminOperationException("Broker component: " + healthStatusString + " is not valid. Must be one of HEALTHY or DEGRADED.");
        }
        return healthStatus;
    }

    private BrokerComponent parseBrokerComponent(String brokerComponentString) {
        BrokerComponent brokerComponent = BrokerComponent.forString((String)brokerComponentString);
        if (brokerComponent.equals((Object)BrokerComponent.UNKNOWN)) {
            throw new AdminOperationException("Broker component: " + brokerComponentString + " is not valid. Must be one of UNSPECIFIED, STORAGE, NETWORK, or EXTERNAL_CONNECTIVITY_STARTUP.");
        }
        return brokerComponent;
    }

    public static final /* synthetic */ void $anonfun$parseBrokerIds$1(String brokerIdsString$1, char ch) {
        if (!((Object)BoxesRunTime.boxToCharacter(ch)).equals(BoxesRunTime.boxToCharacter(',')) && !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(ch))) {
            throw new AdminOperationException("Broker ids: " + brokerIdsString$1 + ", must not include invalid character - '" + ch + "'.");
        }
    }

    private BrokerHealthCommand$() {
    }
}

