/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import kafka.admin.ConfigCommand;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$Tenant$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.server.config.ConfigType;
import org.apache.kafka.server.config.QuotaConfig;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ConfigCommand$
implements Logging {
    public static final ConfigCommand$ MODULE$ = new ConfigCommand$();
    private static final String BrokerDefaultEntityName;
    private static final String BrokerLoggerConfigType;
    private static final Buffer<String> kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes;
    private static final int DefaultScramIterations;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        BrokerDefaultEntityName = "";
        BrokerLoggerConfigType = "broker-loggers";
        kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ConfigType.ALL).asScala().$colon$plus(MODULE$.BrokerLoggerConfigType());
        DefaultScramIterations = 4096;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private String BrokerDefaultEntityName() {
        return BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return BrokerLoggerConfigType;
    }

    public Buffer<String> kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes() {
        return kafka$admin$ConfigCommand$$BrokerSupportedConfigTypes;
    }

    private int DefaultScramIterations() {
        return DefaultScramIterations;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils.maybePrintHelpOrVersion(opts, "This tool helps to manipulate and describe entity config for a topic, client, user, broker, ip, client-metrics, group or cluster link.");
            opts.checkArgs();
            this.processCommand(opts);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException ? true : (throwable2 instanceof InvalidConfigurationException ? true : throwable2 instanceof OptionException)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Failed config command with args '" + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ") + "'", throwable2);
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                System.err.println(throwable2.getMessage());
                Exit.exit((int)1);
            }
            if (throwable2 instanceof UnsupportedVersionException) {
                UnsupportedVersionException unsupportedVersionException = (UnsupportedVersionException)throwable2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Unsupported API encountered in server when executing config command with args '{}'", (Object)Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" "));
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                System.err.println(unsupportedVersionException.getMessage());
                Exit.exit((int)1);
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Error while executing config command with args '" + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ") + "'", throwable3);
                    v2 = BoxedUnit.UNIT;
                } else {
                    v2 = BoxedUnit.UNIT;
                }
                System.err.println("Error while executing config command with args '" + Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ") + "'");
                throwable3.printStackTrace(System.err);
                Exit.exit((int)1);
            }
            throw throwable;
        }
    }

    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = new Properties();
        if (opts.options.has(opts.addConfigFile())) {
            String file = opts.options.valueOf(opts.addConfigFile());
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(Utils.loadProps((String)file));
        }
        if (opts.options.has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(opts.options.valueOf(opts.addConfig()).split("," + pattern)), (Function1<String, String[]> & Serializable)x$1 -> x$1.split("\\s*=\\s*" + pattern, -1), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded), (Function1<String[], Object> & Serializable)config -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config))), (Function0<Object>)(Function0<String> & Serializable)() -> "Invalid entity config: all configs to be added must be in the format \"key=val\" or  \"key=[val1,val2]\" to group values which contain commas.");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded), (Function1<String[], Object> & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
        }
        this.validatePropsKey(props);
        return this.parseReplicaPlacementConfig(props, opts);
    }

    private Properties parseReplicaPlacementConfig(Properties props, ConfigCommand.ConfigCommandOptions opts) {
        block1: {
            if (props.containsKey("confluent.placement.constraints")) {
                throw new IllegalArgumentException("When adding the confluent.placement.constraints configuration please use the --replica-placement flag");
            }
            if (!opts.options.has(opts.replicaPlacementOpt())) break block1;
            String jsonString = Utils.readFileAsString((String)opts.options.valueOf(opts.replicaPlacementOpt()));
            OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(TopicPlacement.parse(jsonString))).foreach((Function1<TopicPlacement, Object> & Serializable)replicaPlacement -> props.setProperty("confluent.placement.constraints", replicaPlacement.toJson()));
        }
        return props;
    }

    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options.has(opts.deleteConfig())) {
            Buffer configsToBeDeleted = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(opts.options.valuesOf(opts.deleteConfig())).asScala().map((Function1<String, String> & Serializable)x$2 -> x$2.trim());
            return configsToBeDeleted;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void validatePropsKey(Properties props) {
        props.keySet().forEach(propsKey -> {
            if (!propsKey.toString().matches("[a-zA-Z0-9._-]*")) {
                throw new IllegalArgumentException("Invalid character found for config key: " + propsKey);
            }
        });
    }

    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        CommandLineUtils.initializeBootstrapProperties(opts.parser, opts.options, props, opts.bootstrapServerOpt(), opts.bootstrapControllerOpt());
        Admin adminClient = Admin.create((Properties)props);
        if (opts.options.has(opts.alterOpt()) && opts.entityTypes().size() != opts.entityNames().size()) {
            throw new IllegalArgumentException("An entity name must be specified for every entity type");
        }
        try {
            if (opts.options.has(opts.alterOpt())) {
                this.alterConfig(adminClient, opts);
            } else if (opts.options.has(opts.describeOpt())) {
                this.describeConfig(adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    private void verifyClusterLinkingPropertyAndFilters(Properties propsToBeAdded, String propName, String propFilterName, ConfigCommand.ConfigCommandOptions opts) {
        boolean propValue = propsToBeAdded.getProperty(propName, "false").equals("true");
        String propFilterJsonValue = propsToBeAdded.getProperty(propFilterName, "");
        if (propValue && propFilterJsonValue.trim().isEmpty()) {
            opts.printMessageAndExit(propName + " is set to true but the JSON filters are not passed in. Please pass in the path to the JSON file using the --add-config-file option and rerun the alter config command.");
            return;
        }
    }

    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        String entityNameHead;
        String entityTypeHead;
        block37: {
            String string;
            Seq<String> configsToBeDeleted;
            scala.collection.immutable.Map configsToBeAdded;
            scala.collection.immutable.Map<String, String> configsToBeAddedMap;
            List<String> entityNames;
            List<String> entityTypes;
            block38: {
                ConfigResource.Type type;
                block39: {
                    block36: {
                        Seq invalidConfigs;
                        entityTypes = opts.entityTypes();
                        entityNames = opts.entityNames();
                        entityTypeHead = (String)entityTypes.head();
                        entityNameHead = (String)entityNames.head();
                        Properties configsToBeAddedProps = this.parseConfigsToBeAdded(opts);
                        configsToBeAddedMap = CollectionConverters$.MODULE$.PropertiesHasAsScala(configsToBeAddedProps).asScala().toMap($less$colon$less$.MODULE$.refl());
                        configsToBeAdded = (scala.collection.immutable.Map)configsToBeAddedMap.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                String k = (String)tuple2._1();
                                String v = (String)tuple2._2();
                                return new Tuple2<String, ConfigEntry>(k, new ConfigEntry(k, v));
                            }
                            throw new MatchError(tuple2);
                        });
                        configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
                        string = entityTypeHead;
                        if (!"cluster-links".equals(string)) break block36;
                        scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1<ConfigEntry, Tuple2> & Serializable)entry -> new Tuple2<String, ConfigEntry>(entry.name(), (ConfigEntry)entry))).toMap($less$colon$less$.MODULE$.refl());
                        boolean isDestination = oldConfig.get(ClusterLinkConfig$.MODULE$.LinkModeProp()).forall((Function1<ConfigEntry, Object> & Serializable)m -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$3(m)));
                        if (isDestination) {
                            this.verifyClusterLinkingPropertyAndFilters(configsToBeAddedProps, ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), ClusterLinkConfig$.MODULE$.AclFiltersProp(), opts);
                            this.verifyClusterLinkingPropertyAndFilters(configsToBeAddedProps, ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), opts);
                            this.verifyClusterLinkingPropertyAndFilters(configsToBeAddedProps, ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), ClusterLinkConfig$.MODULE$.TopicFiltersProp(), opts);
                        }
                        if ((invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(oldConfig.contains(key)))).nonEmpty()) {
                            throw new InvalidConfigurationException("Invalid config(s): " + invalidConfigs.mkString(","));
                        }
                        ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, entityNameHead);
                        AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                        Collection alterEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)configsToBeAdded.values().map((Function1<ConfigEntry, AlterConfigOp> & Serializable)x$3 -> new AlterConfigOp(x$3, AlterConfigOp.OpType.SET))).$plus$plus((IterableOnce)configsToBeDeleted.map((Function1<String, AlterConfigOp> & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE)))).asJavaCollection();
                        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(configResource), alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                        break block37;
                    }
                    if (!("topics".equals(string) ? true : ("client-metrics".equals(string) ? true : ("brokers".equals(string) ? true : "groups".equals(string))))) break block38;
                    String string2 = entityTypeHead;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case -2143183679: {
                            if (!"client-metrics".equals(string2)) break;
                            type = ConfigResource.Type.CLIENT_METRICS;
                            break block39;
                        }
                        case -1237460524: {
                            if (!"groups".equals(string2)) break;
                            type = ConfigResource.Type.GROUP;
                            break block39;
                        }
                        case -868034268: {
                            if (!"topics".equals(string2)) break;
                            type = ConfigResource.Type.TOPIC;
                            break block39;
                        }
                        case 150569914: {
                            if (!"brokers".equals(string2)) break;
                            type = ConfigResource.Type.BROKER;
                            break block39;
                        }
                    }
                    throw new MatchError((Object)string2);
                }
                ConfigResource.Type configResourceType = type;
                try {
                    this.alterResourceConfig(adminClient, entityTypeHead, entityNameHead, configsToBeDeleted, configsToBeAdded, configResourceType);
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof UnsupportedVersionException) {
                        throw new UnsupportedVersionException("The " + ApiKeys.INCREMENTAL_ALTER_CONFIGS + " API is not supported by the cluster. The API is supported starting from version 2.3.0. You may want to use an older version of this tool to interact with your cluster, or upgrade your brokers to version 2.3.0 or newer to avoid this error.");
                    }
                    throw e;
                }
                catch (Throwable e) {
                    throw e;
                }
            }
            String string3 = this.BrokerLoggerConfigType();
            String string4 = string;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                scala.collection.immutable.Seq validLoggers = (scala.collection.immutable.Seq)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, true, false).map((Function1<ConfigEntry, String> & Serializable)x$4 -> x$4.name());
                Seq invalidBrokerLoggers = (Seq)((IterableOps)configsToBeDeleted.filterNot((Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(validLoggers.contains(elem)))).$plus$plus((IterableOnce)configsToBeAdded.keys().filterNot((Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(validLoggers.contains(elem))));
                if (invalidBrokerLoggers.nonEmpty()) {
                    throw new InvalidConfigurationException("Invalid broker logger(s): " + invalidBrokerLoggers.mkString(","));
                }
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Iterable addEntries = (Iterable)configsToBeAdded.values().map((Function1<ConfigEntry, AlterConfigOp> & Serializable)k -> new AlterConfigOp(k, AlterConfigOp.OpType.SET));
                Seq deleteEntries = (Seq)configsToBeDeleted.map((Function1<String, AlterConfigOp> & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
                Collection alterEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)deleteEntries.$plus$plus(addEntries)).asJavaCollection();
                adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(configResource), alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else if ("users".equals(string) ? true : "clients".equals(string)) {
                boolean hasQuotaConfigsToAdd = configsToBeAdded.keys().exists((Function1<String, Object> & Serializable)name -> BoxesRunTime.boxToBoolean(Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig(name))));
                scala.collection.immutable.Map scramConfigsToAddMap = (scala.collection.immutable.Map)configsToBeAdded.filter((Function1<Tuple2, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$13(entry)));
                Iterable unknownConfigsToAdd = (Iterable)configsToBeAdded.keys().filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$14(key)));
                boolean hasQuotaConfigsToDelete = configsToBeDeleted.exists((Function1<String, Object> & Serializable)name -> BoxesRunTime.boxToBoolean(Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig(name))));
                Seq scramConfigsToDelete = (Seq)configsToBeDeleted.filter((Function1<String, Object> & Serializable)mechanismName -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$16(mechanismName)));
                Seq unknownConfigsToDelete = (Seq)configsToBeDeleted.filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$17(key)));
                String string5 = entityTypeHead;
                String string6 = "clients";
                if (!(string5 == null ? string6 != null : !string5.equals(string6)) || entityTypes.size() == 2) {
                    if (unknownConfigsToAdd.nonEmpty() || scramConfigsToAddMap.nonEmpty()) {
                        throw new IllegalArgumentException("Only quota configs can be added for 'clients' using --bootstrap-server. Unexpected config names: " + unknownConfigsToAdd.$plus$plus(scramConfigsToAddMap.keys()));
                    }
                    if (unknownConfigsToDelete.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                        throw new IllegalArgumentException("Only quota configs can be deleted for 'clients' using --bootstrap-server. Unexpected config names: " + unknownConfigsToDelete.$plus$plus(scramConfigsToDelete));
                    }
                } else {
                    if (unknownConfigsToAdd.nonEmpty()) {
                        throw new IllegalArgumentException("Only quota and SCRAM credential configs can be added for 'users' using --bootstrap-server. Unexpected config names: " + unknownConfigsToAdd);
                    }
                    if (unknownConfigsToDelete.nonEmpty()) {
                        throw new IllegalArgumentException("Only quota and SCRAM credential configs can be deleted for 'users' using --bootstrap-server. Unexpected config names: " + unknownConfigsToDelete);
                    }
                    if (scramConfigsToAddMap.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                        if (entityNames.exists((Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isEmpty()))) {
                            throw new IllegalArgumentException("The use of --entity-default or --user-defaults is not allowed with User SCRAM Credentials using --bootstrap-server.");
                        }
                        if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                            throw new IllegalArgumentException("Cannot alter both quota and SCRAM credential configs simultaneously for 'users' using --bootstrap-server.");
                        }
                    }
                }
                if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                    this.alterQuotaConfigs(adminClient, entityTypes, entityNames, configsToBeAddedMap, configsToBeDeleted);
                } else {
                    if (entityNames.size() != 1) {
                        throw new IllegalStateException("Altering user SCRAM credentials should never occur for more zero or multiple users: " + entityNames);
                    }
                    this.alterUserScramCredentialConfigs(adminClient, (String)entityNames.head(), scramConfigsToAddMap, scramConfigsToDelete);
                }
            } else if ("ips".equals(string)) {
                Iterable unknownConfigs = (Iterable)((IterableOps)configsToBeAdded.keys().$plus$plus(configsToBeDeleted)).filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$19(key)));
                if (unknownConfigs.nonEmpty()) {
                    throw new IllegalArgumentException("Only connection quota configs can be added for 'ips' using --bootstrap-server. Unexpected config names: " + unknownConfigs.mkString(","));
                }
                this.alterQuotaConfigs(adminClient, entityTypes, entityNames, configsToBeAddedMap, configsToBeDeleted);
            } else if ("confluent-tenants".equals(string)) {
                Iterable unknownConfigs = (Iterable)((IterableOps)configsToBeAdded.keys().$plus$plus(configsToBeDeleted)).filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$alterConfig$20(key)));
                if (unknownConfigs.nonEmpty()) {
                    throw new IllegalArgumentException("Only connection quota configs can be added for 'confluent-tenants' using --bootstrap-server. Unexpected config names: " + unknownConfigs.mkString(","));
                }
                this.alterQuotaConfigs(adminClient, entityTypes, entityNames, configsToBeAddedMap, configsToBeDeleted);
            } else {
                throw new IllegalArgumentException("Unsupported entity type: " + entityTypeHead);
            }
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityNameHead))) {
            System.out.println("Completed updating config for " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityTypeHead), 1) + " " + entityNameHead + ".");
            return;
        }
        System.out.println("Completed updating default config for " + entityTypeHead + " in the cluster.");
    }

    private Void alterUserScramCredentialConfigs(Admin adminClient, String user, Map<String, ConfigEntry> scramConfigsToAddMap, Seq<String> scramConfigsToDelete) {
        Seq deletions = (Seq)scramConfigsToDelete.map((Function1<String, UserScramCredentialDeletion> & Serializable)mechanismName -> new UserScramCredentialDeletion(user, ScramMechanism.fromMechanismName((String)mechanismName)));
        Iterable upsertions = (Iterable)scramConfigsToAddMap.map((Function1<Tuple2, UserScramCredentialUpsertion> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String mechanismName = (String)tuple2._1();
                ConfigEntry configEntry = (ConfigEntry)tuple2._2();
                Tuple2 tuple22 = this.iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName((String)mechanismName), configEntry.value());
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Integer iterations = (Integer)tuple22._1();
                byte[] passwordBytes = (byte[])tuple22._2();
                Tuple2<Integer, byte[]> tuple23 = new Tuple2<Integer, byte[]>(iterations, passwordBytes);
                Integer iterations2 = tuple23._1();
                byte[] passwordBytes2 = tuple23._2();
                return new UserScramCredentialUpsertion(user, new ScramCredentialInfo(ScramMechanism.fromMechanismName((String)mechanismName), Predef$.MODULE$.Integer2int(iterations2)), passwordBytes2);
            }
            throw new MatchError(tuple2);
        });
        return (Void)adminClient.alterUserScramCredentials(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)deletions.$plus$plus(upsertions)).toList()).asJava()).all().get(60L, TimeUnit.SECONDS);
    }

    private Void alterQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames, Map<String, String> configsToBeAddedMap, Seq<String> configsToBeDeleted) {
        Map<String, Double> oldConfig = this.getClientQuotasConfig(adminClient, entityTypes, entityNames);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(oldConfig.contains(key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException("Invalid config(s): " + invalidConfigs.mkString(","));
        }
        Object alterEntityTypes = entityTypes.map((Function1<String, String> & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1873421222: {
                    if (!"confluent-tenants".equals(string)) break;
                    return "confluent-tenant";
                }
                case 104492: {
                    if (!"ips".equals(string)) break;
                    return "ip";
                }
                case 111578632: {
                    if (!"users".equals(string)) break;
                    return "user";
                }
                case 860587528: {
                    if (!"clients".equals(string)) break;
                    return "client-id";
                }
            }
            throw new IllegalArgumentException("Unexpected entity type: " + string);
        });
        Object alterEntityNames = entityNames.map((Function1<String, String> & Serializable)en -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)en))) {
                return en;
            }
            return null;
        });
        HashMap alterEntityMap = new HashMap();
        ((List)((List)alterEntityTypes).zip((IterableOnce)alterEntityNames)).foreach((Function1<Tuple2, String> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return alterEntityMap.put(k, v);
            }
            throw new MatchError(tuple2);
        });
        ClientQuotaEntity entity = new ClientQuotaEntity(alterEntityMap);
        AlterClientQuotasOptions alterOptions = new AlterClientQuotasOptions().validateOnly(false);
        Collection alterOps = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)configsToBeAddedMap.map((Function1<Tuple2, ClientQuotaAlteration.Op> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                double d;
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                try {
                    d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot parse quota configuration value for " + key + ": " + value);
                }
                double doubleValue = d;
                return new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(doubleValue));
            }
            throw new MatchError(tuple2);
        })).$plus$plus((IterableOnce)configsToBeDeleted.map((Function1<String, ClientQuotaAlteration.Op> & Serializable)key -> new ClientQuotaAlteration.Op(key, null)))).asJavaCollection();
        return (Void)adminClient.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(entity, alterOps)), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        boolean describeAll = opts.options.has(opts.allOpt());
        String string = (String)entityTypes.head();
        if ("topics".equals(string)) {
            bl = true;
        } else if ("brokers".equals(string)) {
            bl = true;
        } else {
            String string2 = this.BrokerLoggerConfigType();
            String string3 = string;
            bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : ("cluster-links".equals(string) ? true : ("client-metrics".equals(string) ? true : "groups".equals(string)));
        }
        if (bl) {
            this.describeResourceConfig(adminClient, (String)entityTypes.head(), entityNames.headOption(), describeAll);
            return;
        }
        if ("users".equals(string) ? true : "clients".equals(string)) {
            this.describeClientQuotaAndUserScramCredentialConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        if ("ips".equals(string) ? true : "confluent-tenants".equals(string)) {
            this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        throw new IllegalArgumentException("Invalid entity type: " + string);
    }

    private void describeResourceConfig(Admin adminClient, String entityType, Option<String> entityName, boolean describeAll) {
        scala.collection.immutable.Seq entities = (scala.collection.immutable.Seq)entityName.map((Function1<String, List> & Serializable)name -> new $colon$colon<Nothing$>((Nothing$)((Object)name), Nil$.MODULE$)).getOrElse((Function0<scala.collection.immutable.Seq> & Serializable)() -> {
            boolean bl;
            String string = entityType;
            if ("topics".equals(string)) {
                return CollectionConverters$.MODULE$.SetHasAsScala((Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala().toSeq();
            }
            if ("brokers".equals(string)) {
                bl = true;
            } else {
                String string2 = MODULE$.BrokerLoggerConfigType();
                String string3 = string;
                bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            if (bl) {
                return (scala.collection.immutable.Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala().map((Function1<Node, String> & Serializable)x$8 -> x$8.idString())).toSeq().$colon$plus(MODULE$.BrokerDefaultEntityName());
            }
            if ("cluster-links".equals(string)) {
                ConfluentAdmin confluentAdminClient = (ConfluentAdmin)adminClient;
                return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)confluentAdminClient.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala().map((Function1<ClusterLinkListing, String> & Serializable)x$9 -> x$9.linkName())).toSeq();
            }
            if ("client-metrics".equals(string)) {
                return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.listClientMetricsResources().all().get()).asScala().map((Function1<ClientMetricsResourceListing, String> & Serializable)x$10 -> x$10.name())).toSeq();
            }
            if ("groups".equals(string)) {
                return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.listConsumerGroups().all().get()).asScala().map((Function1<ConsumerGroupListing, String> & Serializable)x$11 -> x$11.groupId())).toSeq();
            }
            throw new IllegalArgumentException("Invalid entity type: " + string);
        });
        entities.foreach((Function1<String, Object> & Serializable)entity -> {
            ConfigCommand$.$anonfun$describeResourceConfig$7(entityType, describeAll, adminClient, entity);
            return BoxedUnit.UNIT;
        });
    }

    private void alterResourceConfig(Admin adminClient, String entityTypeHead, String entityNameHead, Seq<String> configsToBeDeleted, Map<String, ConfigEntry> configsToBeAdded, ConfigResource.Type resourceType) {
        scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1<ConfigEntry, Tuple2> & Serializable)entry -> new Tuple2<String, ConfigEntry>(entry.name(), (ConfigEntry)entry))).toMap($less$colon$less$.MODULE$.refl());
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1<String, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(oldConfig.contains(key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException("Invalid config(s): " + invalidConfigs.mkString(","));
        }
        ConfigResource configResource = new ConfigResource(resourceType, entityNameHead);
        AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
        Iterable addEntries = (Iterable)configsToBeAdded.values().map((Function1<ConfigEntry, AlterConfigOp> & Serializable)k -> new AlterConfigOp(k, AlterConfigOp.OpType.SET));
        Seq deleteEntries = (Seq)configsToBeDeleted.map((Function1<String, AlterConfigOp> & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
        Collection alterEntries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)deleteEntries.$plus$plus(addEntries)).asJavaCollection();
        adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(configResource), alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    private scala.collection.immutable.Seq<ConfigEntry> getResourceConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>> tuple2;
        String string = entityType;
        if ("topics".equals(string)) {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityName))) {
                Topic.validate((String)entityName);
            }
            tuple2 = new Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>>(ConfigResource.Type.TOPIC, new Some<ConfigEntry.ConfigSource>(ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG));
        } else if ("brokers".equals(string)) {
            String string2 = entityName;
            String string3 = this.BrokerDefaultEntityName();
            String string4 = string2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tuple2 = new Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>>(ConfigResource.Type.BROKER, new Some<ConfigEntry.ConfigSource>(ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG));
            } else {
                ConfigCommand$.validateBrokerId$1(entityName, entityType);
                tuple2 = new Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>>(ConfigResource.Type.BROKER, new Some<ConfigEntry.ConfigSource>(ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG));
            }
        } else {
            String string5 = this.BrokerLoggerConfigType();
            String string6 = string;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityName))) {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                }
                tuple2 = new Tuple2<ConfigResource.Type, None$>(ConfigResource.Type.BROKER_LOGGER, None$.MODULE$);
            } else if ("cluster-links".equals(string)) {
                ClusterLinkUtils$.MODULE$.validateLinkName(entityName);
                tuple2 = new Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>>(ConfigResource.Type.CLUSTER_LINK, new Some<ConfigEntry.ConfigSource>(ConfigEntry.ConfigSource.DYNAMIC_CLUSTER_LINK_CONFIG));
            } else if ("client-metrics".equals(string)) {
                tuple2 = new Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>>(ConfigResource.Type.CLIENT_METRICS, new Some<ConfigEntry.ConfigSource>(ConfigEntry.ConfigSource.DYNAMIC_CLIENT_METRICS_CONFIG));
            } else if ("groups".equals(string)) {
                tuple2 = new Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>>(ConfigResource.Type.GROUP, new Some<ConfigEntry.ConfigSource>(ConfigEntry.ConfigSource.DYNAMIC_GROUP_CONFIG));
            } else {
                throw new IllegalArgumentException("Invalid entity type: " + string);
            }
        }
        Tuple2<ConfigResource.Type, Some<ConfigEntry.ConfigSource>> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        ConfigResource.Type configResourceType = (ConfigResource.Type)tuple22._1();
        Option dynamicConfigSource = (Option)tuple22._2();
        Tuple2<ConfigResource.Type, Option> tuple23 = new Tuple2<ConfigResource.Type, Option>(configResourceType, dynamicConfigSource);
        ConfigResource.Type configResourceType2 = tuple23._1();
        Option dynamicConfigSource2 = tuple23._2();
        Option configSourceFilter = describeAll ? None$.MODULE$ : dynamicConfigSource2;
        ConfigResource configResource = new ConfigResource(configResourceType2, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return (scala.collection.immutable.Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)configs.get(configResource)).entries()).asScala().filter((Function1<ConfigEntry, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(ConfigCommand$.$anonfun$getResourceConfig$1(configSourceFilter, entry)))).toSeq().sortBy((Function1<ConfigEntry, String> & Serializable)entry -> entry.name(), Ordering.String$.MODULE$);
    }

    private void describeQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> quotaConfigs = this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames);
        quotaConfigs.foreachEntry((Function2<ClientQuotaEntity, java.util.Map, Object> & Serializable)(entity, entries) -> {
            ConfigCommand$.$anonfun$describeQuotaConfigs$1(entity, entries);
            return BoxedUnit.UNIT;
        });
    }

    private void describeClientQuotaAndUserScramCredentialConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
        if (!entityTypes.contains("clients") && !entityNames.contains("")) {
            DescribeUserScramCredentialsResult result = adminClient.describeUserScramCredentials(CollectionConverters$.MODULE$.SeqHasAsJava(entityNames).asJava());
            CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result.users().get(30L, TimeUnit.SECONDS)).asScala().foreach((Function1<String, Object> & Serializable)user -> {
                ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(result, user);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Map<String, Double> getClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        if (entityTypes.size() != entityNames.size()) {
            throw new IllegalArgumentException("Exactly one entity name must be specified for every entity type");
        }
        return (Map)this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).headOption().map((Function1<Tuple2, scala.collection.mutable.Map> & Serializable)x$13 -> CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)x$13._2()).asScala()).getOrElse((Function0<Map> & Serializable)() -> (Map)Map$.MODULE$.empty());
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> getAllClientQuotasConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        Object components = ((List)((AbstractIterable)entityTypes.map((Function1<String, Some> & Serializable)x$14 -> new Some<String>((String)x$14))).zipAll((Iterable)entityNames.map((Function1<String, Some> & Serializable)x$15 -> new Some<String>((String)x$15)), None$.MODULE$, None$.MODULE$)).map(ConfigCommand$::$anonfun$getAllClientQuotasConfigs$3);
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.describeClientQuotas(ClientQuotaFilter.containsOnly(CollectionConverters$.MODULE$.SeqHasAsJava(components).asJava())).entities().get(30L, TimeUnit.SECONDS)).asScala();
    }

    public boolean isValidIpEntity(String ip) {
        try {
            InetAddress.getByName(ip);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$3(ConfigEntry m) {
        return ClusterLinkConfig.LinkMode.fromString(m.value()).mayActAsDestination();
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$13(Tuple2 entry) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)((String)entry._1()));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$14(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig(key));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$16(String mechanismName) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)mechanismName);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$17(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || Predef$.MODULE$.Boolean2boolean(QuotaConfig.isClientOrUserQuotaConfig(key));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$19(String key) {
        return DynamicConfig$Ip$.MODULE$.names().contains(key);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$20(String key) {
        return DynamicConfig$Tenant$.MODULE$.names().contains(key);
    }

    /*
     * Unable to fully structure code
     */
    private final Tuple2 iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        block5: {
            block4: {
                pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:iterations=(\\-?[0-9]*),)?password=(.*)"));
                var8_4 = credentialStr;
                if (var8_4 == null || (var9_5 = pattern.unapplySeq(var8_4)).isEmpty() || var9_5.get() == null || var9_5.get().lengthCompare(2) != 0) break block4;
                iterations = (String)((LinearSeqOps)var9_5.get()).apply(0);
                password = (String)((LinearSeqOps)var9_5.get()).apply(1);
                if (iterations == null) ** GOTO lbl-1000
                v0 = iterations;
                var12_8 = "-1";
                if (v0 == null ? var12_8 != null : v0.equals(var12_8) == false) {
                    v1 = BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(iterations)));
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxesRunTime.boxToInteger(this.DefaultScramIterations());
                }
                break block5;
            }
            throw new IllegalArgumentException("Invalid credential property " + mechanism + "=" + credentialStr);
        }
        var7_9 = new Tuple2<Integer, String>(v1, password);
        if (var7_9 == null) {
            throw new MatchError(var7_9);
        }
        iterations = var7_9._1$mcI$sp();
        password = var7_9._2();
        var6_12 = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(iterations), password);
        iterations = var6_12._1$mcI$sp();
        password = var6_12._2();
        if (iterations < mechanism.minIterations()) {
            throw new IllegalArgumentException("Iterations " + iterations + " is less than the minimum " + mechanism.minIterations() + " required for " + mechanism.mechanismName());
        }
        return new Tuple2<Integer, byte[]>(Predef$.MODULE$.int2Integer(iterations), password.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$8(ConfigEntry entry) {
        String synonyms = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(entry.synonyms()).asScala().map((Function1<ConfigEntry.ConfigSynonym, String> & Serializable)synonym -> synonym.source() + ":" + synonym.name() + "=" + synonym.value())).mkString(", ");
        System.out.println("  " + entry.name() + "=" + entry.value() + " sensitive=" + entry.isSensitive() + " synonyms={" + synonyms + "}");
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$7(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = entity;
        String string2 = MODULE$.BrokerDefaultEntityName();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            System.out.println("Default configs for " + entityType$1 + " in the cluster are:");
        } else {
            String configSourceStr = describeAll$1 ? "All" : "Dynamic";
            System.out.println(configSourceStr + " configs for " + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entityType$1), 1) + " " + entity + " are:");
        }
        MODULE$.getResourceConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1<ConfigEntry, Object> & Serializable)entry -> {
            ConfigCommand$.$anonfun$describeResourceConfig$8(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$1, String entityType$2) {
        try {
            StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(entityName$1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The entity name for " + entityType$2 + " must be a valid integer broker id, found: " + entityName$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getResourceConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        Option option = configSourceFilter$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)some.value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            ConfigEntry.ConfigSource configSource3 = configSource;
            return !(configSource2 != null ? !configSource2.equals(configSource3) : configSource3 != null);
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    private static final Option entitySubstr$1(String entityType, scala.collection.mutable.Map entityEntries$1) {
        return entityEntries$1.get(entityType).map((Function1<String, String> & Serializable)name -> {
            String string;
            block7: {
                String string2 = entityType;
                switch (string2 == null ? 0 : string2.hashCode()) {
                    case -1904137635: {
                        if (!"client-id".equals(string2)) break;
                        string = "client-id";
                        break block7;
                    }
                    case -753169607: {
                        if (!"confluent-tenant".equals(string2)) break;
                        string = "confluent-tenant";
                        break block7;
                    }
                    case 3367: {
                        if (!"ip".equals(string2)) break;
                        string = "ip";
                        break block7;
                    }
                    case 3599307: {
                        if (!"user".equals(string2)) break;
                        string = "user-principal";
                        break block7;
                    }
                }
                throw new MatchError((Object)string2);
            }
            String typeStr = string;
            if (name != null) {
                return typeStr + " '" + name + "'";
            }
            return "the default " + typeStr;
        });
    }

    public static final /* synthetic */ void $anonfun$describeQuotaConfigs$1(ClientQuotaEntity entity, java.util.Map entries) {
        scala.collection.mutable.Map entityEntries = CollectionConverters$.MODULE$.MapHasAsScala(entity.entries()).asScala();
        String entityStr = ((IterableOnceOps)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("user", entityEntries)).$plus$plus(ConfigCommand$.entitySubstr$1("client-id", entityEntries))).$plus$plus(ConfigCommand$.entitySubstr$1("ip", entityEntries))).$plus$plus(ConfigCommand$.entitySubstr$1("confluent-tenant", entityEntries))).mkString(", ");
        String entriesStr = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(entries).asScala().map((Function1<Tuple2, String> & Serializable)e -> e._1() + "=" + e._2())).mkString(", ");
        System.out.println("Quota configs for " + entityStr + " are " + entriesStr);
    }

    public static final /* synthetic */ void $anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(DescribeUserScramCredentialsResult result$1, String user) {
        try {
            UserScramCredentialsDescription description = (UserScramCredentialsDescription)result$1.description(user).get(30L, TimeUnit.SECONDS);
            String descriptionText = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(description.credentialInfos()).asScala().map((Function1<ScramCredentialInfo, String> & Serializable)info -> info.mechanism().mechanismName() + "=iterations=" + info.iterations())).mkString(", ");
            System.out.println("SCRAM credential configs for user-principal '" + user + "' are " + descriptionText);
        }
        catch (Exception e) {
            System.out.println("Error retrieving SCRAM credential configs for user-principal '" + user + "': " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClientQuotaFilterComponent $anonfun$getAllClientQuotasConfigs$3(Tuple2 x0$1) {
        block14: {
            var4_1 = x0$1;
            if (var4_1 == null) break block14;
            entityTypeOpt = (Option)var4_1._1();
            entityNameOpt = (Option)var4_1._2();
            var8_4 = false;
            var9_5 = null;
            var10_6 = entityTypeOpt;
            if (!(var10_6 instanceof Some)) ** GOTO lbl-1000
            var8_4 = true;
            var9_5 = (Some)var10_6;
            var11_7 = (String)var9_5.value();
            if ("users".equals(var11_7)) {
                v0 = "user";
            } else if (var8_4 && "clients".equals(var12_8 = (String)var9_5.value())) {
                v0 = "client-id";
            } else if (var8_4 && "ips".equals(var13_9 = (String)var9_5.value())) {
                v0 = "ip";
            } else if (var8_4 && "confluent-tenants".equals(var14_10 = (String)var9_5.value())) {
                v0 = "confluent-tenant";
            } else {
                if (var8_4) {
                    throw new IllegalArgumentException("Unexpected entity type " + entityTypeOpt.get());
                }
                if (None$.MODULE$.equals(var10_6)) {
                    throw new IllegalArgumentException("More entity names specified than entity types");
                }
                throw new MatchError(var10_6);
            }
            entityType = v0;
            var15_12 = false;
            var16_13 = null;
            var17_14 = entityNameOpt;
            if (var17_14 instanceof Some) {
                var15_12 = true;
                var16_13 = (Some)var17_14;
                var18_15 = (String)var16_13.value();
                if ("".equals(var18_15)) {
                    return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                }
            }
            if (var15_12) {
                name = (String)var16_13.value();
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name);
            }
            if (None$.MODULE$.equals(var17_14)) {
                return ClientQuotaFilterComponent.ofEntityType((String)entityType);
            }
            throw new MatchError(var17_14);
        }
        throw new MatchError(var4_1);
    }

    private ConfigCommand$() {
    }
}

