/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.ReplicaExclusionCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.common.errors.BrokerReplicaExclusionNotFoundException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ReplicaExclusionCommand$
implements Logging {
    public static final ReplicaExclusionCommand$ MODULE$ = new ReplicaExclusionCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaExclusionCommand$ replicaExclusionCommand$ = this;
        synchronized (replicaExclusionCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public ConfluentAdmin createAdminClient(ReplicaExclusionCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        return ConfluentAdmin.create((Properties)props);
    }

    public String flagName(OptionSpec<?> option) {
        return "--" + option.options().get(0);
    }

    public Option<String> reasonOpt(ReplicaExclusionCommandOptions opts) {
        if (opts.options.has(opts.reason())) {
            return new Some<String>(opts.valueOf(opts.reason()));
        }
        return None$.MODULE$;
    }

    public List<Object> brokerIds(ReplicaExclusionCommandOptions opts) {
        if (opts.options.has(opts.brokerIdsOpt())) {
            List<Object> list;
            String idString = opts.valueOf(opts.brokerIdsOpt());
            try {
                list = Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(idString), ',')), (Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1.trim()))), ClassTag$.MODULE$.Int())).toList();
            }
            catch (Exception e) {
                throw new AdminCommandFailedException("Error parsing broker ids - " + e.getMessage(), e);
            }
            return list;
        }
        return Nil$.MODULE$;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Error while executing replica exclusion: " + e.getMessage());
                this.error((Function0<String> & Serializable)() -> Utils.stackTrace((Throwable)e));
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block17: {
            ReplicaExclusionCommandOptions opts = new ReplicaExclusionCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0<ConfluentAdmin> & Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options.has(opts.addOpt())) {
                        Map<Integer, ExclusionOp> exclusions = this.exclusionsMap(ExclusionOp.OpType.SET, this.brokerIds(opts), this.reasonOpt(opts));
                        this.alterExclusions(ExclusionOp.OpType.SET, exclusions, client);
                    } else if (opts.options.has(opts.deleteOpt())) {
                        Map<Integer, ExclusionOp> exclusions = this.exclusionsMap(ExclusionOp.OpType.DELETE, this.brokerIds(opts), this.reasonOpt(opts));
                        this.alterExclusions(ExclusionOp.OpType.DELETE, exclusions, client);
                    } else if (opts.options.has(opts.describeOpt())) {
                        this.describeExclusions(client, this.brokerIds(opts));
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        ReplicaExclusionCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", e);
                        break block17;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                        ReplicaExclusionCommand$.throwAdminCommandFailedException$1(clusterAuthorizationException.getMessage(), e);
                        break block17;
                    }
                    if (throwable instanceof InvalidRequestException) {
                        InvalidRequestException invalidRequestException = (InvalidRequestException)throwable;
                        throw new AdminCommandFailedException(invalidRequestException.getMessage(), e);
                    }
                    if (throwable instanceof BrokerReplicaExclusionNotFoundException) {
                        BrokerReplicaExclusionNotFoundException brokerReplicaExclusionNotFoundException = (BrokerReplicaExclusionNotFoundException)throwable;
                        throw new AdminCommandFailedException(brokerReplicaExclusionNotFoundException.getMessage(), e);
                    }
                    if (throwable instanceof InvalidBrokerReplicaExclusionException) {
                        InvalidBrokerReplicaExclusionException invalidBrokerReplicaExclusionException = (InvalidBrokerReplicaExclusionException)throwable;
                        throw new AdminCommandFailedException(invalidBrokerReplicaExclusionException.getMessage(), e);
                    }
                    throw e;
                }
                catch (AdminCommandFailedException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println("Error while issuing request");
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    public void alterExclusions(ExclusionOp.OpType opType, Map<Integer, ExclusionOp> exclusions, ConfluentAdmin client) {
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)client.alterBrokerReplicaExclusions(exclusions).result().get();
        if (result.isSuccessful()) {
            ExclusionOp.OpType opType2 = opType;
            ExclusionOp.OpType opType3 = ExclusionOp.OpType.SET;
            String operationStr = !(opType2 != null ? !opType2.equals(opType3) : opType3 != null) ? "applied" : "removed";
            Predef$.MODULE$.println("Broker replica exclusion was successfully " + operationStr + " for brokers " + result.exclusionResultByBroker().keySet() + ".");
            return;
        }
        Set exclusionBrokerIds = result.exclusionResultByBroker().keySet();
        String indent = "   ";
        scala.collection.immutable.Map failedExclusions = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(result.exclusionResultByBroker()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReplicaExclusionCommand$.$anonfun$alterExclusions$1(x0$1)))).toMap($less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map brokerErrors = (scala.collection.immutable.Map)failedExclusions.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Integer k = (Integer)tuple2._1();
                ExclusionOpResult v = (ExclusionOpResult)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v.errorOpt().get());
            }
            throw new MatchError(tuple2);
        });
        List brokerErrorsStr = ((IterableOnceOps)brokerErrors.map((Function1<Tuple2, String> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Integer k = (Integer)tuple2._1();
                ExclusionOperationError v = (ExclusionOperationError)tuple2._2();
                return indent + "Broker " + k + " => " + v;
            }
            throw new MatchError(tuple2);
        })).toList();
        Iterable failedBrokerIds = failedExclusions.keys();
        ExclusionOp.OpType opType4 = opType;
        ExclusionOp.OpType opType5 = ExclusionOp.OpType.SET;
        String operationStr = !(opType4 != null ? !opType4.equals(opType5) : opType5 != null) ? "remove replica exclusions from" : "set replica exclusions for";
        Predef$.MODULE$.println("Failed to " + operationStr + " all brokers " + exclusionBrokerIds + ".");
        Predef$.MODULE$.println("Errors:" + System.lineSeparator() + brokerErrorsStr.mkString(System.lineSeparator()));
        throw new AdminCommandFailedException("Failed to " + operationStr + " all brokers " + exclusionBrokerIds + " due to failures with of brokers " + failedBrokerIds + " (" + brokerErrors + ")");
    }

    public Map<Integer, ExclusionOp> exclusionsMap(ExclusionOp.OpType exclusionOpType, List<Object> brokerIds, Option<String> reasonOpt) {
        return CollectionConverters$.MODULE$.MapHasAsJava(((AbstractIterable)brokerIds.map((Function1<Object, Tuple2> & Serializable)id -> ReplicaExclusionCommand$.$anonfun$exclusionsMap$1(reasonOpt, exclusionOpType, BoxesRunTime.unboxToInt(id)))).toMap($less$colon$less$.MODULE$.refl())).asJava();
    }

    private void describeExclusions(ConfluentAdmin client, List<Object> brokerIds) {
        Buffer describedExclusions = CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)client.describeBrokerReplicaExclusions().descriptions().get()).asScala();
        Buffer filteredExclusions = (Buffer)describedExclusions.filter((Function1<DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(ReplicaExclusionCommand$.$anonfun$describeExclusions$1(brokerIds, e)));
        List filteredExclusionIds = ((IterableOnceOps)filteredExclusions.map((Function1<DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription, Object> & Serializable)e -> BoxesRunTime.boxToInteger(e.brokerId()))).toList();
        if (describedExclusions.isEmpty()) {
            Predef$.MODULE$.println("No broker replica exclusions are present");
            return;
        }
        if (filteredExclusions.isEmpty()) {
            Predef$.MODULE$.println("There are no broker replica exclusions present for " + brokerIds);
            return;
        }
        Predef$.MODULE$.println("Brokers " + filteredExclusionIds + " are excluded for replica placements.");
        String indent = "    ";
        filteredExclusions.foreach((Function1<DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription, Object> & Serializable)desc -> {
            Predef$.MODULE$.println(indent + "Broker " + desc.brokerId() + "; Reason: " + desc.reason());
            return BoxedUnit.UNIT;
        });
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        Predef$.MODULE$.println(message);
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ boolean $anonfun$alterExclusions$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ExclusionOpResult value = (ExclusionOpResult)tuple2._2();
            return value.errorOpt().isPresent();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$exclusionsMap$1(Option reasonOpt$1, ExclusionOp.OpType exclusionOpType$1, int id) {
        ExclusionOp exclusionOp;
        Option option = reasonOpt$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            String reason = (String)some.value();
            exclusionOp = new ExclusionOp(exclusionOpType$1, reason);
        } else if (None$.MODULE$.equals(option)) {
            exclusionOp = new ExclusionOp(exclusionOpType$1);
        } else {
            throw new MatchError(option);
        }
        ExclusionOp exclusionOp2 = exclusionOp;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(id), exclusionOp2);
    }

    public static final /* synthetic */ boolean $anonfun$describeExclusions$1(List brokerIds$1, DescribeBrokerReplicaExclusionsResult.BrokerReplicaExclusionDescription e) {
        return brokerIds$1.isEmpty() || brokerIds$1.contains(BoxesRunTime.boxToInteger(e.brokerId()));
    }

    private ReplicaExclusionCommand$() {
    }
}

