/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import kafka.admin.ReplicaStatusCommand;
import kafka.admin.ReplicaStatusCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class ReplicaStatusCommand$
implements Logging {
    public static final ReplicaStatusCommand$ MODULE$ = new ReplicaStatusCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaStatusCommand$ replicaStatusCommand$ = this;
        synchronized (replicaStatusCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public List<String> headers(boolean includeClusterLink, boolean includeMirrorInfo) {
        Object clusterLink = includeClusterLink ? new $colon$colon<Nothing$>((Nothing$)((Object)"ClusterLink"), Nil$.MODULE$) : package$.MODULE$.List().empty();
        Object mirror = includeMirrorInfo ? new $colon$colon<Nothing$>((Nothing$)((Object)"MirrorState"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"MirrorLastFetchTimeMs"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"MirrorLastFetchHighWatermark"), Nil$.MODULE$))) : package$.MODULE$.List().empty();
        return (List)((IterableOps)((IterableOps)((IterableOps)new $colon$colon<Nothing$>((Nothing$)((Object)"Topic"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Partition"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Replica"), Nil$.MODULE$))).$plus$plus((IterableOnce)clusterLink)).$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"IsLeader", "IsObserver", "IsIsrEligible", "IsInIsr", "IsCaughtUp", "LastCaughtUpLagMs", "LastFetchLagMs", "LogStartOffset", "LogEndOffset", "LeaderEpoch"})))).$plus$plus(mirror)).$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)"ReplicationMode"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"ReplicationSessionId"), Nil$.MODULE$)));
    }

    public void main(String[] args) {
        this.run(args, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).second());
    }

    public void run(String[] args, Duration timeout) {
        ReplicaStatusCommandOptions commandOptions = new ReplicaStatusCommandOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion(commandOptions, "This tool prints out the replica status of partitions.");
        ReplicaStatusCommand.Args initializedArgs = this.validateAndInitializeArgs(commandOptions);
        try (ConfluentAdmin adminClient = this.createAdminClient(commandOptions, timeout);){
            this.replicaStatus(initializedArgs, adminClient);
        }
    }

    private ConfluentAdmin createAdminClient(ReplicaStatusCommandOptions commandOptions, Duration timeout) {
        Properties props = commandOptions.options.has(commandOptions.adminClientConfigOpt()) ? Utils.loadProps((String)commandOptions.options.valueOf(commandOptions.adminClientConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", commandOptions.options.valueOf(commandOptions.bootstrapServer()));
        props.setProperty("request.timeout.ms", Long.toString(timeout.toMillis()));
        return (KafkaAdminClient)AdminClient.create((Properties)props);
    }

    private void replicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        try {
            this.doReplicaStatus(args, client);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for results";
                Predef$.MODULE$.println(message);
                throw new AdminCommandFailedException(message, (Throwable)timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized";
                Predef$.MODULE$.println(message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println("Error while issuing request");
            throw e;
        }
    }

    private void doReplicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        Iterable iterable;
        scala.collection.immutable.Seq topics;
        if (args.topics() != null) {
            v0 = (scala.collection.immutable.Seq)args.topics().filterNot((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(ReplicaStatusCommand$.$anonfun$doReplicaStatus$1(args, x$1)));
        } else {
            this.debug((Function0<String> & Serializable)() -> "Calling AdminClient.listTopics()");
            v0 = topics = CollectionConverters$.MODULE$.SetHasAsScala((Set)client.listTopics(new ListTopicsOptions().listInternal(!args.excludeInternalTopics())).names().get()).asScala().toSeq();
        }
        if (args.partitions() != null) {
            iterable = (Iterable)topics.flatMap((Function1<String, Seq> & Serializable)topic -> (Seq)args.partitions().map((Function1<Object, TopicPartition> & Serializable)x$2 -> ReplicaStatusCommand$.$anonfun$doReplicaStatus$4(topic, BoxesRunTime.unboxToInt(x$2))));
        } else {
            this.debug((Function0<String> & Serializable)() -> "Calling AdminClient.describeTopics(" + topics);
            iterable = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(((Map)client.describeTopics(CollectionConverters$.MODULE$.IterableHasAsJava(topics).asJavaCollection()).allTopicNames().get()).values()).asScala().flatMap((Function1<TopicDescription, Buffer> & Serializable)td -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(td.partitions()).asScala().map((Function1<TopicPartitionInfo, TopicPartition> & Serializable)pi -> new TopicPartition(td.name(), pi.partition())));
        }
        Iterable topicPartitions = iterable;
        this.debug((Function0<String> & Serializable)() -> "Calling AdminClient.replicaStatus(" + topicPartitions + ")");
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(args.includeLinkedReplicas());
        ReplicaStatusResult result = client.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(topicPartitions.toSet()).asJava(), options);
        ListBuffer entries = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((List)CollectionConverters$.MODULE$.MapHasAsScala(result.partitionResults()).asScala().toList().sortBy((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition key = (TopicPartition)tuple2._1();
                return new Tuple2<String, Integer>(key.topic(), BoxesRunTime.boxToInteger(key.partition()));
            }
            throw new MatchError(tuple2);
        }, Ordering$.MODULE$.Tuple2(Ordering.String$.MODULE$, Ordering.Int$.MODULE$))).foreach((Function1<Tuple2, Buffer> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                KafkaFuture partitionResult = (KafkaFuture)tuple2._2();
                PartitionResult result = (PartitionResult)partitionResult.get();
                Buffer status = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(result.replicas()).asScala().sortBy((Function1<ReplicaStatus, Tuple2> & Serializable)rs -> new Tuple2<String, Integer>(rs.linkName().orElse(""), BoxesRunTime.boxToInteger(rs.brokerId())), Ordering$.MODULE$.Tuple2(Ordering.String$.MODULE$, Ordering.Int$.MODULE$));
                long leaderTimeMs = BoxesRunTime.unboxToLong(((IterableOps)((IterableOps)status.filter((Function1<ReplicaStatus, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isLeader()))).map((Function1<ReplicaStatus, Object> & Serializable)x$4 -> BoxesRunTime.boxToLong(x$4.lastCaughtUpTimeMs()))).headOption().getOrElse(() -> 0L));
                return (Buffer)((IterableOps)status.filterNot((Function1<ReplicaStatus, Object> & Serializable)st -> BoxesRunTime.boxToBoolean(ReplicaStatusCommand$.$anonfun$doReplicaStatus$15(args, st)))).map((Function1<ReplicaStatus, ListBuffer> & Serializable)x$7 -> (ListBuffer)entries.$plus$eq(MODULE$.toEntries(args, partition, (ReplicaStatus)x$7, (Option<Object>)new Some<Object>(BoxesRunTime.boxToInteger(result.leaderEpoch().orElse(-1))), leaderTimeMs)));
            }
            throw new MatchError(tuple2);
        });
        List<String> hdrs = this.headers(args.includeLinkedReplicas(), args.includeMirrorInfo());
        if (args.jsonOutput()) {
            this.printJson(hdrs, entries.toList());
            return;
        }
        if (args.verboseOutput()) {
            this.printVerbose(hdrs, entries.toList());
            return;
        }
        this.printCompact(hdrs, entries.toList());
    }

    /*
     * Unable to fully structure code
     */
    private List<String> toEntries(ReplicaStatusCommand.Args args, TopicPartition partition, ReplicaStatus status, Option<Object> leaderEpoch, long leaderTimeMs) {
        v0 = clusterLink = args.includeLinkedReplicas() != false ? new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromString$1(status.linkName(), args), Nil$.MODULE$) : package$.MODULE$.List().empty();
        if (!args.includeMirrorInfo()) {
            v1 = package$.MODULE$.List().empty();
        } else if (!status.mirrorInfo().isPresent()) {
            v1 = new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromString$1(Optional.empty(), args), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromLong$1(-1L, ReplicaStatusCommand$.fromLong$default$2$1()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromLong$1(-1L, ReplicaStatusCommand$.fromLong$default$2$1()), Nil$.MODULE$)));
        } else {
            mi = (ReplicaStatus.MirrorInfo)status.mirrorInfo().get();
            v1 = new $colon$colon<Nothing$>((Nothing$)mi.state().toString(), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromLong$1(mi.lastFetchTimeMs(), ReplicaStatusCommand$.fromLong$default$2$1()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromLong$1(mi.lastFetchSourceHighWatermark(), ReplicaStatusCommand$.fromLong$default$2$1()), Nil$.MODULE$)));
        }
        mirror = v1;
        var12_9 = leaderEpoch;
        if (!(var12_9 instanceof Some)) ** GOTO lbl-1000
        var13_10 = (Some)var12_9;
        epoch = BoxesRunTime.unboxToInt(var13_10.value());
        if (status.isLeader()) {
            v2 = epoch;
        } else lbl-1000:
        // 2 sources

        {
            v2 = -1;
        }
        epochInfo = v2;
        return (List)((IterableOps)((IterableOps)((IterableOps)new $colon$colon<Nothing$>((Nothing$)partition.topic(), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)Integer.toString(partition.partition()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)Integer.toString(status.brokerId()), Nil$.MODULE$))).$plus$plus((IterableOnce)clusterLink)).$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Boolean.toString(status.isLeader()), Boolean.toString(status.isObserver()), Boolean.toString(status.isIsrEligible()), Boolean.toString(status.isInIsr()), Boolean.toString(status.isCaughtUp()), ReplicaStatusCommand$.fromLagMs$1(status.lastCaughtUpTimeMs(), leaderTimeMs), ReplicaStatusCommand$.fromLagMs$1(status.lastFetchTimeMs(), leaderTimeMs), ReplicaStatusCommand$.fromLong$1(status.logStartOffset(), ReplicaStatusCommand$.fromLong$default$2$1()), ReplicaStatusCommand$.fromLong$1(status.logEndOffset(), ReplicaStatusCommand$.fromLong$default$2$1()), ReplicaStatusCommand$.fromLong$1(epochInfo, "\"N/A\"")})))).$plus$plus(mirror)).$plus$plus(new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.replicationModeFromString$1(status.replicationMode(), args), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)ReplicaStatusCommand$.fromLong$1(status.replicationSessionId().orElse(-1L), ReplicaStatusCommand$.fromLong$default$2$1()), Nil$.MODULE$)));
    }

    private void printJson(List<String> headers, List<List<String>> entries) {
        if (entries.isEmpty()) {
            Predef$.MODULE$.println("[]");
            return;
        }
        ObjectRef<String> lastTopic = ObjectRef.create("");
        ObjectRef<String> lastPartition = ObjectRef.create("");
        Predef$.MODULE$.println("[");
        ((List)entries.zipWithIndex()).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ReplicaStatusCommand$.$anonfun$printJson$1(lastTopic, lastPartition, headers, x0$1);
            return BoxedUnit.UNIT;
        });
        ReplicaStatusCommand$.closePartition$1();
        ReplicaStatusCommand$.closeTopic$1();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println("]");
    }

    private void printVerbose(List<String> headers, List<List<String>> entries) {
        ((List)entries.zipWithIndex()).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ReplicaStatusCommand$.$anonfun$printVerbose$1(headers, entries, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void printCompact(List<String> headers, List<List<String>> entries) {
        ArrayBuffer maxWidth = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((List)headers.zipWithIndex()).foreach((Function1<Tuple2, ArrayBuffer> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return (ArrayBuffer)maxWidth.$plus$eq(BoxesRunTime.boxToInteger(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(name))));
            }
            throw new MatchError(tuple2);
        });
        entries.foreach((Function1<List, Object> & Serializable)entry -> {
            ReplicaStatusCommand$.$anonfun$printCompact$2(maxWidth, entry);
            return BoxedUnit.UNIT;
        });
        ReplicaStatusCommand$.printEntries$1(headers, maxWidth);
        entries.foreach((Function1<List, Object> & Serializable)x$8 -> {
            ReplicaStatusCommand$.printEntries$1(x$8, maxWidth);
            return BoxedUnit.UNIT;
        });
    }

    private ReplicaStatusCommand.Args validateAndInitializeArgs(ReplicaStatusCommandOptions commandOptions) {
        List<String> missingOptions = package$.MODULE$.List().empty();
        if (!commandOptions.options.has(commandOptions.bootstrapServer())) {
            String string = commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon(string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException("Missing required option(s): " + missingOptions.mkString(", "));
        }
        ArraySeq.ofRef<Object> topicsArg = null;
        if (commandOptions.options.has(commandOptions.topicsOpt())) {
            topicsArg = Predef$.MODULE$.wrapRefArray((Object[])commandOptions.options.valueOf(commandOptions.topicsOpt()).split(","));
            topicsArg.foreach((Function1<String, Object> & Serializable)x$9 -> {
                ReplicaStatusCommand$.$anonfun$validateAndInitializeArgs$1(x$9);
                return BoxedUnit.UNIT;
            });
        }
        ListBuffer<Object> partitionsArg = null;
        if (commandOptions.options.has(commandOptions.partitionsOpt())) {
            ListBuffer<Object> tmpPartitions = new ListBuffer<Object>();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(commandOptions.options.valueOf(commandOptions.partitionsOpt()).split(",")), (Function1<String, Object> & Serializable)partitionStr -> {
                Object object;
                String[] divPartitions = partitionStr.split("-");
                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(divPartitions)) || ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(divPartitions)) > 2) {
                    throw new IllegalArgumentException("Invalid partition range: " + partitionStr);
                }
                try {
                    int first = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(divPartitions[0]));
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(divPartitions)) == 1) {
                        object = tmpPartitions.$plus$eq(BoxesRunTime.boxToInteger(first));
                    } else {
                        int second = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(divPartitions[1]));
                        if (first > second) {
                            throw new IllegalArgumentException("Invalid partition range: " + partitionStr);
                        }
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(first), second + 1).foreach((Function1<Object, ListBuffer> & Serializable)i -> ReplicaStatusCommand$.$anonfun$validateAndInitializeArgs$3(tmpPartitions, BoxesRunTime.unboxToInt(i)));
                        object = BoxedUnit.UNIT;
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Failed to parse partition: " + partitionStr);
                }
                return object;
            });
            partitionsArg = tmpPartitions;
        }
        boolean verboseOutputArg = commandOptions.options.has(commandOptions.verboseOutputOpt());
        boolean jsonOutputArg = commandOptions.options.has(commandOptions.jsonOutputOpt());
        boolean excludeInternalTopicsArg = commandOptions.options.has(commandOptions.excludeInternalTopicsOpt());
        boolean includeLinkedReplicasArg = commandOptions.options.has(commandOptions.includeLinkedReplicasOpt());
        boolean includeMirrorInfoArg = commandOptions.options.has(commandOptions.includeMirrorInfoOpt());
        Option leadersArg = ReplicaStatusCommand$.parseBoolOpt$1(commandOptions.leadersOpt(), commandOptions);
        Option observersArg = ReplicaStatusCommand$.parseBoolOpt$1(commandOptions.observersOpt(), commandOptions);
        return new ReplicaStatusCommand.Args(topicsArg, partitionsArg, leadersArg, observersArg, verboseOutputArg, jsonOutputArg, excludeInternalTopicsArg, includeLinkedReplicasArg, includeMirrorInfoArg);
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$1(ReplicaStatusCommand.Args args$1, String x$1) {
        return Topic.isInternal((String)x$1) && args$1.excludeInternalTopics();
    }

    public static final /* synthetic */ TopicPartition $anonfun$doReplicaStatus$4(String topic$1, int x$2) {
        return new TopicPartition(topic$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$16(ReplicaStatus st$1, boolean x$5) {
        return x$5 != st$1.isLeader();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$17(ReplicaStatus st$1, boolean x$6) {
        return x$6 != st$1.isObserver();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$15(ReplicaStatusCommand.Args args$1, ReplicaStatus st) {
        return args$1.leaders().exists((Function1<Object, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ReplicaStatusCommand$.$anonfun$doReplicaStatus$16(st, BoxesRunTime.unboxToBoolean(x$5)))) || args$1.observers().exists((Function1<Object, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(ReplicaStatusCommand$.$anonfun$doReplicaStatus$17(st, BoxesRunTime.unboxToBoolean(x$6))));
    }

    private static final String fromLagMs$1(long timeMs, long leaderTimeMs$2) {
        if (timeMs > 0L) {
            return Long.toString(leaderTimeMs$2 - timeMs);
        }
        return "-1";
    }

    private static final String fromLong$1(long value, String defaultValue) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return defaultValue;
    }

    private static final String fromLong$default$2$1() {
        return "-1";
    }

    private static final String fromString$1(Optional value, ReplicaStatusCommand.Args args$2) {
        if (value.isPresent()) {
            return (String)value.get();
        }
        if (args$2.jsonOutput()) {
            return "\"\"";
        }
        return "-";
    }

    private static final String replicationModeFromString$1(Optional value, ReplicaStatusCommand.Args args$2) {
        if (value.isPresent()) {
            return "\"" + value.get() + "\"";
        }
        if (args$2.jsonOutput()) {
            return "\"LEADER\"";
        }
        return "\"LEADER\"";
    }

    private static final String addQuotes$1(String string) {
        return "\"" + string + "\"";
    }

    private static final void closeTopic$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println("    ]");
        Predef$.MODULE$.print("  }");
    }

    private static final void closePartition$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println("        ]");
        Predef$.MODULE$.print("      }");
    }

    public static final /* synthetic */ void $anonfun$printJson$2(List headers$1, List entry$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String subEntry = (String)tuple2._1();
            int subIndex = tuple2._2$mcI$sp();
            if (subIndex >= 2) {
                Predef$.MODULE$.print("            " + ReplicaStatusCommand$.addQuotes$1((String)headers$1.apply(subIndex)) + ": " + subEntry);
                if (subIndex < entry$1.size() - 1) {
                    Predef$.MODULE$.println(",");
                    return;
                }
                Predef$.MODULE$.println();
                return;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$printJson$1(ObjectRef lastTopic$1, ObjectRef lastPartition$1, List headers$1, Tuple2 x0$1) {
        block10: {
            var5_4 = x0$1;
            if (var5_4 == null) break block10;
            entry = (List)var5_4._1();
            index = var5_4._2$mcI$sp();
            v0 = (String)lastTopic$1.elem;
            var9_7 = entry.apply(0);
            v1 = (v0 == null ? var9_7 != null : v0.equals(var9_7) == false) ? true : (newTopic = false);
            if (newTopic) ** GOTO lbl-1000
            v2 = (String)lastPartition$1.elem;
            var11_9 = entry.apply(1);
            if (v2 == null ? var11_9 != null : v2.equals(var11_9) == false) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = newPartition = false;
            }
            if (index > 0) {
                if (newPartition) {
                    ReplicaStatusCommand$.closePartition$1();
                }
                if (newTopic) {
                    ReplicaStatusCommand$.closeTopic$1();
                }
            }
            if (newTopic) {
                if (index > 0) {
                    Predef$.MODULE$.println(",");
                }
                Predef$.MODULE$.println("  {");
                Predef$.MODULE$.println("    \"Topic\": " + ReplicaStatusCommand$.addQuotes$1((String)entry.apply(0)) + ",");
                Predef$.MODULE$.println("    \"Partitions\": [");
            }
            if (newPartition) {
                if (!newTopic) {
                    Predef$.MODULE$.println(",");
                }
                Predef$.MODULE$.println("      {");
                Predef$.MODULE$.println("        \"Partition\": " + entry.apply(1) + ",");
                Predef$.MODULE$.println("        \"Replicas\": [");
            }
            lastTopic$1.elem = (String)entry.apply(0);
            lastPartition$1.elem = (String)entry.apply(1);
            if (!newPartition) {
                Predef$.MODULE$.println(",");
            }
            Predef$.MODULE$.println("          {");
            ((List)entry.zipWithIndex()).foreach((Function1<Tuple2, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$printJson$2$adapted(scala.collection.immutable.List scala.collection.immutable.List scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((List)headers$1, (List)entry));
            Predef$.MODULE$.print("          }");
            return;
        }
        throw new MatchError(var5_4);
    }

    public static final /* synthetic */ void $anonfun$printVerbose$1(List headers$2, List entries$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            List entry = (List)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ((List)headers$2.zip((IterableOnce)entry)).foreach((Function1<Tuple2, Object> & Serializable)subEntry -> {
                Predef$.MODULE$.println(subEntry._1() + ": " + subEntry._2());
                return BoxedUnit.UNIT;
            });
            if (index < entries$2.size() - 1) {
                Predef$.MODULE$.println();
                return;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$printCompact$3(ArrayBuffer maxWidth$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String subEntry = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            maxWidth$1.update(index, BoxesRunTime.boxToInteger(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(maxWidth$1.apply(index))), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(subEntry)))));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$printCompact$2(ArrayBuffer maxWidth$1, List entry) {
        ((List)entry.zipWithIndex()).foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            ReplicaStatusCommand$.$anonfun$printCompact$3(maxWidth$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final void printEntry$1(String string, int index, ArrayBuffer maxWidth$1) {
        Predef$.MODULE$.print(string);
        Predef$.MODULE$.print(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), BoxesRunTime.unboxToInt(maxWidth$1.apply(index)) - StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(string)) + 1));
    }

    private static final void printEntries$1(List entries, ArrayBuffer maxWidth$1) {
        ((List)entries.zipWithIndex()).foreach((Function1<Tuple2, Object> & Serializable)e -> {
            ReplicaStatusCommand$.printEntry$1((String)e._1(), e._2$mcI$sp(), maxWidth$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$validateAndInitializeArgs$1(String x$9) {
        Topic.validate((String)x$9);
    }

    public static final /* synthetic */ ListBuffer $anonfun$validateAndInitializeArgs$3(ListBuffer tmpPartitions$1, int i) {
        return (ListBuffer)tmpPartitions$1.$plus$eq(BoxesRunTime.boxToInteger(i));
    }

    private static final Option parseBoolOpt$1(ArgumentAcceptingOptionSpec spec, ReplicaStatusCommandOptions commandOptions$1) {
        if (!commandOptions$1.options.has(spec)) {
            return None$.MODULE$;
        }
        if (commandOptions$1.options.valueOf(spec) == null) {
            return new Some<Boolean>(BoxesRunTime.boxToBoolean(true));
        }
        String string = ((String)commandOptions$1.options.valueOf(spec)).toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -1321148966: {
                if (!"exclude".equals(string)) break;
                return new Some<Boolean>(BoxesRunTime.boxToBoolean(false));
            }
            case 3415980: {
                if (!"only".equals(string)) break;
                return new Some<Boolean>(BoxesRunTime.boxToBoolean(true));
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + string);
    }

    private ReplicaStatusCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$printJson$2$adapted(List headers$1, List entry$1, Tuple2 x0$2) {
        ReplicaStatusCommand$.$anonfun$printJson$2(headers$1, entry$1, x0$2);
        return BoxedUnit.UNIT;
    }
}

