/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.balancer.BrokerRemovalCommandOptions;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.BrokerRemovedException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BrokerRemovalCommand$
implements Logging {
    public static final BrokerRemovalCommand$ MODULE$ = new BrokerRemovalCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerRemovalCommand$ brokerRemovalCommand$ = this;
        synchronized (brokerRemovalCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public ConfluentAdmin createAdminClient(BrokerRemovalCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        return ConfluentAdmin.create((Properties)props);
    }

    public String flagName(OptionSpec<?> option) {
        return "--" + option.options().get(0);
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Error while executing broker removal: " + e.getMessage());
                this.error((Function0<String> & Serializable)() -> Utils.stackTrace((Throwable)e));
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        BrokerRemovalCommandOptions opts = new BrokerRemovalCommandOptions(args);
        opts.checkArgs();
        try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0<ConfluentAdmin> & Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options.has(opts.deleteOpt())) {
                    this.removeBroker(opts, client);
                } else if (opts.options.has(opts.describeOpt())) {
                    this.describeBrokerRemoval(opts, client);
                }
            }
            catch (ApiException e) {
                ApiException apiException = e;
                if (apiException instanceof TimeoutException) {
                    throw new AdminCommandFailedException("Timed out waiting for results", e);
                }
                if (apiException instanceof ClusterAuthorizationException) {
                    ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)apiException;
                    throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), e);
                }
                if (apiException instanceof InvalidRequestException) {
                    InvalidRequestException invalidRequestException = (InvalidRequestException)apiException;
                    throw new AdminCommandFailedException(invalidRequestException.getMessage(), e);
                }
                if (apiException instanceof BrokerNotAvailableException) {
                    BrokerNotAvailableException brokerNotAvailableException = (BrokerNotAvailableException)apiException;
                    throw new AdminCommandFailedException(brokerNotAvailableException.getMessage(), e);
                }
                if (apiException instanceof BrokerRemovalInProgressException) {
                    throw new AdminCommandFailedException("One of brokers " + opts.valueOf(opts.brokerIdsOpt()) + " is already being removed", e);
                }
                if (apiException instanceof BrokerRemovedException) {
                    throw new AdminCommandFailedException("One of brokers " + opts.valueOf(opts.brokerIdsOpt()) + " has already been removed", e);
                }
                throw e;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Error while issuing request");
                throw e;
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void removeBroker(BrokerRemovalCommandOptions opts, ConfluentAdmin client) {
        ArrayList<Integer> brokerIds = new ArrayList<Integer>();
        if (opts.options.has(opts.brokerIdOpt())) {
            String brokerId = opts.valueOf(opts.brokerIdOpt());
            v0 = BoxesRunTime.boxToBoolean(brokerIds.add(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(brokerId)))));
        } else {
            if (opts.options.has(opts.brokerIdsOpt())) {
                List brokerIdsToRemove = CollectionConverters$.MODULE$.SeqHasAsJava(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(opts.valueOf(opts.brokerIdsOpt())), ',')), (Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(BrokerRemovalCommand$.$anonfun$removeBroker$1(x$1)))), (Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2.trim()))), ClassTag$.MODULE$.Int())).toList()).asJava();
                brokerIdsToRemove.forEach(id -> brokerIds.add(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(id))));
            }
            v0 = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.println("Initiating remove brokers call...");
        boolean shouldShutdown = !opts.options.has(opts.noShutdownOpt());
        RemoveBrokersOptions options = new RemoveBrokersOptions().shouldShutdownBrokers(shouldShutdown);
        client.removeBrokers(brokerIds, options).all().get();
        Predef$.MODULE$.println("Started remove broker task for brokers " + brokerIds + ".");
        Predef$.MODULE$.println("You can check its status by calling this command again with the `--describe` option.");
    }

    private void describeBrokerRemoval(BrokerRemovalCommandOptions opts, ConfluentAdmin client) {
        Iterable filterResult = CollectionConverters$.MODULE$.CollectionHasAsScala(((Map)client.describeBrokerRemovals().descriptions().get()).values()).asScala();
        Object msgAnnex = "";
        Set nonDescribedBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        if (opts.options.has(opts.brokerIdOpt())) {
            int brokerId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(opts.valueOf(opts.brokerIdOpt())));
            msgAnnex = " for broker " + brokerId;
            filterResult = (Iterable)filterResult.filter((Function1<BrokerRemovalDescription, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(BrokerRemovalCommand$.$anonfun$describeBrokerRemoval$1(brokerId, e)));
        } else if (opts.options.has(opts.brokerIdsOpt())) {
            int[] brokerIds = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(opts.options.valueOf(opts.brokerIdsOpt())), ',')), (Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3))))), (Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4.trim()))), ClassTag$.MODULE$.Int());
            String brokerIdsStr = Predef$.MODULE$.wrapIntArray(brokerIds).mkString(", ");
            msgAnnex = " for brokers " + brokerIdsStr;
            Set describedIds = ((IterableOnceOps)((IterableOps)filterResult.filter((Function1<BrokerRemovalDescription, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(brokerIds), BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(e.brokerId())))))).map((Function1<BrokerRemovalDescription, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(x$5.brokerId())))).toSet();
            filterResult = (Iterable)filterResult.filter((Function1<BrokerRemovalDescription, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(brokerIds), BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(e.brokerId())))));
            nonDescribedBrokers = (Set)Predef$.MODULE$.wrapIntArray(brokerIds).toSet().diff(describedIds);
        }
        if (filterResult.isEmpty()) {
            Predef$.MODULE$.println("No broker removals in progress" + (String)msgAnnex);
            return;
        }
        filterResult.foreach((Function1<BrokerRemovalDescription, Object> & Serializable)desc -> {
            Predef$.MODULE$.println(BrokerRemovalCommand$.MODULE$.brokerRemovalDescriptionString(desc));
            return BoxedUnit.UNIT;
        });
        nonDescribedBrokers.foreach(nonDescribedBrokerId -> Predef$.MODULE$.println("Broker " + nonDescribedBrokerId + " has no removal operations performed on it."));
    }

    private String brokerRemovalDescriptionString(BrokerRemovalDescription desc) {
        String lineSeparator = System.lineSeparator() + "  ";
        String baseStringDescription = "Broker " + desc.brokerId() + " removal status - " + desc.generalOperationStatus() + ". Sub-task statuses:" + lineSeparator + "Broker Replica Exclusion: " + desc.brokerReplicaExclusionStatus() + lineSeparator + "Partition Reassignment: " + desc.reassignmentsStatus() + lineSeparator + "Broker Shutdown: " + desc.shutdownStatus() + lineSeparator + "Shutdown Scheduled: " + desc.isShutdownScheduled();
        if (desc.removalError().isPresent()) {
            BrokerRemovalError balancerOpError = (BrokerRemovalError)desc.removalError().get();
            baseStringDescription = baseStringDescription + lineSeparator + balancerOpError.exception().getClass().getName() + ": " + balancerOpError.errorMessage();
        }
        baseStringDescription = baseStringDescription + lineSeparator + "Operation Creation Time: " + ClientUtils.utcDateFor((long)desc.createTimeMs());
        baseStringDescription = baseStringDescription + lineSeparator + "Operation Last Update Time: " + ClientUtils.utcDateFor((long)desc.lastUpdateTimeMs());
        return baseStringDescription;
    }

    public static final /* synthetic */ boolean $anonfun$removeBroker$1(String x$1) {
        return !x$1.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeBrokerRemoval$1(int brokerId$1, BrokerRemovalDescription e) {
        return BoxesRunTime.equalsNumObject(e.brokerId(), BoxesRunTime.boxToInteger(brokerId$1));
    }

    private BrokerRemovalCommand$() {
    }
}

