/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.availability.BrokerHealthManager$;
import kafka.availability.BrokerHealthManagerConfig;
import kafka.availability.BrokerHealthManagerConfig$;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.HealthSamplesWindow;
import kafka.availability.HealthStatusAggregationOperator;
import kafka.availability.HealthStatusAggregationOperator_And$;
import kafka.availability.HealthStatusAggregationOperator_Or$;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.Unhealthy$;
import kafka.common.ControlledShutdownRequestReason;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.config.BrokerHealthCriteria;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t]g\u0001B A\u0001\u0015C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\ti\u0002\u0011\t\u0011)A\u0005k\")\u0011\u0010\u0001C\u0001u\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\u0007\u0001\u0001\u0006I!!\u0001\t\u0013\u0005=\u0001\u00011A\u0005\u0002\u0005E\u0001\"CA\n\u0001\u0001\u0007I\u0011AA\u000b\u0011\u001d\tY\u0002\u0001Q!\n9D\u0011\"!\n\u0001\u0001\u0004%\t!a\n\t\u0013\u0005=\u0002\u00011A\u0005\u0002\u0005E\u0002\u0002CA\u001b\u0001\u0001\u0006K!!\u000b\t\u0013\u0005e\u0002\u00011A\u0005\u0002\u0005m\u0002\"CA\"\u0001\u0001\u0007I\u0011AA#\u0011!\tI\u0005\u0001Q!\n\u0005u\u0002\"CA'\u0001\u0001\u0007I\u0011AA(\u0011%\t\t\u0006\u0001a\u0001\n\u0003\t\u0019\u0006C\u0004\u0002X\u0001\u0001\u000b\u0015B;\t\u0013\u0005m\u0003\u00011A\u0005\u0002\u0005u\u0003\"CAJ\u0001\u0001\u0007I\u0011AAK\u0011!\tI\n\u0001Q!\n\u0005}\u0003\"CAN\u0001\u0001\u0007I\u0011BA\t\u0011%\ti\n\u0001a\u0001\n\u0013\ty\nC\u0004\u0002$\u0002\u0001\u000b\u0015\u00028\t\u0013\u0005\u0015\u0006\u00011A\u0005\n\u0005\u001d\u0006\"CAX\u0001\u0001\u0007I\u0011BAY\u0011!\t)\f\u0001Q!\n\u0005%\u0006\"CA\\\u0001\u0001\u0007I\u0011BAT\u0011%\tI\f\u0001a\u0001\n\u0013\tY\f\u0003\u0005\u0002@\u0002\u0001\u000b\u0015BAU\u0011%\t\t\r\u0001b\u0001\n\u0013\t\u0019\r\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0011BAc\u0011%\u0011\u0019\u0001\u0001b\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0011\u0002B\u0004\u0011%\u0011y\u0001\u0001a\u0001\n\u0013\t9\u000bC\u0005\u0003\u0012\u0001\u0001\r\u0011\"\u0003\u0003\u0014!A!q\u0003\u0001!B\u0013\tI\u000bC\u0005\u0003\u001a\u0001\u0001\r\u0011\"\u0003\u0002(\"I!1\u0004\u0001A\u0002\u0013%!Q\u0004\u0005\t\u0005C\u0001\u0001\u0015)\u0003\u0002*\"I!1\u0005\u0001A\u0002\u0013%\u0011q\u0015\u0005\n\u0005K\u0001\u0001\u0019!C\u0005\u0005OA\u0001Ba\u000b\u0001A\u0003&\u0011\u0011\u0016\u0005\b\u0005[\u0001A\u0011AA\u001e\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqAa\r\u0001\t\u0003\u0012\t\u0004C\u0005\u00036\u0001\u0011\r\u0011\"\u0003\u00038!A!q\b\u0001!\u0002\u0013\u0011I\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t5\u0003\u0001\"\u0001\u00032!9!q\n\u0001\u0005\u0002\u0005m\u0002b\u0002B)\u0001\u0011\u0005#\u0011\u0007\u0005\b\u0005'\u0002A\u0011\u0001B+\u0011\u001d\u0011)\b\u0001C\u0001\u0005oBqAa \u0001\t\u0003\u0012\t\u0004C\u0004\u0003\u0002\u0002!\tEa!\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!1\u0016\u0001\u0005B\t5va\u0002B[\u0001\"\u0005!q\u0017\u0004\u0007\u007f\u0001C\tA!/\t\re\\D\u0011\u0001Ba\u0011%\u0011\u0019m\u000fb\u0001\n\u0003\u0011)\r\u0003\u0005\u0003Vn\u0002\u000b\u0011\u0002Bd\u0005M\u0011%o\\6fe\"+\u0017\r\u001c;i\u001b\u0006t\u0017mZ3s\u0015\t\t%)\u0001\u0007bm\u0006LG.\u00192jY&$\u0018PC\u0001D\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001$T3B\u0011q)U\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005kRLGN\u0003\u0002L\u0019\u000611/\u001a:wKJT!aQ'\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0005\u0003%\"\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011AkV\u0007\u0002+*\u0011aKQ\u0001\u0006kRLGn]\u0005\u00031V\u0013q\u0001T8hO&tw\r\u0005\u0002[96\t1L\u0003\u0002L\u0005&\u0011Ql\u0017\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002-\r|g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c%p_.\u0004R\u0001Y2fWFl\u0011!\u0019\u0006\u0002E\u0006)1oY1mC&\u0011A-\u0019\u0002\n\rVt7\r^5p]J\u0002\"AZ5\u000e\u0003\u001dT!\u0001\u001b\"\u0002\r\r|W.\\8o\u0013\tQwMA\u0010D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t'+Z9vKN$(+Z1t_:\u00042\u0001\u00197o\u0013\ti\u0017M\u0001\u0004PaRLwN\u001c\t\u0003A>L!\u0001]1\u0003\t1{gn\u001a\t\u0003AJL!a]1\u0003\tUs\u0017\u000e^\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005Y<X\"\u0001!\n\u0005a\u0004%!\u0007\"s_.,'\u000fS3bYRDW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fa\u0001P5oSRtDcA>}{B\u0011a\u000f\u0001\u0005\u0006=\u000e\u0001\ra\u0018\u0005\u0006i\u000e\u0001\r!^\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fQ\u0015aB7fiJL7m]\u0005\u0005\u0003\u0017\t)AA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013\u0001\u0004;pi\u0006d7+Y7qY\u0016\u001cX#\u00018\u0002!Q|G/\u00197TC6\u0004H.Z:`I\u0015\fHcA9\u0002\u0018!A\u0011\u0011D\u0004\u0002\u0002\u0003\u0007a.A\u0002yIE\nQ\u0002^8uC2\u001c\u0016-\u001c9mKN\u0004\u0003f\u0001\u0005\u0002 A\u0019\u0001-!\t\n\u0007\u0005\r\u0012M\u0001\u0005w_2\fG/\u001b7f\u0003I\u0011'o\\6fe\"+\u0017\r\u001c;i'R\fG/^:\u0016\u0005\u0005%\u0002c\u0001<\u0002,%\u0019\u0011Q\u0006!\u0003%\t\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo]\u0001\u0017EJ|7.\u001a:IK\u0006dG\u000f[*uCR,8o\u0018\u0013fcR\u0019\u0011/a\r\t\u0013\u0005e!\"!AA\u0002\u0005%\u0012a\u00052s_.,'\u000fS3bYRD7\u000b^1ukN\u0004\u0003fA\u0006\u0002 \u0005\u0019\u0012n]'ji&<\u0017\r^5p]\u0016s\u0017M\u00197fIV\u0011\u0011Q\b\t\u0004A\u0006}\u0012bAA!C\n9!i\\8mK\u0006t\u0017aF5t\u001b&$\u0018nZ1uS>tWI\\1cY\u0016$w\fJ3r)\r\t\u0018q\t\u0005\n\u00033i\u0011\u0011!a\u0001\u0003{\tA#[:NSRLw-\u0019;j_:,e.\u00192mK\u0012\u0004\u0003f\u0001\b\u0002 \u000511m\u001c8gS\u001e,\u0012!^\u0001\u000bG>tg-[4`I\u0015\fHcA9\u0002V!A\u0011\u0011\u0004\t\u0002\u0002\u0003\u0007Q/A\u0004d_:4\u0017n\u001a\u0011)\u0007E\ty\"A\u0010qe\u00164H\u000b\u001b:fC\u0012dunY1m\u0007>,h\u000e^3sgNs\u0017\r]:i_R,\"!a\u0018\u0011\u0011\u0005\u0005\u0014\u0011NA7\u0003sj!!a\u0019\u000b\u0007%\u000b)G\u0003\u0002\u0002h\u0005!!.\u0019<b\u0013\u0011\tY'a\u0019\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002p\u0005UTBAA9\u0015\u0011\t\u0019(!\u001a\u0002\t1\fgnZ\u0005\u0005\u0003o\n\tH\u0001\u0004UQJ,\u0017\r\u001a\t\u0007\u0003C\nY(a \n\t\u0005u\u00141\r\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0002\u0006=UBAAB\u0015\r\t\u0015Q\u0011\u0006\u0004\u0007\u0006\u001d%\u0002BAE\u0003\u0017\u000b\u0011bY8oM2,XM\u001c;\u000b\u0005\u00055\u0015AA5p\u0013\u0011\t\t*a!\u0003'QC'/Z1e\u0019>\u001c\u0017\r\\\"pk:$XM]:\u0002GA\u0014XM\u001e+ie\u0016\fG\rT8dC2\u001cu.\u001e8uKJ\u001c8K\\1qg\"|Go\u0018\u0013fcR\u0019\u0011/a&\t\u0013\u0005e1#!AA\u0002\u0005}\u0013\u0001\t9sKZ$\u0006N]3bI2{7-\u00197D_VtG/\u001a:t':\f\u0007o\u001d5pi\u0002\n!\u0004\u001d:fm:+XnQ8na2,G/\u001a3Ti>\u0014\u0018mZ3PaN\fa\u0004\u001d:fm:+XnQ8na2,G/\u001a3Ti>\u0014\u0018mZ3PaN|F%Z9\u0015\u0007E\f\t\u000b\u0003\u0005\u0002\u001aY\t\t\u00111\u0001o\u0003m\u0001(/\u001a<Ok6\u001cu.\u001c9mKR,Gm\u0015;pe\u0006<Wm\u00149tA\u0005Q2m\u001c8uS\u001e,x.^:V]\",\u0017\r\u001c;isN\u000bW\u000e\u001d7fgV\u0011\u0011\u0011\u0016\t\u0004A\u0006-\u0016bAAWC\n\u0019\u0011J\u001c;\u0002=\r|g\u000e^5hk>,8/\u00168iK\u0006dG\u000f[=TC6\u0004H.Z:`I\u0015\fHcA9\u00024\"I\u0011\u0011D\r\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u001cG>tG/[4v_V\u001cXK\u001c5fC2$\b._*b[BdWm\u001d\u0011\u00021\r|g\u000e^5hk>,8\u000fS3bYRD\u0017pU1na2,7/\u0001\u000fd_:$\u0018nZ;pkNDU-\u00197uQf\u001c\u0016-\u001c9mKN|F%Z9\u0015\u0007E\fi\fC\u0005\u0002\u001aq\t\t\u00111\u0001\u0002*\u0006I2m\u001c8uS\u001e,x.^:IK\u0006dG\u000f[=TC6\u0004H.Z:!\u0003I\"\bN]3bIN#XoY6TC6\u0004H.Z:Cs\u000e{W\u000e]8oK:$H+\u001f9f\u0005f$\u0006N]3bI\u001e\u0013x.\u001e9UsB,WCAAc!!\t9-!5\u0002T\u0006]XBAAe\u0015\u0011\tY-!4\u0002\u000f5,H/\u00192mK*\u0019\u0011qZ1\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0005%\u0007\u0003BAk\u0003ctA!a6\u0002n:!\u0011\u0011\\Av\u001d\u0011\tY.!;\u000f\t\u0005u\u0017q\u001d\b\u0005\u0003?\f)/\u0004\u0002\u0002b*\u0019\u00111\u001d#\u0002\rq\u0012xn\u001c;?\u0013\t\ti)\u0003\u0003\u0002\n\u0006-\u0015bA\"\u0002\b&\u0019\u0011)!\"\n\t\u0005=\u00181Q\u0001\u0014)\"\u0014X-\u00193M_\u000e\fGnQ8v]R,'o]\u0005\u0005\u0003g\f)PA\bUQJ,\u0017\rZ$s_V\u0004H+\u001f9f\u0015\u0011\ty/a!\u0011\u0011\u0005\u001d\u0017\u0011[A}\u0003\u007f\u0004B!!6\u0002|&!\u0011Q`A{\u0005MiU\r\u001e:jG\u000e{W\u000e]8oK:$H+\u001f9f!\u001d\t9-!5\u0002n9\f1\u0007\u001e5sK\u0006$7\u000b^;dWN\u000bW\u000e\u001d7fg\nK8i\\7q_:,g\u000e\u001e+za\u0016\u0014\u0015\u0010\u00165sK\u0006$wI]8vaRK\b/\u001a\u0011\u00029Ut\u0007.Z1mi\"L8\u000b^8sC\u001e,7+Y7qY\u0016<\u0016N\u001c3poV\u0011!q\u0001\t\u0004m\n%\u0011b\u0001B\u0006\u0001\n\u0019\u0002*Z1mi\"\u001c\u0016-\u001c9mKN<\u0016N\u001c3po\u0006iRO\u001c5fC2$\b._*u_J\fw-Z*b[BdWmV5oI><\b%\u0001\u0015d_:$\u0018nZ;pkN\u001c\u0016-\u001c9mKN,enZ5oKRC'/Z1e\u000fJ|W\u000f]:TiV\u001c7.\u0001\u0017d_:$\u0018nZ;pkN\u001c\u0016-\u001c9mKN,enZ5oKRC'/Z1e\u000fJ|W\u000f]:TiV\u001c7n\u0018\u0013fcR\u0019\u0011O!\u0006\t\u0013\u0005e1%!AA\u0002\u0005%\u0016!K2p]RLw-^8vgN\u000bW\u000e\u001d7fg\u0016sw-\u001b8f)\"\u0014X-\u00193He>,\bo]*uk\u000e\\\u0007%A\u0015d_:$\u0018nZ;pkN\u001c\u0016-\u001c9mKN\u001cFo\u001c:bO\u0016$\u0006N]3bI\u001e\u0013x.\u001e9t'R,8m[\u0001.G>tG/[4v_V\u001c8+Y7qY\u0016\u001c8\u000b^8sC\u001e,G\u000b\u001b:fC\u0012<%o\\;qgN#XoY6`I\u0015\fHcA9\u0003 !I\u0011\u0011\u0004\u0014\u0002\u0002\u0003\u0007\u0011\u0011V\u0001+G>tG/[4v_V\u001c8+Y7qY\u0016\u001c8\u000b^8sC\u001e,G\u000b\u001b:fC\u0012<%o\\;qgN#XoY6!\u00039\u001awN\u001c;jOV|Wo]*b[BdWm\u001d(p'R|'/Y4f)\"\u0014X-\u00193NC.Lgn\u001a)s_\u001e\u0014Xm]:\u0002e\r|g\u000e^5hk>,8oU1na2,7OT8Ti>\u0014\u0018mZ3UQJ,\u0017\rZ'bW&tw\r\u0015:pOJ,7o]0%KF$2!\u001dB\u0015\u0011%\tI\"KA\u0001\u0002\u0004\tI+A\u0018d_:$\u0018nZ;pkN\u001c\u0016-\u001c9mKNtun\u0015;pe\u0006<W\r\u00165sK\u0006$W*Y6j]\u001e\u0004&o\\4sKN\u001c\b%A\u0005jg\"+\u0017\r\u001c;is\u0006i!/Z7pm\u0016lU\r\u001e:jGN$\u0012!]\u0001\tg\",H\u000fZ8x]\u0006)\u0002.\u0019:e'\",H\u000fZ8x]N\u001b\u0007.\u001a3vY\u0016\u0014XC\u0001B\u001d!\r9%1H\u0005\u0004\u0005{A%AD&bM.\f7k\u00195fIVdWM]\u0001\u0017Q\u0006\u0014Hm\u00155vi\u0012|wO\\*dQ\u0016$W\u000f\\3sA\u00059\u0011n]*uk\u000e\\GCBA\u001f\u0005\u000b\u0012I\u0005C\u0004\u0003HA\u0002\r!!\u001c\u0002\rQD'/Z1e\u0011\u001d\u0011Y\u0005\ra\u0001\u0003\u007f\nAbY;se\u000e{WO\u001c;feN\fq\u0002\\8h'R,8m\u001b+ie\u0016\fGm]\u0001\u0012SN\u0014%o\\6feVs\u0007.Z1mi\"L\u0018A\u00023p/>\u00148.\u0001\tti\u0006$Xo\u001d+sC:\u001c\u0018\u000e^5p]R9\u0011Oa\u0016\u0003\\\t}\u0003b\u0002B-i\u0001\u0007\u0011\u0011F\u0001\u0014GV\u0014(/\u001a8u\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d\u0005\b\u0005;\"\u0004\u0019AA\u0015\u0003=qWm\u001e%fC2$\bn\u0015;biV\u001c\bb\u0002B1i\u0001\u0007!1M\u0001\bg\u0006l\u0007\u000f\\3t!\u0019\u0011)Ga\u001c\u0002*:!!q\rB6\u001d\u0011\tyN!\u001b\n\u0003\tL1A!\u001cb\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u001d\u0003t\tA\u0011\n^3sC\ndWMC\u0002\u0003n\u0005\f1\u0004\\8h\u0005J|7.\u001a:IK\u0006dG\u000f[*uCR,8o\u00115b]\u001e,GcB9\u0003z\tm$Q\u0010\u0005\b\u00053*\u0004\u0019AA\u0015\u0011\u001d\u0011i&\u000ea\u0001\u0003SAqA!\u00196\u0001\u0004\u0011\u0019'A\u0002sk:\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003\u0006B1!q\u0011BE\u0005\u001bk!!!4\n\t\t-\u0015Q\u001a\u0002\u0004'\u0016$\b\u0003\u0002BH\u0005/sAA!%\u0003\u0014B\u0019\u0011q\\1\n\u0007\tU\u0015-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00053\u0013YJ\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005+\u000b\u0017a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\r\t(\u0011\u0015\u0005\b\u0005GC\u0004\u0019\u0001BS\u0003%qWm^\"p]\u001aLw\rE\u0002[\u0005OK1A!+\\\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0006c\n=&1\u0017\u0005\b\u0005cK\u0004\u0019\u0001BS\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0003$f\u0002\rA!*\u0002'\t\u0013xn[3s\u0011\u0016\fG\u000e\u001e5NC:\fw-\u001a:\u0011\u0005Y\\4cA\u001e\u0003<B\u0019\u0001M!0\n\u0007\t}\u0016M\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005o\u000bQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003HB1!\u0011\u001aBh\u0005#l!Aa3\u000b\t\t5\u0017QZ\u0001\nS6lW\u000f^1cY\u0016LAAa#\u0003LB!\u0011q\u000eBj\u0013\u0011\u0011I*!\u001d\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\u0002")
public class BrokerHealthManager
extends ShutdownableThread
implements Logging,
BrokerReconfigurable {
    private final Function2<ControlledShutdownRequestReason, Option<Object>, BoxedUnit> controlledShutdownHook;
    private final KafkaMetricsGroup metricsGroup;
    private volatile long totalSamples;
    private volatile BrokerHealthStatus brokerHealthStatus;
    private volatile boolean isMitigationEnabled;
    private volatile BrokerHealthManagerConfig config;
    private Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot;
    private long prevNumCompletedStorageOps;
    private int contiguousUnhealthySamples;
    private int contiguousHealthySamples;
    private final scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType;
    private final HealthSamplesWindow unhealthyStorageSampleWindow;
    private int contiguousSamplesEngineThreadGroupsStuck;
    private int contiguousSamplesStorageThreadGroupsStuck;
    private int contiguousSamplesNoStorageThreadMakingProgress;
    private final KafkaScheduler hardShutdownScheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerHealthManager brokerHealthManager = this;
        synchronized (brokerHealthManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public long totalSamples() {
        return this.totalSamples;
    }

    public void totalSamples_$eq(long x$1) {
        this.totalSamples = x$1;
    }

    public BrokerHealthStatus brokerHealthStatus() {
        return this.brokerHealthStatus;
    }

    public void brokerHealthStatus_$eq(BrokerHealthStatus x$1) {
        this.brokerHealthStatus = x$1;
    }

    public boolean isMitigationEnabled() {
        return this.isMitigationEnabled;
    }

    public void isMitigationEnabled_$eq(boolean x$1) {
        this.isMitigationEnabled = x$1;
    }

    public BrokerHealthManagerConfig config() {
        return this.config;
    }

    public void config_$eq(BrokerHealthManagerConfig x$1) {
        this.config = x$1;
    }

    public Map<Thread, List<ThreadLocalCounters>> prevThreadLocalCountersSnapshot() {
        return this.prevThreadLocalCountersSnapshot;
    }

    public void prevThreadLocalCountersSnapshot_$eq(Map<Thread, List<ThreadLocalCounters>> x$1) {
        this.prevThreadLocalCountersSnapshot = x$1;
    }

    private long prevNumCompletedStorageOps() {
        return this.prevNumCompletedStorageOps;
    }

    private void prevNumCompletedStorageOps_$eq(long x$1) {
        this.prevNumCompletedStorageOps = x$1;
    }

    private int contiguousUnhealthySamples() {
        return this.contiguousUnhealthySamples;
    }

    private void contiguousUnhealthySamples_$eq(int x$1) {
        this.contiguousUnhealthySamples = x$1;
    }

    private int contiguousHealthySamples() {
        return this.contiguousHealthySamples;
    }

    private void contiguousHealthySamples_$eq(int x$1) {
        this.contiguousHealthySamples = x$1;
    }

    private scala.collection.mutable.Map<ThreadLocalCounters.ThreadGroupType, scala.collection.mutable.Map<ThreadLocalCounters.MetricComponentType, scala.collection.mutable.Map<Thread, Object>>> threadStuckSamplesByComponentTypeByThreadGroupType() {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType;
    }

    private HealthSamplesWindow unhealthyStorageSampleWindow() {
        return this.unhealthyStorageSampleWindow;
    }

    private int contiguousSamplesEngineThreadGroupsStuck() {
        return this.contiguousSamplesEngineThreadGroupsStuck;
    }

    private void contiguousSamplesEngineThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesEngineThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesStorageThreadGroupsStuck() {
        return this.contiguousSamplesStorageThreadGroupsStuck;
    }

    private void contiguousSamplesStorageThreadGroupsStuck_$eq(int x$1) {
        this.contiguousSamplesStorageThreadGroupsStuck = x$1;
    }

    private int contiguousSamplesNoStorageThreadMakingProgress() {
        return this.contiguousSamplesNoStorageThreadMakingProgress;
    }

    private void contiguousSamplesNoStorageThreadMakingProgress_$eq(int x$1) {
        this.contiguousSamplesNoStorageThreadMakingProgress = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHealthy() {
        if (!this.isMitigationEnabled()) return true;
        BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        if (brokerHealthStatus != null) {
            if (!brokerHealthStatus.equals(healthy$)) return false;
            return true;
        }
        if (healthy$ == null) return true;
        return false;
    }

    public void removeMetrics() {
        this.metricsGroup().removeMetric("ContiguousUnhealthySamples");
        this.metricsGroup().removeMetric("ContiguousSamplesEngineThreadGroupsStuck");
        this.metricsGroup().removeMetric("ContiguousSamplesStorageThreadGroupsStuck");
        this.metricsGroup().removeMetric("ContiguousSamplesNoStorageThreadMakingProgress");
        this.metricsGroup().removeMetric("UnhealthinessCount");
        this.metricsGroup().removeMetric("StorageHealthStatus");
    }

    @Override
    public void shutdown() {
        this.removeMetrics();
        super.shutdown();
    }

    private KafkaScheduler hardShutdownScheduler() {
        return this.hardShutdownScheduler;
    }

    public boolean isStuck(Thread thread, ThreadLocalCounters currCounters) {
        return this.isPrevCountersPresent$1() && this.isThreadStuck$1(thread, currCounters);
    }

    public void logStuckThreads() {
        this.threadStuckSamplesByComponentTypeByThreadGroupType().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            BrokerHealthManager.$anonfun$logStuckThreads$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isBrokerUnhealthy() {
        Map currentThreadLocalCounterSnapshotForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        LongRef currNumCompletedStorageOps = LongRef.create(0L);
        currentThreadLocalCounterSnapshotForAllThreads.forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
            boolean isThreadStuck = this.isStuck((Thread)thread, (ThreadLocalCounters)threadLocalCounters);
            ThreadLocalCounters.MetricComponentType metricComponentType = threadLocalCounters.metricComponentType;
            ThreadLocalCounters.MetricComponentType metricComponentType2 = ThreadLocalCounters.MetricComponentType.STORAGE;
            if (!(metricComponentType != null ? !metricComponentType.equals(metricComponentType2) : metricComponentType2 != null)) {
                currNumCompletedStorageOps$1.elem += threadLocalCounters.numSuccessOps + threadLocalCounters.numFailedOps;
            }
            scala.collection.mutable.Map componentToThreadNumStuckSamplesMap = (scala.collection.mutable.Map)this.threadStuckSamplesByComponentTypeByThreadGroupType().getOrElseUpdate(threadLocalCounters.threadGroupType, (Function0<scala.collection.mutable.Map> & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$));
            scala.collection.mutable.Map threadToNumStuckSamplesMap = (scala.collection.mutable.Map)componentToThreadNumStuckSamplesMap.getOrElseUpdate(threadLocalCounters.metricComponentType, (Function0<WeakHashMap> & Serializable)() -> (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            long stuckCount = BoxesRunTime.unboxToLong(threadToNumStuckSamplesMap.getOrElseUpdate(thread, () -> 0L));
            if (isThreadStuck) {
                threadToNumStuckSamplesMap.update(thread, BoxesRunTime.boxToLong(stuckCount + 1L));
                return;
            }
            threadToNumStuckSamplesMap.update(thread, BoxesRunTime.boxToLong(0L));
        }));
        this.prevThreadLocalCountersSnapshot_$eq(currentThreadLocalCounterSnapshotForAllThreads);
        boolean engineThreadsStuck = this.isThreadGroupStuck$1(this.config().engineThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.ENGINE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean storageThreadsStuck = this.isThreadGroupStuck$1(this.config().storageThreadStatusCriteria(), ThreadLocalCounters.MetricComponentType.STORAGE, HealthStatusAggregationOperator_Or$.MODULE$);
        boolean noStorageThreadMakingProgress = this.prevNumCompletedStorageOps() == currNumCompletedStorageOps.elem;
        this.prevNumCompletedStorageOps_$eq(currNumCompletedStorageOps.elem);
        if (engineThreadsStuck) {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(this.contiguousSamplesEngineThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesEngineThreadGroupsStuck_$eq(0);
        }
        if (storageThreadsStuck) {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(this.contiguousSamplesStorageThreadGroupsStuck() + 1);
        } else {
            this.contiguousSamplesStorageThreadGroupsStuck_$eq(0);
        }
        if (noStorageThreadMakingProgress) {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(this.contiguousSamplesNoStorageThreadMakingProgress() + 1);
        } else {
            this.contiguousSamplesNoStorageThreadMakingProgress_$eq(0);
        }
        return engineThreadsStuck && storageThreadsStuck && noStorageThreadMakingProgress;
    }

    @Override
    public void doWork() {
        this.pause(this.config().brokerHealthManagerSampleDurationMs(), TimeUnit.MILLISECONDS);
        this.totalSamples_$eq(this.totalSamples() + 1L);
        int isSampleUnhealthy = 0;
        if (this.isBrokerUnhealthy()) {
            isSampleUnhealthy = 1;
            this.contiguousUnhealthySamples_$eq(this.contiguousUnhealthySamples() + 1);
            this.contiguousHealthySamples_$eq(0);
        } else {
            this.contiguousUnhealthySamples_$eq(0);
            this.contiguousHealthySamples_$eq(this.contiguousHealthySamples() + 1);
        }
        BrokerHealthStatus brokerHealthStatus = this.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        if (!(brokerHealthStatus != null ? !brokerHealthStatus.equals(healthy$) : healthy$ != null)) {
            this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
            int numOfSamplesBeforeSuspect = this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect();
            this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSamplesBeforeSuspect);
            if (this.unhealthyStorageSampleWindow().size() == numOfSamplesBeforeSuspect && this.unhealthyStorageSampleWindow().countedSamples() * 100 / this.unhealthyStorageSampleWindow().size() >= this.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition()) {
                this.statusTransition(Healthy$.MODULE$, Suspect$.MODULE$, this.unhealthyStorageSampleWindow().samples());
            }
        } else {
            BrokerHealthStatus brokerHealthStatus2 = this.brokerHealthStatus();
            Suspect$ suspect$ = Suspect$.MODULE$;
            if (!(brokerHealthStatus2 != null ? !brokerHealthStatus2.equals(suspect$) : suspect$ != null)) {
                int numOfSampleBeforeUnhealthy = this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy();
                this.unhealthyStorageSampleWindow().addSample(isSampleUnhealthy);
                this.unhealthyStorageSampleWindow().maybeShrinkSampleWindow(numOfSampleBeforeUnhealthy);
                int minUnhealthySamples = numOfSampleBeforeUnhealthy * this.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() / 100;
                int minHealthySamples = numOfSampleBeforeUnhealthy - minUnhealthySamples;
                if (this.unhealthyStorageSampleWindow().size() - this.unhealthyStorageSampleWindow().countedSamples() > minHealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Healthy$.MODULE$, this.unhealthyStorageSampleWindow().samples());
                } else if (this.unhealthyStorageSampleWindow().countedSamples() >= minUnhealthySamples) {
                    this.statusTransition(Suspect$.MODULE$, Unhealthy$.MODULE$, this.unhealthyStorageSampleWindow().samples());
                }
            }
        }
        BrokerHealthStatus brokerHealthStatus3 = this.brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        if (!(brokerHealthStatus3 != null ? !brokerHealthStatus3.equals(unhealthy$) : unhealthy$ != null)) {
            if (this.isMitigationEnabled()) {
                this.hardShutdownScheduler().startup();
                this.hardShutdownScheduler().scheduleOnce("Hard-Kill-Broker", () -> Exit.halt((int)1), this.config().brokerHealthManagerHardKillDurationMs());
                this.logStuckThreads();
                this.error((Function0<String> & Serializable)() -> "[BrokerHealth] Broker has remained unhealthy for " + this.config().brokerHealthManagerSampleDurationMs() * this.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() + " ms. (1) Calling controlled shutdown to move leadership away if not controller. (2) Then will exit. ");
                this.controlledShutdownHook.apply(ControlledShutdownRequestReason.UNHEALTHY, Option$.MODULE$.empty());
                this.hardShutdownScheduler().shutdown();
                Exit.halt((int)1);
                return;
            }
            if (this.contiguousHealthySamples() > this.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
                Queue healthySamples = (Queue)Queue$.MODULE$.fill(this.contiguousHealthySamples(), () -> 0);
                this.statusTransition(Unhealthy$.MODULE$, Healthy$.MODULE$, healthySamples);
                return;
            }
            return;
        }
    }

    public void statusTransition(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        this.brokerHealthStatus_$eq(newHealthStatus);
        this.logBrokerHealthStatusChange(currentHealthStatus, newHealthStatus, samples);
        this.unhealthyStorageSampleWindow().reset();
    }

    public void logBrokerHealthStatusChange(BrokerHealthStatus currentHealthStatus, BrokerHealthStatus newHealthStatus, Iterable<Object> samples) {
        if (!this.isMitigationEnabled()) {
            this.info((Function0<String> & Serializable)() -> "[BrokerHealth] Broker health status changed. Previous Health Status: " + currentHealthStatus + " New Health Status: " + newHealthStatus + " Unhealthy Samples: " + samples);
            this.logStuckThreads();
            return;
        }
    }

    @Override
    public void run() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        super.run();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return BrokerHealthManager$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString(newConfig.confluentConfig().brokerHealthManagerEngineRequestHandlerThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Engine Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString(newConfig.confluentConfig().brokerHealthManagerStorageRequestHandlerThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Storage Request Handler Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString(newConfig.confluentConfig().brokerHealthManagerStorageBackgroundThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Storage Background Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
        if (OptionConverters$.MODULE$.toScala(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.fromString(newConfig.confluentConfig().brokerHealthManagerStorageNetworkThreadsStuckCriteria())).isEmpty()) {
            throw new ConfigException("Storage Network Thread Stuck Criteria should be one of AnyThreadStuck/AllThreadsStuck/Disabled");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(BrokerHealthManagerConfig$.MODULE$.apply(newConfig));
        this.isMitigationEnabled_$eq(this.config().isBrokerHealthManagerMitigationEnabled());
    }

    public static final /* synthetic */ int $anonfun$new$5(BrokerHealthManager $this) {
        return $this.unhealthyStorageSampleWindow().countedSamples();
    }

    public static final /* synthetic */ int $anonfun$new$6(BrokerHealthManager $this) {
        return $this.brokerHealthStatus().id();
    }

    private final boolean isPrevCountersPresent$1() {
        return this.prevThreadLocalCountersSnapshot() != null;
    }

    private final boolean isThreadStuck$1(Thread thread$1, ThreadLocalCounters currCounters$1) {
        ObjectRef<Object> prevCounters = ObjectRef.create(null);
        ((java.lang.Iterable)this.prevThreadLocalCountersSnapshot().getOrDefault(thread$1, new ArrayList())).forEach(threadLocalCounters -> {
            ThreadLocalCounters.MetricComponentType metricComponentType = threadLocalCounters.metricComponentType;
            ThreadLocalCounters.MetricComponentType metricComponentType2 = currCounters$1.metricComponentType;
            if (!(metricComponentType != null ? !metricComponentType.equals(metricComponentType2) : metricComponentType2 != null)) {
                prevCounters$1.elem = threadLocalCounters;
                return;
            }
        });
        if ((ThreadLocalCounters)prevCounters.elem != null) {
            return currCounters$1.numSuccessOps + currCounters$1.numFailedOps == ((ThreadLocalCounters)prevCounters.elem).numSuccessOps + ((ThreadLocalCounters)prevCounters.elem).numFailedOps && currCounters$1.numInProgressOps == ((ThreadLocalCounters)prevCounters.elem).numInProgressOps && currCounters$1.numInProgressOps >= 1L;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$3(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, ThreadLocalCounters.MetricComponentType metricComponentType$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Thread thread = (Thread)tuple2._1();
            long numStuckSamples = tuple2._2$mcJ$sp();
            $this.info((Function0<String> & Serializable)() -> "[BrokerHealthManager] Broker has stuck threads. Thread Group type stuck = " + threadGroupType$1 + " Component type = " + metricComponentType$1 + " Thread = " + thread.getName() + " num stuck samples " + numStuckSamples);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$2(BrokerHealthManager $this, ThreadLocalCounters.ThreadGroupType threadGroupType$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ThreadLocalCounters.MetricComponentType metricComponentType = (ThreadLocalCounters.MetricComponentType)tuple2._1();
            scala.collection.mutable.Map threadToNumStuckSamples = (scala.collection.mutable.Map)tuple2._2();
            threadToNumStuckSamples.foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$3($this, threadGroupType$1, metricComponentType, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$logStuckThreads$1(BrokerHealthManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ThreadLocalCounters.ThreadGroupType threadGroupType = (ThreadLocalCounters.ThreadGroupType)tuple2._1();
            scala.collection.mutable.Map componentToThreadNumStuckSamplesMap = (scala.collection.mutable.Map)tuple2._2();
            componentToThreadNumStuckSamplesMap.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
                BrokerHealthManager.$anonfun$logStuckThreads$2($this, threadGroupType, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$8(BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, boolean x0$1, Tuple2 x1$1) {
        Tuple2<Boolean, Tuple2> tuple2 = new Tuple2<Boolean, Tuple2>(BoxesRunTime.boxToBoolean(x0$1), x1$1);
        if (tuple2 != null) {
            boolean isThreadGroupStuckLocalVal = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = tuple2._2();
            if (tuple22 != null) {
                long numStuckSamples = tuple22._2$mcJ$sp();
                BrokerHealthCriteria.ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria = countersHealthStatusCriteria$1;
                if (((Object)((Object)BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AnyThreadStuck)).equals((Object)threadCountersHealthStatusCriteria)) {
                    return isThreadGroupStuckLocalVal || numStuckSamples > 0L;
                }
                if (((Object)((Object)BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AllThreadsStuck)).equals((Object)threadCountersHealthStatusCriteria)) {
                    return isThreadGroupStuckLocalVal && numStuckSamples > 0L;
                }
                return isThreadGroupStuckLocalVal;
            }
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$7(boolean initialValue$1, BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadToNumStuckSamples) {
        return BoxesRunTime.unboxToBoolean(threadToNumStuckSamples.foldLeft(BoxesRunTime.boxToBoolean(initialValue$1), (Function2<Object, Tuple2, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(BrokerHealthManager.$anonfun$isBrokerUnhealthy$8(countersHealthStatusCriteria$1, BoxesRunTime.unboxToBoolean(x0$1), x1$1))));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$6(ThreadLocalCounters.MetricComponentType componentType$1, boolean initialValue$1, BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria$1, scala.collection.mutable.Map threadGroup) {
        return threadGroup.get(componentType$1).exists((Function1<scala.collection.mutable.Map, Object> & Serializable)threadToNumStuckSamples -> BoxesRunTime.boxToBoolean(BrokerHealthManager.$anonfun$isBrokerUnhealthy$7(initialValue$1, countersHealthStatusCriteria$1, threadToNumStuckSamples)));
    }

    private final boolean isThreadGroupStuckAccordingToCriteria$1(boolean initialValue, ThreadLocalCounters.ThreadGroupType threadGroupType, ThreadLocalCounters.MetricComponentType componentType, BrokerHealthCriteria.ThreadCountersHealthStatusCriteria countersHealthStatusCriteria) {
        return this.threadStuckSamplesByComponentTypeByThreadGroupType().get(threadGroupType).exists((Function1<scala.collection.mutable.Map, Object> & Serializable)threadGroup -> BoxesRunTime.boxToBoolean(BrokerHealthManager.$anonfun$isBrokerUnhealthy$6(componentType, initialValue, countersHealthStatusCriteria, threadGroup)));
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerUnhealthy$9(BrokerHealthManager $this, HealthStatusAggregationOperator healthStatusAggregationOperator$1, ThreadLocalCounters.MetricComponentType componentType$2, boolean x0$1, Tuple2 x1$1) {
        Tuple2<Boolean, Tuple2> tuple2 = new Tuple2<Boolean, Tuple2>(BoxesRunTime.boxToBoolean(x0$1), x1$1);
        if (tuple2 != null) {
            boolean isBrokerUnhealthy = tuple2._1$mcZ$sp();
            Tuple2 tuple22 = tuple2._2();
            if (tuple22 != null) {
                BrokerHealthCriteria.ThreadCountersHealthStatusCriteria criteria;
                ThreadLocalCounters.ThreadGroupType groupType = (ThreadLocalCounters.ThreadGroupType)tuple22._1();
                BrokerHealthCriteria.ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria = criteria = (BrokerHealthCriteria.ThreadCountersHealthStatusCriteria)((Object)tuple22._2());
                BrokerHealthCriteria.ThreadCountersHealthStatusCriteria threadCountersHealthStatusCriteria2 = BrokerHealthCriteria.ThreadCountersHealthStatusCriteria.AllThreadsStuck;
                boolean initialValue = !(threadCountersHealthStatusCriteria != null ? !((Object)((Object)threadCountersHealthStatusCriteria)).equals((Object)threadCountersHealthStatusCriteria2) : threadCountersHealthStatusCriteria2 != null);
                HealthStatusAggregationOperator healthStatusAggregationOperator = healthStatusAggregationOperator$1;
                HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
                if (!(healthStatusAggregationOperator != null ? !healthStatusAggregationOperator.equals(healthStatusAggregationOperator_And$) : healthStatusAggregationOperator_And$ != null)) {
                    return isBrokerUnhealthy && $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
                }
                HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator$1;
                HealthStatusAggregationOperator_Or$ healthStatusAggregationOperator_Or$ = HealthStatusAggregationOperator_Or$.MODULE$;
                if (!(healthStatusAggregationOperator2 != null ? !healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_Or$) : healthStatusAggregationOperator_Or$ != null)) {
                    return isBrokerUnhealthy || $this.isThreadGroupStuckAccordingToCriteria$1(initialValue, groupType, componentType$2, criteria);
                }
                return false;
            }
        }
        throw new MatchError(tuple2);
    }

    private final boolean isThreadGroupStuck$1(scala.collection.immutable.Map threadStatusCriteria, ThreadLocalCounters.MetricComponentType componentType, HealthStatusAggregationOperator healthStatusAggregationOperator) {
        HealthStatusAggregationOperator healthStatusAggregationOperator2 = healthStatusAggregationOperator;
        HealthStatusAggregationOperator_And$ healthStatusAggregationOperator_And$ = HealthStatusAggregationOperator_And$.MODULE$;
        boolean threadGroupStuckInitialValue = !(healthStatusAggregationOperator2 != null ? !healthStatusAggregationOperator2.equals(healthStatusAggregationOperator_And$) : healthStatusAggregationOperator_And$ != null);
        return threadStatusCriteria.nonEmpty() && BoxesRunTime.unboxToBoolean(threadStatusCriteria.foldLeft(BoxesRunTime.boxToBoolean(threadGroupStuckInitialValue), (Function2<Object, Tuple2, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(BrokerHealthManager.$anonfun$isBrokerUnhealthy$9(this, healthStatusAggregationOperator, componentType, BoxesRunTime.unboxToBoolean(x0$1), x1$1))));
    }

    public BrokerHealthManager(Function2<ControlledShutdownRequestReason, Option<Object>, BoxedUnit> controlledShutdownHook, BrokerHealthManagerConfig initialConfig) {
        this.controlledShutdownHook = controlledShutdownHook;
        super("BrokerHealthManager", true);
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.totalSamples = 0L;
        this.brokerHealthStatus = Healthy$.MODULE$;
        this.isMitigationEnabled = initialConfig.isBrokerHealthManagerMitigationEnabled();
        this.config = initialConfig;
        this.prevThreadLocalCountersSnapshot = null;
        this.prevNumCompletedStorageOps = 0L;
        this.contiguousUnhealthySamples = 0;
        this.contiguousHealthySamples = 0;
        this.threadStuckSamplesByComponentTypeByThreadGroupType = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.unhealthyStorageSampleWindow = new HealthSamplesWindow();
        this.contiguousSamplesEngineThreadGroupsStuck = 0;
        this.contiguousSamplesStorageThreadGroupsStuck = 0;
        this.contiguousSamplesNoStorageThreadMakingProgress = 0;
        this.metricsGroup().newGauge("ContiguousUnhealthySamples", () -> BoxesRunTime.boxToInteger(this.contiguousUnhealthySamples()));
        this.metricsGroup().newGauge("ContiguousSamplesEngineThreadGroupsStuck", () -> BoxesRunTime.boxToInteger(this.contiguousSamplesEngineThreadGroupsStuck()));
        this.metricsGroup().newGauge("ContiguousSamplesStorageThreadGroupsStuck", () -> BoxesRunTime.boxToInteger(this.contiguousSamplesStorageThreadGroupsStuck()));
        this.metricsGroup().newGauge("ContiguousSamplesNoStorageThreadMakingProgress", () -> BoxesRunTime.boxToInteger(this.contiguousSamplesNoStorageThreadMakingProgress()));
        this.metricsGroup().newGauge("UnhealthinessCount", () -> BoxesRunTime.boxToInteger(BrokerHealthManager.$anonfun$new$5(this)));
        this.metricsGroup().newGauge("StorageHealthStatus", () -> BoxesRunTime.boxToInteger(BrokerHealthManager.$anonfun$new$6(this)));
        this.hardShutdownScheduler = new KafkaScheduler(1);
    }
}

