/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;

public class CatalogMetrics {
    public static final String GROUP_NAME = "catalog-metrics";
    public static final String ACTIVE_COLLECTOR = "active-collector";
    public static final String ACTIVE_COLLECTOR_DOC = "Reports 1 if the catalog metadata collector is active, 0 otherwise.";
    public static final String CACHED_TOPICS_TOTAL = "cached-topics-total";
    public static final String CACHED_TOPICS_TOTAL_DOC = "Number of topics cached in the metadata collector.";
    public static final String CACHED_ENTITIES_TOTAL = "cached-entities-total";
    public static final String CACHED_ENTITIES_TOTAL_DOC = "Number of entities cached in the metadata collector.";
    public static final String SNAPSHOT_EMITTING_DELAY_MS = "snapshot-emitting-delay-ms";
    public static final String SNAPSHOT_EMITTING_DELAY_MS_DOC = "Delay between each snapshot emitted (include snapshot taken time) in milliseconds.";
    public static final String DELTA_EVENT_EMIT = "num-delta-event-emit";
    public static final String DELTA_EVENT_EMIT_DOC = "The number of delta create, update and delete events emitted.";
    public static final String SNAPSHOT_EVENT_EMIT = "num-snapshot-event-emit";
    public static final String SNAPSHOT_EVENT_EMIT_DOC = "Number of snapshot events emitted";
    public static final String COLLECTOR_EVENT_HANDLE_ERROR = "num-collector-event-handle-error";
    public static final String COLLECTOR_EVENT_HANDLE_ERROR_DOC = "Number of error during collector events handling";
    public final MetricName cachedTopicsMetricName;
    public final MetricName cachedEntitiesMetricName;
    public final MetricName snapshotDelayMsMetricName;
    public final LongGauge snapshotEmittingDelayMsMetric;
    public final Sensor deltaEventEmitSensor;
    public final Sensor snapshotEventEmitSensor;
    public final Sensor collectorEventHandleErrorSensor;
    private final Metrics metrics;
    private final Set<String> sensorsNames = ConcurrentHashMap.newKeySet();
    private final Set<MetricName> metricNames = ConcurrentHashMap.newKeySet();

    public CatalogMetrics(Metrics metrics, Supplier<Integer> localStoreSizeSupplier) {
        this.metrics = metrics;
        this.cachedTopicsMetricName = metrics.metricName(CACHED_TOPICS_TOTAL, GROUP_NAME, CACHED_TOPICS_TOTAL_DOC);
        metrics.addMetric(this.cachedTopicsMetricName, (config, now) -> ((Integer)localStoreSizeSupplier.get()).intValue());
        this.cachedEntitiesMetricName = metrics.metricName(CACHED_ENTITIES_TOTAL, GROUP_NAME, CACHED_ENTITIES_TOTAL_DOC);
        metrics.addMetric(this.cachedEntitiesMetricName, (config, now) -> ((Integer)localStoreSizeSupplier.get()).intValue());
        this.metricNames.add(this.cachedTopicsMetricName);
        this.metricNames.add(this.cachedEntitiesMetricName);
        this.snapshotDelayMsMetricName = metrics.metricName(SNAPSHOT_EMITTING_DELAY_MS, GROUP_NAME, SNAPSHOT_EMITTING_DELAY_MS_DOC);
        this.snapshotEmittingDelayMsMetric = new LongGauge(0L);
        metrics.addMetric(this.snapshotDelayMsMetricName, (MetricValueProvider)this.snapshotEmittingDelayMsMetric);
        this.metricNames.add(this.snapshotDelayMsMetricName);
        this.deltaEventEmitSensor = this.registerCounterMetrics(DELTA_EVENT_EMIT, DELTA_EVENT_EMIT_DOC);
        this.snapshotEventEmitSensor = this.registerCounterMetrics(SNAPSHOT_EVENT_EMIT, SNAPSHOT_EVENT_EMIT_DOC);
        this.collectorEventHandleErrorSensor = this.registerCounterMetrics(COLLECTOR_EVENT_HANDLE_ERROR, COLLECTOR_EVENT_HANDLE_ERROR_DOC);
    }

    public void removeCatalogMetrics() {
        for (String sensor : this.sensorsNames) {
            this.metrics.removeSensor(sensor);
        }
        for (MetricName metricName : this.metricNames) {
            this.metrics.removeMetric(metricName);
        }
    }

    private Sensor registerCounterMetrics(String name, String doc) {
        Sensor sensor = this.metrics.sensor(name);
        sensor.add(this.metrics.metricName(name + "-rate", GROUP_NAME, doc + " per 30 sec"), (MeasurableStat)new Rate());
        sensor.add(this.metrics.metricName(name + "-total", GROUP_NAME, doc + " in total"), (MeasurableStat)new CumulativeSum());
        this.sensorsNames.add(name);
        return sensor;
    }

    public static class LongGauge
    implements Gauge<Long> {
        private AtomicLong value;

        LongGauge(Long initialValue) {
            this.value = new AtomicLong(initialValue);
        }

        public Long value(MetricConfig config, long now) {
            return this.value.get();
        }

        public void update(Long value) {
            this.value.set(value);
        }
    }
}

