/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.internals.generated.ComputedQuotaKey;
import kafka.internals.generated.ComputedQuotaValue;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class QuotaStateManager$ {
    public static final QuotaStateManager$ MODULE$ = new QuotaStateManager$();
    private static final String MetricsGroup = "quota-coordinator-metrics";
    private static final String LoadTimeSensor = "QuotaPartitionLoadTime";
    private static final String LoadFailureSensor = "QuotaPartitionLoadFailure";
    private static final int DefaultMinElasticCKULimit = 1;
    private static final int DefaultMaxElasticCKULimit = 10;

    public String MetricsGroup() {
        return MetricsGroup;
    }

    public String LoadTimeSensor() {
        return LoadTimeSensor;
    }

    public String LoadFailureSensor() {
        return LoadFailureSensor;
    }

    public int DefaultMinElasticCKULimit() {
        return DefaultMinElasticCKULimit;
    }

    public int DefaultMaxElasticCKULimit() {
        return DefaultMaxElasticCKULimit;
    }

    public QuotaEntity readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            ComputedQuotaKey key = new ComputedQuotaKey((Readable)new ByteBufferAccessor(buffer), version);
            return new QuotaEntity(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(key.quotaEntity()).asScala().map((Function1<ComputedQuotaKey.EntityData, Tuple2> & Serializable)entityData -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entityData.entityType()), entityData.entityName()))).toMap($less$colon$less$.MODULE$.refl()));
        }
        throw new IllegalStateException("Unknown quota message version: " + version);
    }

    public Option<QuotaEntry> readMessageValue(QuotaEntity quotaEntity, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 1) {
            ComputedQuotaValue value = new ComputedQuotaValue((Readable)new ByteBufferAccessor(buffer), version);
            QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, value.lastUpdatedTimestamp());
            CollectionConverters$.MODULE$.ListHasAsScala(value.computedBrokerQuotas()).asScala().foreach((Function1<ComputedQuotaValue.ComputedBrokerQuota, Object> & Serializable)computedBrokerQuota -> {
                QuotaStateManager$.$anonfun$readMessageValue$1(version, quotaEntry, computedBrokerQuota);
                return BoxedUnit.UNIT;
            });
            return new Some<QuotaEntry>(quotaEntry);
        }
        throw new UnsupportedVersionException("Unknown quota message version: " + version);
    }

    public byte[] quotaEntryKey(QuotaEntity quotaEntity) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new ComputedQuotaKey().setQuotaEntity(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)quotaEntity.entityTypes().map((Function1<Tuple2, ComputedQuotaKey.EntityData> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String entityType = (String)tuple2._1();
                String entityName = (String)tuple2._2();
                if (entityType != null) {
                    String string = entityType;
                    if (entityName != null) {
                        String string2 = entityName;
                        return new ComputedQuotaKey.EntityData().setEntityType(string).setEntityName(string2);
                    }
                }
            }
            throw new MatchError(tuple2);
        })).toList()).asJava()));
    }

    public byte[] quotaEntryValue(QuotaEntry quotaEntry) {
        short version = 1;
        return MessageUtil.toVersionPrefixedBytes((short)version, (Message)new ComputedQuotaValue().setComputedBrokerQuotas(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)quotaEntry.computedQuotas().map((Function1<Tuple2, ComputedQuotaValue.ComputedBrokerQuota> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int brokerId = tuple2._1$mcI$sp();
                Map computedQuotas = (Map)tuple2._2();
                return new ComputedQuotaValue.ComputedBrokerQuota().setBrokerId(brokerId).setComputedQuotas(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)computedQuotas.map((Function1<Tuple2, ComputedQuotaValue.ComputedQuota> & Serializable)computedQuota -> new ComputedQuotaValue.ComputedQuota().setQuotaType((String)computedQuota._1()).setQuota(((QuotaValue)computedQuota._2()).quota()).setUsage(((QuotaValue)computedQuota._2()).usage()).setThrottledTimeMs(((QuotaValue)computedQuota._2()).throttledTimeMs()).setLastUsageReportTimestamp(((QuotaValue)computedQuota._2()).lastUsageReportTimestamp()))).toList()).asJava());
            }
            throw new MatchError(tuple2);
        })).toList()).asJava()).setLastUpdatedTimestamp(quotaEntry.lastUpdatedTimestamp()));
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        Object object;
        QuotaEntity quotaEntity = this.readMessageKey(record.key());
        String keyString = "quota_entity::entityTypes=" + quotaEntity.entityTypes();
        Option<QuotaEntry> option = this.readMessageValue(quotaEntity, record.value());
        if (None$.MODULE$.equals(option)) {
            object = "<DELETE>";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            QuotaEntry quotaEntry = (QuotaEntry)some.value();
            object = "computedQuotas:" + quotaEntry.computedQuotasString() + ",lastUpdatedTimestamp:" + quotaEntry.lastUpdatedTimestamp();
        } else {
            throw new MatchError(option);
        }
        String valueString = object;
        return new Tuple2<Option<String>, Option<String>>(new Some<CallSite>((CallSite)((Object)keyString)), new Some<String>(valueString));
    }

    public static final /* synthetic */ void $anonfun$readMessageValue$2(short version$1, QuotaEntry quotaEntry$1, ComputedQuotaValue.ComputedBrokerQuota computedBrokerQuota$1, ComputedQuotaValue.ComputedQuota computedQuota) {
        double throttledTimeMs = version$1 == 0 ? (double)(!computedQuota.throttled() ? 0 : 500) : computedQuota.throttledTimeMs();
        quotaEntry$1.putQuotaValue(computedBrokerQuota$1.brokerId(), computedQuota.quotaType(), QuotaValue$.MODULE$.loadValue(computedQuota.usage(), throttledTimeMs, computedQuota.quota(), computedQuota.lastUsageReportTimestamp()));
    }

    public static final /* synthetic */ void $anonfun$readMessageValue$1(short version$1, QuotaEntry quotaEntry$1, ComputedQuotaValue.ComputedBrokerQuota computedBrokerQuota) {
        CollectionConverters$.MODULE$.ListHasAsScala(computedBrokerQuota.computedQuotas()).asScala().foreach((Function1<ComputedQuotaValue.ComputedQuota, Object> & Serializable)computedQuota -> {
            QuotaStateManager$.$anonfun$readMessageValue$2(version$1, quotaEntry$1, computedBrokerQuota, computedQuota);
            return BoxedUnit.UNIT;
        });
    }

    private QuotaStateManager$() {
    }
}

