/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.transaction.generated.CoordinatorRecordType;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.server.common.TransactionVersion;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;

public final class TransactionLog$ {
    public static final TransactionLog$ MODULE$ = new TransactionLog$();
    private static final Compression EnforcedCompression = Compression.NONE;
    private static final short EnforcedRequiredAcks = (short)-1;

    public Compression EnforcedCompression() {
        return EnforcedCompression;
    }

    public short EnforcedRequiredAcks() {
        return EnforcedRequiredAcks;
    }

    public byte[] keyToBytes(String transactionalId) {
        return MessageUtil.toCoordinatorTypePrefixedBytes((ApiMessage)new TransactionLogKey().setTransactionalId(transactionalId));
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata, TransactionVersion transactionVersionLevel) {
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(empty$) : empty$ != null) && txnMetadata.topicPartitions().nonEmpty()) {
            throw new IllegalStateException("Transaction is not expected to have any partitions since its state is " + txnMetadata.txnState() + ": " + txnMetadata);
        }
        TransactionState transactionState2 = txnMetadata.txnState();
        Empty$ empty$2 = Empty$.MODULE$;
        List<TransactionLogValue.PartitionsSchema> transactionPartitions = !(transactionState2 != null ? !transactionState2.equals(empty$2) : empty$2 != null) ? null : CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)txnMetadata.topicPartitions().groupBy((Function1<TopicPartition, String> & Serializable)x$1 -> x$1.topic()).map((Function1<Tuple2, TransactionLogValue.PartitionsSchema> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                Set partitions = (Set)tuple2._2();
                return new TransactionLogValue.PartitionsSchema().setTopic(topic).setPartitionIds(CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)partitions.map((Function1<TopicPartition, Integer> & Serializable)tp -> tp.partition())).toList()).asJava());
            }
            throw new MatchError(tuple2);
        })).toList()).asJava();
        return MessageUtil.toVersionPrefixedBytes((short)transactionVersionLevel.transactionLogValueVersion(), (Message)new TransactionLogValue().setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStatus(txnMetadata.txnState().id()).setTransactionLastUpdateTimestampMs(txnMetadata.txnLastUpdateTimestamp()).setTransactionStartTimestampMs(txnMetadata.txnStartTimestamp()).setTransactionPartitions(transactionPartitions).setClientTransactionVersion(txnMetadata.clientTransactionVersion().featureLevel()));
    }

    public BaseKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version == CoordinatorRecordType.TRANSACTION_LOG.id()) {
            TransactionLogKey value = new TransactionLogKey((Readable)new ByteBufferAccessor(buffer), (short)0);
            return new TxnKey(version, value.transactionalId());
        }
        return new UnknownKey(version);
    }

    public Option<TransactionMetadata> readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 1) {
            TransactionLogValue value = new TransactionLogValue((Readable)new ByteBufferAccessor(buffer), version);
            TransactionMetadata transactionMetadata = new TransactionMetadata(transactionalId, value.producerId(), value.previousProducerId(), value.nextProducerId(), value.producerEpoch(), -1, value.transactionTimeoutMs(), TransactionState$.MODULE$.fromId(value.transactionStatus()), (Set)Set$.MODULE$.empty(), value.transactionStartTimestampMs(), value.transactionLastUpdateTimestampMs(), TransactionVersion.fromFeatureLevel(value.clientTransactionVersion()));
            if (!transactionMetadata.state().equals(Empty$.MODULE$)) {
                value.transactionPartitions().forEach(partitionsSchema -> transactionMetadata.addPartitions(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionsSchema.partitionIds()).asScala().map((Function1<Integer, TopicPartition> & Serializable)partitionId -> new TopicPartition(partitionsSchema.topic(), Predef$.MODULE$.Integer2int((Integer)partitionId)))).toSet()));
            }
            return new Some<TransactionMetadata>(transactionMetadata);
        }
        throw new IllegalStateException("Unknown version " + version + " from the transaction log message value");
    }

    private TransactionLog$() {
    }
}

