/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$All$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Sample$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.common.TransactionVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r=uA\u0002+V\u0011\u0003)6L\u0002\u0004^+\"\u0005QK\u0018\u0005\u0006K\u0006!\ta\u001a\u0005\u0006Q\u0006!\t!\u001b\u0005\be\u0006\t\n\u0011\"\u0001t\r\u0019iV\u000bA+\u0002\u0004!Q\u0011\u0011C\u0003\u0003\u0006\u0004%\t!a\u0005\t\u0015\u0005-RA!A!\u0002\u0013\t)\u0002\u0003\u0006\u0002.\u0015\u0011\t\u0019!C\u0001\u0003_A!\"!\r\u0006\u0005\u0003\u0007I\u0011AA\u001a\u0011%\ty$\u0002B\u0001B\u0003&Q\u000f\u0003\u0006\u0002B\u0015\u0011\t\u0019!C\u0001\u0003_A!\"a\u0011\u0006\u0005\u0003\u0007I\u0011AA#\u0011%\tI%\u0002B\u0001B\u0003&Q\u000f\u0003\u0006\u0002L\u0015\u0011\t\u0019!C\u0001\u0003_A!\"!\u0014\u0006\u0005\u0003\u0007I\u0011AA(\u0011%\t\u0019&\u0002B\u0001B\u0003&Q\u000fC\u0005o\u000b\t\u0005\r\u0011\"\u0001\u0002V!Q\u0011qK\u0003\u0003\u0002\u0004%\t!!\u0017\t\u0013\u0005uSA!A!B\u0013y\u0007BCA0\u000b\t\u0005\r\u0011\"\u0001\u0002V!Q\u0011\u0011M\u0003\u0003\u0002\u0004%\t!a\u0019\t\u0013\u0005\u001dTA!A!B\u0013y\u0007BCA5\u000b\t\u0005\r\u0011\"\u0001\u0002l!Q\u00111O\u0003\u0003\u0002\u0004%\t!!\u001e\t\u0015\u0005eTA!A!B\u0013\ti\u0007\u0003\u0006\u0002|\u0015\u0011\t\u0019!C\u0001\u0003{B!\"!\"\u0006\u0005\u0003\u0007I\u0011AAD\u0011)\tY)\u0002B\u0001B\u0003&\u0011q\u0010\u0005\u000b\u0003++!\u00111A\u0005\u0002\u0005]\u0005BCA`\u000b\t\u0005\r\u0011\"\u0001\u0002B\"Q\u0011QY\u0003\u0003\u0002\u0003\u0006K!!'\t\u0015\u0005\u001dWA!a\u0001\n\u0003\ty\u0003\u0003\u0006\u0002J\u0016\u0011\t\u0019!C\u0001\u0003\u0017D\u0011\"a4\u0006\u0005\u0003\u0005\u000b\u0015B;\t\u0015\u0005MWA!a\u0001\n\u0003\ty\u0003\u0003\u0006\u0002V\u0016\u0011\t\u0019!C\u0001\u0003/D\u0011\"a7\u0006\u0005\u0003\u0005\u000b\u0015B;\t\u0015\u0005}WA!a\u0001\n\u0003\t\t\u000f\u0003\u0006\u0002r\u0016\u0011\t\u0019!C\u0001\u0003gD!\"a>\u0006\u0005\u0003\u0005\u000b\u0015BAr\u0011\u0019)W\u0001\"\u0001\u0002z\"I!QC\u0003A\u0002\u0013\u0005!q\u0003\u0005\n\u0005?)\u0001\u0019!C\u0001\u0005CA\u0001B!\n\u0006A\u0003&!\u0011\u0004\u0005\n\u0005S)\u0001\u0019!C\u0001\u0005WA\u0011B!\f\u0006\u0001\u0004%\tAa\f\t\u000f\tMR\u0001)Q\u0005U\"Q!QG\u0003C\u0002\u0013\u0005QKa\u000e\t\u0011\tES\u0001)A\u0005\u0005sAqAa\u0015\u0006\t\u0003\u0011)\u0006C\u0004\u0003z\u0015!\tAa\u001f\t\u000f\t\u001dU\u0001\"\u0001\u0003\n\"9!qR\u0003\u0005\u0002\tE\u0005b\u0002BM\u000b\u0011\u0005!\u0011\u0013\u0005\b\u00057+A\u0011\u0001BO\u0011\u001d\u0011Y-\u0002C\u0001\u0005\u001bDqAa7\u0006\t\u0003\u0011i\u000eC\u0004\u0003r\u0016!\tAa=\t\u000f\r\rQ\u0001\"\u0001\u0004\u0006!91\u0011B\u0003\u0005\u0002\tE\u0005bBB\u0006\u000b\u0011\u0005!1\u0006\u0005\b\u0007\u001b)A\u0011\u0001B\u0016\u0011\u001d\u0019y!\u0002C\u0005\u0005WAqa!\u0005\u0006\t\u0003\u0019\u0019\u0002\u0003\u0005\u0004*\u0015\t\n\u0011\"\u0001t\u0011!\u0019Y#BI\u0001\n\u0003\u0019\b\"CB\u0017\u000bE\u0005I\u0011AB\u0018\u0011%\u0019\u0019$BI\u0001\n\u0003\u0019y\u0003C\u0005\u00046\u0015\t\n\u0011\"\u0001\u00048!I11H\u0003\u0012\u0002\u0013\u00051Q\b\u0005\t\u0007\u0003*\u0011\u0013!C\u0001g\"A11I\u0003\u0012\u0002\u0013\u00051\u000fC\u0005\u0004F\u0015\t\n\u0011\"\u0001\u0004H!911J\u0003\u0005\u0002\r5\u0003bBB*\u000b\u0011%1Q\u000b\u0005\b\u00073*A\u0011BB.\u0011\u001d\u0019y&\u0002C\u0005\u0007CBqaa\u001a\u0006\t\u0003\u0011Y\u0003C\u0004\u0004j\u0015!IAa\u000b\t\u000f\r-T\u0001\"\u0001\u0004n!911N\u0003\u0005B\re\u0004bBB>\u000b\u0011\u00053Q\u0010\u0005\b\u0007\u0007+A\u0011IBC\u0003M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0015\t1v+A\u0006ue\u0006t7/Y2uS>t'B\u0001-Z\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003i\u000bQa[1gW\u0006\u0004\"\u0001X\u0001\u000e\u0003U\u00131\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\"!A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A.\u0002!%\u001cX\t]8dQ\u0016C\b.Y;ti\u0016$GC\u00016n!\t\u00017.\u0003\u0002mC\n9!i\\8mK\u0006t\u0007\"\u00028\u0004\u0001\u0004y\u0017!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0005\u0002aa&\u0011\u0011/\u0019\u0002\u0006'\"|'\u000f^\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00191+\u0005!(FA;y!\t\u0001g/\u0003\u0002xC\n!Aj\u001c8hW\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003%)hn\u00195fG.,GM\u0003\u0002\u007fC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u00051PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u001cB!B0\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fe\u000bQ!\u001e;jYNLA!a\u0004\u0002\n\t9Aj\\4hS:<\u0017a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0016\u0005\u0005U\u0001\u0003BA\f\u0003KqA!!\u0007\u0002\"A\u0019\u00111D1\u000e\u0005\u0005u!bAA\u0010M\u00061AH]8pizJ1!a\tb\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111E1\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\tQ/\u0001\bqe>$WoY3s\u0013\u0012|F%Z9\u0015\t\u0005U\u00121\b\t\u0004A\u0006]\u0012bAA\u001dC\n!QK\\5u\u0011!\ti$CA\u0001\u0002\u0004)\u0018a\u0001=%c\u0005Y\u0001O]8ek\u000e,'/\u00133!\u00039\u0001(/\u001a<Qe>$WoY3s\u0013\u0012\f!\u0003\u001d:fmB\u0013x\u000eZ;dKJLEm\u0018\u0013fcR!\u0011QGA$\u0011!\ti\u0004DA\u0001\u0002\u0004)\u0018a\u00049sKZ\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002\u001d9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI\u0006\u0011b.\u001a=u!J|G-^2fe&#w\fJ3r)\u0011\t)$!\u0015\t\u0011\u0005ur\"!AA\u0002U\fqB\\3yiB\u0013x\u000eZ;dKJLE\rI\u000b\u0002_\u0006\t\u0002O]8ek\u000e,'/\u00129pG\"|F%Z9\u0015\t\u0005U\u00121\f\u0005\t\u0003{\u0011\u0012\u0011!a\u0001_\u0006q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0013!\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0006)B.Y:u!J|G-^2fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u001b\u0003KB\u0001\"!\u0010\u0016\u0003\u0003\u0005\ra\\\u0001\u0013Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0007%\u0001\u0007uq:$\u0016.\\3pkRl5/\u0006\u0002\u0002nA\u0019\u0001-a\u001c\n\u0007\u0005E\u0014MA\u0002J]R\f\u0001\u0003\u001e=o)&lWm\\;u\u001bN|F%Z9\u0015\t\u0005U\u0012q\u000f\u0005\n\u0003{A\u0012\u0011!a\u0001\u0003[\nQ\u0002\u001e=o)&lWm\\;u\u001bN\u0004\u0013!B:uCR,WCAA@!\ra\u0016\u0011Q\u0005\u0004\u0003\u0007+&\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0003%\u0019H/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005%\u0005\"CA\u001f7\u0005\u0005\t\u0019AA@\u0003\u0019\u0019H/\u0019;fA!\u001aA$a$\u0011\u0007\u0001\f\t*C\u0002\u0002\u0014\u0006\u0014\u0001B^8mCRLG.Z\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\u0011\u0011\u0011\u0014\t\u0007\u00037\u000b)+!+\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bq!\\;uC\ndWMC\u0002\u0002$\u0006\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9+!(\u0003\u0007M+G\u000f\u0005\u0003\u0002,\u0006mVBAAW\u0015\u0011\ty+!-\u0002\r\r|W.\\8o\u0015\rQ\u00161\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003s\u000b1a\u001c:h\u0013\u0011\ti,!,\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019Bo\u001c9jGB\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011QGAb\u0011%\tiDHA\u0001\u0002\u0004\tI*\u0001\tu_BL7\rU1si&$\u0018n\u001c8tA\u0005\tB\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\u0002+QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011QGAg\u0011!\ti$IA\u0001\u0002\u0004)\u0018A\u0005;y]N#\u0018M\u001d;US6,7\u000f^1na\u0002B3AIAH\u0003Y!\bP\u001c'bgR,\u0006\u000fZ1uKRKW.Z:uC6\u0004\u0018A\u0007;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA\u001b\u00033D\u0001\"!\u0010%\u0003\u0003\u0005\r!^\u0001\u0018ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0002B3!JAH\u0003a\u0019G.[3oiR\u0013\u0018M\\:bGRLwN\u001c,feNLwN\\\u000b\u0003\u0003G\u0004B!!:\u0002n6\u0011\u0011q\u001d\u0006\u0005\u0003_\u000bIO\u0003\u0003\u0002l\u0006E\u0016AB:feZ,'/\u0003\u0003\u0002p\u0006\u001d(A\u0005+sC:\u001c\u0018m\u0019;j_:4VM]:j_:\fAd\u00197jK:$HK]1og\u0006\u001cG/[8o-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005U\b\"CA\u001fO\u0005\u0005\t\u0019AAr\u0003e\u0019G.[3oiR\u0013\u0018M\\:bGRLwN\u001c,feNLwN\u001c\u0011\u00155\u0005m\u0018Q`A\u0000\u0005\u0003\u0011\u0019A!\u0002\u0003\b\t%!1\u0002B\u0007\u0005\u001f\u0011\tBa\u0005\u0011\u0005q+\u0001bBA\tS\u0001\u0007\u0011Q\u0003\u0005\u0007\u0003[I\u0003\u0019A;\t\r\u0005\u0005\u0013\u00061\u0001v\u0011\u0019\tY%\u000ba\u0001k\")a.\u000ba\u0001_\"1\u0011qL\u0015A\u0002=Dq!!\u001b*\u0001\u0004\ti\u0007C\u0004\u0002|%\u0002\r!a \t\u000f\u0005U\u0015\u00061\u0001\u0002\u001a\"A\u0011qY\u0015\u0011\u0002\u0003\u0007Q\u000f\u0003\u0004\u0002T&\u0002\r!\u001e\u0005\b\u0003?L\u0003\u0019AAr\u00031\u0001XM\u001c3j]\u001e\u001cF/\u0019;f+\t\u0011I\u0002E\u0003a\u00057\ty(C\u0002\u0003\u001e\u0005\u0014aa\u00149uS>t\u0017\u0001\u00059f]\u0012LgnZ*uCR,w\fJ3r)\u0011\t)Da\t\t\u0013\u0005u2&!AA\u0002\te\u0011!\u00049f]\u0012LgnZ*uCR,\u0007\u0005K\u0002-\u0003\u001f\u000b1\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016,\u0012A[\u0001\u0018Q\u0006\u001ch)Y5mK\u0012,\u0005o\\2i\r\u0016t7-Z0%KF$B!!\u000e\u00032!A\u0011Q\b\u0018\u0002\u0002\u0003\u0007!.\u0001\u000biCN4\u0015-\u001b7fI\u0016\u0003xn\u00195GK:\u001cW\rI\u0001\u0005Y>\u001c7.\u0006\u0002\u0003:A!!1\bB'\u001b\t\u0011iD\u0003\u0003\u0003@\t\u0005\u0013!\u00027pG.\u001c(\u0002\u0002B\"\u0005\u000b\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\u00119E!\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u0017\nAA[1wC&!!q\nB\u001f\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006)An\\2lA\u00051\u0011N\u001c'pG.,BAa\u0016\u0003^Q!!\u0011\fB8!\u0011\u0011YF!\u0018\r\u0001\u00119!q\f\u001aC\u0002\t\u0005$!\u0001+\u0012\t\t\r$\u0011\u000e\t\u0004A\n\u0015\u0014b\u0001B4C\n9aj\u001c;iS:<\u0007c\u00011\u0003l%\u0019!QN1\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003rI\"\t\u0019\u0001B:\u0003\r1WO\u001c\t\u0006A\nU$\u0011L\u0005\u0004\u0005o\n'\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0011\t)D! \t\u000f\t}4\u00071\u0001\u0003\u0002\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\t\r%QQAU\u001b\t\t\t+\u0003\u0003\u0002(\u0006\u0005\u0016a\u0004:f[>4X\rU1si&$\u0018n\u001c8\u0015\t\u0005U\"1\u0012\u0005\b\u0005\u001b#\u0004\u0019AAU\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003\u001d:fa\u0006\u0014XMT8Ue\u0006t7/\u001b;\u0015\u0005\tM\u0005c\u0001/\u0003\u0016&\u0019!qS+\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/Y\u0001\u001aaJ,\u0007/\u0019:f\r\u0016t7-\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007.A\u000fqe\u0016\u0004\u0018M]3J]\u000e\u0014X-\\3oiB\u0013x\u000eZ;dKJ,\u0005o\\2i)!\u0011yJ!0\u0003B\n\u001d\u0007\u0003\u0003BQ\u0005W\u0013\tLa%\u000f\t\t\r&q\u0015\b\u0005\u00037\u0011)+C\u0001c\u0013\r\u0011I+Y\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iKa,\u0003\r\u0015KG\u000f[3s\u0015\r\u0011I+\u0019\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*!!qWAW\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B^\u0005k\u0013a!\u0012:s_J\u001c\bb\u0002B`o\u0001\u0007\u0011QN\u0001\u0010]\u0016<H\u000b\u001f8US6,w.\u001e;Ng\"9!1Y\u001cA\u0002\t\u0015\u0017!F3ya\u0016\u001cG/\u001a3Qe>$WoY3s\u000bB|7\r\u001b\t\u0005A\nmq\u000e\u0003\u0004\u0003J^\u0002\r!^\u0001\u0010kB$\u0017\r^3US6,7\u000f^1na\u0006I\u0002O]3qCJ,\u0007K]8ek\u000e,'/\u00133S_R\fG/[8o))\u0011\u0019Ja4\u0003T\nU'q\u001b\u0005\u0007\u0005#D\u0004\u0019A;\u0002\u001b9,w\u000f\u0015:pIV\u001cWM]%e\u0011\u001d\u0011y\f\u000fa\u0001\u0003[BaA!39\u0001\u0004)\bB\u0002Bmq\u0001\u0007!.A\bsK\u000e|'\u000f\u001a'bgR,\u0005o\\2i\u0003Q\u0001(/\u001a9be\u0016\fE\r\u001a)beRLG/[8ogRA!1\u0013Bp\u0005[\u0014y\u000fC\u0004\u0003bf\u0002\rAa9\u0002)\u0005$G-\u001a3U_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011)Oa;\u0002*6\u0011!q\u001d\u0006\u0005\u0005S\f\t+A\u0005j[6,H/\u00192mK&!\u0011q\u0015Bt\u0011\u0019\u0011I-\u000fa\u0001k\"9\u0011q\\\u001dA\u0002\u0005\r\u0018\u0001\u00069sKB\f'/Z!c_J$xJ]\"p[6LG\u000f\u0006\u0007\u0003\u0014\nU(\u0011 B~\u0005{\u0014y\u0010C\u0004\u0003xj\u0002\r!a \u0002\u00119,wo\u0015;bi\u0016Dq!a8;\u0001\u0004\t\u0019\u000f\u0003\u0004\u0002Li\u0002\r!\u001e\u0005\u0007\u0005\u0013T\u0004\u0019A;\t\r\r\u0005!\b1\u0001k\u0003Aqw\u000eU1si&$\u0018n\u001c8BI\u0012,G-A\bqe\u0016\u0004\u0018M]3D_6\u0004H.\u001a;f)\u0011\u0011\u0019ja\u0002\t\r\t%7\b1\u0001v\u0003-\u0001(/\u001a9be\u0016$U-\u00193\u00021%\u001c\bK]8ek\u000e,'/\u00129pG\",\u0005\u0010[1vgR,G-\u0001\u0010jg\u0012K7\u000f\u001e:jEV$X\r\u001a+x_BC\u0017m]3D_6l\u0017\u000e\u001e+y]\u0006)\u0002.Y:QK:$\u0017N\\4Ue\u0006t7/Y2uS>t\u0017a\u00059sKB\f'/\u001a+sC:\u001c\u0018\u000e^5p]R{GC\u0006BJ\u0007+\u00199b!\u0007\u0004\u001c\ru1qDB\u0011\u0007G\u0019)ca\n\t\u000f\u0005m\u0004\t1\u0001\u0002\u0000!A\u0011Q\u0006!\u0011\u0002\u0003\u0007Q\u000f\u0003\u0005\u0002L\u0001\u0003\n\u00111\u0001v\u0011\u001dq\u0007\t%AA\u0002=D\u0001\"a\u0018A!\u0003\u0005\ra\u001c\u0005\n\u0003S\u0002\u0005\u0013!a\u0001\u0003[B\u0011\"!&A!\u0003\u0005\r!!'\t\u0011\u0005\u001d\u0007\t%AA\u0002UD\u0001\"a5A!\u0003\u0005\r!\u001e\u0005\n\u0003?\u0004\u0005\u0013!a\u0001\u0003G\fQ\u0004\u001d:fa\u0006\u0014X\r\u0016:b]NLG/[8o)>$C-\u001a4bk2$HEM\u0001\u001eaJ,\u0007/\u0019:f)J\fgn]5uS>tGk\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0002O]3qCJ,GK]1og&$\u0018n\u001c8U_\u0012\"WMZ1vYR$C'\u0006\u0002\u00042)\u0012q\u000e_\u0001\u001eaJ,\u0007/\u0019:f)J\fgn]5uS>tGk\u001c\u0013eK\u001a\fW\u000f\u001c;%k\u0005i\u0002O]3qCJ,GK]1og&$\u0018n\u001c8U_\u0012\"WMZ1vYR$c'\u0006\u0002\u0004:)\u001a\u0011Q\u000e=\u0002;A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8%I\u00164\u0017-\u001e7uI]*\"aa\u0010+\u0007\u0005e\u00050A\u000fqe\u0016\u0004\u0018M]3Ue\u0006t7/\u001b;j_:$v\u000e\n3fM\u0006,H\u000e\u001e\u00139\u0003u\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+pI\u0011,g-Y;mi\u0012J\u0014A\b9sKB\f'/\u001a+sC:\u001c\u0018\u000e^5p]R{G\u0005Z3gCVdG\u000fJ\u00191+\t\u0019IEK\u0002\u0002db\fAcY8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]R{G\u0003BA\u001b\u0007\u001fBqa!\u0015K\u0001\u0004\u0011\u0019*A\bue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003I1\u0018\r\\5e!J|G-^2fe\u0016\u0003xn\u00195\u0015\u0007)\u001c9\u0006C\u0004\u0004R-\u0003\rAa%\u0002-Y\fG.\u001b3Qe>$WoY3s\u000bB|7\r\u001b\"v[B$2A[B/\u0011\u001d\u0019\t\u0006\u0014a\u0001\u0005'\u000b1\u0004\u001e5s_^\u001cF/\u0019;f)J\fgn]5uS>tg)Y5mkJ,G\u0003BA\u001b\u0007GBqa!\u001aN\u0001\u0004\u0011\u0019*\u0001\nuq:$&/\u00198tSRlU\r^1eCR\f\u0017a\u00079f]\u0012Lgn\u001a+sC:\u001c\u0018\u000e^5p]&s\u0007K]8he\u0016\u001c8/A\bj]\u000edW\u000fZ3t\u001f\u001a47/\u001a;t\u0003!!xn\u0015;sS:<G\u0003BA\u000b\u0007_Bqa!\u001dQ\u0001\u0004\u0019\u0019(A\u0005wKJ\u0014wn]5usB\u0019Al!\u001e\n\u0007\r]TKA\u000eUe\u0006t7/Y2uS>tGj\\4hS:<g+\u001a:c_NLG/\u001f\u000b\u0003\u0003+\ta!Z9vC2\u001cHc\u00016\u0004\u0000!91\u0011\u0011*A\u0002\t%\u0014\u0001\u0002;iCR\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003[B3!BBE!\u0011\t9aa#\n\t\r5\u0015\u0011\u0002\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long prevProducerId;
    private long nextProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private volatile TransactionState state;
    private scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private TransactionVersion clientTransactionVersion;
    private volatile Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$10() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean isEpochExhausted(short producerEpoch) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(producerEpoch);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionMetadata transactionMetadata = this;
        synchronized (transactionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long prevProducerId() {
        return this.prevProducerId;
    }

    public void prevProducerId_$eq(long x$1) {
        this.prevProducerId = x$1;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(scala.collection.mutable.Set<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public TransactionVersion clientTransactionVersion() {
        return this.clientTransactionVersion;
    }

    public void clientTransactionVersion_$eq(TransactionVersion x$1) {
        this.clientTransactionVersion = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException("Transaction metadata's current state is " + this.state() + ", and its pending state is " + this.pendingState() + " while trying to remove partitions whose txn marker has been sent, this is not expected");
            }
        }
        this.topicPartitions().$minus$eq(topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.prevProducerId(), this.nextProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.mutable.Set)this.topicPartitions().clone(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp(), this.clientTransactionVersion());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        PrepareEpochFence$ x$1 = PrepareEpochFence$.MODULE$;
        short x$2 = bumpedEpoch;
        int x$3 = -1;
        long x$4 = this.prepareTransitionTo$default$2();
        long x$5 = this.prepareTransitionTo$default$3();
        int x$6 = this.prepareTransitionTo$default$6();
        scala.collection.mutable.Set<TopicPartition> x$7 = this.prepareTransitionTo$default$7();
        long x$8 = this.prepareTransitionTo$default$8();
        long x$9 = this.prepareTransitionTo$default$9();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(x$1, x$4, x$5, x$2, (short)-1, x$6, x$7, x$8, x$9, x$10);
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Right right;
        Tuple2 tuple2;
        Right epochBumpResult;
        Either either;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException("Cannot allocate any more producer epochs for producerId " + this.producerId());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        Option<Object> option = expectedProducerEpoch;
        if (None$.MODULE$.equals(option)) {
            either = new Right(new Tuple2<Short, Short>(BoxesRunTime.boxToShort(bumpedEpoch), BoxesRunTime.boxToShort((short)-1)));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            short expectedEpoch = BoxesRunTime.unboxToShort(some.value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                either = new Right(new Tuple2<Short, Short>(BoxesRunTime.boxToShort(bumpedEpoch), BoxesRunTime.boxToShort(this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                either = new Right(new Tuple2<Short, Short>(BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToShort(this.lastProducerEpoch())));
            } else {
                this.info((Function0<String> & Serializable)() -> "Expected producer epoch " + expectedEpoch + " does not match current producer epoch " + this.producerEpoch() + " or previous producer epoch " + this.lastProducerEpoch());
                either = new Left(Errors.PRODUCER_FENCED);
            }
        } else {
            throw new MatchError(option);
        }
        Right right2 = epochBumpResult = either;
        if (right2 instanceof Right && (tuple2 = (Tuple2)(right = right2).value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort(tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort(tuple2._2());
            Empty$ x$1 = Empty$.MODULE$;
            short x$2 = nextEpoch;
            short x$3 = lastEpoch;
            int x$4 = newTxnTimeoutMs;
            scala.collection.mutable.Set x$5 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
            long x$6 = -1L;
            long x$7 = updateTimestamp;
            long x$8 = this.prepareTransitionTo$default$2();
            long x$9 = this.prepareTransitionTo$default$3();
            TransactionVersion x$10 = this.prepareTransitionTo$default$10();
            return new Right<Errors, TxnTransitMetadata>(this.prepareTransitionTo(x$1, x$8, x$9, x$2, x$3, x$4, x$5, -1L, x$7, x$10));
        }
        if (right2 instanceof Left) {
            Left left = (Left)((Object)right2);
            Errors err = (Errors)left.value();
            return new Left<Errors, TxnTransitMetadata>(err);
        }
        throw new MatchError(right2);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        Empty$ x$1 = Empty$.MODULE$;
        long x$2 = newProducerId;
        boolean x$3 = false;
        short x$4 = recordLastEpoch ? (short)this.producerEpoch() : (short)-1;
        int x$5 = newTxnTimeoutMs;
        scala.collection.mutable.Set x$6 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$7 = -1L;
        long x$8 = updateTimestamp;
        long x$9 = this.prepareTransitionTo$default$3();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(x$1, x$2, x$9, (short)0, x$4, x$5, x$6, -1L, x$8, x$10);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp, TransactionVersion clientTransactionVersion) {
        TransactionState transactionState = this.state();
        long newTxnStartTimestamp = (Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState))) ? updateTimestamp : this.txnStartTimestamp();
        Ongoing$ x$1 = Ongoing$.MODULE$;
        scala.collection.mutable.Set x$2 = (scala.collection.mutable.Set)this.topicPartitions().$plus$plus(addedTopicPartitions);
        long x$3 = newTxnStartTimestamp;
        long x$4 = updateTimestamp;
        TransactionVersion x$5 = clientTransactionVersion;
        long x$6 = this.prepareTransitionTo$default$2();
        long x$7 = this.prepareTransitionTo$default$3();
        short x$8 = this.prepareTransitionTo$default$4();
        short x$9 = this.prepareTransitionTo$default$5();
        int x$10 = this.prepareTransitionTo$default$6();
        return this.prepareTransitionTo(x$1, x$6, x$7, x$8, x$9, x$10, x$2, x$3, x$4, x$5);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, TransactionVersion clientTransactionVersion, long nextProducerId, long updateTimestamp, boolean noPartitionAdded) {
        Tuple2<Short, Short> tuple2;
        Tuple2<Short, Short> tuple22 = tuple2 = clientTransactionVersion.supportsEpochBump() ? new Tuple2<Short, Short>(BoxesRunTime.boxToShort((short)(this.producerEpoch() + 1)), BoxesRunTime.boxToShort(this.producerEpoch())) : new Tuple2<Short, Short>(BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToShort(this.lastProducerEpoch()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        short updatedProducerEpoch = BoxesRunTime.unboxToShort(tuple2._1());
        short updatedLastProducerEpoch = BoxesRunTime.unboxToShort(tuple2._2());
        Tuple2<Short, Short> tuple23 = new Tuple2<Short, Short>(BoxesRunTime.boxToShort(updatedProducerEpoch), BoxesRunTime.boxToShort(updatedLastProducerEpoch));
        short updatedProducerEpoch2 = BoxesRunTime.unboxToShort(tuple23._1());
        short updatedLastProducerEpoch2 = BoxesRunTime.unboxToShort(tuple23._2());
        long newTxnStartTimestamp = noPartitionAdded ? updateTimestamp : this.txnStartTimestamp();
        TransactionState x$1 = newState;
        long x$2 = nextProducerId;
        short x$3 = updatedProducerEpoch2;
        short x$4 = updatedLastProducerEpoch2;
        long x$5 = newTxnStartTimestamp;
        long x$6 = updateTimestamp;
        TransactionVersion x$7 = clientTransactionVersion;
        long x$8 = this.prepareTransitionTo$default$2();
        int x$9 = this.prepareTransitionTo$default$6();
        scala.collection.mutable.Set<TopicPartition> x$10 = this.prepareTransitionTo$default$7();
        return this.prepareTransitionTo(x$1, x$8, x$2, x$3, x$4, x$9, x$10, x$5, x$6, x$7);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        Tuple2<Long, Short> tuple2;
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        Tuple2<Long, Short> tuple22 = tuple2 = this.clientTransactionVersion().supportsEpochBump() && this.nextProducerId() != -1L ? new Tuple2<Long, Short>(BoxesRunTime.boxToLong(this.nextProducerId()), BoxesRunTime.boxToShort((short)0)) : new Tuple2<Long, Short>(BoxesRunTime.boxToLong(this.producerId()), BoxesRunTime.boxToShort(this.producerEpoch()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long updatedProducerId = tuple2._1$mcJ$sp();
        short updatedProducerEpoch = BoxesRunTime.unboxToShort(tuple2._2());
        Tuple2<Long, Short> tuple23 = new Tuple2<Long, Short>(BoxesRunTime.boxToLong(updatedProducerId), BoxesRunTime.boxToShort(updatedProducerEpoch));
        long updatedProducerId2 = tuple23._1$mcJ$sp();
        short updatedProducerEpoch2 = BoxesRunTime.unboxToShort(tuple23._2());
        Product x$1 = newState;
        long x$2 = updatedProducerId2;
        long x$3 = -1L;
        short x$4 = updatedProducerEpoch2;
        scala.collection.mutable.Set x$5 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$6 = updateTimestamp;
        short x$7 = this.prepareTransitionTo$default$5();
        int x$8 = this.prepareTransitionTo$default$6();
        long x$9 = this.prepareTransitionTo$default$8();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo((TransactionState)((Object)x$1), x$2, -1L, x$4, x$7, x$8, x$5, x$9, x$6, x$10);
    }

    public TxnTransitMetadata prepareDead() {
        Dead$ x$1 = Dead$.MODULE$;
        scala.collection.mutable.Set x$2 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$3 = this.prepareTransitionTo$default$2();
        long x$4 = this.prepareTransitionTo$default$3();
        short x$5 = this.prepareTransitionTo$default$4();
        short x$6 = this.prepareTransitionTo$default$5();
        int x$7 = this.prepareTransitionTo$default$6();
        long x$8 = this.prepareTransitionTo$default$8();
        long x$9 = this.prepareTransitionTo$default$9();
        TransactionVersion x$10 = this.prepareTransitionTo$default$10();
        return this.prepareTransitionTo(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10);
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    public boolean isDistributedTwoPhaseCommitTxn() {
        return this.txnTimeoutMs() >= 0x7FFFFFFE;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        return Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
    }

    public TxnTransitMetadata prepareTransitionTo(TransactionState state, long producerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException("Preparing transaction state transition to " + state + " while it already has pending state " + this.pendingState().get());
        }
        if (producerId < 0L) {
            throw new IllegalArgumentException("Illegal new producer id " + producerId);
        }
        TransactionState transactionState = state;
        Dead$ dead$ = Dead$.MODULE$;
        if ((transactionState == null ? dead$ != null : !transactionState.equals(dead$)) && producerEpoch < 0) {
            throw new IllegalArgumentException("Illegal new producer epoch " + producerEpoch);
        }
        if (state.validPreviousStates().contains(this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(producerId, this.producerId(), nextProducerId, producerEpoch, lastProducerEpoch, txnTimeoutMs, state, topicPartitions, txnStartTimestamp, txnLastUpdateTimestamp, clientTransactionVersion);
            this.debug((Function0<String> & Serializable)() -> "TransactionalId " + this.transactionalId() + " prepare transition from " + this.state() + " to " + transitMetadata);
            this.pendingState_$eq(new Some<TransactionState>(state));
            return transitMetadata;
        }
        throw new IllegalStateException("Preparing transaction state transition to " + state + " failed since the target state " + state + " is not a valid previous state of the current state " + this.state());
    }

    public long prepareTransitionTo$default$2() {
        return this.producerId();
    }

    public long prepareTransitionTo$default$3() {
        return this.nextProducerId();
    }

    public short prepareTransitionTo$default$4() {
        return this.producerEpoch();
    }

    public short prepareTransitionTo$default$5() {
        return this.lastProducerEpoch();
    }

    public int prepareTransitionTo$default$6() {
        return this.txnTimeoutMs();
    }

    public scala.collection.mutable.Set<TopicPartition> prepareTransitionTo$default$7() {
        return this.topicPartitions();
    }

    public long prepareTransitionTo$default$8() {
        return this.txnStartTimestamp();
    }

    public long prepareTransitionTo$default$9() {
        return this.txnLastUpdateTimestamp();
    }

    public TransactionVersion prepareTransitionTo$default$10() {
        return this.clientTransactionVersion();
    }

    /*
     * Unable to fully structure code
     */
    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        v0 = toState = (TransactionState)this.pendingState().getOrElse((Function0<Nothing$> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$1(kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()Lscala/runtime/Nothing$;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
                        var6_3 = transitMetadata.txnState();
                        if (v0 == null ? var6_3 != null : v0.equals(var6_3) == false) {
                            this.throwStateTransitionFailure(transitMetadata);
                            return;
                        }
                        var7_4 = toState;
                        if (!Empty$.MODULE$.equals(var7_4)) break block12;
                        if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                            this.throwStateTransitionFailure(transitMetadata);
                        }
                        break block13;
                    }
                    if (!Ongoing$.MODULE$.equals(var7_4)) break block14;
                    if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                        this.throwStateTransitionFailure(transitMetadata);
                    }
                    break block13;
                }
                if (!(PrepareAbort$.MODULE$.equals(var7_4) != false ? true : PrepareCommit$.MODULE$.equals(var7_4) != false)) break block15;
                v1 = toState;
                var9_5 = PrepareAbort$.MODULE$;
                if ((v1 != null ? v1.equals(var9_5) == false : var9_5 != null) || !transitMetadata.clientTransactionVersion().supportsEpochBump()) ** GOTO lbl-1000
                v2 = this.state();
                var10_6 = Empty$.MODULE$;
                if (!(v2 == null ? var10_6 != null : v2.equals(var10_6) == false)) ** GOTO lbl-1000
                v3 = this.state();
                var11_7 = CompleteCommit$.MODULE$;
                if (!(v3 == null ? var11_7 != null : v3.equals(var11_7) == false)) ** GOTO lbl-1000
                v4 = this.state();
                var12_8 = CompleteAbort$.MODULE$;
                if (!(v4 != null ? v4.equals(var12_8) == false : var12_8 != null)) lbl-1000:
                // 3 sources

                {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                allowedEmptyAbort = v5;
                v6 = validTimestamp = this.txnStartTimestamp() == transitMetadata.txnStartTimestamp() || allowedEmptyAbort != false;
                if (!(this.validProducerEpoch(transitMetadata) && this.topicPartitions().equals(transitMetadata.topicPartitions()) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && validTimestamp)) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
                break block13;
            }
            if (CompleteAbort$.MODULE$.equals(var7_4) != false ? true : CompleteCommit$.MODULE$.equals(var7_4) != false) {
                if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else if (PrepareEpochFence$.MODULE$.equals(var7_4)) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                if (Dead$.MODULE$.equals(var7_4)) {
                    throw new IllegalStateException("TransactionalId " + this.transactionalId() + " is trying to complete a transition to " + toState + ". This means that the transactionalId was being expired, and the only acceptable completion of this operation is to remove the transaction metadata from the cache, not to persist the " + toState + " in the log.");
                }
                throw new MatchError(var7_4);
            }
        }
        this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$3(kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
        this.producerId_$eq(transitMetadata.producerId());
        this.prevProducerId_$eq(transitMetadata.prevProducerId());
        this.nextProducerId_$eq(transitMetadata.nextProducerId());
        this.producerEpoch_$eq(transitMetadata.producerEpoch());
        this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
        this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
        this.topicPartitions_$eq(transitMetadata.topicPartitions());
        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.clientTransactionVersion_$eq(transitMetadata.clientTransactionVersion());
        this.pendingState_$eq(None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        boolean isAtLeastTransactionsV2 = transitMetadata.clientTransactionVersion().supportsEpochBump();
        TransactionState txnState = transitMetadata.txnState();
        short transitProducerEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        short transitLastProducerEpoch = transitMetadata.lastProducerEpoch();
        Tuple3<Boolean, TransactionState, Short> tuple3 = new Tuple3<Boolean, TransactionState, Short>(BoxesRunTime.boxToBoolean(isAtLeastTransactionsV2), txnState, BoxesRunTime.boxToShort(transitProducerEpoch));
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple3._1());
            TransactionState transactionState = tuple3._2();
            short epoch = BoxesRunTime.unboxToShort(tuple3._3());
            if (bl && (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)) && epoch == (short)0) {
                return transitLastProducerEpoch == this.lastProducerEpoch() && transitMetadata.prevProducerId() == this.producerId();
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple3._1());
            TransactionState transactionState = tuple3._2();
            if (bl && (PrepareCommit$.MODULE$.equals(transactionState) ? true : PrepareAbort$.MODULE$.equals(transactionState))) {
                return transitLastProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
            }
        }
        return transitProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String> & Serializable)() -> this.toString() + "'s transition to " + txnTransitMetadata + " failed: this should not happen");
        throw new IllegalStateException("TransactionalId " + this.transactionalId() + " failed transition to state " + txnTransitMetadata + " due to unexpected metadata");
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    private boolean includesOffsets() {
        return this.topicPartitions().exists((Function1<TopicPartition, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(TransactionMetadata.$anonfun$includesOffsets$1(x$4)));
    }

    public String toString(TransactionLoggingVerbosity verbosity) {
        StringBuilder res = new StringBuilder("TransactionMetadata(");
        res.append("transactionalId=").append(this.transactionalId());
        res.append(", producerId=").append(this.producerId());
        res.append(", prevProducerId=").append(this.prevProducerId());
        res.append(", nextProducerId=").append(this.nextProducerId());
        res.append(", producerEpoch=").append(this.producerEpoch());
        res.append(", lastProducerEpoch=").append(this.lastProducerEpoch());
        res.append(", txnTimeoutMs=").append(this.txnTimeoutMs());
        res.append(", state=").append(this.state());
        res.append(", pendingState=").append(this.pendingState());
        res.append(", txnStartTimestamp=").append(this.txnStartTimestamp());
        res.append(", txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp());
        res.append(", clientTransactionVersion=").append(this.clientTransactionVersion());
        TransactionLoggingVerbosity transactionLoggingVerbosity = verbosity;
        if (TransactionLoggingVerbosity$All$.MODULE$.equals(transactionLoggingVerbosity)) {
            res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
        } else if (TransactionLoggingVerbosity$Sample$.MODULE$.equals(transactionLoggingVerbosity)) {
            if (this.topicPartitions().size() > 20) {
                scala.collection.mutable.Set partitionsSample = (scala.collection.mutable.Set)this.topicPartitions().take(20);
                res.append(", samplePartitions=").append(TransactionMetadata.partitionsToString$1(partitionsSample));
                res.append(", includesOffsets=").append(this.includesOffsets());
            } else {
                res.append(", partitions=").append(TransactionMetadata.partitionsToString$1(this.topicPartitions()));
            }
        } else if (TransactionLoggingVerbosity$Off$.MODULE$.equals(transactionLoggingVerbosity)) {
            res.append(", numPartitions=").append(this.topicPartitions().size());
            res.append(", includesOffsets=").append(this.includesOffsets());
        } else {
            throw new MatchError(transactionLoggingVerbosity);
        }
        return res.append(")").toString();
    }

    public String toString() {
        return this.toString(TransactionLoggingVerbosity$Sample$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)object;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        TransactionVersion transactionVersion = this.clientTransactionVersion();
        TransactionVersion transactionVersion2 = transactionMetadata.clientTransactionVersion();
        if (transactionVersion == null) {
            if (transactionVersion2 == null) return true;
            return false;
        } else {
            if (!transactionVersion.equals(transactionVersion2)) return false;
            return true;
        }
    }

    public int hashCode() {
        Seq fields = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.transactionalId(), BoxesRunTime.boxToLong(this.producerId()), BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToInteger(this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong(this.txnStartTimestamp()), BoxesRunTime.boxToLong(this.txnLastUpdateTimestamp()), this.clientTransactionVersion()}));
        return BoxesRunTime.unboxToInt(((IterableOnceOps)fields.map((Function1<Object, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(x$5.hashCode()))).foldLeft(BoxesRunTime.boxToInteger(0), (a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ Nothing$ $anonfun$completeTransitionTo$1(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        $this.fatal((Function0<String> & Serializable)() -> $this + "'s transition to " + transitMetadata$2 + " failed since pendingState is not defined: this should not happen");
        throw new IllegalStateException("TransactionalId " + $this.transactionalId() + " completing transaction state transition while it does not have a pending state");
    }

    public static final /* synthetic */ String $anonfun$completeTransitionTo$3(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        return "TransactionalId " + $this.transactionalId() + " complete transition from " + $this.state() + " to " + transitMetadata$2;
    }

    public static final /* synthetic */ boolean $anonfun$includesOffsets$1(TopicPartition x$4) {
        String string = x$4.topic();
        String string2 = "__consumer_offsets";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final String partitionsToString$1(Iterable topicPartitions) {
        return topicPartitions.mkString("[", ",", "]");
    }

    public TransactionMetadata(String transactionalId, long producerId, long prevProducerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.prevProducerId = prevProducerId;
        this.nextProducerId = nextProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.clientTransactionVersion = clientTransactionVersion;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

