/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.durability.db.serdes.AuditRunInfo;
import java.io.Serializable;
import java.util.UUID;
import kafka.durability.db.AuditRunState$;
import scala.Function1;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\u000b\u0017\u0001uA\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005M!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u0003-\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011y\u0002!Q1A\u0005\u0002-B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"AQ\n\u0001B\u0001B\u0003%!\tC\u0003O\u0001\u0011\u0005q\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0003f\u0001\u0011\u0005c\rC\u0003p\u0001\u0011\u0005\u0003oB\u0003r-!\u0005!OB\u0003\u0016-!\u00051\u000fC\u0003O!\u0011\u0005A\u000fC\u0003v!\u0011\u0005a\u000f\u0003\u0004v!\u0011\u0005\u0011Q\u0002\u0005\u0007kB!\t!!\u0007\u0003\u001b\u0005+H-\u001b;Sk:\u001cF/\u0019;f\u0015\t9\u0002$\u0001\u0002eE*\u0011\u0011DG\u0001\u000bIV\u0014\u0018MY5mSRL(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002/I,\u0017\r\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$X#\u0001\u0014\u0011\u0005}9\u0013B\u0001\u0015!\u0005\u0011auN\\4\u00021I,\u0017\r\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$\b%\u0001\u000bbk\u0012LG\u000fV5nK:\u001b\b+\u001a:SK\u000e|'\u000fZ\u000b\u0002YA\u0011q$L\u0005\u0003]\u0001\u00121!\u00138u\u0003U\tW\u000fZ5u)&lWMT:QKJ\u0014VmY8sI\u0002\nq!Y;eSRLE-F\u00013!\t\u0019$H\u0004\u00025qA\u0011Q\u0007I\u0007\u0002m)\u0011q\u0007H\u0001\u0007yI|w\u000e\u001e \n\u0005e\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0002<y\t11\u000b\u001e:j]\u001eT!!\u000f\u0011\u0002\u0011\u0005,H-\u001b;JI\u0002\naBZ1jY\u0016$\u0017\t\u001e;f[B$8/A\bgC&dW\rZ!ui\u0016l\u0007\u000f^:!\u0003I1\u0018\r\\5eCR,Gm\u00142kK\u000e$\u0018\nZ:\u0016\u0003\t\u00032aM\"F\u0013\t!EHA\u0002TKR\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauI\u0001\u0003V+&#\u0015a\u0005<bY&$\u0017\r^3e\u001f\nTWm\u0019;JIN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004Q%N#VK\u0016\t\u0003#\u0002i\u0011A\u0006\u0005\u0006I-\u0001\rA\n\u0005\u0006U-\u0001\r\u0001\f\u0005\u0006a-\u0001\rA\r\u0005\u0006}-\u0001\r\u0001\f\u0005\u0006\u0001.\u0001\rAQ\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\"\u0001L-\t\u000bic\u0001\u0019A.\u0002\u000f\t,\u0018\u000e\u001c3feB\u0011AlY\u0007\u0002;*\u0011alX\u0001\fM2\fGOY;gM\u0016\u00148O\u0003\u0002aC\u00061qm\\8hY\u0016T\u0011AY\u0001\u0004G>l\u0017B\u00013^\u0005E1E.\u0019;Ck\u001a4WM\u001d\"vS2$WM]\u0001\u0007KF,\u0018\r\\:\u0015\u0005\u001dT\u0007CA\u0010i\u0013\tI\u0007EA\u0004C_>dW-\u00198\t\u000b-l\u0001\u0019\u00017\u0002\u0007=\u0014'\u000e\u0005\u0002 [&\u0011a\u000e\t\u0002\u0004\u0003:L\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003I\nQ\"Q;eSR\u0014VO\\*uCR,\u0007CA)\u0011'\t\u0001b\u0004F\u0001s\u0003\u0015\t\u0007\u000f\u001d7z)\t\u0001v\u000fC\u0003y%\u0001\u0007\u00110\u0001\u0003j]\u001a|\u0007c\u0001>\u0002\n5\t1P\u0003\u0002}{\u000611/\u001a:eKNT!a\u0006@\u000b\u0005ey(bA\u000e\u0002\u0002)!\u00111AA\u0003\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002\b\u0005\u0011\u0011n\\\u0005\u0004\u0003\u0017Y(\u0001D!vI&$(+\u001e8J]\u001a|Gc\u0003)\u0002\u0010\u0005E\u00111CA\u000b\u0003/AQ\u0001J\nA\u0002\u0019BQAK\nA\u00021BQ\u0001M\nA\u0002IBQAP\nA\u00021BQ\u0001Q\nA\u0002\t#\u0012\u0001\u0015")
public class AuditRunState {
    private final long readTierPartitionOffset;
    private final int auditTimeNsPerRecord;
    private final String auditId;
    private final int failedAttempts;
    private final Set<UUID> validatedObjectIds;

    public static AuditRunState apply() {
        return AuditRunState$.MODULE$.apply();
    }

    public static AuditRunState apply(long readTierPartitionOffset, int auditTimeNsPerRecord, String auditId, int failedAttempts, Set<UUID> validatedObjectIds) {
        return AuditRunState$.MODULE$.apply(readTierPartitionOffset, auditTimeNsPerRecord, auditId, failedAttempts, validatedObjectIds);
    }

    public static AuditRunState apply(AuditRunInfo info) {
        return AuditRunState$.MODULE$.apply(info);
    }

    public long readTierPartitionOffset() {
        return this.readTierPartitionOffset;
    }

    public int auditTimeNsPerRecord() {
        return this.auditTimeNsPerRecord;
    }

    public String auditId() {
        return this.auditId;
    }

    public int failedAttempts() {
        return this.failedAttempts;
    }

    public Set<UUID> validatedObjectIds() {
        return this.validatedObjectIds;
    }

    public synchronized int serialize(FlatBufferBuilder builder) {
        int auditIdOffset = builder.createString(this.auditId());
        AuditRunInfo.startValidatedObjectIdsVector(builder, this.validatedObjectIds().size());
        this.validatedObjectIds().foreach((Function1<UUID, Object> & Serializable)objectId -> BoxesRunTime.boxToInteger(AuditRunState.$anonfun$serialize$1(builder, objectId)));
        int validatedObjectIdsOffset = builder.endVector();
        return AuditRunInfo.createAuditRunInfo(builder, this.readTierPartitionOffset(), this.auditTimeNsPerRecord(), auditIdOffset, this.failedAttempts(), validatedObjectIdsOffset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof AuditRunState)) return false;
        AuditRunState auditRunState = (AuditRunState)object;
        if (this.readTierPartitionOffset() != auditRunState.readTierPartitionOffset()) return false;
        if (this.auditTimeNsPerRecord() != auditRunState.auditTimeNsPerRecord()) return false;
        String string = this.auditId();
        String string2 = auditRunState.auditId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.failedAttempts() != auditRunState.failedAttempts()) return false;
        Set<UUID> set = this.validatedObjectIds();
        Set<UUID> set2 = auditRunState.validatedObjectIds();
        if (set == null) {
            if (set2 == null) return true;
            return false;
        } else {
            if (!set.equals(set2)) return false;
            return true;
        }
    }

    public String toString() {
        return "{readTierPartitionOffset:" + this.readTierPartitionOffset() + ",auditTimeNsPerRecord: " + this.auditTimeNsPerRecord() + ", auditId: " + this.auditId() + ", failedAttempts: " + this.failedAttempts() + ", validatedObjectIds: " + this.validatedObjectIds() + "}";
    }

    public static final /* synthetic */ int $anonfun$serialize$1(FlatBufferBuilder builder$1, UUID objectId) {
        return io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder$1, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
    }

    public AuditRunState(long readTierPartitionOffset, int auditTimeNsPerRecord, String auditId, int failedAttempts, Set<UUID> validatedObjectIds) {
        this.readTierPartitionOffset = readTierPartitionOffset;
        this.auditTimeNsPerRecord = auditTimeNsPerRecord;
        this.auditId = auditId;
        this.failedAttempts = failedAttempts;
        this.validatedObjectIds = validatedObjectIds;
    }
}

