/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FileChannelWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.DbTrait;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.TopicState;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftQuorumState;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.exceptions.DurabilityObjectNotFoundException;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$mcIJ$sp;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\u000e\u001c\u0001\tB\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0007y\u0001!\t\u0001A\u001f\t\u0011\u0001\u0003!\u0019!C\u00017\u0005CaA\u0011\u0001!\u0002\u0013!\u0004\u0002C\"\u0001\u0005\u0004%\taG!\t\r\u0011\u0003\u0001\u0015!\u00035\u0011\u001d)\u0005A1A\u0005\n\u0019CaA\u0013\u0001!\u0002\u00139\u0005\u0002C&\u0001\u0001\u0004%\tf\u0007'\t\u0011A\u0003\u0001\u0019!C)7ECaa\u0016\u0001!B\u0013i\u0005\"\u0002-\u0001\t\u0003J\u0006\"B3\u0001\t\u00032\u0007\u0002CA\t\u0001\t\u0007I\u0011I!\t\u000f\u0005M\u0001\u0001)A\u0005i!1\u0011Q\u0003\u0001\u0005B\u0019Da!a\t\u0001\t\u00131\u0007\u0002CA\u0013\u0001\u0011\u0005S$a\n\t\u0011\u0005]\u0003\u0001\"\u0011\u001c\u00033Bq!!\u0018\u0001\t\u0003\nyfB\u0004\u0002xmA\t!!\u001f\u0007\riY\u0002\u0012AA>\u0011\u0019ad\u0003\"\u0001\u0002~!)\u0001L\u0006C!3\"9\u0011q\u0010\f\u0005\u0002\u0005\u0005%\u0001\u0004#ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013%B\u0001\u000f\u001e\u0003\t!'M\u0003\u0002\u001f?\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001G%j\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+W5\t1$\u0003\u0002-7\t9AI\u0019+sC&$\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019 \u0003\u0015)H/\u001b7t\u0013\t\u0011tFA\u0004M_\u001e<\u0017N\\4\u0002\tA\fG\u000f\u001b\t\u0003kij\u0011A\u000e\u0006\u0003oa\n!![8\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0005\r&dW-\u0001\u0004=S:LGO\u0010\u000b\u0003}}\u0002\"A\u000b\u0001\t\u000bM\u0012\u0001\u0019\u0001\u001b\u0002\r\u0011\u0014g)\u001b7f+\u0005!\u0014a\u00023c\r&dW\rI\u0001\bi6\u0004h)\u001b7f\u0003!!X\u000e\u001d$jY\u0016\u0004\u0013a\u0002<feNLwN\\\u000b\u0002\u000fB\u0011A\u0005S\u0005\u0003\u0013\u0016\u00121!\u00138u\u0003!1XM]:j_:\u0004\u0013A\u00025fC\u0012,'/F\u0001N!\tQc*\u0003\u0002P7\tAAI\u0019%fC\u0012,'/\u0001\u0006iK\u0006$WM]0%KF$\"AU+\u0011\u0005\u0011\u001a\u0016B\u0001+&\u0005\u0011)f.\u001b;\t\u000fYS\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002\u000f!,\u0017\rZ3sA\u0005QAn\\4hKJt\u0015-\\3\u0016\u0003i\u0003\"a\u00172\u000f\u0005q\u0003\u0007CA/&\u001b\u0005q&BA0\"\u0003\u0019a$o\\8u}%\u0011\u0011-J\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bK\u0005Q1\r[3dWB|\u0017N\u001c;\u0015\u0003IC3!\u00045o!\r!\u0013n[\u0005\u0003U\u0016\u0012a\u0001\u001e5s_^\u001c\bCA\u001bm\u0013\tigGA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017'\u0002\u0010[_\u0006=\u0011GB\u0012qg\u0006\u0015A/\u0006\u0002Zc\u0012)!/\tb\u0001o\n\tA+\u0003\u0002uk\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!A^\u0013\u0002\rQD'o\\<t#\tA8\u0010\u0005\u0002%s&\u0011!0\n\u0002\b\u001d>$\b.\u001b8h!\taxP\u0004\u0002%{&\u0011a0J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t!a\u0001\u0003\u0013QC'o\\<bE2,'B\u0001@&c!\u0019\u0013qAA\u0005\u0003\u00171hb\u0001\u0013\u0002\n%\u0011a/J\u0019\u0006E\u0011*\u0013Q\u0002\u0002\u0006g\u000e\fG.Y\u0019\u0003M-\f1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\u000fI,7m\u001c<fe\"\"\u0001\u0003[A\rc\u0019q\",a\u0007\u0002\"E21\u0005]:\u0002\u001eQ\f\u0004bIA\u0004\u0003\u0013\tyB^\u0019\u0006E\u0011*\u0013QB\u0019\u0003M-\fa!\u001b8ji\u0012\u0013\u0015AG4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N4uN]!vI&$XCAA\u0015!\u0019\tY#!\r\u000269\u0019\u0011QF?\u000f\u0007u\u000by#C\u0001'\u0013\u0011\t\u0019$a\u0001\u0003\u0007M+\u0017\u000fE\u0004%\u0003o\tY$!\u0015\n\u0007\u0005eRE\u0001\u0004UkBdWM\r\t\u0005\u0003{\ti%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0019\u0019w.\\7p]*\u0019\u0001%!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0013aA8sO&!\u0011qJA \u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042\u0001JA*\u0013\r\t)&\n\u0002\u0005\u0019>tw-\u0001\thKR\fE\u000e\u001c)beRLG/[8ogV\u0011\u00111\f\t\u0007\u0003W\t\t$a\u000f\u0002!\u0019,Go\u00195U_BL7m\u0015;bi\u0016\u001cHCAA1!\u001d\t\u0019'!\u001c[\u0003cj!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\b[V$\u0018M\u00197f\u0015\r\tY'J\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA8\u0003K\u0012q\u0001S1tQ6\u000b\u0007\u000fE\u0002+\u0003gJ1!!\u001e\u001c\u0005)!v\u000e]5d'R\fG/Z\u0001\r\tV\u0014\u0018MY5mSRLHI\u0011\t\u0003UY\u00192AF\u0012.)\t\tI(A\u0003baBd\u0017\u0010F\u0002?\u0003\u0007CQaM\rA\u0002QBC!\u00075\u0002\bF2aDWAE\u0003\u001f\u000bda\t9t\u0003\u0017#\u0018\u0007C\u0012\u0002\b\u0005%\u0011Q\u0012<2\u000b\t\"S%!\u00042\u0005\u0019Z\u0007&B\r\u0002\u0014\u0006m\u0005\u0003\u0002\u0013j\u0003+\u00032!NAL\u0013\r\tIJ\u000e\u0002\u0016\r&dWMT8u\r>,h\u000eZ#yG\u0016\u0004H/[8oc\u0019q\",!(\u0002$F21\u0005]:\u0002 R\f\u0004bIA\u0004\u0003\u0013\t\tK^\u0019\u0006E\u0011*\u0013QB\u0019\u0004M\u0005U\u0005&B\r\u0002(\u0006U\u0006\u0003\u0002\u0013j\u0003S\u0003B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_C\u0014\u0001\u00027b]\u001eLA!a-\u0002.\n\u0011\u0012\n\u001c7fO\u0006d\u0017iY2fgN,%O]8sc\u0019q\",a.\u0002>F21\u0005]:\u0002:R\f\u0004bIA\u0004\u0003\u0013\tYL^\u0019\u0006E\u0011*\u0013QB\u0019\u0004M\u0005%\u0006")
public class DurabilityDB
implements DbTrait,
Logging {
    private final File dbFile;
    private final File tmpFile;
    private final int version;
    private DbHeader header;
    private final File dir;
    private Logger logger;
    private String logIdent;
    private int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH;
    private int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT;
    private int DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION;
    private volatile Enumeration.Value status;
    private HashMap<String, TopicState> topicStates;
    private KRaftQuorumState kraftQuorumState;
    private long dbSize;
    private volatile boolean bitmap$0;

    public static DurabilityDB apply(File path) throws IOException, FileNotFoundException, IllegalAccessError {
        return DurabilityDB$.MODULE$.apply(path);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public long getDbSize() {
        return DbTrait.getDbSize$(this);
    }

    @Override
    public Option<PartitionState> fetchPartitionState(TopicPartition id) throws DurabilityDBNotReadyException {
        return DbTrait.fetchPartitionState$(this, id);
    }

    @Override
    public Option<Object> fetchNextAuditOffset(TopicPartition id) throws DurabilityDBNotReadyException {
        return DbTrait.fetchNextAuditOffset$(this, id);
    }

    @Override
    public void deletePartition(TopicPartition id) {
        DbTrait.deletePartition$(this, id);
    }

    @Override
    public Option<PartitionState> addPartition(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        return DbTrait.addPartition$(this, id, state);
    }

    @Override
    public Option<PartitionState> addAuditInfo(TopicPartition id, PartitionState state) throws DurabilityDBNotReadyException, DurabilityObjectNotFoundException {
        return DbTrait.addAuditInfo$(this, id, state);
    }

    @Override
    public Option<PartitionState> addDataLossInfo(TopicPartition id, PartitionState state) {
        return DbTrait.addDataLossInfo$(this, id, state);
    }

    @Override
    public Option<KRaftPartitionState> addKRaftPartitionState(KRaftPartitionState state) {
        return DbTrait.addKRaftPartitionState$(this, state);
    }

    @Override
    public Option<KRaftPartitionState> fetchKRaftPartitionState(TopicIdPartition topicIdPartition) {
        return DbTrait.fetchKRaftPartitionState$(this, topicIdPartition);
    }

    @Override
    public Option<Object> addKRaftEpochLeader(int epoch, int leaderId) {
        return DbTrait.addKRaftEpochLeader$(this, epoch, leaderId);
    }

    @Override
    public void truncateKRaftEpochLeaders(int minEpoch) {
        DbTrait.truncateKRaftEpochLeaders$(this, minEpoch);
    }

    @Override
    public Option<Object> fetchKRaftEpochLeader(int epoch) {
        return DbTrait.fetchKRaftEpochLeader$(this, epoch);
    }

    @Override
    public Option<Object> setKRaftLocalEpoch(int epoch) {
        return DbTrait.setKRaftLocalEpoch$(this, epoch);
    }

    @Override
    public Option<Object> getKRaftLocalEpoch() {
        return DbTrait.getKRaftLocalEpoch$(this);
    }

    @Override
    public Option<Object> setKRaftLocalNodeId(int nodeId) {
        return DbTrait.setKRaftLocalNodeId$(this, nodeId);
    }

    @Override
    public Option<Object> getKRaftLocalNodeId() {
        return DbTrait.getKRaftLocalNodeId$(this);
    }

    @Override
    public void clearKRaftQuorumState() {
        DbTrait.clearKRaftQuorumState$(this);
    }

    @Override
    public ByteBuffer serialize() {
        return DbTrait.serialize$(this);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        DbTrait.deserialize$(this, buffer);
    }

    @Override
    public boolean isOnline() {
        return DbTrait.isOnline$(this);
    }

    @Override
    public void updateDurabilityTopicPartitionOffset(int partition, long offset) throws DurabilityDBNotReadyException, IndexOutOfBoundsException {
        DbTrait.updateDurabilityTopicPartitionOffset$(this, partition, offset);
    }

    @Override
    public Seq<Object> getDurabilityTopicPartitionOffsets() {
        return DbTrait.getDurabilityTopicPartitionOffsets$(this);
    }

    @Override
    public void close() throws IOException {
        DbTrait.close$(this);
    }

    private Logger logger$lzycompute() {
        DurabilityDB durabilityDB = this;
        synchronized (durabilityDB) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH() {
        return this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH;
    }

    @Override
    public int DURABILITY_EVENTS_TOPIC_PARTITION_COUNT() {
        return this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT;
    }

    @Override
    public int DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION() {
        return this.DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION;
    }

    @Override
    public Enumeration.Value status() {
        return this.status;
    }

    @Override
    public void status_$eq(Enumeration.Value x$1) {
        this.status = x$1;
    }

    @Override
    public HashMap<String, TopicState> topicStates() {
        return this.topicStates;
    }

    @Override
    public KRaftQuorumState kraftQuorumState() {
        return this.kraftQuorumState;
    }

    @Override
    public void kraftQuorumState_$eq(KRaftQuorumState x$1) {
        this.kraftQuorumState = x$1;
    }

    @Override
    public long dbSize() {
        return this.dbSize;
    }

    @Override
    public void dbSize_$eq(long x$1) {
        this.dbSize = x$1;
    }

    @Override
    public final void kafka$durability$db$DbTrait$_setter_$kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH_$eq(int x$1) {
        this.kafka$durability$db$DbTrait$$DB_BUFFER_INIT_LENGTH = x$1;
    }

    @Override
    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_EVENTS_TOPIC_PARTITION_COUNT_$eq(int x$1) {
        this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT = x$1;
    }

    @Override
    public void kafka$durability$db$DbTrait$_setter_$DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION_$eq(int x$1) {
        this.DURABILITY_LOSS_EVENT_PER_TOPIC_PARTITION = x$1;
    }

    @Override
    public void kafka$durability$db$DbTrait$_setter_$topicStates_$eq(HashMap<String, TopicState> x$1) {
        this.topicStates = x$1;
    }

    public File dbFile() {
        return this.dbFile;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    private int version() {
        return this.version;
    }

    @Override
    public DbHeader header() {
        return this.header;
    }

    @Override
    public void header_$eq(DbHeader x$1) {
        this.header = x$1;
    }

    @Override
    public String loggerName() {
        return DurabilityDB.class.getName();
    }

    @Override
    public synchronized void checkpoint() throws IOException {
        FileChannel channel = FileChannelWrapper.open((Path)this.tmpFile().toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        ByteBuffer buffer = this.serialize();
        Utils.writeFully((FileChannel)channel, (long)0L, (ByteBuffer)buffer);
        FileChannelWrapper.force((FileChannel)channel, (boolean)true);
        Utils.atomicMoveWithFallback((Path)this.tmpFile().toPath(), (Path)this.dbFile().toPath());
        this.dbSize_$eq(channel.size());
        this.info((Function0<String> & Serializable)() -> "Checkpoint durability db files with " + this.getAllPartitions().length() + " partitions");
        FileChannelWrapper.close((FileChannel)channel);
    }

    @Override
    public File dir() {
        return this.dir;
    }

    @Override
    public synchronized void recover() throws IOException {
        block8: {
            FileChannel channel;
            block7: {
                channel = null;
                try {
                    try {
                        channel = FileChannelWrapper.open((Path)this.dbFile().toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
                        this.dbSize_$eq(channel.size());
                        ByteBuffer buffer = ByteBuffer.allocate((int)this.dbSize()).order(ByteOrder.LITTLE_ENDIAN);
                        Utils.readFully((FileChannel)channel, (ByteBuffer)buffer, (long)0L);
                        buffer.flip();
                        this.deserialize(buffer);
                        this.status_$eq(DbStatus$.MODULE$.Online());
                        this.info((Function0<String> & Serializable)() -> "Recovered Durability DB with " + this.getAllPartitions().length() + " partitions");
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof NoSuchFileException) {
                            this.info((Function0<String> & Serializable)() -> "No Durability db found at path " + this.dbFile().toPath());
                            this.initDB();
                            break block7;
                        }
                        if (throwable2 instanceof Exception) {
                            Exception exception = (Exception)throwable2;
                            throw exception;
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        FileChannelWrapper.close(channel);
                    }
                    throw throwable;
                }
            }
            if (channel == null) break block8;
            FileChannelWrapper.close((FileChannel)channel);
        }
    }

    private void initDB() {
        this.info((Function0<String> & Serializable)() -> " Initializing new durability db at " + this.dbFile().toPath());
        this.header_$eq(new DbHeader(this.version(), 1, (long[])Array$.MODULE$.fill(this.DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), () -> 0L, ClassTag$.MODULE$.Long())));
        this.status_$eq(DbStatus$.MODULE$.Online());
        this.checkpoint();
    }

    @Override
    public synchronized Seq<Tuple2<TopicPartition, Object>> getTopicPartitionsForAudit() {
        if (this.isOnline()) {
            return (Seq)this.topicStates().toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String topicName = (String)tuple2._1();
                    TopicState state = (TopicState)tuple2._2();
                    Seq readyPartitions = (Seq)((IterableOps)state.partitions().toSeq().filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(DurabilityDB.$anonfun$getTopicPartitionsForAudit$2(x0$2)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            int partition = tuple2._1$mcI$sp();
                            PartitionState state = (PartitionState)tuple2._2();
                            return new Tuple2$mcIJ$sp(partition, state.config());
                        }
                        throw new MatchError(tuple2);
                    });
                    return (IterableOnce)readyPartitions.map((Function1<Tuple2, Tuple2> & Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            int partitionNum = tuple2._1$mcI$sp();
                            long stateConfig = tuple2._2$mcJ$sp();
                            return new Tuple2<TopicPartition, Long>(new TopicPartition(topicName, partitionNum), BoxesRunTime.boxToLong(stateConfig));
                        }
                        throw new MatchError(tuple2);
                    });
                }
                throw new MatchError(tuple2);
            });
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public synchronized Seq<TopicPartition> getAllPartitions() {
        if (this.isOnline()) {
            return (Seq)this.topicStates().toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String topicName = (String)tuple2._1();
                    TopicState state = (TopicState)tuple2._2();
                    Seq readyPartitions = (Seq)state.partitions().toSeq().map((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToInteger(DurabilityDB.$anonfun$getAllPartitions$2(x0$2)));
                    return (IterableOnce)readyPartitions.map((Function1<Object, TopicPartition> & Serializable)partitionNum -> DurabilityDB.$anonfun$getAllPartitions$3(topicName, BoxesRunTime.unboxToInt(partitionNum)));
                }
                throw new MatchError(tuple2);
            });
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public HashMap<String, TopicState> fetchTopicStates() {
        return this.topicStates();
    }

    public static final /* synthetic */ boolean $anonfun$getTopicPartitionsForAudit$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            PartitionState state = (PartitionState)tuple2._2();
            return state.latestLocalEpoch() > -1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ int $anonfun$getAllPartitions$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int partition = tuple2._1$mcI$sp();
            return partition;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$3(String topicName$2, int partitionNum) {
        return new TopicPartition(topicName$2, partitionNum);
    }

    public DurabilityDB(File path) {
        DbTrait.$init$(this);
        Logging.$init$(this);
        this.dbFile = new File(path, "durability.db");
        this.tmpFile = new File(path, "durability.db.tmp");
        this.version = 2;
        this.header = null;
        this.dir = path;
        Statics.releaseFence();
    }
}

