/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.topic;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.durability.Utils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager$;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.server.InternalAdmin;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\u0015*\u0001AB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\u007f!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003G\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011Y\u0003!Q1A\u0005\u0002]C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"Aa\u000f\u0001B\u0001B\u0003%q\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0016\u0001\u0001\u0006I!!\n\t\u0017\u00055\u0002\u0001#b\u0001\n\u0003Y\u0013q\u0006\u0005\f\u0003o\u0001\u0001R1A\u0005\u0002-\nI\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0001\u0002D!I\u0011Q\t\u0001A\u0002\u0013\u0005\u0011q\t\u0005\b\u0003'\u0002\u0001\u0015)\u0003x\u0011%\ti\u0006\u0001a\u0001\n\u0003\t\u0019\u0005C\u0005\u0002`\u0001\u0001\r\u0011\"\u0001\u0002b!9\u0011Q\r\u0001!B\u00139\b\"CA5\u0001\u0001\u0007I\u0011BA6\u0011%\t\u0019\t\u0001a\u0001\n\u0013\t)\t\u0003\u0005\u0002\n\u0002\u0001\u000b\u0015BA7\u0011%\tY\t\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAH\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!-\u0001\t\u0003\t\u0019\fC\u0004\u00026\u0002!I!a-\t\u000f\u0005]\u0006\u0001\"\u0001\u00020\"A\u0011\u0011\u0018\u0001\u0005\u0002-\ny\u000bC\u0004\u0002<\u0002!I!a,\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001dw!CAgS\u0005\u0005\t\u0012AAh\r!A\u0013&!A\t\u0002\u0005E\u0007B\u0002>&\t\u0003\t\u0019\u000eC\u0005\u0002V\u0016\n\n\u0011\"\u0001\u0002X\n1B)\u001e:bE&d\u0017\u000e^=U_BL7-T1oC\u001e,'O\u0003\u0002+W\u0005)Ao\u001c9jG*\u0011A&L\u0001\u000bIV\u0014\u0018MY5mSRL(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA4(D\u0001:\u0015\tQT&A\u0003vi&d7/\u0003\u0002=s\t9Aj\\4hS:<\u0017AB2p]\u001aLw-F\u0001@!\t\u0001\u0015)D\u0001*\u0013\t\u0011\u0015FA\u000bEkJ\f'-\u001b7jif$v\u000e]5d\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005AA-\u0019;bE\u0006\u001cX-F\u0001G!\t9%*D\u0001I\u0015\tI5&\u0001\u0002eE&\u00111\n\u0013\u0002\r\tV\u0014\u0018MY5mSRLHIQ\u0001\nI\u0006$\u0018MY1tK\u0002\n1\"\\1uKJL\u0017\r\\5{KV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002SW\u0005yQ.\u0019;fe&\fG.\u001b>bi&|g.\u0003\u0002U#\n\u0019\u0013IY:ue\u0006\u001cG\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,\u0017\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0004\u0013!F5oi\u0016\u0014h.\u00197BI6LgnU;qa2LWM]\u000b\u00021B\u0019\u0011\f\u00192\u000e\u0003iS!a\u0017/\u0002\u0011\u0019,hn\u0019;j_:T!!\u00180\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0006!!.\u0019<b\u0013\t\t'L\u0001\u0005TkB\u0004H.[3s!\t\u0019g-D\u0001e\u0015\t)W&\u0001\u0004tKJ4XM]\u0005\u0003O\u0012\u0014Q\"\u00138uKJt\u0017\r\\!e[&t\u0017AF5oi\u0016\u0014h.\u00197BI6LgnU;qa2LWM\u001d\u0011\u0002\tQLW.\u001a\t\u0003WRl\u0011\u0001\u001c\u0006\u0003u5T!A\\8\u0002\r\r|W.\\8o\u0015\tq\u0003O\u0003\u0002re\u00061\u0011\r]1dQ\u0016T\u0011a]\u0001\u0004_J<\u0017BA;m\u0005\u0011!\u0016.\\3\u0002+\r\u0014X-\u0019;f\tV\u0014\u0018MY5mSRLHk\u001c9jGB\u0011!\u0007_\u0005\u0003sN\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u000byvtx0!\u0001\u0002\u0004\u0005\u0015\u0001C\u0001!\u0001\u0011\u0015i4\u00021\u0001@\u0011\u0015!5\u00021\u0001G\u0011\u0015i5\u00021\u0001P\u0011\u001516\u00021\u0001Y\u0011\u001dI7\u0002%AA\u0002)DQA^\u0006A\u0002]\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005ma\u0002BA\b\u0003/\u00012!!\u00054\u001b\t\t\u0019BC\u0002\u0002\u0016=\na\u0001\u0010:p_Rt\u0014bAA\rg\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u00074\u0003y!UKU!C\u00132KE+W0D%\u0016\u000bE+S(O?\n\u000b5iS(G\r~k5+\u0006\u0002\u0002&A\u0019!'a\n\n\u0007\u0005%2G\u0001\u0003M_:<\u0017a\b#V%\u0006\u0013\u0015\nT%U3~\u001b%+R!U\u0013>suLQ!D\u0017>3eiX'TA\u0005\u00012m\u001c8tk6,'\u000f\u0015:pm&$WM]\u000b\u0003\u0003c\u00012\u0001QA\u001a\u0013\r\t)$\u000b\u0002\u0018\tV\u0014\u0018MY5mSRLHk\u001c9jG\u000e{gn];nKJ\f\u0001\u0003\u001d:pIV\u001cWM\u001d)s_ZLG-\u001a:\u0016\u0005\u0005m\u0002c\u0001!\u0002>%\u0019\u0011qH\u0015\u0003/\u0011+(/\u00192jY&$\u0018\u0010V8qS\u000e\u0004&o\u001c3vG\u0016\u0014\u0018!\u0002:fC\u0012LX#A<\u0002\u0013I,\u0017\rZ=`I\u0015\fH\u0003BA%\u0003\u001f\u00022AMA&\u0013\r\tie\r\u0002\u0005+:LG\u000f\u0003\u0005\u0002RI\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0007e\u0016\fG-\u001f\u0011)\u0007M\t9\u0006E\u00023\u00033J1!a\u00174\u0005!1x\u000e\\1uS2,\u0017AC5t'\",H\u000fZ8x]\u0006q\u0011n]*ikR$wn\u001e8`I\u0015\fH\u0003BA%\u0003GB\u0001\"!\u0015\u0016\u0003\u0003\u0005\ra^\u0001\fSN\u001c\u0006.\u001e;e_^t\u0007\u0005K\u0002\u0017\u0003/\n\u0001\"\u00193nS:|\u0005\u000f^\u000b\u0003\u0003[\u0002RAMA8\u0003gJ1!!\u001d4\u0005\u0019y\u0005\u000f^5p]B!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!B1e[&t'bAA?_\u000691\r\\5f]R\u001c\u0018\u0002BAA\u0003o\u0012abQ8oM2,XM\u001c;BI6Lg.\u0001\u0007bI6Lgn\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002J\u0005\u001d\u0005\"CA)1\u0005\u0005\t\u0019AA7\u0003%\tG-\\5o\u001fB$\b%\u0001\u0007rk\u0016,X\rZ#wK:$8/\u0006\u0002\u0002\u0010B1\u0011\u0011SAN\u0003?k!!a%\u000b\t\u0005U\u0015qS\u0001\b[V$\u0018M\u00197f\u0015\r\tIjM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAO\u0003'\u0013Q!U;fk\u0016\u0004B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003K[\u0013AB3wK:$8/\u0003\u0003\u0002*\u0006\r&aF!cgR\u0014\u0018m\u0019;EkJ\f'-\u001b7jif,e/\u001a8u\u00035\tX/Z;fI\u00163XM\u001c;tA\u0005)1\u000f^1siR\u0011\u0011\u0011J\u0001\bSN\u0014V-\u00193z)\u00059\u0018A\u0004;ss\n+7m\\7f%\u0016\fG-_\u0001\tg\",H\u000fZ8x]\u0006i1\u000f^1si\u000e{gn];nKJ\fqa\u00197fC:,\b/A\u0006f]N,(/\u001a+pa&\u001cG\u0003BA%\u0003\u0003Da!a1#\u0001\u0004\u0011\u0017!D5oi\u0016\u0014h.\u00197BI6Lg.\u0001\nbI\u0012$UO]1cS2LG/_#wK:$H\u0003BA%\u0003\u0013Dq!a3$\u0001\u0004\ty*A\u0003fm\u0016tG/\u0001\fEkJ\f'-\u001b7jif$v\u000e]5d\u001b\u0006t\u0017mZ3s!\t\u0001Ue\u0005\u0002&cQ\u0011\u0011qZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005e'f\u00016\u0002\\.\u0012\u0011Q\u001c\t\u0005\u0003?\fI/\u0004\u0002\u0002b*!\u00111]As\u0003%)hn\u00195fG.,GMC\u0002\u0002hN\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY/!9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DurabilityTopicManager
implements Logging {
    private DurabilityTopicConsumer consumerProvider;
    private DurabilityTopicProducer producerProvider;
    private final DurabilityTopicConfig config;
    private final DurabilityDB database;
    private final AbstractDurabilityEventsMaterialize materialize;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final Time time;
    private final boolean createDurabilityTopic;
    private final long DURABILITY_CREATION_BACKOFF_MS;
    private volatile boolean ready;
    private volatile boolean isShutdown;
    private Option<ConfluentAdmin> adminOpt;
    private final Queue<AbstractDurabilityEvent> queuedEvents;
    private Logger logger;
    private String logIdent;
    private volatile byte bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return DurabilityTopicManager$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DurabilityTopicManager durabilityTopicManager = this;
        synchronized (durabilityTopicManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityTopicConfig config() {
        return this.config;
    }

    public DurabilityDB database() {
        return this.database;
    }

    public AbstractDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    @Override
    public String loggerName() {
        return DurabilityTopicManager.class.getName();
    }

    private long DURABILITY_CREATION_BACKOFF_MS() {
        return this.DURABILITY_CREATION_BACKOFF_MS;
    }

    private DurabilityTopicConsumer consumerProvider$lzycompute() {
        DurabilityTopicManager durabilityTopicManager = this;
        synchronized (durabilityTopicManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.consumerProvider = new DurabilityTopicConsumer(this.config(), this.database(), this.materialize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.consumerProvider;
    }

    public DurabilityTopicConsumer consumerProvider() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.consumerProvider$lzycompute();
        }
        return this.consumerProvider;
    }

    private DurabilityTopicProducer producerProvider$lzycompute() {
        DurabilityTopicManager durabilityTopicManager = this;
        synchronized (durabilityTopicManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.producerProvider = new DurabilityTopicProducer(this.config());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.producerProvider;
    }

    public DurabilityTopicProducer producerProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.producerProvider$lzycompute();
        }
        return this.producerProvider;
    }

    public boolean ready() {
        return this.ready;
    }

    public void ready_$eq(boolean x$1) {
        this.ready = x$1;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void isShutdown_$eq(boolean x$1) {
        this.isShutdown = x$1;
    }

    private Option<ConfluentAdmin> adminOpt() {
        return this.adminOpt;
    }

    private void adminOpt_$eq(Option<ConfluentAdmin> x$1) {
        this.adminOpt = x$1;
    }

    public Queue<AbstractDurabilityEvent> queuedEvents() {
        return this.queuedEvents;
    }

    public void start() {
        try {
            while (!this.ready() && !this.isShutdown()) {
                if (this.tryBecomeReady()) continue;
                this.warn((Function0<String> & Serializable)() -> "Failed to become ready.");
                this.time.sleep(this.DURABILITY_CREATION_BACKOFF_MS());
            }
        }
        catch (Exception e) {
            if (this.isShutdown()) {
                this.debug((Function0<String> & Serializable)() -> "Ignoring exception caught during shutdown", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            } else {
                this.error((Function0<String> & Serializable)() -> "Caught exception while starting DurabilityTopicManager", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            }
        }
    }

    public boolean isReady() {
        return this.ready() && this.consumerProvider().isReady();
    }

    private boolean tryBecomeReady() {
        if (this.config().interBrokerClientConfigs().get().isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Could not resolve bootstrap server. Will retry.");
            return false;
        }
        if (this.createDurabilityTopic) {
            try {
                this.ensureTopic(this.internalAdminSupplier().get());
            }
            catch (Exception e) {
                this.info((Function0<String> & Serializable)() -> "Caught exception when ensuring durability topic is created. Will retry.", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                return false;
            }
            v0 = BoxedUnit.UNIT;
        } else {
            Properties adminProps = new Properties();
            try {
                Object endpoint = this.config().interBrokerClientConfigs().get().get("bootstrap.servers");
                adminProps.put("bootstrap.servers", endpoint);
                this.adminOpt_$eq(new Some<ConfluentAdmin>(ConfluentAdmin.create((Properties)adminProps)));
                v0 = ((Admin)this.adminOpt().get()).describeTopics(Collections.singletonList(this.config().topicName())).allTopicNames().get();
            }
            catch (Exception e) {
                this.info((Function0<String> & Serializable)() -> "Caught exception when checking if durability topic was created by some other node. Will retry.", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                return false;
            }
        }
        Option<ConfluentAdmin> option = this.adminOpt();
        if (option instanceof Some) {
            Some some = (Some)option;
            ConfluentAdmin admin = (ConfluentAdmin)some.value();
            admin.close();
            this.adminOpt_$eq(None$.MODULE$);
        }
        this.startConsumer();
        this.info((Function0<String> & Serializable)() -> "Started consumer for DurabilityTopicManager");
        return true;
    }

    public void shutdown() {
        this.isShutdown_$eq(true);
        this.cleanup();
    }

    public void startConsumer() {
        this.consumerProvider().startConsumer(this.consumerProvider().startConsumer$default$1());
        DurabilityTopicManager durabilityTopicManager = this;
        synchronized (durabilityTopicManager) {
            this.ready_$eq(true);
            this.queuedEvents().foreach((Function1<AbstractDurabilityEvent, Object> & Serializable)event -> {
                this.addDurabilityEvent(event);
                return BoxedUnit.UNIT;
            });
        }
    }

    private synchronized void cleanup() {
        try {
            this.ready_$eq(false);
            if (this.producerProvider() != null) {
                try {
                    this.producerProvider().get().close(Duration.ofSeconds(2L));
                }
                catch (InterruptException interruptException) {
                    this.info((Function0<String> & Serializable)() -> "Received interrupt while being blocked on producer, will close", (Function0<Throwable>)(Function0<InterruptException> & Serializable)() -> interruptException);
                }
                catch (Exception e) {
                    this.error((Function0<String> & Serializable)() -> "Received unknown error while closing producer", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                }
            }
        }
        finally {
            this.consumerProvider().shutdown();
        }
    }

    private void ensureTopic(InternalAdmin internalAdmin) {
        internalAdmin.ensureTopic(this.config().topicName(), this.config().configuredNumPartitions(), this.config().configuredReplicationFactor(), this.config().toTopicProperties());
    }

    public void addDurabilityEvent(AbstractDurabilityEvent event) {
        DurabilityTopicManager durabilityTopicManager = this;
        synchronized (durabilityTopicManager) {
            if (this.isShutdown()) {
                this.debug((Function0<String> & Serializable)() -> "Durability Topic Manager service shutting down, ignoring append request " + event);
                v0 = BoxedUnit.UNIT;
            } else {
                this.debug((Function0<String> & Serializable)() -> "DurabilityEvent: Sending " + event + " to durability topic");
                v0 = this.liftedTree1$1(event);
            }
        }
    }

    private final /* synthetic */ Object liftedTree1$1(AbstractDurabilityEvent event$1) {
        Object object;
        block3: {
            try {
                if (!this.ready()) {
                    object = this.queuedEvents().$colon$plus(event$1);
                    break block3;
                }
                object = this.producerProvider().get().send(new ProducerRecord(this.config().topicName(), Predef$.MODULE$.int2Integer(Utils$.MODULE$.toPartition(event$1.topicIdPartition().topicPartition(), this.config().configuredNumPartitions())), (Object)event$1.serializeKey(), (Object)event$1.serializeValue()));
            }
            catch (Exception ex) {
                this.warn((Function0<String> & Serializable)() -> "Exception in addDurabilityEvent " + ex.getCause() + " " + ex.getMessage(), (Function0<Throwable>)(Function0<Exception> & Serializable)() -> ex);
                object = BoxedUnit.UNIT;
            }
        }
        return object;
    }

    public DurabilityTopicManager(DurabilityTopicConfig config, DurabilityDB database, AbstractDurabilityEventsMaterialize materialize, Supplier<InternalAdmin> internalAdminSupplier, Time time, boolean createDurabilityTopic) {
        this.config = config;
        this.database = database;
        this.materialize = materialize;
        this.internalAdminSupplier = internalAdminSupplier;
        this.time = time;
        this.createDurabilityTopic = createDurabilityTopic;
        Logging.$init$(this);
        this.DURABILITY_CREATION_BACKOFF_MS = 5000L;
        this.ready = false;
        this.isShutdown = false;
        this.adminOpt = None$.MODULE$;
        this.queuedEvents = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

