/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.log.AbstractLog;
import kafka.log.LogSegmentReadAdapter;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.storage.internals.log.LogSegment;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t4AAC\u0006\u0001!!AA\u0002\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015A\u0004\u0001\"\u0011:\u0011\u0015i\u0004\u0001\"\u0011:\u0011\u0015q\u0004\u0001\"\u0011@\u0011\u0015\u0019\u0005\u0001\"\u0011@\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015)\u0006\u0001\"\u0011W\u0005iaunY1m\u0019><7+Z4nK:$(+Z1e\u0003\u0012\f\u0007\u000f^3s\u0015\taQ\"A\u0002m_\u001eT\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011cF\u000e\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0012$D\u0001\f\u0013\tQ2BA\u000bM_\u001e\u001cVmZ7f]R\u0014V-\u00193BI\u0006\u0004H/\u001a:\u0011\u0005qyR\"A\u000f\u000b\u0005yi\u0011!B;uS2\u001c\u0018B\u0001\u0011\u001e\u0005\u001daunZ4j]\u001e\u0004\"\u0001\u0007\u0012\n\u0005\rZ!aC!cgR\u0014\u0018m\u0019;M_\u001e\fqa]3h[\u0016tG\u000f\u0005\u0002'c5\tqE\u0003\u0002\rQ)\u0011\u0011FK\u0001\nS:$XM\u001d8bYNT!a\u000b\u0017\u0002\u000fM$xN]1hK*\u0011a\"\f\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023O\tQAj\\4TK\u001elWM\u001c;\u0002\rqJg.\u001b;?)\r)dg\u000e\t\u00031\u0001AQ\u0001D\u0002A\u0002\u0005BQ\u0001J\u0002A\u0002\u0015\n!BY1tK>3gm]3u+\u0005Q\u0004C\u0001\n<\u0013\ta4C\u0001\u0003M_:<\u0017!C3oI>3gm]3u\u00035\u0019H/\u0019:u!>\u001c\u0018\u000e^5p]V\t\u0001\t\u0005\u0002\u0013\u0003&\u0011!i\u0005\u0002\u0004\u0013:$\u0018aC3oIB{7/\u001b;j_:\f\u0011B]3bI\nKH/Z:\u0015\u0007\u0019K5\u000b\u0005\u0002\u0013\u000f&\u0011\u0001j\u0005\u0002\u0005+:LG\u000fC\u0003K\u0011\u0001\u00071*\u0001\u0004ck\u001a4WM\u001d\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b1A\\5p\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003U\u0011\u0001\u0007\u0001)\u0001\u0005q_NLG/[8o\u0003!!xn\u0015;sS:<G#A,\u0011\u0005a{fBA-^!\tQ6#D\u0001\\\u0015\tav\"\u0001\u0004=e>|GOP\u0005\u0003=N\ta\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011al\u0005")
public class LocalLogSegmentReadAdapter
implements LogSegmentReadAdapter,
Logging {
    private final AbstractLog log;
    private final LogSegment segment;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LocalLogSegmentReadAdapter localLogSegmentReadAdapter = this;
        synchronized (localLogSegmentReadAdapter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public long baseOffset() {
        return this.segment.baseOffset();
    }

    @Override
    public long endOffset() {
        return this.segment.readNextOffset() - 1L;
    }

    @Override
    public int startPosition() {
        return 0;
    }

    @Override
    public int endPosition() {
        return (int)this.segment.log().channel().size();
    }

    @Override
    public void readBytes(ByteBuffer buffer, int position) {
        if (position < this.startPosition() || position > this.endPosition()) {
            throw new IllegalArgumentException("Invalid position: " + position + ". Valid position range is [" + this.startPosition() + ", " + this.endPosition() + "]");
        }
        try {
            this.segment.log().readInto(buffer, position);
        }
        catch (Exception e) {
            throw new KafkaException("Failed to read from segment " + this.segment + " of partition " + this.log + ".topicPartition ", (Throwable)e);
        }
    }

    public String toString() {
        return "LocalLogSegmentReadAdapter(log segment: " + this.segment.log().file() + ", startPosition: " + this.startPosition() + ", endPosition: " + this.endPosition() + ", baseOffset: " + this.baseOffset() + ", endOffset:" + this.endOffset() + ")";
    }

    public LocalLogSegmentReadAdapter(AbstractLog log, LogSegment segment) {
        this.log = log;
        this.segment = segment;
        Logging.$init$(this);
    }
}

