/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Some;

public final class StrayLogMetadataFile$
implements Logging {
    public static final StrayLogMetadataFile$ MODULE$ = new StrayLogMetadataFile$();
    private static final String StrayLogMetadataFilename;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        StrayLogMetadataFilename = "partition.stray";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        StrayLogMetadataFile$ strayLogMetadataFile$ = this;
        synchronized (strayLogMetadataFile$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    private String StrayLogMetadataFilename() {
        return StrayLogMetadataFilename;
    }

    private File newFile(File dir) {
        return new File(dir, this.StrayLogMetadataFilename());
    }

    public Option<TopicPartition> read(File dir, LogDirFailureChannel logDirFailureChannel) {
        Some<TopicPartition> some;
        File metadataFile = this.newFile(dir);
        Path filePath = metadataFile.toPath().toAbsolutePath();
        if (!metadataFile.exists() || metadataFile.length() == 0L) {
            this.error((Function0<String> & Serializable)() -> "Missing or empty stray log metadata file: " + metadataFile.getAbsolutePath());
            return Option$.MODULE$.empty();
        }
        try (BufferedReader reader = Files.newBufferedReader(filePath);){
            some = new Some<TopicPartition>(LocalLog.parseTopicPartitionName(reader.readLine()));
        }
        catch (IOException ioe) {
            String msg = "Error while reading stray log metadata file " + metadataFile.getAbsolutePath() + " due to error " + ioe.getMessage();
            logDirFailureChannel.maybeAddOfflineLogDir(metadataFile.getParentFile().getParent(), msg, ioe);
            throw new KafkaStorageException(msg, (Throwable)ioe);
        }
        catch (Exception e) {
            String msg = "Error while reading stray log metadata file " + metadataFile.getAbsolutePath() + " due to error " + e.getMessage();
            throw new KafkaException(msg, (Throwable)e);
        }
        return some;
    }

    public void createFileWithData(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        File metadataFile = this.newFile(dir);
        Path path = metadataFile.toPath().toAbsolutePath();
        Path tempPath = Paths.get(((Object)path).toString() + ".tmp", new String[0]);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tempPath.toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                writer.write(LocalLog.logDirName(topicPartition));
                writer.flush();
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)tempPath, (Path)path);
        }
        catch (IOException e) {
            String msg = "Error while writing to stray log metadata file " + metadataFile.getAbsolutePath();
            logDirFailureChannel.maybeAddOfflineLogDir(metadataFile.getParentFile().getParent(), msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public long lastModifiedTime(File dir) {
        File metadataFile = this.newFile(dir);
        if (!metadataFile.exists() || metadataFile.length() == 0L) {
            throw new KafkaException("Missing or empty stray log metadata file: " + metadataFile.getAbsolutePath());
        }
        return metadataFile.lastModified();
    }

    private StrayLogMetadataFile$() {
    }
}

