/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001B\u001a5\u0001eB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A!\f\u0001B\u0001B\u0003%1\fC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0004p\u0001\t\u0007I\u0011\u00019\t\rU\u0004\u0001\u0015!\u0003r\u0011\u001d1\bA1A\u0005\n]Daa\u001f\u0001!\u0002\u0013A\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003\u007f\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\b\u0011%\t)\u0003\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\b\u0011%\tI\u0003\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\b\u0011%\ti\u0003\u0001b\u0001\n\u0013\ty\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0019\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA\u001f\u0011!\ti\u0006\u0001a\u0001\n\u00139\b\"CA0\u0001\u0001\u0007I\u0011BA1\u0011\u001d\ti\u0007\u0001Q!\naD1\"a\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002r!Y\u0011q\u0010\u0001A\u0002\u0003\u0007I\u0011BAA\u0011-\t)\t\u0001a\u0001\u0002\u0003\u0006K!a\u001d\t\u0017\u0005\u001d\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0012\u0005\f\u0003/\u0003\u0001\u0019!a\u0001\n\u0013\tI\nC\u0006\u0002\u001e\u0002\u0001\r\u0011!Q!\n\u0005-\u0005bCAP\u0001\u0001\u0007\t\u0019!C\u0005\u0003CC1\"a0\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B\"Y\u0011Q\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BAR\u0011-\t9\r\u0001a\u0001\u0002\u0004%I!!3\t\u0017\u0005E\u0007\u00011AA\u0002\u0013%\u00111\u001b\u0005\f\u0003/\u0004\u0001\u0019!A!B\u0013\tY\rC\u0005\u0002Z\u0002\u0011\r\u0011\"\u0003\u0002\\\"A\u00111\u001e\u0001!\u0002\u0013\ti\u000eC\u0004\u0002n\u0002!\t%a<\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"9\u00111 \u0001\u0005\u0002\u0005M\bbBA\u007f\u0001\u0011\u0005\u00111\u001f\u0005\u0007\u0003\u007f\u0004A\u0011A<\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002p\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\u000b\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqA!\u0016\u0001\t\u0003\ty\u000fC\u0004\u0003X\u0001!I!a<\t\u000f\te\u0003\u0001\"\u0003\u0002p\nQR*[4sCRLwN\u001c+jKJ$v\u000e]5d!J|G-^2fe*\u0011QGN\u0001\n[&<'/\u0019;j_:T\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!H\u0011\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019y%M[3diB\u00111hQ\u0005\u0003\tr\u0012\u0001BU;o]\u0006\u0014G.Z\u0001\u0007G>tg-[4\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%3\u0014AB:feZ,'/\u0003\u0002L\u0011\nY1*\u00194lC\u000e{gNZ5h\u0003%\u0019G.^:uKJLE\r\u0005\u0002O/:\u0011q*\u0016\t\u0003!Nk\u0011!\u0015\u0006\u0003%b\na\u0001\u0010:p_Rt$\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV*\u0002\tQLW.\u001a\t\u00039\u001al\u0011!\u0018\u0006\u0003=~\u000bQ!\u001e;jYNT!\u0001Y1\u0002\r\r|W.\\8o\u0015\t9$M\u0003\u0002dI\u00061\u0011\r]1dQ\u0016T\u0011!Z\u0001\u0004_J<\u0017BA4^\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u0011QG.\u001c8\u0011\u0005-\u0004Q\"\u0001\u001b\t\u000b\u0015#\u0001\u0019\u0001$\t\u000b1#\u0001\u0019A'\t\u000bi#\u0001\u0019A.\u0002'5\u000b\u0005l\u0018)P\u00192{F+S'F\u001fV#v,T*\u0016\u0003E\u0004\"A]:\u000e\u0003MK!\u0001^*\u0003\t1{gnZ\u0001\u0015\u001b\u0006Cv\fU(M\u0019~#\u0016*T#P+R{Vj\u0015\u0011\u0002\u00135\u000b\u0005l\u0018*F)JKV#\u0001=\u0011\u0005IL\u0018B\u0001>T\u0005\rIe\u000e^\u0001\u000b\u001b\u0006CvLU#U%f\u0003\u0013a\u00017pOV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA-A\u0003tY\u001a$$.\u0003\u0003\u0002\b\u0005\u0005!A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013aC5oSRL\u0017\r\\5{K\u0012,\"!a\u0004\u0011\t\u0005E\u0011qD\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00051\u0011\r^8nS\u000eTA!!\u0007\u0002\u001c\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005ua(\u0001\u0003vi&d\u0017\u0002BA\u0011\u0003'\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013aB:uCJ$X\rZ\u0001\tgR\f'\u000f^3eA\u000511\r\\8tK\u0012\fqa\u00197pg\u0016$\u0007%\u0001\bqe>$WoY3s)\"\u0014X-\u00193\u0016\u0005\u0005E\u0002c\u0001/\u00024%\u0019\u0011QG/\u0003\u0017-\u000bgm[1UQJ,\u0017\rZ\u0001\u0010aJ|G-^2feRC'/Z1eA\u0005q\u0011/^3vK\u0012lU\r^1eCR\fWCAA\u001f!\u0019\ty$!\u0011\u0002F5\u0011\u0011qC\u0005\u0005\u0003\u0007\n9BA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0004s\u0003\u000f\nY\u0005_\u0005\u0004\u0003\u0013\u001a&A\u0002+va2,'\u0007\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\r\u0011|W.Y5o\u0015\r\t)FN\u0001\u0005i&,'/\u0003\u0003\u0002Z\u0005=#\u0001F!cgR\u0014\u0018m\u0019;US\u0016\u0014X*\u001a;bI\u0006$\u0018-A\brk\u0016,X\rZ'fi\u0006$\u0017\r^1!\u0003M1\u0017-\u001b7fI6+G/\u00193bi\u0006\u001cu.\u001e8u\u0003]1\u0017-\u001b7fI6+G/\u00193bi\u0006\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005%\u0004c\u0001:\u0002f%\u0019\u0011qM*\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003W2\u0012\u0011!a\u0001q\u0006\u0019\u0001\u0010J\u0019\u0002)\u0019\f\u0017\u000e\\3e\u001b\u0016$\u0018\rZ1uC\u000e{WO\u001c;!\u0003Y!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<WCAA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$\u0002BA=\u0003'\nQ\u0001^8qS\u000eLA!! \u0002x\t1B+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw-\u0001\u000euS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005\r\u0005\"CA63\u0005\u0005\t\u0019AA:\u0003]!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0007%A\ruS\u0016\u0014Hk\u001c9jGB\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAAF!\u0011\ti)a%\u000e\u0005\u0005=%\u0002BAI\u0003'\naa\u00197jK:$\u0018\u0002BAK\u0003\u001f\u0013\u0011\u0004V5feR{\u0007/[2Qe>$WoY3s'V\u0004\b\u000f\\5fe\u0006iB/[3s)>\u0004\u0018n\u0019)s_\u0012,8-\u001a:TkB\u0004H.[3s?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005m\u0005\"CA69\u0005\u0005\t\u0019AAF\u0003i!\u0018.\u001a:U_BL7\r\u0015:pIV\u001cWM]*vaBd\u0017.\u001a:!\u0003E!\u0018.\u001a:U_BL7\r\u0015:pIV\u001cWM]\u000b\u0003\u0003G\u0003\u0002\"!*\u00020\u0006M\u00161W\u0007\u0003\u0003OSA!!+\u0002,\u0006A\u0001O]8ek\u000e,'OC\u0002\u0002.\u0006\fqa\u00197jK:$8/\u0003\u0003\u00022\u0006\u001d&\u0001\u0003)s_\u0012,8-\u001a:\u0011\u000bI\f),!/\n\u0007\u0005]6KA\u0003BeJ\f\u0017\u0010E\u0002s\u0003wK1!!0T\u0005\u0011\u0011\u0015\u0010^3\u0002+QLWM\u001d+pa&\u001c\u0007K]8ek\u000e,'o\u0018\u0013fcR!\u00111MAb\u0011%\tYgHA\u0001\u0002\u0004\t\u0019+\u0001\nuS\u0016\u0014Hk\u001c9jGB\u0013x\u000eZ;dKJ\u0004\u0013!\u0003;jKJ$v\u000e]5d+\t\tY\r\u0005\u0003\u0002v\u00055\u0017\u0002BAh\u0003o\u0012\u0011\u0002V5feR{\u0007/[2\u0002\u001bQLWM\u001d+pa&\u001cw\fJ3r)\u0011\t\u0019'!6\t\u0013\u0005-$%!AA\u0002\u0005-\u0017A\u0003;jKJ$v\u000e]5dA\u0005aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011\u0011Q\u001c\t\u0005\u0003?\f9/\u0004\u0002\u0002b*!\u00111]As\u0003\u001diW\r\u001e:jGNT!!S1\n\t\u0005%\u0018\u0011\u001d\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!D7fiJL7m]$s_V\u0004\b%A\u0002sk:$\"!a\u0019\u0002\u001b%\u001c\u0018J\\5uS\u0006d\u0017N_3e+\t\t)\u0010E\u0002s\u0003oL1!!?T\u0005\u001d\u0011un\u001c7fC:\f\u0011\"[:Ti\u0006\u0014H/\u001a3\u0002\u0015%\u001c8\u000b[;uI><h.A\nrk\u0016,X\rZ'fi\u0006$\u0017\r^1D_VtG/A\u0003ti\u0006\u0014H/\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!a\u0019\u0003\b!9!\u0011\u0002\u0017A\u0002\t-\u0011!B5nC\u001e,\u0007\u0003\u0002B\u0007\u0005#i!Aa\u0004\u000b\u0007\t%\u0011-\u0003\u0003\u0003\u0014\t=!!D'fi\u0006$\u0017\r^1J[\u0006<W-\u0001\u0004e_^{'o[\u0001\ne\u0016$(/_*f]\u0012$\u0002\"a\u0019\u0003\u001c\t}!1\u0005\u0005\b\u0005;q\u0003\u0019AA&\u0003!iW\r^1eCR\f\u0007B\u0002B\u0011]\u0001\u0007\u00010A\u0003sKR\u0014\u0018\u0010C\u0004\u0003&9\u0002\rAa\n\u0002\u0003\u0015\u0004BA!\u000b\u000349!!1\u0006B\u0018\u001d\r\u0001&QF\u0005\u0002)&\u0019!\u0011G*\u0002\u000fA\f7m[1hK&!!Q\u0007B\u001c\u0005%)\u0005pY3qi&|gNC\u0002\u00032M\u000bA$];fk\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKR,\u0017J\\5uS\u0006$X\r\u0006\u0006\u0002d\tu\"\u0011\tB'\u0005#BaAa\u00100\u0001\u0004i\u0015\u0001\u00053fY\u0016$X\r\u001a+pa&\u001cg*Y7f\u0011\u001d\u0011\u0019e\fa\u0001\u0005\u000b\na\u0002Z3mKR,G\rV8qS\u000eLE\r\u0005\u0003\u0003H\t%S\"A0\n\u0007\t-sL\u0001\u0003Vk&$\u0007B\u0002B(_\u0001\u0007\u00010A\u0005qCJ$\u0018\u000e^5p]\"1!1K\u0018A\u0002a\f\u0011C_6D_:$(o\u001c7mKJ,\u0005o\\2i\u0003!\u0019\b.\u001e;e_^t\u0017aB2mK\u0006tW\u000f]\u0001\u000ee\u0016lwN^3NKR\u0014\u0018nY:")
public class MigrationTierTopicProducer
implements Runnable {
    private final KafkaConfig config;
    private final String clusterId;
    private final Time time;
    private final long MAX_POLL_TIMEOUT_MS;
    private final int MAX_RETRY;
    private final Logger log;
    private final AtomicBoolean initialized;
    private final AtomicBoolean started;
    private final AtomicBoolean closed;
    private final KafkaThread producerThread;
    private final LinkedBlockingQueue<Tuple2<AbstractTierMetadata, Object>> queuedMetadata;
    private int failedMetadataCount;
    private TierTopicManagerConfig tierTopicManagerConfig;
    private TierTopicProducerSupplier tierTopicProducerSupplier;
    private Producer<byte[], byte[]> tierTopicProducer;
    private TierTopic tierTopic;
    private final KafkaMetricsGroup metricsGroup;

    public long MAX_POLL_TIMEOUT_MS() {
        return this.MAX_POLL_TIMEOUT_MS;
    }

    private int MAX_RETRY() {
        return this.MAX_RETRY;
    }

    private Logger log() {
        return this.log;
    }

    private AtomicBoolean initialized() {
        return this.initialized;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    private KafkaThread producerThread() {
        return this.producerThread;
    }

    private LinkedBlockingQueue<Tuple2<AbstractTierMetadata, Object>> queuedMetadata() {
        return this.queuedMetadata;
    }

    private int failedMetadataCount() {
        return this.failedMetadataCount;
    }

    private void failedMetadataCount_$eq(int x$1) {
        this.failedMetadataCount = x$1;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private void tierTopicManagerConfig_$eq(TierTopicManagerConfig x$1) {
        this.tierTopicManagerConfig = x$1;
    }

    private TierTopicProducerSupplier tierTopicProducerSupplier() {
        return this.tierTopicProducerSupplier;
    }

    private void tierTopicProducerSupplier_$eq(TierTopicProducerSupplier x$1) {
        this.tierTopicProducerSupplier = x$1;
    }

    private Producer<byte[], byte[]> tierTopicProducer() {
        return this.tierTopicProducer;
    }

    private void tierTopicProducer_$eq(Producer<byte[], byte[]> x$1) {
        this.tierTopicProducer = x$1;
    }

    private TierTopic tierTopic() {
        return this.tierTopic;
    }

    private void tierTopic_$eq(TierTopic x$1) {
        this.tierTopic = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public void run() {
        try {
            while (!this.closed().get()) {
                this.doWork();
            }
        }
        catch (Exception e) {
            if (this.closed().get()) {
                this.log().debug("Exception caught during shutdown", (Throwable)e);
            } else {
                this.log().error("Fatal exception in MigrationTierTopicProducer", (Throwable)e);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized().get();
    }

    public boolean isStarted() {
        return this.started().get();
    }

    public boolean isShutdown() {
        return this.closed().get();
    }

    public int queuedMetadataCount() {
        return this.queuedMetadata().size();
    }

    public void start() {
        if (this.initialized().get() && !this.closed().get()) {
            this.started().set(true);
            this.producerThread().start();
            return;
        }
    }

    public void initialize(MetadataImage image) {
        if (!this.initialized().get() && !this.closed().get()) {
            try {
                this.tierTopicManagerConfig_$eq(new TierTopicManagerConfig(this.config, this.tieredStorageInterBrokerClientConfigsSupplier$1(image), this.clusterId));
                this.tierTopicProducerSupplier_$eq(new TierTopicProducerSupplier(this.tierTopicManagerConfig(), this.time));
                this.tierTopic_$eq(new TierTopic(this.tierTopicManagerConfig().tierNamespace));
                this.tierTopic().initialize(this.tierTopicManagerConfig().configuredNumPartitions);
                this.tierTopicProducer_$eq(this.tierTopicProducerSupplier().get());
                this.initialized().set(true);
                this.log().info("Successfully initialized tier topic producer for ZK migration.");
            }
            catch (Exception e) {
                this.log().error("Error to initialize tier topic producer for ZK migration.", (Throwable)e);
            }
            return;
        }
    }

    public void doWork() {
        if (this.initialized().get()) {
            Tuple2<AbstractTierMetadata, Object> metadataNode = null;
            metadataNode = this.queuedMetadata().poll(this.MAX_POLL_TIMEOUT_MS(), TimeUnit.MILLISECONDS);
            if (metadataNode != null) {
                Tuple2<AbstractTierMetadata, Object> tuple2 = metadataNode;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                AbstractTierMetadata metadata = tuple2._1();
                int retryCount = tuple2._2$mcI$sp();
                Tuple2<AbstractTierMetadata, Integer> tuple22 = new Tuple2<AbstractTierMetadata, Integer>(metadata, BoxesRunTime.boxToInteger(retryCount));
                AbstractTierMetadata metadata2 = tuple22._1();
                int retryCount2 = tuple22._2$mcI$sp();
                if (new Tuple2<AbstractTierMetadata, Integer>(metadata2, BoxesRunTime.boxToInteger(retryCount2)) != null) {
                    TopicPartition tierTopicPartition = this.tierTopic().toTierTopicPartition(metadata2.topicIdPartition());
                    ProducerRecord producerRecord = new ProducerRecord(tierTopicPartition.topic(), Predef$.MODULE$.int2Integer(tierTopicPartition.partition()), (Object)metadata2.serializeKey(), (Object)metadata2.serializeValue());
                    try {
                        this.tierTopicProducer().send(producerRecord, (x$9, exception) -> {
                            if (exception != null) {
                                if (exception instanceof RetriableException) {
                                    this.retrySend(metadata2, retryCount2, exception);
                                    return;
                                }
                                this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
                                this.log().error("Caught exception when sending " + metadata2 + " to tier topic partition.", (Throwable)exception);
                                return;
                            }
                        });
                    }
                    catch (RetriableException e) {
                        this.retrySend(metadata2, retryCount2, (Exception)((Object)e));
                    }
                    catch (Throwable t) {
                        this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
                        this.log().error("Caught exception when sending " + metadata2 + " to tier topic partition.", t);
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    private void retrySend(AbstractTierMetadata metadata, int retry, Exception e) {
        int newRetryCount = retry + 1;
        if (newRetryCount < this.MAX_RETRY()) {
            this.queuedMetadata().add(new Tuple2<AbstractTierMetadata, Integer>(metadata, BoxesRunTime.boxToInteger(newRetryCount)));
            this.log().warn("Caught retriable exception when sending " + metadata + " to tier topic partition. Will try again, retry count: " + newRetryCount, (Throwable)e);
            return;
        }
        this.failedMetadataCount_$eq(this.failedMetadataCount() + 1);
        this.log().error("Caught retriable exception when sending " + metadata + " to tier topic partition. No more retry left.", (Throwable)e);
    }

    public void queuePartitionDeleteInitiate(String deletedTopicName, Uuid deletedTopicId, int partition, int zkControllerEpoch) {
        TopicIdPartition deletedPartition = new TopicIdPartition(deletedTopicName, CoreUtils$.MODULE$.toJavaUUID(deletedTopicId), partition);
        TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(deletedPartition, zkControllerEpoch, UUID.randomUUID());
        this.queuedMetadata().add(new Tuple2<TierPartitionDeleteInitiate, Integer>(deleteInitiate, BoxesRunTime.boxToInteger(0)));
    }

    public void shutdown() {
        this.closed().set(true);
        this.removeMetrics();
        try {
            try {
                if (this.started().get()) {
                    this.producerThread().join();
                }
            }
            catch (InterruptedException e) {
                this.log().error("Shutdown interrupted", (Throwable)e);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            this.initialized().set(false);
            if (this.tierTopicProducer() != null) {
                this.tierTopicProducer().close(Duration.ofSeconds(1L));
            }
        }
        catch (Exception e) {
            this.log().error("Caught exception when closing tierTopicProducer.", (Throwable)e);
        }
    }

    private void removeMetrics() {
        this.metricsGroup().removeMetric("FailedMetadataCount");
        this.metricsGroup().removeMetric("QueuedMetadataCount");
    }

    private final Supplier tieredStorageInterBrokerClientConfigsSupplier$1(MetadataImage image$1) {
        return () -> {
            if ($this.config.confluentConfig().tierMetadataBootstrapServers() != null) {
                return Collections.singletonMap("bootstrap.servers", $this.config.confluentConfig().tierMetadataBootstrapServers());
            }
            ListenerName listenerName = $this.config.interBrokerListenerName();
            SecurityProtocol securityProtocol = $this.config.interBrokerSecurityProtocol();
            List brokerNodes = image$1.cluster().brokers().values().stream().map(x$5 -> x$5.node(listenerName.value())).filter(x$6 -> x$6.isPresent()).limit(3L).map(x$7 -> (Node)x$7.get()).collect(Collectors.toList());
            if (brokerNodes.size() > 0) {
                Node node = (Node)brokerNodes.get(0);
                Endpoint endpoint = new Endpoint(listenerName.value(), securityProtocol, node.host(), node.port());
                Map clientConfig = ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)$this.config, (Endpoint)endpoint);
                String servers = brokerNodes.stream().map(n -> n.host() + ":" + n.port()).collect(Collectors.joining(","));
                clientConfig.put("bootstrap.servers", servers);
                return clientConfig;
            }
            return Collections.emptyMap();
        };
    }

    public MigrationTierTopicProducer(KafkaConfig config, String clusterId, Time time) {
        this.config = config;
        this.clusterId = clusterId;
        this.time = time;
        this.MAX_POLL_TIMEOUT_MS = 100L;
        this.MAX_RETRY = 5;
        this.log = LoggerFactory.getLogger(MigrationTierTopicProducer.class);
        this.initialized = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.producerThread = new KafkaThread("MigrationTierTopicProducer", (Runnable)this, false);
        this.queuedMetadata = new LinkedBlockingQueue();
        this.failedMetadataCount = 0;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().newGauge("FailedMetadataCount", () -> BoxesRunTime.boxToInteger(this.failedMetadataCount()));
        this.metricsGroup().newGauge("QueuedMetadataCount", () -> BoxesRunTime.boxToInteger(this.queuedMetadataCount()));
    }
}

