/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kafka.network.RequestChannel;
import kafka.network.RequestInterceptor;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2A\u0001B\u0003\u0001\u0015!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C!3!)q\u0005\u0001C)Q\t9b)\u001a;dQJ+\u0017/^3ti&sG/\u001a:dKB$xN\u001d\u0006\u0003\r\u001d\tqA\\3uo>\u00148NC\u0001\t\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u0006\u0010!\taQ\"D\u0001\u0006\u0013\tqQA\u0001\nSKF,Xm\u001d;J]R,'oY3qi>\u0014\bC\u0001\t\u0014\u001b\u0005\t\"B\u0001\n\b\u0003\u0015)H/\u001b7t\u0013\t!\u0012CA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\u0007\u0001\u0003-\u0011X-];fgR$\u0016\u0010]3\u0016\u0003i\u0001\"aG\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0011A\u0014x\u000e^8d_2T!a\b\u0011\u0002\r\r|W.\\8o\u0015\tA\u0011E\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<\u0017B\u0001\u0014\u001d\u0005\u001d\t\u0005/[&fsN\fQB]3kK\u000e$(+Z9vKN$HCA\u00150!\tQS&D\u0001,\u0015\tac$\u0001\u0005sKF,Xm\u001d;t\u0013\tq3F\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\")\u0001g\u0001a\u0001c\u0005\u0019!/Z9\u0011\u0005I*dB\u0001\u00074\u0013\t!T!\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005Y:$a\u0002*fcV,7\u000f\u001e\u0006\u0003i\u0015\u0001")
public class FetchRequestInterceptor
extends RequestInterceptor {
    @Override
    public ApiKeys requestType() {
        return ApiKeys.FETCH;
    }

    @Override
    public AbstractResponse rejectRequest(RequestChannel.Request req) {
        FetchRequest fetchRequest = (FetchRequest)req.body(ClassTag$.MODULE$.apply(FetchRequest.class));
        ArrayList fetchableTopicResponses = new ArrayList();
        fetchRequest.data().topics().forEach(topic -> {
            List partitions = topic.partitions().stream().map(partition -> new FetchResponseData.PartitionData().setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setPartitionIndex(partition.partition())).collect(Collectors.toList());
            FetchResponseData.FetchableTopicResponse fetchableTopicResponse = new FetchResponseData.FetchableTopicResponse().setTopic(topic.topic()).setTopicId(topic.topicId()).setPartitions(partitions);
            fetchableTopicResponses.add(fetchableTopicResponse);
        });
        return new FetchResponse(new FetchResponseData().setResponses(fetchableTopicResponses));
    }
}

