/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kafka.restore.operators.RestorePartitionOperator;
import kafka.restore.operators.SegmentStateAndPath;
import kafka.tier.state.SegmentState;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.TopicPartition;

public class RestoreTierPartitionState {
    private static final String TOPIC_CONFIG = "topic";
    private static final String TOPIC_DOC = "Name of the topic to restore";
    private static final String PARTITION_CONFIG = "partition";
    private static final String PARTITION_DOC = "Name of the partition to restore";
    private static final String FTPS_FILE_CONFIG = "ftps";
    private static final String FTPS_FILE_DOC = "Absolute path of the tier partition state file";
    private static final String FROM_TIMESTAMP_CONFIG = "from-timestamp";
    private static final String FROM_TIMESTAMP_DOC = "Restore from timestamp, either as unix epoch or format as 'yyyy-MM-dd HH:mm:ss'";
    private static final String OBJECT_STORE_PREFIX_CONFIG = "object-store-prefix";
    private static final String OBJECT_STORE_PREFIX_DOC = "Object store prefix";
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static void main(String[] args) throws Exception {
        System.out.println("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = RestoreTierPartitionState.createComparatorParser();
        Namespace res = cliParser.parseArgs(args);
        String topic = res.getString(TOPIC_CONFIG);
        Integer partition = res.getInt(PARTITION_CONFIG);
        String ftps = res.getString(FTPS_FILE_CONFIG);
        Long fromTimestamp = RestoreTierPartitionState.convertInputToTimestamp(res.getString(FROM_TIMESTAMP_CONFIG));
        if (fromTimestamp == null) {
            throw new IllegalArgumentException("fromTimestamp is required, either as unix epoch or format as 'yyyy-MM-dd HH:mm:ss'");
        }
        RestorePartitionOperator restorePartitionOperator = new RestorePartitionOperator(new TopicPartition(topic, partition.intValue()), ftps, fromTimestamp);
        Map<UUID, SegmentStateAndPath> segmentPathMap = restorePartitionOperator.restore();
        int updateCount = segmentPathMap.size();
        System.out.println("flipping below segments:");
        for (UUID objectId : segmentPathMap.keySet()) {
            SegmentState segmentState = restorePartitionOperator.segmentStateByObjectID(objectId);
            System.out.println("id: " + String.valueOf(segmentState.objectId()) + ", epoch: " + segmentState.tierEpoch() + ", base offset: " + segmentState.baseOffset() + ", end offset: " + segmentState.endOffset() + ", max timestamp: " + segmentState.maxTimestamp());
        }
        System.out.printf("flipped %d segments from SEGMENT_DELETE_INITIATE/COMPLETE to SEGMENT_UPLOAD_COMPLETE\n", updateCount);
    }

    private static Long convertInputToTimestamp(String input) throws ParseException {
        Long t = null;
        try {
            t = Long.parseLong(input);
        }
        catch (NumberFormatException nfe) {
            SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
            Date date = formatter.parse(input);
            t = date.getTime();
        }
        return t;
    }

    private static ArgumentParser createComparatorParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(RestoreTierPartitionState.class.getName()).defaultHelp(true).description("Restore the tier-state file from given timestamp");
        parser.addArgument(RecoveryUtils.makeArgument(TOPIC_CONFIG)).dest(TOPIC_CONFIG).type(String.class).required(true).help(TOPIC_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(PARTITION_CONFIG)).dest(PARTITION_CONFIG).type(Integer.class).required(true).help(PARTITION_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(FTPS_FILE_CONFIG)).dest(FTPS_FILE_CONFIG).type(String.class).required(true).help(FTPS_FILE_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(FROM_TIMESTAMP_CONFIG)).dest(FROM_TIMESTAMP_CONFIG).type(String.class).required(true).help(FROM_TIMESTAMP_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(OBJECT_STORE_PREFIX_CONFIG)).dest(OBJECT_STORE_PREFIX_CONFIG).type(String.class).required(false).help(OBJECT_STORE_PREFIX_DOC);
        return parser;
    }
}

