/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.db;

import java.util.UUID;
import kafka.restore.configmap.PartitionConfig;
import kafka.tier.TopicIdPartition;
import org.apache.kafka.common.Uuid;

public class PartitionRestoreContext {
    public final String topic;
    public final String topicId;
    public final PartitionConfig partitionConfig;
    public final long timeStampRestoreFrom;
    public long revertCompactionSinceTimestamp;
    public RestoreStatus status;
    public RestoreState state;

    public PartitionRestoreContext(String topic, String topicId, PartitionConfig partitionConfig, long timeStampRestoreFrom, long revertCompactionSinceTimestamp, RestoreStatus status, RestoreState state) {
        this.topic = topic;
        this.topicId = topicId;
        this.partitionConfig = partitionConfig;
        this.timeStampRestoreFrom = timeStampRestoreFrom;
        this.revertCompactionSinceTimestamp = revertCompactionSinceTimestamp;
        this.status = status;
        this.state = state;
    }

    public UUID topicId() {
        Uuid uuid = Uuid.fromString((String)this.topicId);
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public TopicIdPartition topicIdPartition() {
        return new TopicIdPartition(this.topic, this.topicId(), this.partitionConfig.getPartition());
    }

    public static enum RestoreStatus {
        NOT_STARTED,
        IN_PROGRESS,
        FAILED,
        COMPLETED;

    }

    public static enum RestoreState {
        NOT_STARTED,
        RESTORE_FTPS,
        RESTORE_SEGMENTS,
        FINALIZE_FTPS,
        RECOVER_FTPS;

    }
}

