/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.schedulers.RetryableException;
import kafka.restore.schedulers.SchedulerUtil;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionStatusFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionStatusFetcher.class);
    private CloseableHttpClient httpClient;
    private String topic;
    private int partition;
    private NodeConfig broker;
    private int expectedStatus;
    private ThreadPoolExecutor executor;

    public PartitionStatusFetcher(CloseableHttpClient httpClient, String topic, int partition, NodeConfig broker, int expectedStatus, ThreadPoolExecutor executor) {
        this.httpClient = httpClient;
        this.topic = topic;
        this.partition = partition;
        this.broker = broker;
        this.expectedStatus = expectedStatus;
        this.executor = executor;
    }

    public CompletableFuture<Integer> fetchPartitionStatus() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map<String, String> attributes = Stream.of({"topic_name", this.topic}, {"partition", String.valueOf(this.partition)}).collect(Collectors.toMap(d -> d[0], d -> d[1]));
                HttpPost post = SchedulerUtil.buildKafkaHttpRequest(this.broker, "/v1/restore/tier-state", attributes);
                LOGGER.debug("execute request: " + post.toString());
                CloseableHttpResponse response = this.httpClient.execute(post);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 300) {
                    LOGGER.error("[{}-{}]: fetch partition status http error, status code: {}, error message: {}", new Object[]{this.topic, this.partition, statusCode, response.getStatusLine().getReasonPhrase()});
                    return -1;
                }
                String responseBody = EntityUtils.toString(response.getEntity());
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = mapper.readTree(responseBody);
                LOGGER.info("rootNode: " + rootNode.toPrettyString());
                int status = rootNode.get("data").get("attributes").get("state").asInt();
                LOGGER.info("status: " + status);
                if (status == -1 || status == this.expectedStatus) {
                    return status;
                }
                String errorMessage = String.format("[%s-%s]: Partition status is not match: expected %s, got %s", this.topic, this.partition, this.expectedStatus, status);
                LOGGER.error(errorMessage);
                throw new RetryableException(errorMessage);
            }
            catch (IOException | URISyntaxException e) {
                return -1;
            }
        }, this.executor);
    }
}

