/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Supplier;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.util.Scheduler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r]a!B\u001c9\u0003\u0003i\u0004\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011a\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t5\u0002\u0011\t\u0011)A\u00057\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!\u0019\bA!A!\u0002\u0013!\b\"\u0002>\u0001\t\u0003Y\b\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u0005\u0002BCA\u0018\u0001\t\u0007I\u0011\u0001\u001d\u00022!A\u0011Q\t\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0005\u0002J!A\u00111\f\u0001!\u0002\u0013\tY\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0005\u0002`!A\u0011q\r\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002j\u0001\u0011\r\u0011\"\u0005\u0002l!9\u0011Q\u000e\u0001!\u0002\u0013y\u0006\"CA8\u0001\t\u0007I\u0011AA9\u0011!\tI\b\u0001Q\u0001\n\u0005M\u0004\"CA>\u0001\t\u0007I\u0011AA?\u0011!\t)\t\u0001Q\u0001\n\u0005}\u0004\"CAD\u0001\t\u0007I\u0011BAE\u0011!\t\t\n\u0001Q\u0001\n\u0005-\u0005\"CAJ\u0001\t\u0007I\u0011BAK\u0011!\t\u0019\f\u0001Q\u0001\n\u0005]\u0005\u0002CA[\u0001\u0011\u0005\u0001(a.\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u0011q\u001a\u0001\u0005\n\u0005E\u0007\u0002CA}\u0001\u0011\u0005\u0001(a?\t\u0011\u0005u\b\u0001\"\u00019\u0003\u007fDqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0003\u001a!A!q\u0006\u0001\u0005\u0002a\u0012\t\u0004\u0003\u0005\u0003F\u0001!\t\u0001\u000fB$\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001fBqA!\u0019\u0001\r\u0003\u0011\u0019\u0007C\u0004\u0003|\u0001!\tA! \t\u0013\t]\u0005!%A\u0005\u0002\te\u0005b\u0002BO\u0001\u0011\u0005!q\u0014\u0005\b\u0005G\u0003A\u0011\u0003BS\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005cC\u0011B!.\u0001#\u0003%\tA!'\t\u000f\t]\u0006\u0001\"\u0005\u0003:\"9!1\u001a\u0001\u0005\u0002\t5\u0007b\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005k\u0004A\u0011AA\\\u0011\u001d\u00119\u0010\u0001C\u0001\u0003oCqA!?\u0001\t\u0003\t9lB\u0005\u0003|b\n\t\u0011#\u0001\u0003~\u001aAq\u0007OA\u0001\u0012\u0003\u0011y\u0010\u0003\u0004{g\u0011\u00051\u0011\u0001\u0005\n\u0007\u0007\u0019\u0014\u0013!C\u0001\u0007\u000bA\u0011b!\u00044#\u0003%\taa\u0004\u0003-\u0005\u00137\u000f\u001e:bGR4U\r^2iKJl\u0015M\\1hKJT!!\u000f\u001e\u0002\rM,'O^3s\u0015\u0005Y\u0014!B6bM.\f7\u0001A\u000b\u0003}}\u001c2\u0001A F!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0011a)S\u0007\u0002\u000f*\u0011\u0001JO\u0001\u0006kRLGn]\u0005\u0003\u0015\u001e\u0013q\u0001T8hO&tw-\u0001\u0003oC6,W#A'\u0011\u00059+fBA(T!\t\u0001\u0016)D\u0001R\u0015\t\u0011F(\u0001\u0004=e>|GOP\u0005\u0003)\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A+Q\u0001\u0006]\u0006lW\rI\u0001\tG2LWM\u001c;JI\u0006Ya.^7GKR\u001c\u0007.\u001a:t!\t\u0001E,\u0003\u0002^\u0003\n\u0019\u0011J\u001c;\u0002\u0013\u0019,Go\u00195N_\u0012,\u0007C\u00011b\u001b\u0005A\u0014B\u000129\u0005Q1U\r^2i\u0007>tg.Z2uS>t7/T8eK\u0006I1o\u00195fIVdWM\u001d\t\u0004\u0001\u0016<\u0017B\u00014B\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001.]\u0007\u0002S*\u0011!n[\u0001\u0005kRLGN\u0003\u0002:Y*\u00111(\u001c\u0006\u0003]>\fa!\u00199bG\",'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sS\nI1k\u00195fIVdWM]\u0001\u0010Kb$(/Y'fiJL7\rV1hgB!Q\u000f_'N\u001b\u00051(BA<B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003sZ\u00141!T1q\u0003\u0019a\u0014N\\5u}QiA0!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\u00012\u0001\u0019\u0001~!\tqx\u0010\u0004\u0001\u0005\u000f\u0005\u0005\u0001A1\u0001\u0002\u0004\t\tA+\u0005\u0003\u0002\u0006\u0005-\u0001c\u0001!\u0002\b%\u0019\u0011\u0011B!\u0003\u000f9{G\u000f[5oOB\u0019\u0001-!\u0004\n\u0007\u0005=\u0001HA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\t\u000b-C\u0001\u0019A'\t\u000beC\u0001\u0019A'\t\u000biC\u0001\u0019A.\t\u000byC\u0001\u0019A0\t\u000f\rD\u0001\u0013!a\u0001I\"91\u000f\u0003I\u0001\u0002\u0004!\u0018\u0001D7fiJL7m]$s_V\u0004XCAA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014W\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA\u0016\u0003K\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005\u0001b-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012l\u0015\r]\u000b\u0003\u0003g\u0001r!!\u000e\u0002<\u0005}R0\u0004\u0002\u00028)\u0019\u0011\u0011\b<\u0002\u000f5,H/\u00192mK&!\u0011QHA\u001c\u0005\u001dA\u0015m\u001d5NCB\u00042\u0001YA!\u0013\r\t\u0019\u0005\u000f\u0002\u000b\r\u0016$8\r[3s)\u0006<\u0017!\u00054fi\u000eDWM\u001d+ie\u0016\fG-T1qA\u0005!An\\2l+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\t1\fgn\u001a\u0006\u0003\u0003+\nAA[1wC&!\u0011\u0011LA(\u0005\u0019y%M[3di\u0006)An\\2lA\u0005!b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ,\"!!\u0019\u0011\t\u0001\u000b\u0019gW\u0005\u0004\u0003K\n%!B!se\u0006L\u0018!\u00068v[\u001a+Go\u00195feN\u0004VM\u001d\"s_.,'\u000fI\u0001\u001ce\u0016\u0004H.[2b\r\u0016$8\r[\"p]:,7\r^5p]Nlu\u000eZ3\u0016\u0003}\u000bAD]3qY&\u001c\u0017MR3uG\"\u001cuN\u001c8fGRLwN\\:N_\u0012,\u0007%\u0001\tgC&dW\r\u001a)beRLG/[8ogV\u0011\u00111\u000f\t\u0004A\u0006U\u0014bAA<q\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0012M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u00059bkN,G\rU1si&$\u0018n\u001c8t+\t\ty\bE\u0002a\u0003\u0003K1!a!9\u0005A\u0001\u0016-^:fIB\u000b'\u000f^5uS>t7/A\tqCV\u001cX\r\u001a)beRLG/[8og\u0002\nA\u0001^1hgV\u0011\u00111\u0012\t\u0006kb\fi)\u0014\t\u0005\u0003\u001b\ny)C\u0002W\u0003\u001f\nQ\u0001^1hg\u0002\nA\"\u00193eK\u0012lU\r\u001e:jGN,\"!a&\u0011\r\u0005U\u0012\u0011TAO\u0013\u0011\tY*a\u000e\u0003\r\t+hMZ3s!\u0011\ty*a,\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000bAaY8sK*!\u0011qEAT\u0015\u0011\tI+a+\u0002\re\fW.\\3s\u0015\t\ti+A\u0002d_6LA!!-\u0002\"\nQQ*\u001a;sS\u000et\u0015-\\3\u0002\u001b\u0005$G-\u001a3NKR\u0014\u0018nY:!\u0003q\u0019'/Z1uKN+\u0007/\u0019:bi\u00164U\r^2iKJlU\r\u001e:jGN$\"!!/\u0011\u0007\u0001\u000bY,C\u0002\u0002>\u0006\u0013A!\u00168ji\u0006aQ.\u001b8GKR\u001c\u0007NU1uKR!\u00111YAe!\r\u0001\u0015QY\u0005\u0004\u0003\u000f\f%A\u0002#pk\ndW\rC\u0004\u0002Lr\u0001\r!!4\u0002\u0015\u0019,Go\u00195fe6\u000b\u0007\u000fE\u0003vq\u0006}R0\u0001\bde\u0016\fG/\u001a(fo\u001e\u000bWoZ3\u0016\t\u0005M\u00171\u001e\u000b\t\u0003s\u000b).a6\u0002x\")1*\ba\u0001\u001b\"9\u0011\u0011\\\u000fA\u0002\u0005m\u0017AB7fiJL7\r\u0005\u0004\u0002^\u0006\u0015\u0018\u0011^\u0007\u0003\u0003?TA!!9\u0002d\u0006Aa-\u001e8di&|gNC\u0002k\u0003'JA!a:\u0002`\nA1+\u001e9qY&,'\u000fE\u0002\u007f\u0003W$q!!<\u001e\u0005\u0004\tyOA\u0001W#\u0011\t)!!=\u0011\u0007\u0001\u000b\u00190C\u0002\u0002v\u0006\u00131!\u00118z\u0011\u0019\t9)\ba\u0001i\u0006yA-Z1e)\"\u0014X-\u00193D_VtG/F\u0001\\\u0003M!W-\u00193UQJ,\u0017\rZ\"pk:$H+Y4t)\r!(\u0011\u0001\u0005\u0007\u0003\u000f{\u0002\u0019\u0001;\u0002!I,7/\u001b>f)\"\u0014X-\u00193Q_>dGCBA]\u0005\u000f\u0011Y\u0001\u0003\u0004\u0003\n\u0001\u0002\raW\u0001\b]\u0016<8+\u001b>f\u0011%\u0011i\u0001\tI\u0001\u0002\u0004\u0011y!A\u0006gKR\u001c\u0007.\u001a:Q_>d\u0007\u0003\u0002!f\u0005#\u00012\u0001\u0019B\n\u0013\r\u0011)\u0002\u000f\u0002\f\r\u0016$8\r[3s!>|G.\u0001\u000esKNL'0\u001a+ie\u0016\fG\rU8pY\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001c)\"!q\u0002B\u000fW\t\u0011y\u0002\u0005\u0003\u0003\"\t-RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0015\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5\"1\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC4fi\u001a+Go\u00195feR!!1\u0007B\u001b!\r\u0001U- \u0005\b\u0005o\u0011\u0003\u0019\u0001B\u001d\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004BAa\u000f\u0003B5\u0011!Q\b\u0006\u0004\u0005\u007fa\u0017AB2p[6|g.\u0003\u0003\u0003D\tu\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\rO\u0016$h)\u001a;dQ\u0016\u0014\u0018\n\u001a\u000b\u00067\n%#1\n\u0005\b\u0005o\u0019\u0003\u0019\u0001B\u001d\u0011\u001d\u0011ia\ta\u0001\u0005#\t1$\\1sWB\u000b'\u000f^5uS>t7OR8s)J,hnY1uS>tG\u0003CA]\u0005#\u0012)Fa\u0016\t\r\tMC\u00051\u0001\\\u0003!\u0011'o\\6fe&#\u0007b\u0002B\u001cI\u0001\u0007!\u0011\b\u0005\b\u00053\"\u0003\u0019\u0001B.\u0003A!(/\u001e8dCRLwN\\(gMN,G\u000fE\u0002A\u0005;J1Aa\u0018B\u0005\u0011auN\\4\u0002'\r\u0014X-\u0019;f\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\u000fu\u0014)G!\u001b\u0003z!1!qM\u0013A\u0002m\u000b\u0011BZ3uG\",'/\u00133\t\u000f\t-T\u00051\u0001\u0003n\u0005a1o\\;sG\u0016\u0014%o\\6feB!!q\u000eB;\u001b\t\u0011\tHC\u0002\u0003t-\fqA\\3uo>\u00148.\u0003\u0003\u0003x\tE$A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u0005\b\u0005\u001b)\u0003\u0019\u0001B\t\u0003]\tG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0002:\n}$1\u0012BG\u0011\u001d\u0011\tI\na\u0001\u0005\u0007\u000b1\u0003]1si&$\u0018n\u001c8B]\u0012|eMZ:fiN\u0004b!\u001e=\u0003:\t\u0015\u0005c\u00011\u0003\b&\u0019!\u0011\u0012\u001d\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0003\u000e\u0019\u0002\rA!\u0005\t\u0013\t=e\u0005%AA\u0002\tE\u0015\u0001C2bY2\u0014\u0017mY6\u0011\u0011\u0001\u0013\u0019J!\u000f~\u0003sK1A!&B\u0005%1UO\\2uS>t''A\u0011bI\u00124U\r^2iKJ4uN\u001d)beRLG/[8og\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001c*\"!\u0011\u0013B\u000f\u0003I\tG\r\u001a$bS2,G\rU1si&$\u0018n\u001c8\u0015\t\u0005e&\u0011\u0015\u0005\b\u0005oA\u0003\u0019\u0001B\u001d\u0003q\tG\r\u001a)beRLG/[8ogR{g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$b!!/\u0003(\n-\u0006B\u0002BUS\u0001\u0007Q0A\u0007gKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0005[K\u0003\u0019\u0001BB\u0003YIg.\u001b;jC2|eMZ:fi\u0006sG-\u00129pG\"\u001c\u0018\u0001H7bs\n,W*[4sCR,\u0017J\\*z]\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003s\u0013\u0019\fC\u0005\u0003\u0010*\u0002\n\u00111\u0001\u0003\u0012\u00061S.Y=cK6KwM]1uK&s7+\u001f8d!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002'Q|\u0017J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0015\r\t\r%1\u0018B`\u0011\u001d\u0011i\f\fa\u0001\u0003\u0017\tqAZ3uG\",'\u000fC\u0004\u0003B2\u0002\rAa1\u0002\u001fA\f'\u000f^5uS>t7\u000b^1uKN\u0004b!\u001e=\u0003:\t\u0015\u0007c\u00011\u0003H&\u0019!\u0011\u001a\u001d\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002'5\f\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:\u0015\r\u0005e&q\u001aBk\u0011\u001d\u0011\t.\fa\u0001\u0005'\f!\u0003]1si&$\u0018n\u001c8t)>,\u0006\u000fZ1uKB)Q\u000f\u001fB\u001d7\"9!q[\u0017A\u0002\te\u0017\u0001\u0003;pa&\u001c\u0017\nZ:\u0011\r\u0001\u0013Y.\u0014Bp\u0013\r\u0011i.\u0011\u0002\n\rVt7\r^5p]F\u0002B\u0001Q3\u0003bB!!1\bBr\u0013\u0011\u0011)O!\u0010\u0003\tU+\u0018\u000eZ\u0001\u001be\u0016lwN^3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005\u0007\u0014Y\u000fC\u0004\u0003n:\u0002\rAa<\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003v\u0005c\u0014I$C\u0002\u0003tZ\u00141aU3u\u0003i\u0019\b.\u001e;e_^t\u0017\n\u001a7f\r\u0016$8\r[3s)\"\u0014X-\u00193t\u0003A\u0019Gn\\:f\u00032dg)\u001a;dQ\u0016\u00148/\u0001\u0005tQV$Hm\\<o\u0003Y\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bC\u000114'\t\u0019t\b\u0006\u0002\u0003~\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*Baa\u0002\u0004\fU\u00111\u0011\u0002\u0016\u0004I\nuAaBA\u0001k\t\u0007\u00111A\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\rE1QC\u000b\u0003\u0007'Q3\u0001\u001eB\u000f\t\u001d\t\tA\u000eb\u0001\u0003\u0007\u0001")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final int numFetchers;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private final int[] numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final PausedPartitions pausedPartitions;
    private final Map<String, String> tags;
    private final Buffer<MetricName> addedMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    public int[] numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public PausedPartitions pausedPartitions() {
        return this.pausedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    private Buffer<MetricName> addedMetrics() {
        return this.addedMetrics;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1<FetcherPool, Object> & Serializable)fetcherPool -> {
            this.createNewGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble($this.minFetchRate((Map)$this.fetcherThreadMap().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))))), (Map)this.tags().$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("FetcherPool"), fetcherPool.name())}))));
            return BoxedUnit.UNIT;
        });
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble(fetcherMap.values().headOption().map((Function1<AbstractFetcherThread, Object> & Serializable)x$4 -> BoxesRunTime.boxToDouble(AbstractFetcherManager.$anonfun$minFetchRate$1(x$4))).getOrElse(() -> 0.0));
        return BoxesRunTime.unboxToDouble(fetcherMap.values().foldLeft(BoxesRunTime.boxToDouble(headRate), (Function2<Object, AbstractFetcherThread, Object> & Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble(package$.MODULE$.min(BoxesRunTime.unboxToDouble(curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    private <V> void createNewGauge(String name, Supplier<V> metric, Map<String, String> tags) {
        MetricName metricName = this.metricsGroup().metricName(name, CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        this.metricsGroup().newGauge(metricName, metric);
        this.addedMetrics().$plus$eq(metricName);
    }

    public int deadThreadCount() {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = this.fetcherThreadMap().values().count((Function1<AbstractFetcherThread, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isThreadFailed()));
        }
        return n;
    }

    public Map<String, String> deadThreadCountTags(Map<String, String> tags) {
        return tags;
    }

    public void resizeThreadPool(int newSize, Option<FetcherPool> fetcherPool) {
        Object object = this.lock();
        synchronized (object) {
            if (fetcherPool.isEmpty()) {
                FetcherPool$.MODULE$.values().foreach((Function1<FetcherPool, Object> & Serializable)pool -> {
                    this.maybeMigratePartitions$1(pool, newSize);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.maybeMigratePartitions$1(fetcherPool.get(), newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public Option<FetcherPool> resizeThreadPool$default$2() {
        return None$.MODULE$;
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            option = this.fetcherThreadMap().values().find((Function1<AbstractFetcherThread, Object> & Serializable)fetcherThread -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
        }
        return option;
    }

    public int getFetcherId(TopicPartition topicPartition, FetcherPool fetcherPool) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker()[fetcherPool.index()];
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            FetcherPool$.MODULE$.values().foreach((Function1<FetcherPool, Object> & Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, topicPartition, brokerId, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool, Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1<Tuple2, BrokerAndFetcherId> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition, fetcherPool));
                }
                throw new MatchError(tuple2);
            });
            partitionsPerFetcher.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$8 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, fetcherPool, callback, x$8);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> addFetcherForPartitions$default$3() {
        return (Function2<TopicPartition, AbstractFetcherThread, Object> & Serializable)(x$6, x$7) -> {
            AbstractFetcherManager.$anonfun$addFetcherForPartitions$default$3$1(x$6, x$7);
            return BoxedUnit.UNIT;
        };
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String> & Serializable)() -> "Added fetcher " + fetcherThread.getName() + " to broker " + fetcherThread.leader().brokerEndPoint().id() + " for partitions " + initialOffsetAndEpochs);
    }

    public void maybeMigrateInSyncPartitions(Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$1(check$ifrefutable$2)))).foreach((Function1<Tuple2, Object> & Serializable)x$11 -> {
                AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$2(this, callback, x$11);
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> maybeMigrateInSyncPartitions$default$1() {
        return (Function2<TopicPartition, AbstractFetcherThread, Object> & Serializable)(x$9, x$10) -> {
            AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$default$1$1(x$9, x$10);
            return BoxedUnit.UNIT;
        };
    }

    public Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), new InitialFetchState(fetchState.topicId(), fetcher.leader().brokerEndPoint(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset(), fetchState.replicationSessionId()));
            }
            throw new MatchError(tuple2);
        });
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = (scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1<Tuple2, Seq> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    int leaderId = tuple2._2$mcI$sp();
                    return (Seq)FetcherPool$.MODULE$.values().map((Function1<FetcherPool, FetcherTag> & Serializable)poolType -> new FetcherTag(leaderId, this.getFetcherId(topicPartition, (FetcherPool)poolType), (FetcherPool)poolType));
                }
                throw new MatchError(tuple2);
            }).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Seq brokerAndFetcherId = (Seq)tuple2._1();
                    Map partitionsToUpdate = (Map)tuple2._2();
                    return new Tuple2(brokerAndFetcherId, partitionsToUpdate.keySet());
                }
                throw new MatchError(tuple2);
            });
            partitionsPerFetcher.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$4(check$ifrefutable$3))).foreach((Function1<Tuple2, Object> & Serializable)x$13 -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$5(this, topicIds, x$13);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates;
        block3: {
            fetchStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Object object = this.lock();
            synchronized (object) {
                this.fetcherThreadMap().values().foreach((Function1<AbstractFetcherThread, scala.collection.mutable.Map> & Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
                this.failedPartitions().removeAll(partitions);
                this.pausedPartitions().removeAll(partitions);
            }
            if (!partitions.nonEmpty()) break block3;
            this.info((Function0<String> & Serializable)() -> "Removed fetcher for partitions " + partitions);
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$4)))).foreach((Function1<Tuple2, Object> & Serializable)x$14 -> {
                Tuple2 tuple2 = x$14;
                if (tuple2 != null) {
                    FetcherTag key = (FetcherTag)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq(key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(tuple2);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq(keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$5)))).foreach((Function1<Tuple2, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$15)));
            ((IterableOps.WithFilter)this.fetcherThreadMap().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$6)))).foreach((Function1<Tuple2, Object> & Serializable)x$16 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$16);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public void shutdown() {
        this.closeAllFetchers();
        this.addedMetrics().foreach((Function1<MetricName, Object> & Serializable)metricName -> {
            AbstractFetcherManager.$anonfun$shutdown$1(this, metricName);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong(fetcherThread.fetcherLagStats().stats().values().foldLeft(BoxesRunTime.boxToLong(0L), (Function2<Object, FetcherLagMetrics, Object> & Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong(package$.MODULE$.max(BoxesRunTime.unboxToLong(curMaxLagThread), lagMetrics.lag()))));
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public static final /* synthetic */ long $anonfun$new$1(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong($this.fetcherThreadMap().values().foldLeft(BoxesRunTime.boxToLong(0L), (Function2<Object, AbstractFetcherThread, Object> & Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong(curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ long $anonfun$new$5(AbstractFetcherThread x$1) {
        return BoxesRunTime.unboxToLong(x$1.fetcherLagStats().stats().values().iterator().map((Function1<FetcherLagMetrics, Object> & Serializable)x$2 -> BoxesRunTime.boxToLong(x$2.lag())).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$new$4(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong($this.fetcherThreadMap().valuesIterator().map((Function1<AbstractFetcherThread, Object> & Serializable)x$1 -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$5(x$1))).sum(Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$new$9(AbstractFetcherThread x$3) {
        return x$3.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ double $anonfun$new$8(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToDouble($this.fetcherThreadMap().valuesIterator().map((Function1<AbstractFetcherThread, Object> & Serializable)x$3 -> BoxesRunTime.boxToDouble(AbstractFetcherManager.$anonfun$new$9(x$3))).sum(Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$new$10(AbstractFetcherManager $this) {
        return $this.failedPartitions().size();
    }

    public static final /* synthetic */ int $anonfun$new$11(AbstractFetcherManager $this) {
        return $this.pausedPartitions().size();
    }

    public static final /* synthetic */ void $anonfun$new$13(AbstractFetcherManager $this, Scheduler s) {
        s.schedule("migrate-in-sync-partitions-thread", () -> $this.maybeMigrateInSyncPartitions($this.maybeMigrateInSyncPartitions$default$1()), 0L, 1000L);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FetcherTag ft = (FetcherTag)tuple2._1();
            FetcherPool fetcherPool = ft.fetcherPool();
            FetcherPool fetcherPool2 = fetcherPool$1;
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool2) : fetcherPool2 != null);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$4) {
        return x$4.fetcherStats().requestRate().oneMinuteRate();
    }

    private final void maybeMigratePartitions$1(FetcherPool fetcherPool, int newSize$1) {
        int currentSize = this.numFetchersPerBroker()[fetcherPool.index()];
        if (newSize$1 != currentSize) {
            this.numFetchersPerBroker()[fetcherPool.index()] = newSize$1;
            this.info((Function0<String> & Serializable)() -> "Resizing fetcher thread in " + fetcherPool.name() + " size from " + currentSize + " to " + newSize$1);
            this.migratePartitions$1(newSize$1, fetcherPool);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$resizeThreadPool$2(FetcherPool fetcherPool$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FetcherTag fetcherTag = (FetcherTag)tuple2._1();
            FetcherPool fetcherPool = fetcherTag.fetcherPool();
            FetcherPool fetcherPool2 = fetcherPool$3;
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool2) : fetcherPool2 != null);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$4(AbstractFetcherThread thread$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id$1, TopicPartition topicPartition, PartitionFetchState currentFetchState) {
        InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread$1.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset(), currentFetchState.replicationSessionId());
        scala.collection.mutable.Map allRemovedPartitionsMap = (scala.collection.mutable.Map)allRemovedPartitionsMapByFetcherPool$1.getOrElseUpdate(id$1.fetcherPool(), (Function0<scala.collection.mutable.Map> & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$));
        allRemovedPartitionsMap.update(topicPartition, initialFetchState);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$3(int newSize$2, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$2) {
            thread.shutdown();
        }
        partitionStates.foreachEntry((Function2<TopicPartition, PartitionFetchState, Object> & Serializable)(topicPartition, currentFetchState) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$4(thread, allRemovedPartitionsMapByFetcherPool$1, id, topicPartition, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    private final void migratePartitions$1(int newSize, FetcherPool fetcherPool2) {
        scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        HashMap filteredFetcherThreads = (HashMap)this.fetcherThreadMap().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$resizeThreadPool$2(fetcherPool2, x0$1)));
        filteredFetcherThreads.foreachEntry((Function2<FetcherTag, AbstractFetcherThread, Object> & Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$3(newSize, allRemovedPartitionsMapByFetcherPool, id, thread);
            return BoxedUnit.UNIT;
        });
        allRemovedPartitionsMapByFetcherPool.foreachEntry((Function2<FetcherPool, scala.collection.mutable.Map, Object> & Serializable)(fetcherPool, allRemovedPartitionsMap) -> {
            this.addFetcherForPartitions(allRemovedPartitionsMap, fetcherPool, this.addFetcherForPartitions$default$3());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, TopicPartition topicPartition$2, int brokerId$1, long truncationOffset$1, FetcherPool fetcherPool) {
        int fetcherId = $this.getFetcherId(topicPartition$2, fetcherPool);
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId, fetcherPool);
        $this.fetcherThreadMap().get(fetcherTag).foreach((Function1<AbstractFetcherThread, Object> & Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put(fetcherTag, fetcherThread);
        ((AbstractFetcherThread)fetcherThread).start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$4, Function2 callback$1, Tuple2 x$8) {
        block6: {
            var6_4 = x$8;
            if (var6_4 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)var6_4._1();
            initialFetchOffsets = (Map)var6_4._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$4);
            var11_8 = false;
            var12_9 = null;
            var13_10 = $this.fetcherThreadMap().get(fetcherTag);
            if (!(var13_10 instanceof Some)) ** GOTO lbl-1000
            var11_8 = true;
            var12_9 = (Some)var13_10;
            currentFetcherThread = (AbstractFetcherThread)var12_9.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var15_12 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var15_12) == false : var15_12 != null)) {
                v1 = currentFetcherThread;
            } else if (var11_8) {
                f = (AbstractFetcherThread)var12_9.value();
                f.shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var13_10)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError(var13_10);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, initialFetchOffsets);
            initialFetchOffsets.keys().foreach((Function1<TopicPartition, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)fetcherThread));
            return;
        }
        throw new MatchError(var6_4);
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$default$3$1(TopicPartition x$6, AbstractFetcherThread x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (lagMetrics = (FetcherLagMetrics)tuple2._2()) != null) {
            FetcherLagMetrics fetcherLagMetrics = lagMetrics;
            return fetcherLagMetrics.lag() == 0L;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Function2 callback$2, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            FetcherTag tag = (FetcherTag)tuple2._1();
            AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
            FetcherPool fetcherPool = tag.fetcherPool();
            FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
            if (!(fetcherPool != null ? !fetcherPool.equals(fetcherPool$Default$) : fetcherPool$Default$ != null)) {
                scala.collection.immutable.Set<TopicPartition> inSyncPartitions = ((IterableOnceOps)((IterableOps)fetcher.fetcherLagStats().stats().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1<Tuple2, TopicPartition> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        return topicPartition;
                    }
                    throw new MatchError(tuple2);
                })).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions(inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$, callback$2);
                if (partitionStates.nonEmpty()) {
                    $this.info((Function0<String> & Serializable)() -> "Moved " + partitionStates.keys() + " partitions from " + FetcherPool$Default$.MODULE$ + " to " + FetcherPool$InSync$.MODULE$ + " for " + tag);
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$default$1$1(TopicPartition x$9, AbstractFetcherThread x$10) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$6(AbstractFetcherManager $this, Set partitions$1, Function1 topicIds$1, FetcherTag fetcherTag) {
        $this.fetcherThreadMap().get(fetcherTag).foreach((Function1<AbstractFetcherThread, Object> & Serializable)x$12 -> {
            x$12.maybeUpdateTopicIds(partitions$1, topicIds$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 != null) {
            Seq fetcherTags = (Seq)tuple2._1();
            Set partitions = (Set)tuple2._2();
            fetcherTags.foreach((Function1<FetcherTag, Object> & Serializable)fetcherTag -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$6($this, partitions, topicIds$1, fetcherTag);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 != null) {
            AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
            return fetcher.initiateShutdown();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 != null) {
            AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
            fetcher.shutdown();
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(AbstractFetcherManager $this, MetricName metricName) {
        $this.metricsGroup().removeMetric(metricName);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags) {
        BoxedUnit boxedUnit;
        this.name = name;
        this.numFetchers = numFetchers;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = (int[])Array$.MODULE$.fill(FetcherPool$.MODULE$.values().size(), () -> $this.numFetchers, ClassTag$.MODULE$.Int());
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.pausedPartitions = new PausedPartitions();
        this.logIdent_$eq("[" + name + "] ");
        this.tags = (Map)((MapOps)scala.collection.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("clientId"), clientId)}))).$plus$plus(extraMetricTags);
        this.addedMetrics = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.createNewGauge("MaxLag", () -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$1(this)), this.tags());
        this.createNewGauge("TotalLag", () -> BoxesRunTime.boxToLong(AbstractFetcherManager.$anonfun$new$4(this)), this.tags());
        this.createNewGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble(this.minFetchRate(this.fetcherThreadMap())), this.tags());
        this.createNewGauge("TotalFetchRate", () -> BoxesRunTime.boxToDouble(AbstractFetcherManager.$anonfun$new$8(this)), this.tags());
        this.createNewGauge("FailedPartitionsCount", () -> BoxesRunTime.boxToInteger(AbstractFetcherManager.$anonfun$new$10(this)), this.tags());
        this.createNewGauge("PausedPartitionsCount", () -> BoxesRunTime.boxToInteger(AbstractFetcherManager.$anonfun$new$11(this)), this.tags());
        this.createNewGauge("DeadThreadCount", () -> BoxesRunTime.boxToInteger(this.deadThreadCount()), this.deadThreadCountTags(this.tags()));
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (!(fetchConnectionsMode != null ? !fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$) : fetchConnectionsMode$Isolated$ != null)) {
            scheduler.foreach((Function1<Scheduler, Object> & Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$13(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally(boxedUnit);
    }

    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$4$adapted(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply(tp, fetcherThread$1);
        return BoxedUnit.UNIT;
    }
}

