/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.server.BlockingSend;
import kafka.server.BrokerBlockingSender$;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005ux!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\"CA^\u0003E\u0005I\u0011AA_\u0011\u001d\t\u0019.\u0001C\u0001\u0003+D\u0011\"!>\u0002#\u0003%\t!!0\t\u0013\u0005]\u0018!%A\u0005\u0002\u0005eh\u0001B\u0013\u001f\u0001IB\u0001B\u000e\u0005\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0007\"\u0011\t\u0011)A\u0005\t\"Aq\t\u0003B\u0001B\u0003%\u0001\n\u0003\u0005L\u0011\t\u0005\t\u0015!\u0003M\u0011!!\u0006B!A!\u0002\u0013A\u0005\u0002C+\t\u0005\u0003\u0007I\u0011\u0001,\t\u0011uC!\u00111A\u0005\u0002yC\u0001\u0002\u001a\u0005\u0003\u0002\u0003\u0006Ka\u0016\u0005\tK\"\u0011\t\u0019!C\u0001M\"Aa\u000e\u0003BA\u0002\u0013\u0005q\u000e\u0003\u0005r\u0011\t\u0005\t\u0015)\u0003h\u0011\u0015i\u0003\u0002\"\u0001s\u0011\u001dQ\bB1A\u0005\u0002mDaa \u0005!\u0002\u0013a\bBB\u0017\t\t\u0003\t\t\u0001C\u0004\u0002B!!\t%a\u0011\t\u000f\u0005\u0015\u0003\u0002\"\u0011\u0002H!9\u00111\u0013\u0005\u0005B\u0005U\u0005bBAL\u0011\u0011\u0005\u0013Q\u0013\u0005\b\u00033CA\u0011IAN\u0003Q\u0011%o\\6fe\ncwnY6j]\u001e\u001cVM\u001c3fe*\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002%\u00035\taD\u0001\u000bCe>\\WM\u001d\"m_\u000e\\\u0017N\\4TK:$WM]\n\u0003\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001$\u0003\u0015\t\u0007\u000f\u001d7z)E\t\u0014QTAP\u0003C\u000b\u0019+!*\u0002(\u0006%\u00161\u0016\t\u0003I!\u00192\u0001C\u00144!\t!C'\u0003\u00026=\ta!\t\\8dW&twmU3oI\u0006a1o\\;sG\u0016\u0014%o\\6feB\u0011\u0001(Q\u0007\u0002s)\u0011!hO\u0001\b]\u0016$xo\u001c:l\u0015\tyBH\u0003\u0002\"{)\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011\u0015H\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005\u0011*\u0015B\u0001$\u001f\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001bM|7m[3u)&lWm\\;u!\tA\u0013*\u0003\u0002KS\t\u0019\u0011J\u001c;\u0002\tQLW.\u001a\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000bQ!\u001e;jYNT!!\u0015\u001f\u0002\r\r|W.\\8o\u0013\t\u0019fJ\u0001\u0003US6,\u0017!\u00034fi\u000eDWM]%e\u00035qW\r^<pe.\u001cE.[3oiV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[y\u000591\r\\5f]R\u001c\u0018B\u0001/Z\u0005-Y\u0015MZ6b\u00072LWM\u001c;\u0002#9,Go^8sW\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002`EB\u0011\u0001\u0006Y\u0005\u0003C&\u0012A!\u00168ji\"91mDA\u0001\u0002\u00049\u0016a\u0001=%c\u0005qa.\u001a;x_J\\7\t\\5f]R\u0004\u0013\u0001\b:fG>tg-[4ve\u0006\u0014G.Z\"iC:tW\r\u001c\"vS2$WM]\u000b\u0002OB\u0019\u0001\u0006\u001b6\n\u0005%L#AB(qi&|g\u000e\u0005\u0002lY6\t\u0001+\u0003\u0002n!\nq!+Z2p]\u001aLw-\u001e:bE2,\u0017\u0001\t:fG>tg-[4ve\u0006\u0014G.Z\"iC:tW\r\u001c\"vS2$WM]0%KF$\"a\u00189\t\u000f\r\u0014\u0012\u0011!a\u0001O\u0006i\"/Z2p]\u001aLw-\u001e:bE2,7\t[1o]\u0016d')^5mI\u0016\u0014\b\u0005\u0006\u00052gR,ho\u001e=z\u0011\u00151D\u00031\u00018\u0011\u0015\u0019E\u00031\u0001E\u0011\u00159E\u00031\u0001I\u0011\u0015YE\u00031\u0001M\u0011\u0015!F\u00031\u0001I\u0011\u0015)F\u00031\u0001X\u0011\u0015)G\u00031\u0001h\u0003)\u0019x.\u001e:dK:{G-Z\u000b\u0002yB\u00111.`\u0005\u0003}B\u0013AAT8eK\u0006Y1o\\;sG\u0016tu\u000eZ3!)E\t\u00141AA\u0003\u0003\u000f\t)\"a\u0006\u0002\u001a\u0005M\u0012Q\b\u0005\u0006m]\u0001\ra\u000e\u0005\u0006\u0007^\u0001\r\u0001\u0012\u0005\b\u0003\u00139\u0002\u0019AA\u0006\u0003\u001diW\r\u001e:jGN\u0004B!!\u0004\u0002\u00125\u0011\u0011q\u0002\u0006\u0004\u0003\u0013\u0001\u0016\u0002BA\n\u0003\u001f\u0011q!T3ue&\u001c7\u000fC\u0003L/\u0001\u0007A\nC\u0003U/\u0001\u0007\u0001\nC\u0004\u0002\u001c]\u0001\r!!\b\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004B!a\b\u0002.9!\u0011\u0011EA\u0015!\r\t\u0019#K\u0007\u0003\u0003KQ1!a\n#\u0003\u0019a$o\\8u}%\u0019\u00111F\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tY#\u000b\u0005\b\u0003k9\u0002\u0019AA\u001c\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0004\u001b\u0006e\u0012bAA\u001e\u001d\nQAj\\4D_:$X\r\u001f;\t\u000f\u0005}r\u00031\u0001\u0002\u001e\u0005yQ.\u001a;sS\u000e<%\u000f\u001d)sK\u001aL\u00070\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\u0003]\n1b]3oIJ+\u0017/^3tiR!\u0011\u0011JA(!\rA\u00161J\u0005\u0004\u0003\u001bJ&AD\"mS\u0016tGOU3ta>t7/\u001a\u0005\b\u0003#J\u0002\u0019AA*\u00039\u0011X-];fgR\u0014U/\u001b7eKJ\u0004D!!\u0016\u0002\u0000A1\u0011qKA;\u0003wrA!!\u0017\u0002p9!\u00111LA6\u001d\u0011\ti&!\u001b\u000f\t\u0005}\u0013q\r\b\u0005\u0003C\n)G\u0004\u0003\u0002$\u0005\r\u0014\"\u0001!\n\u0005yz\u0014BA\u0011>\u0013\t\tF(C\u0002\u0002nA\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003c\n\u0019(A\bBEN$(/Y2u%\u0016\fX/Z:u\u0015\r\ti\u0007U\u0005\u0005\u0003o\nIHA\u0004Ck&dG-\u001a:\u000b\t\u0005E\u00141\u000f\t\u0005\u0003{\ny\b\u0004\u0001\u0005\u0019\u0005\u0005\u0015qJA\u0001\u0002\u0003\u0015\t!a!\u0003\u0007}#3'\u0005\u0003\u0002\u0006\u0006-\u0005c\u0001\u0015\u0002\b&\u0019\u0011\u0011R\u0015\u0003\u000f9{G\u000f[5oOB!\u0011QRAH\u001b\t\t\u0019(\u0003\u0003\u0002\u0012\u0006M$aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f)\u0005y\u0016!B2m_N,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0001\"\u0002\u001c\u0004\u0001\u00049\u0004\"B\"\u0004\u0001\u0004!\u0005bBA\u0005\u0007\u0001\u0007\u00111\u0002\u0005\u0006\u0017\u000e\u0001\r\u0001\u0014\u0005\u0006)\u000e\u0001\r\u0001\u0013\u0005\b\u00037\u0019\u0001\u0019AA\u000f\u0011\u001d\t)d\u0001a\u0001\u0003oA\u0011\"!,\u0004!\u0003\u0005\r!a,\u0002\u001f\u0015DHO]1NKR\u0014\u0018n\u0019+bON\u0004\u0002\"!-\u00028\u0006u\u0011QD\u0007\u0003\u0003gS1!!.*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\u000b\u0019LA\u0002NCB\fq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003\u007fSC!a,\u0002B.\u0012\u00111\u0019\t\u0005\u0003\u000b\fy-\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003%)hn\u00195fG.,GMC\u0002\u0002N&\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t.a2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u001ade\u0016\fG/\u001a(fi^|'o[\"mS\u0016tG/\u00118e%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007\"\fgN\\3m\u0005VLG\u000eZ3s)Q\t9.a9\u0002f\u0006\u001d\u0018\u0011^Av\u0003[\fy/!=\u0002tB1\u0001&!7\u0002^\u001eL1!a7*\u0005\u0019!V\u000f\u001d7feA\u0019\u0001,a8\n\u0007\u0005\u0005\u0018LA\u0007OKR<xN]6DY&,g\u000e\u001e\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\b\u0003\u0013)\u0001\u0019AA\u0006\u0011\u0015YU\u00011\u0001M\u0011\u0015!V\u00011\u0001I\u0011\u001d\tY\"\u0002a\u0001\u0003;Aq!!\u000e\u0006\u0001\u0004\t9\u0004C\u0005\u0002.\u0016\u0001\n\u00111\u0001\u00020\"I\u0011qH\u0003\u0011\u0002\u0003\u0007\u0011QD\u0001=GJ,\u0017\r^3OKR<xN]6DY&,g\u000e^!oIJ+7m\u001c8gS\u001e,(/\u00192mK\u000eC\u0017M\u001c8fY\n+\u0018\u000e\u001c3fe\u0012\"WMZ1vYR$\u0003(\u0001\u001fde\u0016\fG/\u001a(fi^|'o[\"mS\u0016tG/\u00118e%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007\"\fgN\\3m\u0005VLG\u000eZ3sI\u0011,g-Y;mi\u0012JTCAA~U\u0011\ti\"!1")
public class BrokerBlockingSender
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final int socketTimeout;
    private final Time time;
    private final int fetcherId;
    private KafkaClient networkClient;
    private Option<Reconfigurable> reconfigurableChannelBuilder;
    private final Node sourceNode;

    public static String createNetworkClientAndReconfigurableChannelBuilder$default$9() {
        return BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder$default$9();
    }

    public static Map<String, String> createNetworkClientAndReconfigurableChannelBuilder$default$8() {
        return BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder$default$8();
    }

    public static Tuple2<NetworkClient, Option<Reconfigurable>> createNetworkClientAndReconfigurableChannelBuilder(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags, String metricGrpPrefix) {
        return BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags, metricGrpPrefix);
    }

    public static Map<String, String> apply$default$8() {
        return BrokerBlockingSender$.MODULE$.apply$default$8();
    }

    public static BrokerBlockingSender apply(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags) {
        return BrokerBlockingSender$.MODULE$.apply(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags);
    }

    public KafkaClient networkClient() {
        return this.networkClient;
    }

    public void networkClient_$eq(KafkaClient x$1) {
        this.networkClient = x$1;
    }

    public Option<Reconfigurable> reconfigurableChannelBuilder() {
        return this.reconfigurableChannelBuilder;
    }

    public void reconfigurableChannelBuilder_$eq(Option<Reconfigurable> x$1) {
        this.reconfigurableChannelBuilder = x$1;
    }

    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout)) {
                throw new SocketTimeoutException("Failed to connect within " + this.socketTimeout + " ms");
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(Integer.toString(this.sourceBroker.id()), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(Integer.toString(this.sourceBroker.id()));
            throw e;
        }
        return clientResponse;
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder().foreach((Function1<Reconfigurable, Object> & Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public String toString() {
        return "BrokerBlockingSender(sourceBroker=" + this.sourceBroker + ", fetcherId=" + this.fetcherId + ")";
    }

    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, int socketTimeout, Time time, int fetcherId, KafkaClient networkClient, Option<Reconfigurable> reconfigurableChannelBuilder) {
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.socketTimeout = socketTimeout;
        this.time = time;
        this.fetcherId = fetcherId;
        this.networkClient = networkClient;
        this.reconfigurableChannelBuilder = reconfigurableChannelBuilder;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
    }

    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, String metricGrpPrefix) {
        this(sourceBroker, brokerConfig, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs()), time, fetcherId, null, null);
        BrokerEndPoint x$1 = sourceBroker;
        KafkaConfig x$2 = brokerConfig;
        Metrics x$3 = metrics;
        Time x$4 = time;
        int x$5 = fetcherId;
        String x$6 = clientId;
        LogContext x$7 = logContext;
        String x$8 = metricGrpPrefix;
        Map<String, String> x$9 = BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder$default$8();
        Tuple2<NetworkClient, Option<Reconfigurable>> tuple2 = BrokerBlockingSender$.MODULE$.createNetworkClientAndReconfigurableChannelBuilder(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$9, x$8);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        NetworkClient networkClient = tuple2._1();
        Option<Reconfigurable> reconfigurableChannelBuilder = tuple2._2();
        Tuple2<NetworkClient, Option<Reconfigurable>> tuple22 = new Tuple2<NetworkClient, Option<Reconfigurable>>(networkClient, reconfigurableChannelBuilder);
        NetworkClient networkClient2 = tuple22._1();
        Option<Reconfigurable> reconfigurableChannelBuilder2 = tuple22._2();
        this.networkClient_$eq((KafkaClient)networkClient2);
        this.reconfigurableChannelBuilder_$eq(reconfigurableChannelBuilder2);
    }
}

