/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.metrics.BrokerLoad;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaMetricsReporterConfig;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.QuotaFactory;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.quota.QuotaType;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e4Aa\u0004\t\u0001+!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!!\u0004A!A!\u0002\u0013)\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\")A\n\u0001C\u0001\u001b\")a\u000b\u0001C\u0001/\")1\f\u0001C\u0001/\")A\f\u0001C\u0001;\")!\u000f\u0001C\u0001g\")Q\u000f\u0001C\u0001m\")\u0001\u0010\u0001C\u0005/\nQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe*\u0011\u0011CE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0013\u0003\u0015)H/\u001b7t\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\t!S%D\u0001\u0011\u0013\t1\u0003C\u0001\u0011DY&,g\u000e^)v_R\fW*\u001a;sS\u000e\u001c(+\u001a9peR,'oQ8oM&<\u0017aB7fiJL7m\u001d\t\u0003SIj\u0011A\u000b\u0006\u0003O-R!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t\u0019bF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005\u001diU\r\u001e:jGN\f\u0011CZ3uG\"\fVo\u001c;b\u001b\u0006t\u0017mZ3s!\t!c'\u0003\u00028!\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003M\u0001(o\u001c3vG\u0016\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003Q\t7\r^5wKR+g.\u00198ug6\u000bg.Y4feB\u0019qcO\u001f\n\u0005qB\"AB(qi&|g\u000e\u0005\u0002%}%\u0011q\b\u0005\u0002\u0015\u0003\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:\u0002G\u0011Lh.Y7jGF+x\u000e^1SKB|'\u000f^5oO\u000eC\u0017M\u001c8fY6\u000bg.Y4feB\u0019qc\u000f\"\u0011\u0005\u0011\u001a\u0015B\u0001#\u0011\u0005\t\"\u0015P\\1nS\u000e\fVo\u001c;b%\u0016\u0004xN\u001d;j]\u001e\u0014V-];fgR$\u0006N]3bI\u0006Q!M]8lKJdu.\u00193\u0011\u0007]Yt\t\u0005\u0002I\u00156\t\u0011J\u0003\u0002(%%\u00111*\u0013\u0002\u000b\u0005J|7.\u001a:M_\u0006$\u0017A\u0002\u001fj]&$h\b\u0006\u0005O\u001fB\u000b&k\u0015+V!\t!\u0003\u0001C\u0003#\u0011\u0001\u00071\u0005C\u0003(\u0011\u0001\u0007\u0001\u0006C\u00035\u0011\u0001\u0007Q\u0007C\u00039\u0011\u0001\u0007Q\u0007C\u0003:\u0011\u0001\u0007!\bC\u0003A\u0011\u0001\u0007\u0011\tC\u0003F\u0011\u0001\u0007a)\u0001\u0003j]&$H#\u0001-\u0011\u0005]I\u0016B\u0001.\u0019\u0005\u0011)f.\u001b;\u00027E,x\u000e^1Vg\u0006<WMU3q_J$\u0018N\\4DC2d'-Y2l\u0003m\u0019wN\u001c8fGRLwN\\!ui\u0016l\u0007\u000f^'fiJL7MT1nKR\u0011aL\u0019\t\u0003?\u0002l\u0011aK\u0005\u0003C.\u0012!\"T3ue&\u001cg*Y7f\u0011\u0015\u00197\u00021\u0001e\u0003)iW\r\u001e:jGR\u000bwm\u001d\t\u0005K2|wN\u0004\u0002gUB\u0011q\rG\u0007\u0002Q*\u0011\u0011\u000eF\u0001\u0007yI|w\u000e\u001e \n\u0005-D\u0012A\u0002)sK\u0012,g-\u0003\u0002n]\n\u0019Q*\u00199\u000b\u0005-D\u0002CA3q\u0013\t\thN\u0001\u0004TiJLgnZ\u0001\u001fC\u001e<'/Z4bi\u0016\u0014V-];fgR\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016$\"A\u0018;\t\u000b\rd\u0001\u0019\u00013\u00023\r|gN\\3di&|gnQ8v]RlU\r\u001e:jG:\u000bW.\u001a\u000b\u0003=^DQaY\u0007A\u0002\u0011\f1D\u0019:pW\u0016\u0014Hj\\1e%\u0016\u0004xN\u001d;j]\u001e\u001c\u0015\r\u001c7cC\u000e\\\u0007")
public class ClientQuotaMetricsReporter
implements Logging {
    private final ClientQuotaMetricsReporterConfig config;
    private final Metrics metrics;
    private final ClientQuotaManager fetchQuotaManager;
    private final ClientQuotaManager produceQuotaManager;
    private final Option<ActiveTenantsManager> activeTenantsManager;
    private final Option<DynamicQuotaReportingRequestThread> dynamicQuotaReportingChannelManager;
    private final Option<BrokerLoad> brokerLoad;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClientQuotaMetricsReporter clientQuotaMetricsReporter = this;
        synchronized (clientQuotaMetricsReporter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void init() {
        if (this.activeTenantsManager.isDefined()) {
            this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$1 -> {
                x$1.schedule("reporting-quota-usage", () -> this.quotaUsageReportingCallback(), this.config.consumptionReportingIntervalMs());
                return BoxedUnit.UNIT;
            });
        }
        if (this.activeTenantsManager.isDefined()) {
            this.brokerLoad.foreach((Function1<BrokerLoad, Object> & Serializable)x$2 -> {
                x$2.schedule("reporting-quota-usage-for-broker-load-metric", () -> this.brokerLoadReportingCallback(), 0L, this.config.consumptionReportingIntervalMs());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void quotaUsageReportingCallback() {
        if (QuotaFactory.quotaConsumptionReportingEnabled || this.config.elasticCkuEnabled()) {
            Seq<Map<String, String>> activeTenants = this.activeTenantsManager.get().getActiveTenants();
            activeTenants.foreach((Function1<Map, Object> & Serializable)metricTags -> {
                ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$1(this, metricTags);
                return BoxedUnit.UNIT;
            });
            this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$5 -> {
                x$5.wakeup();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public MetricName connectionAttemptMetricName(Map<String, String> metricTags) {
        scala.collection.mutable.Map tagsWithListener = (scala.collection.mutable.Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>("listener", "EXTERNAL")}));
        metricTags.foreach((Function1<Tuple2, scala.collection.mutable.Map> & Serializable)quotaEntity -> (scala.collection.mutable.Map)tagsWithListener.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntity._1()), quotaEntity._2())));
        return this.metrics.metricName("listener-tenant-connection-accept-rate", "socket-server-metrics", "Tracking rate of accepting new connections (per second)", CollectionConverters$.MODULE$.MutableMapHasAsJava(tagsWithListener).asJava());
    }

    public MetricName aggregateRequestRateMetricName(Map<String, String> metricTags) {
        return this.metrics.metricName("aggregate-request-rate", "tenant-metrics", "Tracking total request rate (per second)", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    public MetricName connectionCountMetricName(Map<String, String> metricTags) {
        return this.metrics.metricName("authenticated-unthrottled-connection-count", "socket-server-metrics", "Tracking number of active authenticated connections", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    private void brokerLoadReportingCallback() {
        if (QuotaFactory.brokerLoadConsumptionReportingEnabled) {
            ClientQuotaManager[] quotaManagers = (ClientQuotaManager[])((Object[])new ClientQuotaManager[]{this.produceQuotaManager, this.fetchQuotaManager});
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(quotaManagers), (Function1<ClientQuotaManager, Object> & Serializable)quotaManager -> {
                ClientQuotaMetricsReporter.$anonfun$brokerLoadReportingCallback$1(this, quotaManager);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$quotaUsageReportingCallback$4(ReportQuotaConsumptionRequestData.EntryData entryData$1, Tuple2 quotaEntity) {
        return entryData$1.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType((String)quotaEntity._1()).setEntityName((String)quotaEntity._2()));
    }

    public static final /* synthetic */ void $anonfun$quotaUsageReportingCallback$2(ClientQuotaMetricsReporter $this, Map metricTags$1, ClientQuotaManager quotaManager) {
        if (quotaManager.hasQuotaLimit(CollectionConverters$.MODULE$.MapHasAsJava(metricTags$1).asJava())) {
            KafkaMetric clientMetric = (KafkaMetric)$this.metrics.metrics().get(quotaManager.clientRateMetricName(metricTags$1));
            if (clientMetric != null) {
                double usage;
                double throttleTimeMs;
                String quotaType = QuotaType.toClientQuotaType(quotaManager.quotaType()).toString();
                $this.debug((Function0<String> & Serializable)() -> "Reporting " + quotaType + " metric for " + metricTags$1.toString());
                ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
                metricTags$1.foreach((Function1<Tuple2, Object> & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean(ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$4(entryData, quotaEntity)));
                KafkaMetric throttlingMetric = (KafkaMetric)$this.metrics.metrics().get(quotaManager.throttleMetricName(metricTags$1));
                double throttledTimeMs = throttlingMetric != null ? (Double.isNaN(throttleTimeMs = BoxesRunTime.unboxToDouble(throttlingMetric.metricValue())) ? 0.0 : throttleTimeMs) : 0.0;
                double adjustedUsage = usage = BoxesRunTime.unboxToDouble(clientMetric.metricValue());
                adjustedUsage = $this.config.enableBrokerReportMinUsageMode() ? package$.MODULE$.max(usage, 102400.0) : package$.MODULE$.max(usage, 0.0);
                entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(quotaType).setUsage(adjustedUsage).setThrottledTimeMs(throttledTimeMs));
                $this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$3 -> {
                    x$3.addEntryForNode(entryData);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$quotaUsageReportingCallback$11(ReportQuotaConsumptionRequestData.EntryData entryData$2, Tuple2 quotaEntity) {
        return entryData$2.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType((String)quotaEntity._1()).setEntityName((String)quotaEntity._2()));
    }

    public static final /* synthetic */ void $anonfun$quotaUsageReportingCallback$9(ClientQuotaMetricsReporter $this, Map metricTags$1, Tuple2 mapEntry) {
        KafkaMetric metricToReport = (KafkaMetric)$this.metrics.metrics().get(((Function1)mapEntry._2()).apply(metricTags$1));
        if (metricToReport != null) {
            $this.debug((Function0<String> & Serializable)() -> "Reporting " + mapEntry._1() + " metric for " + metricTags$1.toString());
            ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
            metricTags$1.foreach((Function1<Tuple2, Object> & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean(ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$11(entryData, quotaEntity)));
            double metricUsage = BoxesRunTime.unboxToDouble(metricToReport.metricValue());
            entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType((String)mapEntry._1()).setUsage(metricUsage));
            $this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$4 -> {
                x$4.addEntryForNode(entryData);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$quotaUsageReportingCallback$1(ClientQuotaMetricsReporter $this, Map metricTags2) {
        ClientQuotaManager[] quotaEnforcedMetricsManagers = (ClientQuotaManager[])((Object[])new ClientQuotaManager[]{$this.produceQuotaManager, $this.fetchQuotaManager});
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(quotaEnforcedMetricsManagers), (Function1<ClientQuotaManager, Object> & Serializable)quotaManager -> {
            ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$2($this, metricTags2, quotaManager);
            return BoxedUnit.UNIT;
        });
        if (metricTags2.size() == 1 && metricTags2.contains("tenant") && $this.config.elasticCkuEnabled()) {
            scala.collection.mutable.Map nonQuotaEnforcedMetricsToReport = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
            nonQuotaEnforcedMetricsToReport.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("listener-tenant-connection-accept-rate"), (Function1<Map, MetricName> & Serializable)metricTags -> $this.connectionAttemptMetricName((Map<String, String>)metricTags)));
            nonQuotaEnforcedMetricsToReport.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("aggregate-request-rate"), (Function1<Map, MetricName> & Serializable)metricTags -> $this.aggregateRequestRateMetricName((Map<String, String>)metricTags)));
            nonQuotaEnforcedMetricsToReport.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("authenticated-unthrottled-connection-count"), (Function1<Map, MetricName> & Serializable)metricTags -> $this.connectionCountMetricName((Map<String, String>)metricTags)));
            nonQuotaEnforcedMetricsToReport.foreach((Function1<Tuple2, Object> & Serializable)mapEntry -> {
                ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$9($this, metricTags2, mapEntry);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$brokerLoadReportingCallback$7(ClientQuotaMetricsReporter $this, ClientQuotaManager quotaManager$1, DoubleRef totalThroughput$1, Map metricTags) {
        if (quotaManager$1.hasQuotaLimit(CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava())) {
            KafkaMetric clientMetric = (KafkaMetric)$this.metrics.metrics().get(quotaManager$1.clientRateMetricName(metricTags));
            if (clientMetric != null) {
                totalThroughput$1.elem += BoxesRunTime.unboxToDouble(clientMetric.metricValue());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$brokerLoadReportingCallback$1(ClientQuotaMetricsReporter $this, ClientQuotaManager quotaManager) {
        Seq activeTenants = (Seq)$this.activeTenantsManager.map((Function1<ActiveTenantsManager, Seq> & Serializable)x$6 -> x$6.getActiveTenants((Function1<Map<String, String>, BoxedUnit>)(Function1<Map, Object> & Serializable)metricTags -> {
            quotaManager.resetQuotaCallback(metricTags);
            return BoxedUnit.UNIT;
        })).getOrElse((Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Map groupedQuotaEntities = activeTenants.groupBy((Function1<Map, Map> & Serializable)tags -> CollectionConverters$.MODULE$.MapHasAsScala(quotaManager.quotaCallback().parentQuotaMetricTags(quotaManager.clientQuotaType(), CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava())).asScala().toMap($less$colon$less$.MODULE$.refl()));
        DoubleRef totalThroughput = DoubleRef.create(0.0);
        Seq topLevelQuotaEntities = (Seq)groupedQuotaEntities.getOrElse(Predef$.MODULE$.Map().empty(), (Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
        topLevelQuotaEntities.foreach((Function1<Map, Object> & Serializable)metricTags -> {
            ClientQuotaMetricsReporter.$anonfun$brokerLoadReportingCallback$7($this, quotaManager, totalThroughput, metricTags);
            return BoxedUnit.UNIT;
        });
        $this.brokerLoad.foreach((Function1<BrokerLoad, Object> & Serializable)x$7 -> {
            x$7.updateReportedUsage(quotaManager.clientQuotaType(), totalThroughput.elem, quotaManager.getBrokerQuotaLimit());
            return BoxedUnit.UNIT;
        });
    }

    public ClientQuotaMetricsReporter(ClientQuotaMetricsReporterConfig config, Metrics metrics, ClientQuotaManager fetchQuotaManager, ClientQuotaManager produceQuotaManager, Option<ActiveTenantsManager> activeTenantsManager, Option<DynamicQuotaReportingRequestThread> dynamicQuotaReportingChannelManager, Option<BrokerLoad> brokerLoad) {
        this.config = config;
        this.metrics = metrics;
        this.fetchQuotaManager = fetchQuotaManager;
        this.produceQuotaManager = produceQuotaManager;
        this.activeTenantsManager = activeTenantsManager;
        this.dynamicQuotaReportingChannelManager = dynamicQuotaReportingChannelManager;
        this.brokerLoad = brokerLoad;
        Logging.$init$(this);
    }
}

