/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Properties;
import kafka.server.ConfigAdminManager;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ConfigAdminManager$ {
    public static final ConfigAdminManager$ MODULE$ = new ConfigAdminManager$();
    private static final Logger log = LoggerFactory.getLogger(ConfigAdminManager.class);

    public Logger log() {
        return log;
    }

    public AlterConfigsRequestData copyWithoutPreprocessed(AlterConfigsRequestData request, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        AlterConfigsRequestData copy = new AlterConfigsRequestData().setValidateOnly(request.validateOnly());
        request.resources().forEach(resource -> {
            if (!processed.containsKey(resource)) {
                copy.resources().mustAdd((ImplicitLinkedHashCollection.Element)resource.duplicate());
                return;
            }
        });
        return copy;
    }

    public AlterConfigsResponseData reassembleLegacyResponse(AlterConfigsRequestData original, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, AlterConfigsResponseData persistentResponses) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        scala.collection.immutable.Map responsesByResource = CollectionConverters$.MODULE$.IteratorHasAsScala(persistentResponses.responses().iterator()).asScala().map((Function1<AlterConfigsResponseData.AlterConfigsResourceResponse, Tuple2> & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<String, Byte>(r.resourceName(), BoxesRunTime.boxToByte(r.resourceType()))), new ApiError(r.errorCode(), r.errorMessage()))).toMap($less$colon$less$.MODULE$.refl());
        original.resources().forEach(r -> {
            ApiError apiError;
            Option option = Option$.MODULE$.apply(preprocessingResponses.get(r));
            if (None$.MODULE$.equals(option)) {
                Option option2 = responsesByResource.get(new Tuple2<String, Byte>(r.resourceName(), BoxesRunTime.boxToByte(r.resourceType())));
                if (None$.MODULE$.equals(option2)) {
                    MODULE$.log().error("The controller returned fewer results than we expected. No response found for " + r + ".");
                    apiError = new ApiError(Errors.UNKNOWN_SERVER_ERROR);
                } else {
                    ApiError err;
                    if (!(option2 instanceof Some)) throw new MatchError(option2);
                    Some some = (Some)option2;
                    apiError = err = (ApiError)some.value();
                }
            } else {
                ApiError err;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                apiError = err = (ApiError)some.value();
            }
            ApiError err = apiError;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(r.resourceName()).setResourceType(r.resourceType()).setErrorCode(err.error().code()).setErrorMessage(err.message()));
        });
        return response;
    }

    public <T> boolean containsDuplicates(Iterable<T> iterable) {
        HashSet previous = new HashSet();
        return !iterable.forall((Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(previous.add(x$1)));
    }

    public Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return (Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(configProps).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return new Tuple2<String, String>(key, KafkaConfig$.MODULE$.loggableValue(resource.type(), key, value));
            }
            throw new MatchError(tuple2);
        });
    }

    public void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        alterConfigOps.foreach((Function1<AlterConfigOp, Object> & Serializable)alterConfigOp -> {
            String configPropName = alterConfigOp.configEntry().name();
            AlterConfigOp.OpType opType = alterConfigOp.opType();
            if (AlterConfigOp.OpType.SET.equals(opType)) {
                return configProps.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
            }
            if (AlterConfigOp.OpType.DELETE.equals(opType)) {
                return configProps.remove(alterConfigOp.configEntry().name());
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                Object oldValueListMinusBlanks;
                if (!ConfigAdminManager$.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidConfigurationException("Config value append is not allowed for config key: " + alterConfigOp.configEntry().name());
                }
                List oldValueList = (List)Option$.MODULE$.apply(configProps.getProperty(alterConfigOp.configEntry().name())).orElse((Function0<Option> & Serializable)() -> Option$.MODULE$.apply(ConfigDef.convertToString((Object)((ConfigDef.ConfigKey)configKeys$1.apply(configPropName$1)).defaultValue, (ConfigDef.Type)ConfigDef.Type.LIST))).filter((Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)))).map((Function1<String, List> & Serializable)x$7 -> Predef$.MODULE$.wrapRefArray((Object[])x$7.split(",")).toList()).getOrElse((Function0<List> & Serializable)() -> package$.MODULE$.List().empty());
                Object appendingValueList = Predef$.MODULE$.wrapRefArray((Object[])alterConfigOp.configEntry().value().split(",")).toList().filter((Function1<String, Object> & Serializable)value -> BoxesRunTime.boxToBoolean(ConfigAdminManager$.$anonfun$prepareIncrementalConfigs$6(oldValueList, value)));
                Object object = oldValueListMinusBlanks = oldValueList.filter((Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(ConfigAdminManager$.$anonfun$prepareIncrementalConfigs$7(s)));
                List newValueList = ((List)appendingValueList).$colon$colon$colon(object);
                return configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                if (!ConfigAdminManager$.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidConfigurationException("Config value subtract is not allowed for config key: " + alterConfigOp.configEntry().name());
                }
                List oldValueList = Predef$.MODULE$.wrapRefArray((Object[])((String)Option$.MODULE$.apply(configProps.getProperty(alterConfigOp.configEntry().name())).orElse((Function0<Option> & Serializable)() -> Option$.MODULE$.apply(ConfigDef.convertToString((Object)((ConfigDef.ConfigKey)configKeys$1.apply(configPropName$1)).defaultValue, (ConfigDef.Type)ConfigDef.Type.LIST))).getOrElse((Function0<String> & Serializable)() -> "")).split(",")).toList();
                List newValueList = (List)oldValueList.diff((Seq)Predef$.MODULE$.wrapRefArray((Object[])alterConfigOp.configEntry().value().split(",")).toList());
                return configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            }
            throw new MatchError(opType);
        });
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply(configName);
        if (configKey == null) {
            throw new InvalidConfigurationException("Unknown config name: " + configName);
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$prepareIncrementalConfigs$6(List oldValueList$1, String value) {
        return !oldValueList$1.contains(value);
    }

    public static final /* synthetic */ boolean $anonfun$prepareIncrementalConfigs$7(String s) {
        return !s.trim().isEmpty();
    }

    private ConfigAdminManager$() {
    }
}

