/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.Fetching$;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaState;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierState;
import kafka.server.TierStateMachine;
import kafka.tier.exceptions.TierPartitionStateClosedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.utils.ExponentialBackoff;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r]c\u0001B&M\u0001EC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003r\u0001\u0011\u0005!\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0004\u0002:\u0001!\t%a\u000f\t\u0011\u0005M\u0003\u0001\"\u0001M\u0003+B\u0001\"!!\u0001\t\u0003a\u00151\u0011\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\u0019\t\u0004\u0001C\u0005\u0007gA\u0001b!\u0010\u0001\t\u0003a5q\b\u0005\t\u0007\u001f\u0002A\u0011\u0001'\u0004R\u001d9\u0011Q\u0017'\t\u0002\u0005]fAB&M\u0011\u0003\tI\f\u0003\u0004r\u001d\u0011\u0005\u0011\u0011\u0019\u0004\u0007\u0003\u0007t\u0001)!2\t\u0015\u0005\u0015\bC!f\u0001\n\u0003\t9\u000f\u0003\u0006\u0002jB\u0011\t\u0012)A\u0005\u0003/B!\"a;\u0011\u0005+\u0007I\u0011AAw\u0011)\ty\u000f\u0005B\tB\u0003%\u0011Q\u000f\u0005\u000b\u0003c\u0004\"Q3A\u0005\u0002\u0005M\bBCA{!\tE\t\u0015!\u0003\u0002H\"1\u0011\u000f\u0005C\u0001\u0003oD\u0011Ba\u0001\u0011\u0003\u0003%\tA!\u0002\t\u0013\t5\u0001#%A\u0005\u0002\t=\u0001\"\u0003B\u0013!E\u0005I\u0011\u0001B\u0014\u0011%\u0011Y\u0003EI\u0001\n\u0003\u0011i\u0003C\u0005\u00032A\t\t\u0011\"\u0011\u00034!I!\u0011\t\t\u0002\u0002\u0013\u0005!1\t\u0005\n\u0005\u000b\u0002\u0012\u0011!C\u0001\u0005\u000fB\u0011Ba\u0015\u0011\u0003\u0003%\tE!\u0016\t\u0013\t\r\u0004#!A\u0005\u0002\t\u0015\u0004\"\u0003B8!\u0005\u0005I\u0011\tB9\u0011%\u0011)\bEA\u0001\n\u0003\u00129\bC\u0005\u0003zA\t\t\u0011\"\u0011\u0003|!I!Q\u0010\t\u0002\u0002\u0013\u0005#qP\u0004\n\u0005\u0007s\u0011\u0011!E\u0001\u0005\u000b3\u0011\"a1\u000f\u0003\u0003E\tAa\"\t\rE4C\u0011\u0001BP\u0011%\u0011IHJA\u0001\n\u000b\u0012Y\bC\u0005\u0003\"\u001a\n\t\u0011\"!\u0003$\"I!1\u0016\u0014\u0002\u0002\u0013\u0005%Q\u0016\u0005\n\u0005\u007f3\u0013\u0011!C\u0005\u0005\u00034aA!3\u000f\u0001\n-\u0007BCAsY\tU\r\u0011\"\u0001\u0003N\"Q\u0011\u0011\u001e\u0017\u0003\u0012\u0003\u0006IAa4\t\u0015\t]GF!f\u0001\n\u0003\u0011I\u000e\u0003\u0006\u0003\\2\u0012\t\u0012)A\u0005\u0003GB!\"a;-\u0005+\u0007I\u0011AAw\u0011)\ty\u000f\fB\tB\u0003%\u0011Q\u000f\u0005\u000b\u0003cd#Q3A\u0005\u0002\u0005M\bBCA{Y\tE\t\u0015!\u0003\u0002H\"1\u0011\u000f\fC\u0001\u0005;D\u0011Ba\u0001-\u0003\u0003%\tA!;\t\u0013\t5A&%A\u0005\u0002\tM\b\"\u0003B\u0013YE\u0005I\u0011\u0001B|\u0011%\u0011Y\u0003LI\u0001\n\u0003\u00119\u0003C\u0005\u0003|2\n\n\u0011\"\u0001\u0003.!I!\u0011\u0007\u0017\u0002\u0002\u0013\u0005#1\u0007\u0005\n\u0005\u0003b\u0013\u0011!C\u0001\u0005\u0007B\u0011B!\u0012-\u0003\u0003%\tA!@\t\u0013\tMC&!A\u0005B\tU\u0003\"\u0003B2Y\u0005\u0005I\u0011AB\u0001\u0011%\u0011y\u0007LA\u0001\n\u0003\u001a)\u0001C\u0005\u0003v1\n\t\u0011\"\u0011\u0003x!I!\u0011\u0010\u0017\u0002\u0002\u0013\u0005#1\u0010\u0005\n\u0005{b\u0013\u0011!C!\u0007\u00139\u0011b!\u0004\u000f\u0003\u0003E\taa\u0004\u0007\u0013\t%g\"!A\t\u0002\rE\u0001BB9F\t\u0003\u0019I\u0002C\u0005\u0003z\u0015\u000b\t\u0011\"\u0012\u0003|!I!\u0011U#\u0002\u0002\u0013\u000551\u0004\u0005\n\u0005W+\u0015\u0011!CA\u0007KA\u0011Ba0F\u0003\u0003%IA!1\u0003O\r{gN\u001a7vK:$(+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H+[3s'R\fG/Z'bG\"Lg.\u001a\u0006\u0003\u001b:\u000baa]3sm\u0016\u0014(\"A(\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0015,\u0011\u0005M#V\"\u0001'\n\u0005Uc%\u0001\u0005+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f!\t9&,D\u0001Y\u0015\tIf*A\u0003vi&d7/\u0003\u0002\\1\n9Aj\\4hS:<\u0017A\u00027fC\u0012,'\u000f\u0005\u0002T=&\u0011q\f\u0014\u0002\u000f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003'\nL!a\u0019'\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011R\r\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g!\t1w.D\u0001h\u0015\tI\u0006N\u0003\u0002jU\u000611m\\7n_:T!aT6\u000b\u00051l\u0017AB1qC\u000eDWMC\u0001o\u0003\ry'oZ\u0005\u0003a\u001e\u0014!#\u0012=q_:,g\u000e^5bY\n\u000b7m[8gM\u00061A(\u001b8jiz\"Ba\u001d;vmB\u00111\u000b\u0001\u0005\u00069\u0012\u0001\r!\u0018\u0005\u0006A\u0012\u0001\r!\u0019\u0005\u0006I\u0012\u0001\r!Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0007sr\f)!!\u0003\u0011\u0005MS\u0018BA>M\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0011\u0015iX\u00011\u0001\u007f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042a`A\u0001\u001b\u0005A\u0017bAA\u0002Q\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBA\u0004\u000b\u0001\u0007\u00110A\tdkJ\u0014XM\u001c;GKR\u001c\u0007n\u0015;bi\u0016Dq!a\u0003\u0006\u0001\u0004\ti!\u0001\ngKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007\u0003BA\b\u0003gqA!!\u0005\u0002.9!\u00111CA\u0015\u001d\u0011\t)\"a\n\u000f\t\u0005]\u0011Q\u0005\b\u0005\u00033\t\u0019C\u0004\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002U\u0001\u0007yI|w\u000e\u001e \n\u00039L!\u0001\\7\n\u0005=[\u0017BA5k\u0013\r\tY\u0003[\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ty#!\r\u0002#\u0019+Go\u00195SKN\u0004xN\\:f\t\u0006$\u0018MC\u0002\u0002,!LA!!\u000e\u00028\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006TA!a\f\u00022\u0005\tR.Y=cK\u0006#g/\u00198dKN#\u0018\r^3\u0015\r\u0005u\u0012QJA)!\u0015\ty$!\u0013z\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001B;uS2T!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\tE\u0001\u0005PaRLwN\\1m\u0011\u0019\tyE\u0002a\u0001}\u0006\u0011A\u000f\u001d\u0005\u0007\u0003\u000f1\u0001\u0019A=\u0002?5\fG/\u001a:jC2L'0\u001a+jKJ\u001cF/\u0019;f+:$\u0018\u000e\\(gMN,G\u000f\u0006\u0004\u0002X\u0005=\u0014\u0011\u000f\t\u0007\u00033\ny&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003\u0003\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\t'a\u0017\u0003\r\u0019+H/\u001e:f!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5\u001d\u0006\u0019An\\4\n\t\u00055\u0014q\r\u0002\u000f)&,'\u000fT8h'\u0016<W.\u001a8u\u0011\u0015ix\u00011\u0001\u007f\u0011\u001d\t\u0019h\u0002a\u0001\u0003k\nA\u0002^1sO\u0016$xJ\u001a4tKR\u0004B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0003\u0003w\nQa]2bY\u0006LA!a \u0002z\t!Aj\u001c8h\u0003\u0005j\u0017\r^3sS\u0006d\u0017N_3US\u0016\u00148\u000b^1uKVsG/\u001b7PE*,7\r^%e))\t9&!\"\u0002\b\u0006%\u00151\u0013\u0005\u0006{\"\u0001\rA \u0005\b\u0003gB\u0001\u0019AA;\u0011\u001d\tY\t\u0003a\u0001\u0003\u001b\u000ba\u0002^1sO\u0016$xJ\u00196fGRLE\r\u0005\u0003\u0002@\u0005=\u0015\u0002BAI\u0003\u0003\u0012A!V+J\t\"9\u0011Q\u0013\u0005A\u0002\u0005]\u0015A\u0005;be\u001e,GOU3ti>\u0014X-\u00129pG\"\u0004B!a\u001e\u0002\u001a&!\u00111TA=\u0005\rIe\u000e^\u0001\u001ciJ\fgn]5uS>tg)\u001a;dQ&tw\rV5feN#\u0018\r^3\u0015\u000fe\f\t+a)\u0002&\")Q0\u0003a\u0001}\"1\u0011qA\u0005A\u0002eDq!a*\n\u0001\u0004\tI+A\u0005uS\u0016\u00148\u000b^1uKB\u0019\u00111\u0016\u0017\u000f\u0007\u00055VB\u0004\u0003\u00020\u0006Mf\u0002BA\u000e\u0003cK\u0011aT\u0005\u0003\u001b:\u000bqeQ8oM2,XM\u001c;SKBd\u0017nY1GKR\u001c\u0007.\u001a:US\u0016\u00148\u000b^1uK6\u000b7\r[5oKB\u00111KD\n\u0004\u001d\u0005m\u0006\u0003BA<\u0003{KA!a0\u0002z\t1\u0011I\\=SK\u001a$\"!a.\u000335\u000bG/\u001a:jC2L'0\u001b8h)&,'/T3uC\u0012\fG/Y\n\n!\u0005m\u0016qYAg\u0003'\u00042aUAe\u0013\r\tY\r\u0014\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\t\u0005\u0003o\ny-\u0003\u0003\u0002R\u0006e$a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003+\fyN\u0004\u0003\u0002X\u0006mg\u0002BA\u000e\u00033L!!a\u001f\n\t\u0005u\u0017\u0011P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t/a9\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\t\u0005u\u0017\u0011P\u0001\u0011G>l\u0007\u000f\\3uS>t7\u000b^1ukN,\"!a\u0016\u0002#\r|W\u000e\u001d7fi&|gn\u0015;biV\u001c\b%A\tmK\u0006$WM]*uCJ$xJ\u001a4tKR,\"!!\u001e\u0002%1,\u0017\rZ3s'R\f'\u000f^(gMN,G\u000fI\u0001\u000eaJ,g/[8vgN#\u0018\r^3\u0016\u0005\u0005\u001d\u0017A\u00049sKZLw.^:Ti\u0006$X\r\t\u000b\t\u0003s\fi0a@\u0003\u0002A\u0019\u00111 \t\u000e\u00039Aq!!:\u0018\u0001\u0004\t9\u0006C\u0004\u0002l^\u0001\r!!\u001e\t\u000f\u0005Ex\u00031\u0001\u0002H\u0006!1m\u001c9z)!\tIPa\u0002\u0003\n\t-\u0001\"CAs1A\u0005\t\u0019AA,\u0011%\tY\u000f\u0007I\u0001\u0002\u0004\t)\bC\u0005\u0002rb\u0001\n\u00111\u0001\u0002H\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\tU\u0011\t9Fa\u0005,\u0005\tU\u0001\u0003\u0002B\f\u0005Ci!A!\u0007\u000b\t\tm!QD\u0001\nk:\u001c\u0007.Z2lK\u0012TAAa\b\u0002z\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005SQC!!\u001e\u0003\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0018U\u0011\t9Ma\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\u0004\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\u0011\u0011Y$!\u0012\u0002\t1\fgnZ\u0005\u0005\u0005\u007f\u0011ID\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003/\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003J\t=\u0003\u0003BA<\u0005\u0017JAA!\u0014\u0002z\t\u0019\u0011I\\=\t\u0013\tEc$!AA\u0002\u0005]\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003XA1!\u0011\fB0\u0005\u0013j!Aa\u0017\u000b\t\tu\u0013\u0011P\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B1\u00057\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\rB7!\u0011\t9H!\u001b\n\t\t-\u0014\u0011\u0010\u0002\b\u0005>|G.Z1o\u0011%\u0011\t\u0006IA\u0001\u0002\u0004\u0011I%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u001b\u0005gB\u0011B!\u0015\"\u0003\u0003\u0005\r!a&\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u000e\u0002\r\u0015\fX/\u00197t)\u0011\u00119G!!\t\u0013\tEC%!AA\u0002\t%\u0013!G'bi\u0016\u0014\u0018.\u00197ju&tw\rV5fe6+G/\u00193bi\u0006\u00042!a?''\u00151#\u0011\u0012BK!1\u0011YI!%\u0002X\u0005U\u0014qYA}\u001b\t\u0011iI\u0003\u0003\u0003\u0010\u0006e\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005'\u0013iIA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa&\u0003\u001e6\u0011!\u0011\u0014\u0006\u0005\u00057\u000b)%\u0001\u0002j_&!\u0011\u0011\u001dBM)\t\u0011))A\u0003baBd\u0017\u0010\u0006\u0005\u0002z\n\u0015&q\u0015BU\u0011\u001d\t)/\u000ba\u0001\u0003/Bq!a;*\u0001\u0004\t)\bC\u0004\u0002r&\u0002\r!a2\u0002\u000fUt\u0017\r\u001d9msR!!q\u0016B^!\u0019\t9H!-\u00036&!!1WA=\u0005\u0019y\u0005\u000f^5p]BQ\u0011q\u000fB\\\u0003/\n)(a2\n\t\te\u0016\u0011\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tu&&!AA\u0002\u0005e\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0019\t\u0005\u0005o\u0011)-\u0003\u0003\u0003H\ne\"AB(cU\u0016\u001cGOA\tGKR\u001c\u0007.\u001b8h)&,'o\u0015;bi\u0016\u001c\u0012\u0002LA^\u0003\u000f\fi-a5\u0016\u0005\t=\u0007CBA-\u0003?\u0012\t\u000eE\u0002T\u0005'L1A!6M\u0005%!\u0016.\u001a:Ti\u0006$X-A\u0006uS\u0016\u00148+Z4nK:$XCAA2\u00031!\u0018.\u001a:TK\u001elWM\u001c;!))\u0011yN!9\u0003d\n\u0015(q\u001d\t\u0004\u0003wd\u0003bBAsk\u0001\u0007!q\u001a\u0005\b\u0005/,\u0004\u0019AA2\u0011\u001d\tY/\u000ea\u0001\u0003kBq!!=6\u0001\u0004\t9\r\u0006\u0006\u0003`\n-(Q\u001eBx\u0005cD\u0011\"!:7!\u0003\u0005\rAa4\t\u0013\t]g\u0007%AA\u0002\u0005\r\u0004\"CAvmA\u0005\t\u0019AA;\u0011%\t\tP\u000eI\u0001\u0002\u0004\t9-\u0006\u0002\u0003v*\"!q\u001aB\n+\t\u0011IP\u000b\u0003\u0002d\tM\u0011AD2paf$C-\u001a4bk2$H\u0005\u000e\u000b\u0005\u0005\u0013\u0012y\u0010C\u0005\u0003Ru\n\t\u00111\u0001\u0002\u0018R!!qMB\u0002\u0011%\u0011\tfPA\u0001\u0002\u0004\u0011I\u0005\u0006\u0003\u00036\r\u001d\u0001\"\u0003B)\u0001\u0006\u0005\t\u0019AAL)\u0011\u00119ga\u0003\t\u0013\tE3)!AA\u0002\t%\u0013!\u0005$fi\u000eD\u0017N\\4US\u0016\u00148\u000b^1uKB\u0019\u00111`#\u0014\u000b\u0015\u001b\u0019B!&\u0011\u001d\t-5Q\u0003Bh\u0003G\n)(a2\u0003`&!1q\u0003BG\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0007\u001f!\"Ba8\u0004\u001e\r}1\u0011EB\u0012\u0011\u001d\t)\u000f\u0013a\u0001\u0005\u001fDqAa6I\u0001\u0004\t\u0019\u0007C\u0004\u0002l\"\u0003\r!!\u001e\t\u000f\u0005E\b\n1\u0001\u0002HR!1qEB\u0018!\u0019\t9H!-\u0004*Aa\u0011qOB\u0016\u0005\u001f\f\u0019'!\u001e\u0002H&!1QFA=\u0005\u0019!V\u000f\u001d7fi!I!QX%\u0002\u0002\u0003\u0007!q\\\u0001$iJ\fgn]5uS>tW*\u0019;fe&\fG.\u001b>j]\u001e$\u0016.\u001a:NKR\fG-\u0019;b)\u001dI8QGB\u001c\u0007sAQ! \u0006A\u0002yDa!a\u0002\u000b\u0001\u0004I\bbBAT\u0015\u0001\u000711\b\t\u0004\u0003W\u0003\u0012AE8o%\u0016\u001cHo\u001c:f)&,'o\u0015;bi\u0016$\u0002b!\u0011\u0004H\r%3Q\n\t\u0005\u0003o\u001a\u0019%\u0003\u0003\u0004F\u0005e$\u0001B+oSRDQ!`\u0006A\u0002yDqaa\u0013\f\u0001\u0004\t)(A\u000bqe>\u0004xn]3e\u0019>\u001c\u0017\r\u001c'pON#\u0018M\u001d;\t\u000f\u0005\u001d6\u00021\u0001\u0003R\u0006qa-\u001a;dQRKWM]*uCR,GC\u0002Bh\u0007'\u001a)\u0006C\u0003~\u0019\u0001\u0007a\u0010C\u0004\u0003X2\u0001\r!a\u0019")
public class ConfluentReplicaFetcherTierStateMachine
extends TierStateMachine
implements Logging {
    private final LeaderEndPoint leader;
    private final ReplicaManager replicaMgr;
    private final ExponentialBackoff exponentialBackoff;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfluentReplicaFetcherTierStateMachine confluentReplicaFetcherTierStateMachine = this;
        synchronized (confluentReplicaFetcherTierStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
        block4: {
            block3: {
                var8_4 = this.leader.fetchTierMaterializationTarget(topicPartition, currentFetchState.currentLeaderEpoch());
                if (var8_4 == null) break block3;
                leaderStartOffset = var8_4.localLogStartOffset();
                var11_6 = var8_4.tierRestorePoint();
                if (!(var11_6 instanceof Some) || (var13_8 = (TierMaterializationRequirements)(var12_7 = (Some)var11_6).value()) == null) break block3;
                objectId = var13_8.objectId();
                restoreEpoch = var13_8.restoreEpoch();
                status = this.materializeTierStateUntilObjectId(topicPartition, leaderStartOffset, objectId, restoreEpoch);
                this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$1(org.apache.kafka.common.TopicPartition java.util.UUID ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (UUID)objectId));
                v0 = new Tuple2<Future<TierLogSegment>, Long>(status, BoxesRunTime.boxToLong(leaderStartOffset));
                break block4;
            }
            if (var8_4 == null) ** GOTO lbl-1000
            leaderStartOffset = var8_4.localLogStartOffset();
            var19_13 = var8_4.tierRestorePoint();
            if (None$.MODULE$.equals(var19_13)) {
                status = this.materializeTierStateUntilOffset(topicPartition, leaderStartOffset - 1L);
                this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$2(org.apache.kafka.common.TopicPartition long ), ()Ljava/lang/String;)((TopicPartition)topicPartition, (long)leaderStartOffset));
                v0 = new Tuple2<Future<TierLogSegment>, Long>(status, BoxesRunTime.boxToLong(leaderStartOffset));
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError(var8_4);
            }
        }
        var7_15 = v0;
        if (var7_15 == null) {
            throw new MatchError(var7_15);
        }
        completionStatus = var7_15._1();
        leaderStartOffset = var7_15._2$mcJ$sp();
        var6_18 = new Tuple2<Future<TierLogSegment>, Long>(completionStatus, BoxesRunTime.boxToLong(leaderStartOffset));
        completionStatus = var6_18._1();
        leaderStartOffset = var6_18._2$mcJ$sp();
        x$1 = new MaterializingTierMetadata(completionStatus, leaderStartOffset, currentFetchState.state());
        x$2 = currentFetchState.copy$default$1();
        x$3 = currentFetchState.copy$default$2();
        x$4 = currentFetchState.copy$default$3();
        x$5 = currentFetchState.copy$default$4();
        x$6 = currentFetchState.copy$default$5();
        x$7 = currentFetchState.copy$default$7();
        x$8 = currentFetchState.copy$default$8();
        x$9 = currentFetchState.copy$default$9();
        return currentFetchState.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
    }

    @Override
    public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
        MaterializingTierMetadata materializingTierMetadata;
        FetchingTierState fetchingTierState;
        ReplicaState replicaState = currentFetchState.state();
        if (replicaState instanceof FetchingTierState && (fetchingTierState = (FetchingTierState)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionFetchingTierState(tp, currentFetchState, fetchingTierState));
        }
        if (replicaState instanceof MaterializingTierMetadata && (materializingTierMetadata = (MaterializingTierMetadata)replicaState).completionStatus().isDone()) {
            return Optional.of(this.transitionMaterializingTierMetadata(tp, currentFetchState, materializingTierMetadata));
        }
        return Optional.empty();
    }

    public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        return log.materializeTierStateUntilOffset(targetOffset);
    }

    public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        return log.materializeTierStateUntilObjectId(targetOffset, targetObjectId, targetRestoreEpoch);
    }

    private PartitionFetchState transitionFetchingTierState(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchingTierState tierState) {
        PartitionFetchState partitionFetchState;
        try {
            long leaderStartOffset = tierState.leaderStartOffset();
            long proposedLocalLogStart = tierState.tierSegment().endOffset() + 1L;
            long replicationOffset = package$.MODULE$.max(leaderStartOffset, proposedLocalLogStart);
            this.onRestoreTierState(topicPartition, replicationOffset, tierState.completionStatus().get());
            if (leaderStartOffset > proposedLocalLogStart) {
                this.info((Function0<String> & Serializable)() -> "Tier state " + tierState.tierSegment() + " restored. Resuming replicating from leader's local log start offset " + leaderStartOffset + ".");
            } else {
                this.info((Function0<String> & Serializable)() -> "Tier state " + tierState.tierSegment() + " restored. Resuming replicating from one offset past the materialized end offset " + proposedLocalLogStart);
            }
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), replicationOffset, currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), Fetching$.MODULE$, new Some<Object>(BoxesRunTime.boxToInteger(tierState.tierSegment().metadata().tierEpoch())), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts());
        }
        catch (ExecutionException ee) {
            this.error((Function0<String> & Serializable)() -> "Exception fetching tier state.", (Function0<Throwable> & Serializable)() -> ee.getCause());
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), new Some<Object>(BoxesRunTime.boxToLong(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), Fetching$.MODULE$, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
        return partitionFetchState;
    }

    private PartitionFetchState transitionMaterializingTierMetadata(TopicPartition topicPartition, PartitionFetchState currentFetchState, MaterializingTierMetadata tierState) {
        PartitionFetchState partitionFetchState;
        try {
            TierLogSegment tierSegment = tierState.completionStatus().get();
            long leaderStartOffset = tierState.leaderStartOffset();
            Future<TierState> completionStatus = this.fetchTierState(topicPartition, tierSegment);
            this.info((Function0<String> & Serializable)() -> "Restoring tiered state corresponding to " + tierSegment + " for partition " + topicPartition);
            FetchingTierState x$1 = new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, currentFetchState.state());
            Option<Uuid> x$2 = currentFetchState.copy$default$1();
            long x$3 = currentFetchState.copy$default$2();
            Option<Object> x$4 = currentFetchState.copy$default$3();
            int x$5 = currentFetchState.copy$default$4();
            Option<Object> x$6 = currentFetchState.copy$default$5();
            Option<Object> x$7 = currentFetchState.copy$default$7();
            Option<Object> x$8 = currentFetchState.copy$default$8();
            int x$9 = currentFetchState.copy$default$9();
            partitionFetchState = currentFetchState.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() != null && ee.getCause() instanceof TierPartitionStateClosedException) {
                this.info((Function0<String> & Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable> & Serializable)() -> ee.getCause());
            } else {
                this.warn((Function0<String> & Serializable)() -> "Exception completing tier materialization. Retrying initial fetch.", (Function0<Throwable> & Serializable)() -> ee.getCause());
            }
            partitionFetchState = new PartitionFetchState(currentFetchState.topicId(), currentFetchState.fetchOffset(), currentFetchState.lag(), currentFetchState.currentLeaderEpoch(), new Some<Object>(BoxesRunTime.boxToLong(this.exponentialBackoff.backoff((long)currentFetchState.failedAttempts()))), Fetching$.MODULE$, currentFetchState.lastFetchedEpoch(), currentFetchState.replicationSessionId(), currentFetchState.failedAttempts() + 1);
        }
        return partitionFetchState;
    }

    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String> & Serializable)() -> "Restoring tier state " + topicPartition + ": " + tierState);
        log.truncateAndRestoreTierState(proposedLocalLogStart, tierState);
    }

    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
        Partition partition = this.replicaMgr.onlinePartition(topicPartition).get();
        return partition.fetchTierState(tierSegment);
    }

    public static final /* synthetic */ String $anonfun$start$1(TopicPartition topicPartition$1, UUID objectId$1) {
        return "Processed OFFSET_TIERED exception for " + topicPartition$1 + ". Waiting until tier partition state is materialized until objectId " + CoreUtils$.MODULE$.uuidToBase64(objectId$1);
    }

    public static final /* synthetic */ String $anonfun$start$2(TopicPartition topicPartition$1, long leaderStartOffset$1) {
        return "Processed OFFSET_TIERED exception for " + topicPartition$1 + ". Waiting until tier partition state is materialized until " + (leaderStartOffset$1 - 1L);
    }

    public ConfluentReplicaFetcherTierStateMachine(LeaderEndPoint leader, ReplicaManager replicaMgr, ExponentialBackoff exponentialBackoff) {
        this.leader = leader;
        this.replicaMgr = replicaMgr;
        this.exponentialBackoff = exponentialBackoff;
        super(leader, replicaMgr, false);
        Logging.$init$(this);
    }

    public static class FetchingTierState
    implements ReplicaState,
    Product,
    Serializable {
        private final Future<TierState> completionStatus;
        private final TierLogSegment tierSegment;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public Future<TierState> completionStatus() {
            return this.completionStatus;
        }

        public TierLogSegment tierSegment() {
            return this.tierSegment;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public FetchingTierState copy(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            return new FetchingTierState(completionStatus, tierSegment, leaderStartOffset, previousState);
        }

        public Future<TierState> copy$default$1() {
            return this.completionStatus();
        }

        public TierLogSegment copy$default$2() {
            return this.tierSegment();
        }

        public long copy$default$3() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$4() {
            return this.previousState();
        }

        @Override
        public String productPrefix() {
            return "FetchingTierState";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return this.tierSegment();
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this.leaderStartOffset());
                }
                case 3: {
                    return this.previousState();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchingTierState;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "completionStatus";
                }
                case 1: {
                    return "tierSegment";
                }
                case 2: {
                    return "leaderStartOffset";
                }
                case 3: {
                    return "previousState";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.completionStatus()));
            n = Statics.mix(n, Statics.anyHash(this.tierSegment()));
            n = Statics.mix(n, Statics.longHash(this.leaderStartOffset()));
            n = Statics.mix(n, Statics.anyHash(this.previousState()));
            return Statics.finalizeHash(n, 4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FetchingTierState)) return false;
            boolean bl = true;
            if (!bl) return false;
            FetchingTierState fetchingTierState = (FetchingTierState)x$1;
            if (this.leaderStartOffset() != fetchingTierState.leaderStartOffset()) return false;
            Future<TierState> future = this.completionStatus();
            Future<TierState> future2 = fetchingTierState.completionStatus();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            TierLogSegment tierLogSegment = this.tierSegment();
            TierLogSegment tierLogSegment2 = fetchingTierState.tierSegment();
            if (tierLogSegment == null) {
                if (tierLogSegment2 != null) {
                    return false;
                }
            } else if (!((Object)tierLogSegment).equals(tierLogSegment2)) return false;
            ReplicaState replicaState = this.previousState();
            ReplicaState replicaState2 = fetchingTierState.previousState();
            if (replicaState == null) {
                if (replicaState2 != null) {
                    return false;
                }
            } else if (!replicaState.equals(replicaState2)) return false;
            if (!fetchingTierState.canEqual(this)) return false;
            return true;
        }

        public FetchingTierState(Future<TierState> completionStatus, TierLogSegment tierSegment, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.tierSegment = tierSegment;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$(this);
        }
    }

    public static class MaterializingTierMetadata
    implements ReplicaState,
    Product,
    Serializable {
        private final Future<TierLogSegment> completionStatus;
        private final long leaderStartOffset;
        private final ReplicaState previousState;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public Future<TierLogSegment> completionStatus() {
            return this.completionStatus;
        }

        public long leaderStartOffset() {
            return this.leaderStartOffset;
        }

        public ReplicaState previousState() {
            return this.previousState;
        }

        public MaterializingTierMetadata copy(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            return new MaterializingTierMetadata(completionStatus, leaderStartOffset, previousState);
        }

        public Future<TierLogSegment> copy$default$1() {
            return this.completionStatus();
        }

        public long copy$default$2() {
            return this.leaderStartOffset();
        }

        public ReplicaState copy$default$3() {
            return this.previousState();
        }

        @Override
        public String productPrefix() {
            return "MaterializingTierMetadata";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.completionStatus();
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this.leaderStartOffset());
                }
                case 2: {
                    return this.previousState();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaterializingTierMetadata;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "completionStatus";
                }
                case 1: {
                    return "leaderStartOffset";
                }
                case 2: {
                    return "previousState";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.completionStatus()));
            n = Statics.mix(n, Statics.longHash(this.leaderStartOffset()));
            n = Statics.mix(n, Statics.anyHash(this.previousState()));
            return Statics.finalizeHash(n, 3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MaterializingTierMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            MaterializingTierMetadata materializingTierMetadata = (MaterializingTierMetadata)x$1;
            if (this.leaderStartOffset() != materializingTierMetadata.leaderStartOffset()) return false;
            Future<TierLogSegment> future = this.completionStatus();
            Future<TierLogSegment> future2 = materializingTierMetadata.completionStatus();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            ReplicaState replicaState = this.previousState();
            ReplicaState replicaState2 = materializingTierMetadata.previousState();
            if (replicaState == null) {
                if (replicaState2 != null) {
                    return false;
                }
            } else if (!replicaState.equals(replicaState2)) return false;
            if (!materializingTierMetadata.canEqual(this)) return false;
            return true;
        }

        public MaterializingTierMetadata(Future<TierLogSegment> completionStatus, long leaderStartOffset, ReplicaState previousState) {
            this.completionStatus = completionStatus;
            this.leaderStartOffset = leaderStartOffset;
            this.previousState = previousState;
            Product.$init$(this);
        }
    }
}

