/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.AutoTopicCreationManager$;
import kafka.server.ControllerMutationQuota;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\b\u0011\u0001UA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!A\u0005A!A!\u0002\u0013I\u0005\"\u0002*\u0001\t\u0003\u0019\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u0007_\u0002\u0001\u000b\u0011\u0002/\t\u000bA\u0004A\u0011I9\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u00111\f\u0001\u0005\n\u0005u\u0003bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\tY\b\u0001C\u0005\u0003{\u0012q\u0004R3gCVdG/Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0015\t\t\"#\u0001\u0004tKJ4XM\u001d\u0006\u0002'\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00179\u0001\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005\u0001\u0012BA\u0010\u0011\u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\t\u0003C\u0011j\u0011A\t\u0006\u0003GI\tQ!\u001e;jYNL!!\n\u0012\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"!\b\u0015\n\u0005%\u0002\"aC&bM.\f7i\u001c8gS\u001e\fab\u00195b]:,G.T1oC\u001e,'\u000f\u0005\u0002-k5\tQF\u0003\u0002/_\u000511m\\7n_:T!!\u0005\u0019\u000b\u0005M\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!AN\u0017\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s!\tId(D\u0001;\u0015\tYD(A\u0003he>,\bO\u0003\u0002>a\u0005Y1m\\8sI&t\u0017\r^8s\u0013\ty$H\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\bC\u0001\"G\u001b\u0005\u0019%B\u0001#F\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005u\u0012\u0012BA$D\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\u0018\u0001E:iCJ,7i\\8sI&t\u0017\r^8s!\r9\"\nT\u0005\u0003\u0017b\u0011aa\u00149uS>t\u0007CA'Q\u001b\u0005q%BA(=\u0003\u0015\u0019\b.\u0019:f\u0013\t\tfJ\u0001\tTQ\u0006\u0014XmQ8pe\u0012Lg.\u0019;pe\u00061A(\u001b8jiz\"b\u0001V+W/bK\u0006CA\u000f\u0001\u0011\u00151c\u00011\u0001(\u0011\u0015Qc\u00011\u0001,\u0011\u00159d\u00011\u00019\u0011\u0015\u0001e\u00011\u0001B\u0011\u0015Ae\u00011\u0001J\u00039IgN\u001a7jO\"$Hk\u001c9jGN,\u0012\u0001\u0018\t\u0004;\n$W\"\u00010\u000b\u0005}\u0003\u0017\u0001B;uS2T\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n\u00191+\u001a;\u0011\u0005\u0015dgB\u00014k!\t9\u0007$D\u0001i\u0015\tIG#\u0001\u0004=e>|GOP\u0005\u0003Wb\ta\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111\u000eG\u0001\u0010S:4G.[4iiR{\u0007/[2tA\u0005a1M]3bi\u0016$v\u000e]5dgR9!/!\u0007\u0002\"\u0005-\u0002cA:wq6\tAO\u0003\u0002v1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]$(aA*fcB\u0019\u00110a\u0005\u000f\u0007i\fiAD\u0002|\u0003\u000fq1\u0001`A\u0003\u001d\ri\u00181\u0001\b\u0004}\u0006\u0005aBA4\u0000\u0013\u0005!\u0014B\u0001\u001a4\u0013\t\u0019\u0012'\u0003\u0002/a%!\u0011\u0011BA\u0006\u0003\u001diWm]:bO\u0016T!A\f\u0019\n\t\u0005=\u0011\u0011C\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\u0005%\u00111B\u0005\u0005\u0003+\t9BA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\u000b\t\u0005=\u0011\u0011\u0003\u0005\b\u00037I\u0001\u0019AA\u000f\u0003\u0019!x\u000e]5dgB!1/a\be\u0013\t\u0019G\u000fC\u0004\u0002$%\u0001\r!!\n\u0002/\r|g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0007cA\u000f\u0002(%\u0019\u0011\u0011\u0006\t\u0003/\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0007bBA\u0017\u0013\u0001\u0007\u0011qF\u0001\u0017[\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u000e{g\u000e^3yiB!qCSA\u0019!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"\u0002BA\u001c\u0003\u0017\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003w\t)D\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u0002-M,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$RA]A!\u00033Bq!a\u0011\u000b\u0001\u0004\t)%A\bde\u0016\fG/\u00192mKR{\u0007/[2t!\u0019\u0019\u0018q\t3\u0002L%\u0019\u0011\u0011\n;\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002N\u0005Mcb\u0001>\u0002P%!\u0011\u0011KA\t\u0003]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002V\u0005]#AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u0003#\n\t\u0002C\u0004\u0002.)\u0001\r!a\f\u0002+\rdW-\u0019:J]\u001ad\u0017n\u001a5u%\u0016\fX/Z:ugR!\u0011qLA3!\r9\u0012\u0011M\u0005\u0004\u0003GB\"\u0001B+oSRDq!a\u0011\f\u0001\u0004\t)%\u0001\bde\u0016\fG/\u00192mKR{\u0007/[2\u0015\t\u0005-\u00131\u000e\u0005\u0007\u0003[b\u0001\u0019\u00013\u0002\u000bQ|\u0007/[2\u0002!%\u001ch+\u00197jIR{\u0007/[2OC6,G\u0003BA:\u0003s\u00022aFA;\u0013\r\t9\b\u0007\u0002\b\u0005>|G.Z1o\u0011\u0019\ti'\u0004a\u0001I\u0006)b-\u001b7uKJ\u001c%/Z1uC\ndW\rV8qS\u000e\u001cH\u0003BA@\u0003\u000b\u0003baFAA\u0003\u000b\u0012\u0018bAAB1\t1A+\u001e9mKJBq!a\u0007\u000f\u0001\u0004\ti\u0002")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final NodeToControllerChannelManager channelManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final Option<ShareCoordinator> shareCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DefaultAutoTopicCreationManager defaultAutoTopicCreationManager = this;
        synchronized (defaultAutoTopicCreationManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics = tuple2._1();
        Seq<MetadataResponseData.MetadataResponseTopic> uncreatableTopicResponses = tuple2._2();
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple22 = new Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>>(creatableTopics, uncreatableTopicResponses);
        Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics2 = tuple22._1();
        Seq<MetadataResponseData.MetadataResponseTopic> uncreatableTopicResponses2 = tuple22._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = creatableTopics2.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : this.sendCreateTopicRequest(creatableTopics2, metadataRequestContext);
        return (Seq)uncreatableTopicResponses2.$plus$plus(creatableTopicResponses);
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(this.creatableTopics$1);
                this.$outer.debug((Function0<String> & Serializable)() -> "Auto topic creation timed out for " + $this.creatableTopics$1.keys() + ".");
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String> & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with authentication exception");
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String> & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with invalid version exception");
                    return;
                }
                this.$outer.debug((Function0<String> & Serializable)() -> "Auto topic creation completed for " + $this.creatableTopics$1.keys() + " with response " + response.responseBody() + ".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        };
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1<RequestContext, EnvelopeRequest.Builder> & Serializable)context -> {
            short s;
            Option<NodeApiVersions> option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.channelManager.controllerApiVersions()));
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                NodeApiVersions nodeApiVersions = (NodeApiVersions)some.value();
                s = nodeApiVersions.latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError(option);
            }
            short requestVersion = s;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(requestVersion).serializeWithHeader(requestHeader));
        }).getOrElse((Function0<CreateTopicsRequest.Builder> & Serializable)() -> createTopicsRequest);
        this.channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
        scala.collection.immutable.Seq creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1<String, MetadataResponseData.MetadataResponseTopic> & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
        this.info((Function0<String> & Serializable)() -> "Sent auto-creation request for " + creatableTopics.keys() + " to the active controller.");
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String> & Serializable)() -> "Cleared inflight topic creation state for " + creatableTopics);
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        String string = topic;
        switch (string == null ? 0 : string.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(string)) break;
                Properties groupMetadataTopicConfigs = this.groupCoordinator.groupMetadataTopicConfigs();
                String topicPlacementConstraints = groupMetadataTopicConfigs.getProperty("confluent.placement.constraints", "");
                short replicationFactor = topicPlacementConstraints.isEmpty() ? (short)this.config.groupCoordinatorConfig().offsetsTopicReplicationFactor() : (short)-1;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.groupCoordinatorConfig().offsetsTopicPartitions()).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs()));
            }
            case -253293552: {
                if (!"__transaction_state".equals(string)) break;
                short replicationFactor = this.txnCoordinator.placementConstraints().isEmpty() ? (short)this.config.transactionLogConfig().transactionTopicReplicationFactor() : (short)-1;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.transactionLogConfig().transactionTopicPartitions()).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
            case -81655151: {
                Properties properties;
                if (!"__share_group_state".equals(string)) break;
                Option<ShareCoordinator> option = this.shareCoordinator;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ShareCoordinator coordinator = (ShareCoordinator)some.value();
                    properties = coordinator.shareGroupStateTopicConfigs();
                } else if (None$.MODULE$.equals(option)) {
                    properties = new Properties();
                } else {
                    throw new MatchError(option);
                }
                Properties props = properties;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()).setReplicationFactor(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicReplicationFactor()).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(props));
            }
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(string).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private boolean isValidTopicName(String topic) {
        boolean bl;
        try {
            Topic.validate((String)topic);
            bl = true;
        }
        catch (InvalidTopicException invalidTopicException) {
            bl = false;
        }
        return bl;
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1<String, Object> & Serializable)topic -> {
            Option validationError = !this.isValidTopicName((String)topic) ? new Some<Errors>(Errors.INVALID_TOPIC_EXCEPTION) : (!this.inflightTopics().add((String)topic) ? new Some<Errors>(Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            Some<Errors> some = validationError;
            if (some instanceof Some) {
                Some<Errors> some2 = some;
                Errors error = some2.value();
                return uncreatableTopics.$plus$eq(new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(some)) {
                return creatableTopics.put(topic, this.creatableTopic((String)topic));
            }
            throw new MatchError(some);
        });
        return new Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>>(creatableTopics, uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, NodeToControllerChannelManager channelManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, Option<ShareCoordinator> shareCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        Logging.$init$(this);
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

