/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t=u!\u0002\u00180\u0011\u0003!d!\u0002\u001c0\u0011\u00039\u0004\"\u0002 \u0002\t\u0003y\u0004b\u0002!\u0002\u0005\u0004%I!\u0011\u0005\u0007\u0015\u0006\u0001\u000b\u0011\u0002\"\t\u000f-\u000b!\u0019!C\u0001\u0019\"1\u0001+\u0001Q\u0001\n5Cq!U\u0001C\u0002\u0013\u0005A\n\u0003\u0004S\u0003\u0001\u0006I!\u0014\u0005\u0006'\u0006!\t\u0001\u0016\u0005\u0006S\u0006!IA\u001b\u0005\u0006'\u0006!\t!\u001e\u0005\u0006q\u0006!\t!\u001f\u0004\u0006m=\u0002\u00111\f\u0005\u000b\u0003Sj!Q1A\u0005\u0002\u0005-\u0004BCA:\u001b\t\u0005\t\u0015!\u0003\u0002n!Q\u0011QO\u0007\u0003\u0006\u0004%\t!a\u001e\t\u0015\u0005\u0015UB!A!\u0002\u0013\tI\b\u0003\u0006\u0002\b6\u0011)\u0019!C\u0001\u0003\u0013C!\"!&\u000e\u0005\u0003\u0005\u000b\u0011BAF\u0011\u0019qT\u0002\"\u0001\u0002\u0018\"I\u0011\u0011U\u0007C\u0002\u0013E\u00111\u0015\u0005\t\u0003Wk\u0001\u0015!\u0003\u0002&\u00161\u0011QV\u0007\u0001\u0003_+a!!0\u000e\u0001\u0005}VABAl\u001b\u0001\ty\f\u0003\u0005i\u001b\t\u0007I\u0011AAm\u0011\u001d\tY.\u0004Q\u0001\n-D\u0011\"!8\u000e\u0005\u0004%\t!a8\t\u0011\u0005\u0005X\u0002)A\u0005\u0003#D\u0011\"a9\u000e\u0005\u0004%\t!a8\t\u0011\u0005\u0015X\u0002)A\u0005\u0003#Dq!a:\u000e\t\u0003\tI\u000fC\u0004\u0002l6!\t!!;\t\u000f\u00055X\u0002\"\u0005\u0002p\"9\u0011\u0011`\u0007\u0005\n\u0005m\bb\u0002B\n\u001b\u0011\u0005!Q\u0003\u0005\b\u00053iA\u0011\u0001B\u000e\u0011\u001d\u0011)$\u0004C\u0001\u0005oAqAa\u0016\u000e\t\u0003\u0011I\u0006C\u0004\u0003`5!\tA!\u0019\t\u000f\tET\u0002\"\u0001\u0003t!9!qO\u0007\u0005\u0012\te\u0004b\u0002B?\u001b\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u007fjA\u0011\u0001BA\u0011\u001d\u0011))\u0004C\u0001\u0005\u000f\u000ba\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d\u0006\u0003aE\naa]3sm\u0016\u0014(\"\u0001\u001a\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q'A\u0007\u0002_\t1B)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'o\u0005\u0002\u0002qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001b\u0002)\u0011+g-Y;mi\"k\u0017mY!mO>\u0014\u0018\u000e\u001e5n+\u0005\u0011\u0005CA\"I\u001b\u0005!%BA#G\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002+\u0011+g-Y;mi\"k\u0017mY!mO>\u0014\u0018\u000e\u001e5nA\u0005q1)\u001e:sK:$h+\u001a:tS>tW#A'\u0011\u0005er\u0015BA(;\u0005\rIe\u000e^\u0001\u0010\u0007V\u0014(/\u001a8u-\u0016\u00148/[8oA\u0005qQI\u001d:peRKW.Z:uC6\u0004\u0018aD#se>\u0014H+[7fgR\fW\u000e\u001d\u0011\u0002\u0015\r\u0014X-\u0019;f\u00116\f7\rF\u0002V7\u001e\u00042!\u000f,Y\u0013\t9&HA\u0003BeJ\f\u0017\u0010\u0005\u0002:3&\u0011!L\u000f\u0002\u0005\u0005f$X\rC\u0003]\u0013\u0001\u0007Q,A\u0004u_.,g.\u00133\u0011\u0005y+gBA0d!\t\u0001'(D\u0001b\u0015\t\u00117'\u0001\u0004=e>|GOP\u0005\u0003Ij\na\u0001\u0015:fI\u00164\u0017BA%g\u0015\t!'\bC\u0003i\u0013\u0001\u0007Q,A\u0005tK\u000e\u0014X\r^&fs\u0006y1M]3bi\u0016\u001cVm\u0019:fi.+\u0017\u0010\u0006\u0002lgB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0007GJL\b\u000f^8\u000b\u0003A\fQA[1wCbL!A]7\u0003\u0013M+7M]3u\u0017\u0016L\b\"\u0002;\u000b\u0001\u0004)\u0016\u0001C6fs\nLH/Z:\u0015\u0007U3x\u000fC\u0003]\u0017\u0001\u0007Q\fC\u0003i\u0017\u0001\u00071.A\u0006gS2$XM\u001d+pW\u0016tGC\u0003>~\u0003;\tI$a\u0013\u0002VA\u0011\u0011h_\u0005\u0003yj\u0012qAQ8pY\u0016\fg\u000eC\u0003\u007f\u0019\u0001\u0007q0\u0001\nsKF,Xm\u001d;feB\u0013\u0018N\\2ja\u0006d\u0007\u0003BA\u0001\u00033i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005CV$\bN\u0003\u0003\u0002\n\u0005-\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\t\u00055\u0011qB\u0001\u0007G>lWn\u001c8\u000b\u0007I\n\tB\u0003\u0003\u0002\u0014\u0005U\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0018\u0005\u0019qN]4\n\t\u0005m\u00111\u0001\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u001d\ty\u0002\u0004a\u0001\u0003C\taa\\<oKJ\u001c\b#B\u001d\u0002$\u0005\u001d\u0012bAA\u0013u\t1q\n\u001d;j_:\u0004R!!\u000b\u00024}tA!a\u000b\u000209\u0019\u0001-!\f\n\u0003mJ1!!\r;\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000e\u00028\t!A*[:u\u0015\r\t\tD\u000f\u0005\b\u0003wa\u0001\u0019AA\u001f\u0003\u0015!xn[3o!\u0011\ty$a\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n!\u0002Z3mK\u001e\fG/[8o\u0015\u0011\tY$a\u0002\n\t\u0005%\u0013\u0011\t\u0002\u0011)>\\WM\\%oM>\u0014X.\u0019;j_:Dq!!\u0014\r\u0001\u0004\ty%\u0001\bbkRDwN]5{KR{7.\u001a8\u0011\u000be\n\t&\u0018>\n\u0007\u0005M#HA\u0005Gk:\u001cG/[8oc!9\u0011q\u000b\u0007A\u0002\u0005e\u0013AE1vi\"|'/\u001b>f%\u0016\fX/Z:uKJ\u0004R!OA)\u007fj\u001cB!\u0004\u001d\u0002^A!\u0011qLA3\u001b\t\t\tGC\u0002\u0002dE\nQ!\u001e;jYNLA!a\u001a\u0002b\t9Aj\\4hS:<\u0017AB2p]\u001aLw-\u0006\u0002\u0002nA\u0019Q'a\u001c\n\u0007\u0005EtFA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000bi>\\WM\\\"bG\",WCAA=!\u0011\tY(!!\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\n\u0011\"\u001b8uKJt\u0017\r\\:\n\t\u0005\r\u0015Q\u0010\u0002\u0015\t\u0016dWmZ1uS>tGk\\6f]\u000e\u000b7\r[3\u0002\u0017Q|7.\u001a8DC\u000eDW\rI\u0001\u0005i&lW-\u0006\u0002\u0002\fB!\u0011QRAI\u001b\t\tyI\u0003\u0003\u0002d\u0005-\u0011\u0002BAJ\u0003\u001f\u0013A\u0001V5nK\u0006)A/[7fAQA\u0011\u0011TAN\u0003;\u000by\n\u0005\u00026\u001b!9\u0011\u0011\u000e\u000bA\u0002\u00055\u0004bBA;)\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u000f#\u0002\u0019AAF\u0003\u0011awnY6\u0016\u0005\u0005\u0015\u0006cA\"\u0002(&\u0019\u0011\u0011\u0016#\u0003\r=\u0013'.Z2u\u0003\u0015awnY6!\u0005Y\u0019%/Z1uKJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007cB\u001d\u0002R\u0005E\u0016q\u0017\t\u0004k\u0005M\u0016bAA[_\t\t2I]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;\u0011\u0007e\nI,C\u0002\u0002<j\u0012A!\u00168ji\n)\"+\u001a8foJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007#C\u001d\u0002B\u0006\u0015\u0017\u0011[A\\\u0013\r\t\u0019M\u000f\u0002\n\rVt7\r^5p]J\u0002B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\fY!\u0001\u0005qe>$xnY8m\u0013\u0011\ty-!3\u0003\r\u0015\u0013(o\u001c:t!\rI\u00141[\u0005\u0004\u0003+T$\u0001\u0002'p]\u001e\u0014a#\u0012=qSJ,'+Z:q_:\u001cXmQ1mY\n\f7m[\u000b\u0002W\u0006Q1/Z2sKR\\U-\u001f\u0011\u0002!Q|7.\u001a8NCbd\u0015NZ3uS6,WCAAi\u0003E!xn[3o\u001b\u0006DH*\u001b4fi&lW\rI\u0001\u0016I\u00164\u0017-\u001e7u)>\\WM\u001c*f]\u0016<H+[7f\u0003Y!WMZ1vYR$vn[3o%\u0016tWm\u001e+j[\u0016\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0003o\u000b\u0001b\u001d5vi\u0012|wO\\\u0001\fkB$\u0017\r^3DC\u000eDW\r\u0006\u0003\u00028\u0006E\bbBA\u001eE\u0001\u0007\u00111\u001f\t\u0005\u0003\u007f\t)0\u0003\u0003\u0002x\u0006\u0005#a\u0004#fY\u0016<\u0017\r^5p]R{7.\u001a8\u0002/A\u0014X\r]1sKN\u001b'/Y7De\u0016$WM\u001c;jC2\u001cH\u0003BA\u007f\u0005\u001f\u0001bAXA\u0000;\n\r\u0011b\u0001B\u0001M\n\u0019Q*\u00199\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQAA!\u0003\u0002\b\u0005)1o\u0019:b[&!!Q\u0002B\u0004\u0005=\u00196M]1n\u0007J,G-\u001a8uS\u0006d\u0007B\u0002B\tG\u0001\u0007Q,\u0001\u0006i[\u0006\u001c7\u000b\u001e:j]\u001e\f1\"\u001e9eCR,Gk\\6f]R!\u0011q\u0017B\f\u0011\u001d\tY\u0004\na\u0001\u0003g\f1b\u0019:fCR,Gk\\6f]Ra\u0011q\u0017B\u000f\u0005C\u0011)C!\u000b\u0003.!1!qD\u0013A\u0002}\fQa\\<oKJDaAa\t&\u0001\u0004y\u0018A\u0004;pW\u0016t'+Z9vKN$XM\u001d\u0005\b\u0005O)\u0003\u0019AA\u0014\u0003!\u0011XM\\3xKJ\u001c\bb\u0002B\u0016K\u0001\u0007\u0011\u0011[\u0001\u000e[\u0006DH*\u001b4f)&lW-T:\t\u000f\t=R\u00051\u0001\u00032\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0004\u0005g9R\"A\u0007\u0002\u0015I,g.Z<U_.,g\u000e\u0006\u0006\u00028\ne\"Q\bB'\u0005#BaAa\u000f'\u0001\u0004y\u0018!\u00039sS:\u001c\u0017\u000e]1m\u0011\u001d\u0011yD\na\u0001\u0005\u0003\nA\u0001[7bGB!!1\tB%\u001b\t\u0011)EC\u0002\u0003H\u0019\u000b1A\\5p\u0013\u0011\u0011YE!\u0012\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0003P\u0019\u0002\r!!5\u0002\u001fI,g.Z<MS\u001a,G+[7f\u001bNDqAa\u0015'\u0001\u0004\u0011)&A\u0007sK:,woQ1mY\n\f7m\u001b\t\u0004\u0005gA\u0012AE4fi\u0012+G.Z4bi&|g\u000eV8lK:$B!a=\u0003\\!9!QL\u0014A\u0002\u0005u\u0012!\u0003;pW\u0016t\u0017J\u001c4p\u0003-)\u0007\u0010]5sKR{7.\u001a8\u0015\u0015\u0005]&1\rB3\u0005O\u0012Y\u0007\u0003\u0004\u0003<!\u0002\ra \u0005\b\u0005\u007fA\u0003\u0019\u0001B!\u0011\u001d\u0011I\u0007\u000ba\u0001\u0003#\f\u0001#\u001a=qSJ,G*\u001b4f)&lW-T:\t\u000f\t5\u0004\u00061\u0001\u0003p\u00051R\r\u001f9je\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002\u00034e\t1B]3n_Z,Gk\\6f]R!\u0011q\u0017B;\u0011\u0015a\u0016\u00061\u0001^\u0003-\u0011X-\\8wK\u000e\u000b7\r[3\u0015\t\u0005]&1\u0010\u0005\u00069*\u0002\r!X\u0001\rKb\u0004\u0018N]3U_.,gn]\u0001\u0017O\u0016$\u0018\t\u001c7U_.,g.\u00138g_Jl\u0017\r^5p]V\u0011!1\u0011\t\u0007\u0003S\t\u0019$!\u0010\u0002\u0013\u001d,G\u000fV8lK:\u001cH\u0003\u0002BE\u0005\u0017\u0003b!!\u000b\u00024\u0005M\bB\u0002=.\u0001\u0004\u0011i\t\u0005\u0004:\u0003#\niD\u001f")
public class DelegationTokenManager
implements Logging {
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final Object lock;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal requesterPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken, Function1<KafkaPrincipal, Object> authorizeRequester) {
        return DelegationTokenManager$.MODULE$.filterToken(requesterPrincipal, owners, token, authorizeToken, authorizeRequester);
    }

    public static byte[] createHmac(String tokenId, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(tokenId, secretKey);
    }

    public static byte[] createHmac(String tokenId, String secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(tokenId, secretKey);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public Object lock() {
        return this.lock;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public void startup() {
    }

    public void shutdown() {
    }

    public void updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, CollectionConverters$.MODULE$.MapHasAsJava(scramCredentialMap).asJava());
    }

    private Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(ScramMechanism.values()), (Function1<ScramMechanism, Object> & Serializable)mechanism -> {
            scramCredentialMap.update(mechanism.mechanismName(), DelegationTokenManager.scramCredential$1(mechanism, hmacString));
            return BoxedUnit.UNIT;
        });
        return scramCredentialMap.toMap($less$colon$less$.MODULE$.refl());
    }

    public void updateToken(DelegationToken token) {
        this.updateCache(token);
    }

    public void createToken(KafkaPrincipal owner, KafkaPrincipal tokenRequester, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        throw new IllegalStateException("API createToken was not forwarded to a handler.");
    }

    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        throw new IllegalStateException("API renewToken was not forwarded to a handler.");
    }

    public DelegationToken getDelegationToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        throw new IllegalStateException("API expireToken was not forwarded to a handler.");
    }

    public void removeToken(String tokenId) {
        this.removeCache(tokenId);
    }

    public void removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach((Function1<TokenInformation, Object> & Serializable)tokenInfo -> {
                DelegationTokenManager.$anonfun$expireTokens$1(this, tokenInfo);
                return BoxedUnit.UNIT;
            });
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.tokenCache().tokens()).asScala().toList();
    }

    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        return ((List)this.getAllTokenInformation().filter((Function1)filterToken)).map((Function1<TokenInformation, DelegationToken> & Serializable)token -> this.getDelegationToken((TokenInformation)token));
    }

    private static final ScramCredential scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public static final /* synthetic */ void $anonfun$expireTokens$1(DelegationTokenManager $this, TokenInformation tokenInfo) {
        long now = $this.time().milliseconds();
        if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
            $this.info((Function0<String> & Serializable)() -> "Delegation token expired for token: " + tokenInfo.tokenId() + " for owner: " + tokenInfo.owner());
            $this.removeToken(tokenInfo.tokenId());
            return;
        }
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[Token Manager on Node " + config.brokerId() + "]: ");
        this.lock = new Object();
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenSecretKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(keyBytes)) ? null : DelegationTokenManager$.MODULE$.kafka$server$DelegationTokenManager$$createSecretKey(keyBytes);
        this.tokenMaxLifetime = Predef$.MODULE$.Long2long(config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = Predef$.MODULE$.Long2long(config.delegationTokenExpiryTimeMs());
    }
}

