/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicLogConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005)<Q!\u0004\b\t\u0002M1Q!\u0006\b\t\u0002YAQ!H\u0001\u0005\u0002yAqaH\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u00043\u0003\u0001\u0006I!\t\u0004\u0005+9\u00011\u0007\u0003\u0005>\u000b\t\u0005\t\u0015!\u0003?\u0011!yQA!A!\u0002\u0013!\u0005\"B\u000f\u0006\t\u00039\u0005\"B&\u0006\t\u0003\u0002\u0003\"\u0002'\u0006\t\u0003j\u0005\"\u0002,\u0006\t\u00139\u0006\"B3\u0006\t\u00032\u0017\u0001\u0005#z]\u0006l\u0017n\u0019'pO\u000e{gNZ5h\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u000b\u0002\u001b\u0005q!\u0001\u0005#z]\u0006l\u0017n\u0019'pO\u000e{gNZ5h'\t\tq\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\tQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001\"!\r\u0011SeJ\u0007\u0002G)\u0011A%G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0014$\u0005\r\u0019V\r\u001e\t\u0003Q=r!!K\u0017\u0011\u0005)JR\"A\u0016\u000b\u00051\u0012\u0012A\u0002\u001fs_>$h(\u0003\u0002/3\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq\u0013$\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!'\u0011)q\u0003N\u001c\u0011\u0005Q)\u0014B\u0001\u001c\u000f\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKB\u0011\u0001hO\u0007\u0002s)\u0011!\bE\u0001\u0006kRLGn]\u0005\u0003ye\u0012q\u0001T8hO&tw-\u0001\u0006m_\u001el\u0015M\\1hKJ\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\t\u0002\u00071|w-\u0003\u0002D\u0001\nQAj\\4NC:\fw-\u001a:\u0011\u0005Q)\u0015B\u0001$\u000f\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0015\u0007!K%\n\u0005\u0002\u0015\u000b!)Q\b\u0003a\u0001}!)q\u0002\u0003a\u0001\t\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\tq\u0015\u000b\u0005\u0002\u0019\u001f&\u0011\u0001+\u0007\u0002\u0005+:LG\u000fC\u0003S\u0015\u0001\u00071+A\u0005oK^\u001cuN\u001c4jOB\u0011A\u0003V\u0005\u0003+:\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001R\u000f\u001d3bi\u0016dunZ:D_:4\u0017n\u001a\u000b\u0003\u001dbCQ!W\u0006A\u0002i\u000b\u0011C\\3x\u0005J|7.\u001a:EK\u001a\fW\u000f\u001c;t!\u0011\u00113lJ/\n\u0005q\u001b#aA'baB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&AB(cU\u0016\u001cG/A\u0006sK\u000e|gNZ5hkJ,Gc\u0001(hS\")\u0001\u000e\u0004a\u0001'\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\u0006%2\u0001\ra\u0015")
public class DynamicLogConfig
implements BrokerReconfigurable,
Logging {
    private final LogManager logManager;
    private final KafkaBroker server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicLogConfig dynamicLogConfig = this;
        synchronized (dynamicLogConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        DynamicLogConfig.validateLogLocalRetentionMs$1(newConfig);
        DynamicLogConfig.validateLogLocalRetentionBytes$1(newConfig);
    }

    private void updateLogsConfig(Map<String, Object> newBrokerDefaults) {
        this.logManager.brokerConfigUpdated();
        this.logManager.allLogs().foreach((Function1<AbstractLog, Object> & Serializable)log -> {
            DynamicLogConfig.$anonfun$updateLogsConfig$1(this, newBrokerDefaults, log);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        HashMap<String, Object> newBrokerDefaults = new HashMap<String, Object>(newConfig.extractLogConfigMap());
        this.logManager.reconfigureDefaultLogConfig(new LogConfig(newBrokerDefaults));
        this.updateLogsConfig(CollectionConverters$.MODULE$.MapHasAsScala(newBrokerDefaults).asScala());
    }

    private static final void validateLogLocalRetentionMs$1(KafkaConfig newConfig$4) {
        long logRetentionMs = newConfig$4.logRetentionTimeMillis();
        Long logLocalRetentionMs = Predef$.MODULE$.long2Long(newConfig$4.remoteLogManagerConfig().logLocalRetentionMs());
        if (logRetentionMs != -1L && !BoxesRunTime.equalsNumObject(logLocalRetentionMs, BoxesRunTime.boxToLong(-2L))) {
            if (BoxesRunTime.equalsNumObject(logLocalRetentionMs, BoxesRunTime.boxToLong(-1L))) {
                throw new ConfigException("log.local.retention.ms", (Object)logLocalRetentionMs, "Value must not be -1 as " + ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG + " value is set as " + logRetentionMs + ".");
            }
            if (Predef$.MODULE$.Long2long(logLocalRetentionMs) > logRetentionMs) {
                throw new ConfigException("log.local.retention.ms", (Object)logLocalRetentionMs, "Value must not be more than " + ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG + " property value: " + logRetentionMs);
            }
            return;
        }
    }

    private static final void validateLogLocalRetentionBytes$1(KafkaConfig newConfig$4) {
        Long logRetentionBytes = newConfig$4.logRetentionBytes();
        Long logLocalRetentionBytes = Predef$.MODULE$.long2Long(newConfig$4.remoteLogManagerConfig().logLocalRetentionBytes());
        if (Predef$.MODULE$.Long2long(logRetentionBytes) > -1L && !BoxesRunTime.equalsNumObject(logLocalRetentionBytes, BoxesRunTime.boxToInteger(-2))) {
            if (BoxesRunTime.equalsNumObject(logLocalRetentionBytes, BoxesRunTime.boxToInteger(-1))) {
                throw new ConfigException("log.local.retention.bytes", (Object)logLocalRetentionBytes, "Value must not be -1 as " + ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG + " value is set as " + logRetentionBytes + ".");
            }
            if (Predef$.MODULE$.Long2long(logLocalRetentionBytes) > Predef$.MODULE$.Long2long(logRetentionBytes)) {
                throw new ConfigException("log.local.retention.bytes", (Object)logLocalRetentionBytes, "Value must not be more than " + ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG + " property value: " + logRetentionBytes);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateLogsConfig$2(AbstractLog log$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return log$1.config().overriddenConfigs.contains(k);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateLogsConfig$1(DynamicLogConfig $this, Map newBrokerDefaults$1, AbstractLog log) {
        scala.collection.mutable.Map props = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        props.$plus$plus$eq(newBrokerDefaults$1);
        props.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(log.config().originals()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(DynamicLogConfig.$anonfun$updateLogsConfig$2(log, x0$1))));
        LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava(), log.config().overriddenConfigs);
        $this.server.replicaManager().updateLogConfig(log.topicPartition(), logConfig);
    }

    public DynamicLogConfig(LogManager logManager, KafkaBroker server) {
        this.logManager = logManager;
        this.server = server;
        Logging.$init$(this);
    }
}

