/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.server.AbstractRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001B\u0007\u000f\u0001MA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b5\u0003A\u0011\u0001(\t\u000bY\u0003A\u0011I,\t\u000b\u001d\u0004A\u0011\t5\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002bBA\u0019\u0001\u0011%\u00111\u0007\u0002$\tft\u0017-\\5d#V|G/\u0019)vE2L7\u000f[5oOJ+\u0017/^3tiRC'/Z1e\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\r)b\u0003G\u0007\u0002\u001d%\u0011qC\u0004\u0002\u0016\u0003\n\u001cHO]1diJ+\u0017/^3tiRC'/Z1e!\tIbE\u0004\u0002\u001bI5\t1D\u0003\u0002\u001d;\u00059Q.Z:tC\u001e,'B\u0001\u0010 \u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0003\t\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&7\u0005i\u0002+\u001e2mSND\u0017+^8uCR\u000b'oZ3u%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0002(Q\tIQI\u001c;ss\u0012\u000bG/\u0019\u0006\u0003Km\taaY8oM&<\u0007CA\u000b,\u0013\tacBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB7fiJL7m\u001d\t\u0003_Ej\u0011\u0001\r\u0006\u0003[uI!A\r\u0019\u0003\u000f5+GO]5dg\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"!F\u001b\n\u0005Yr!!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0003sqj\u0011A\u000f\u0006\u0003w}\tqa\u00197jK:$8/\u0003\u0002>u\tia*\u001a;x_J\\7\t\\5f]R\fab[1gW\u0006\u001c6\r[3ek2,'\u000f\u0005\u0002A\t6\t\u0011I\u0003\u0002C\u0007\u0006!Q\u000f^5m\u0015\tyq$\u0003\u0002F\u0003\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"\u0001S&\u000e\u0003%S!AS\u000f\u0002\u000bU$\u0018\u000e\\:\n\u00051K%\u0001\u0002+j[\u0016\fa\u0001P5oSRtDcB(Q#J\u001bF+\u0016\t\u0003+\u0001AQ!K\u0004A\u0002)BQ!L\u0004A\u00029BQaM\u0004A\u0002QBQaN\u0004A\u0002aBQAP\u0004A\u0002}BQAR\u0004A\u0002\u001d\u000bQa\u001d;beR$\"\u0001\u00170\u0011\u0005ecV\"\u0001.\u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0003\tUs\u0017\u000e\u001e\u0005\u0006?\"\u0001\r\u0001Y\u0001\fG>|'\u000fZ5oCR|'\u000f\u0005\u0002bK6\t!M\u0003\u0002dI\u0006)\u0011/^8uC*\u0011q\fE\u0005\u0003M\n\u0014\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0002\u001b\r\u0014X-\u0019;f%\u0016\fX/Z:u)\u0011Iw0a\u00031\u0005)4\bcA6ri:\u0011An\\\u0007\u0002[*\u0011a.H\u0001\te\u0016\fX/Z:ug&\u0011\u0001/\\\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&\u0011!o\u001d\u0002\b\u0005VLG\u000eZ3s\u0015\t\u0001X\u000e\u0005\u0002vm2\u0001A!C<\n\u0003\u0003\u0005\tQ!\u0001y\u0005\ryFeM\t\u0003sr\u0004\"!\u0017>\n\u0005mT&a\u0002(pi\"Lgn\u001a\t\u0003YvL!A`7\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!!\u0001\n\u0001\u0004\t\u0019!\u0001\u0003o_\u0012,\u0007\u0003BA\u0003\u0003\u000fi\u0011!H\u0005\u0004\u0003\u0013i\"\u0001\u0002(pI\u0016Dq!!\u0004\n\u0001\u0004\ty!A\u0004f]R\u0014\u0018.Z:\u0011\u000b\u0005E\u0011\u0011\u0004\r\u000e\u0005\u0005M!b\u0001\"\u0002\u0016)\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005M!!C!se\u0006LH*[:u\u0003\u001d9W\r\u001e(pI\u0016$b!!\t\u0002(\u0005-\u0002#B-\u0002$\u0005\r\u0011bAA\u00135\n1q\n\u001d;j_:Da!!\u000b\u000b\u0001\u0004A\u0012!B3oiJL\b\"CA\u0001\u0015A\u0005\t\u0019AA\u0011\u0003u\tXo\u001c;b)\u0006\u0014x-\u001a;Qk\nd\u0017n\u001d5j]\u001e\u001c\u0015\r\u001c7cC\u000e\\G#\u0001-\u0002'\r\u0014X-\u0019;f\u000b:$(/\u001f$peF+X-^3\u0015\u000ba\u000b)$a\u0010\t\u000f\u0005]B\u00021\u0001\u0002:\u0005Y\u0011/^8uC\u0016sG/\u001b;z!\r\t\u00171H\u0005\u0004\u0003{\u0011'aC)v_R\fWI\u001c;jifDq!!\u0011\r\u0001\u0004\t\u0019%\u0001\trk>$\u0018\rR3tGJL\u0007\u000f^5p]B\u0019\u0011-!\u0012\n\u0007\u0005\u001d#M\u0001\tRk>$\u0018\rR3tGJL\u0007\u000f^5p]\u0002")
public class DynamicQuotaPublishingRequestThread
extends AbstractRequestThread<PublishQuotaTargetRequestData.EntryData> {
    private final KafkaConfig config;
    private final MetadataCache metadataCache;

    @Override
    public void start(QuotaCoordinator coordinator) {
        super.start(coordinator);
        this.schedule("publish-quota-target", () -> this.quotaTargetPublishingCallback(), Predef$.MODULE$.Long2long(this.config.confluentConfig().quotaDynamicPublishingIntervalMs()));
    }

    @Override
    public AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node node, ArrayList<PublishQuotaTargetRequestData.EntryData> entries) {
        PublishQuotaTargetRequestData data = new PublishQuotaTargetRequestData().setEntries(entries);
        return new PublishQuotaTargetRequest.Builder(data);
    }

    @Override
    public Option<Node> getNode(PublishQuotaTargetRequestData.EntryData entry, Option<Node> node) {
        return node.flatMap((Function1<Node, Option> & Serializable)n -> $this.metadataCache.getAliveBrokerNode(n.id(), $this.config.interBrokerListenerName()));
    }

    private void quotaTargetPublishingCallback() {
        if (this.quotaCoordinator().isActive().get()) {
            Iterable<QuotaEntity> quotaEntities = this.quotaCoordinator().quotaStateManager().recomputedQuotaEntities();
            quotaEntities.foreach((Function1<QuotaEntity, Object> & Serializable)quotaEntity -> {
                DynamicQuotaPublishingRequestThread.$anonfun$quotaTargetPublishingCallback$1(this, quotaEntity);
                return BoxedUnit.UNIT;
            });
            this.wakeup();
            return;
        }
    }

    private void createEntryForQueue(QuotaEntity quotaEntity, QuotaDescription quotaDescription) {
        ArrayList entity = new ArrayList();
        quotaEntity.entityTypes().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$1(entity, x0$1)));
        quotaDescription.brokerQuotas().foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$2(this, entity, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$quotaTargetPublishingCallback$1(DynamicQuotaPublishingRequestThread $this, QuotaEntity quotaEntity) {
        if (!$this.quotaCoordinator().isDynamicQuotaComputedByFlexFanout(quotaEntity)) {
            Tuple2<Errors, QuotaDescription> tuple2 = $this.quotaCoordinator().describeQuota(quotaEntity);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Errors error = tuple2._1();
            QuotaDescription quotaDescription = tuple2._2();
            Tuple2<Errors, QuotaDescription> tuple22 = new Tuple2<Errors, QuotaDescription>(error, quotaDescription);
            Errors error2 = tuple22._1();
            QuotaDescription quotaDescription2 = tuple22._2();
            Errors errors = error2;
            if (Errors.NONE.equals(errors)) {
                $this.createEntryForQueue(quotaEntity, quotaDescription2);
                return;
            }
            $this.warn((Function0<String> & Serializable)() -> "Failed to describe quota for entity " + quotaEntity + " due to " + error2);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$createEntryForQueue$1(ArrayList entity$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String entityType = (String)tuple2._1();
            String entityName = (String)tuple2._2();
            return entity$1.add(new PublishQuotaTargetRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$createEntryForQueue$3(ArrayList quotas$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String quotaType = (String)tuple2._1();
            double quotaValue = tuple2._2$mcD$sp();
            return quotas$1.add(new PublishQuotaTargetRequestData.QuotaData().setQuotaType(quotaType).setQuota(quotaValue));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$createEntryForQueue$2(DynamicQuotaPublishingRequestThread $this, ArrayList entity$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            Map perBrokerQuota = (Map)tuple2._2();
            ArrayList quotas = new ArrayList();
            perBrokerQuota.foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(DynamicQuotaPublishingRequestThread.$anonfun$createEntryForQueue$3(quotas, x0$3)));
            PublishQuotaTargetRequestData.EntryData entry = new PublishQuotaTargetRequestData.EntryData().setEntity((List)entity$1).setQuotas(quotas);
            Option<Node> destination = $this.metadataCache.getAliveBrokerNode(brokerId, $this.config.interBrokerListenerName());
            $this.addEntryForNode(entry, destination);
            return;
        }
        throw new MatchError(tuple2);
    }

    public DynamicQuotaPublishingRequestThread(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, NetworkClient networkClient, KafkaScheduler kafkaScheduler, Time time) {
        this.config = config;
        this.metadataCache = metadataCache;
        super(config, metrics, networkClient, kafkaScheduler, time, "Quota Publishing");
    }
}

