/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionCacheShard;
import kafka.server.FullFetchContext$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dt!B\f\u0019\u0011\u0003ib!B\u0010\u0019\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%iA\u000b\u0005\u0007k\u0005\u0001\u000bQB\u0016\u0007\t}A\u0002A\u000e\u0005\tu\u0015\u0011)\u0019!C\u0005w!A\u0011*\u0002B\u0001B\u0003%A\b\u0003\u0005K\u000b\t\u0015\r\u0011\"\u0003L\u0011!yUA!A!\u0002\u0013a\u0005\u0002\u0003)\u0006\u0005\u000b\u0007I\u0011B)\t\u0011\u0005,!\u0011!Q\u0001\nIC\u0001BY\u0003\u0003\u0006\u0004%Ia\u0019\u0005\tO\u0016\u0011\t\u0011)A\u0005I\"A\u0001.\u0002BC\u0002\u0013%1\r\u0003\u0005j\u000b\t\u0005\t\u0015!\u0003e\u0011\u00159S\u0001\"\u0001k\u0011\u00159S\u0001\"\u0001r\u0011!IS\u0001#b\u0001\n\u0003R\u0003\"B>\u0006\t\u0003b\bbBA\u0006\u000b\u0011\u0005\u0013Q\u0002\u0005\b\u0003?)A\u0011IA\u0011\u0011\u001d\t)%\u0002C!\u0003\u000f\n\u0001CR;mY\u001a+Go\u00195D_:$X\r\u001f;\u000b\u0005eQ\u0012AB:feZ,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AH\u0001\u000e\u0003a\u0011\u0001CR;mY\u001a+Go\u00195D_:$X\r\u001f;\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u00051An\\4hKJ,\u0012a\u000b\t\u0003YMj\u0011!\f\u0006\u0003]=\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001M\u0019\u0002\u0011QL\b/Z:bM\u0016T\u0011AM\u0001\u0004G>l\u0017B\u0001\u001b.\u0005\u0019aunZ4fe\u00069An\\4hKJ\u00043cA\u0003\"oA\u0011a\u0004O\u0005\u0003sa\u0011ABR3uG\"\u001cuN\u001c;fqR\fA\u0001^5nKV\tA\b\u0005\u0002>\u000f6\taH\u0003\u0002@\u0001\u0006)Q\u000f^5mg*\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005m\u0019%B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001eL!\u0001\u0013 \u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u0019B\u0011a$T\u0005\u0003\u001db\u0011\u0011CR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f\u0003\u0019\u0019\u0017m\u00195fA\u0005Ia-\u001a;dQ\u0012\u000bG/Y\u000b\u0002%B!1\u000b\u0017._\u001b\u0005!&BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\u0004\u001b\u0006\u0004\bCA.]\u001b\u0005\u0001\u0015BA/A\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u001f?&\u0011\u0001\r\u0007\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\u0006Qa-\u001a;dQ\u0012\u000bG/\u0019\u0011\u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:\u0016\u0003\u0011\u0004\"AI3\n\u0005\u0019\u001c#a\u0002\"p_2,\u0017M\\\u0001\u000ekN,7\u000fV8qS\u000eLEm\u001d\u0011\u0002\u001d%\u001chI]8n\r>dGn\\<fe\u0006y\u0011n\u001d$s_64u\u000e\u001c7po\u0016\u0014\b\u0005\u0006\u0004lY6tw\u000e\u001d\t\u0003=\u0015AQA\u000f\tA\u0002qBQA\u0013\tA\u00021CQ\u0001\u0015\tA\u0002ICQA\u0019\tA\u0002\u0011DQ\u0001\u001b\tA\u0002\u0011$ba\u001b:tqfT\b\"\u0002\u001e\u0012\u0001\u0004a\u0004\"\u0002;\u0012\u0001\u0004)\u0018AC2bG\",7\u000b[1sIB\u0011aD^\u0005\u0003ob\u0011aCR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f'\"\f'\u000f\u001a\u0005\u0006!F\u0001\rA\u0015\u0005\u0006EF\u0001\r\u0001\u001a\u0005\u0006QF\u0001\r\u0001Z\u0001\u000fO\u0016$h)\u001a;dQ>3gm]3u)\ri\u0018q\u0001\t\u0005Ey\f\t!\u0003\u0002\u0000G\t1q\n\u001d;j_:\u00042AIA\u0002\u0013\r\t)a\t\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\nM\u0001\rAW\u0001\u0005a\u0006\u0014H/\u0001\tg_J,\u0017m\u00195QCJ$\u0018\u000e^5p]R!\u0011qBA\u000b!\r\u0011\u0013\u0011C\u0005\u0004\u0003'\u0019#\u0001B+oSRDq!a\u0006\u0015\u0001\u0004\tI\"A\u0002gk:\u0004rAIA\u000e5z\u000by!C\u0002\u0002\u001e\r\u0012\u0011BR;oGRLwN\u001c\u001a\u0002\u001f\u001d,GOU3ta>t7/Z*ju\u0016$b!a\t\u0002*\u0005m\u0002c\u0001\u0012\u0002&%\u0019\u0011qE\u0012\u0003\u0007%sG\u000fC\u0004\u0002,U\u0001\r!!\f\u0002\u000fU\u0004H-\u0019;fgB!\u0011qFA\u001b\u001d\rq\u0012\u0011G\u0005\u0004\u0003gA\u0012\u0001\u0004$fi\u000eD7+Z:tS>t\u0017\u0002BA\u001c\u0003s\u0011\u0001BU#T!~k\u0015\t\u0015\u0006\u0004\u0003gA\u0002bBA\u001f+\u0001\u0007\u0011qH\u0001\nm\u0016\u00148/[8o\u0013\u0012\u00042AIA!\u0013\r\t\u0019e\t\u0002\u0006'\"|'\u000f^\u0001\u001ekB$\u0017\r^3B]\u0012<UM\\3sCR,'+Z:q_:\u001cX\rR1uCR1\u0011\u0011JA+\u0003/\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\u0002\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005M\u0013Q\n\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\u000f\u0005-b\u00031\u0001\u0002.!9\u0011\u0011\f\fA\u0002\u0005m\u0013!\u00048pI\u0016,e\u000e\u001a9pS:$8\u000fE\u0003T\u0003;\n\t'C\u0002\u0002`Q\u0013A\u0001T5tiB\u00191,a\u0019\n\u0007\u0005\u0015\u0004I\u0001\u0003O_\u0012,\u0007")
public class FullFetchContext
implements FetchContext {
    private Logger logger;
    private final Time time;
    private final FetchSessionCache cache;
    private final Map<TopicIdPartition, PartitionFetchMetadata> fetchData;
    private final boolean usesTopicIds;
    private final boolean isFromFollower;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs, List<Node> nodeEndpoints) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs, nodeEndpoints);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private Map<TopicIdPartition, PartitionFetchMetadata> fetchData() {
        return this.fetchData;
    }

    private boolean usesTopicIds() {
        return this.usesTopicIds;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    private Logger logger$lzycompute() {
        FullFetchContext fullFetchContext = this;
        synchronized (fullFetchContext) {
            if (!this.bitmap$0) {
                this.logger = FullFetchContext$.MODULE$.kafka$server$FullFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply(this.fetchData().get(part)).map((Function1<PartitionFetchMetadata, Object> & Serializable)x$3 -> BoxesRunTime.boxToLong(x$3.fetchOffset()));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        this.fetchData().forEach((topicPartition, partition) -> fun.apply((TopicIdPartition)topicPartition, (PartitionFetchMetadata)partition));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, List<Node> nodeEndpoints) {
        FetchSessionCacheShard cacheShard = this.cache().getNextCacheShard();
        int responseSessionId = cacheShard.maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), this.usesTopicIds(), (Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>>)(Function0<ImplicitLinkedHashCollection> & Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String> & Serializable)() -> "Full fetch context with session id " + responseSessionId + " returning " + this.partitionsToLogString(updates.keySet()));
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates, nodeEndpoints);
    }

    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            PartitionFetchMetadata reqData = this.fetchData().get(part);
            IncrementalPartitionFetchMetadata cachedPartition = new IncrementalPartitionFetchMetadata((TopicIdPartition)part, reqData);
            cachedPartition.maybeUpdateResponseData((FetchResponseData.PartitionData)respData, true);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)cachedPartition);
        });
        return cachedPartitions;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, Map<TopicIdPartition, PartitionFetchMetadata> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.fetchData = fetchData;
        this.usesTopicIds = usesTopicIds;
        this.isFromFollower = isFromFollower;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    public FullFetchContext(Time time, FetchSessionCacheShard cacheShard, Map<TopicIdPartition, PartitionFetchMetadata> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this(time, new FetchSessionCache(new $colon$colon<Nothing$>((Nothing$)((Object)cacheShard), Nil$.MODULE$)), fetchData, usesTopicIds, isFromFollower);
    }
}

