/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2RequestHandler;
import io.confluent.k2.kafka.PartitionRequest;
import io.confluent.k2.kafka.PartitionResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import kafka.server.ClientPartitionHandler;
import kafka.server.K2RequestConversions;
import kafka.server.K2RequestConversions$FetchConverters$;
import kafka.server.K2RequestConversions$OffsetsForTimestampConverters$;
import kafka.server.K2RequestConversions$ProduceConverters$;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaQuota;
import kafka.server.TransactionSupportedOperation;
import kafka.utils.Logging;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.storage.log.FetchPartitionStats;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t]f\u0001\u0002\u000b\u0016\u0001iA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tq\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003<\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011U\u0003!\u0011!Q\u0001\nYCQa\u0019\u0001\u0005\u0002\u0011DqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019)\b\u0001)A\u0005e\")a\u000f\u0001C!o\"9\u00111\u000b\u0001\u0005B\u0005U\u0003\"CAB\u0001E\u0005I\u0011AAC\u0011\u001d\tY\n\u0001C!\u0003;Cq!!6\u0001\t\u0003\n9\u000eC\u0004\u0003r\u0001!\tEa\u001d\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\nA2JM\"mS\u0016tG\u000fU1si&$\u0018n\u001c8IC:$G.\u001a:\u000b\u0005Y9\u0012AB:feZ,'OC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u000e\"OA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0013\u000e\u0003\rR!\u0001J\f\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001a#a\u0002'pO\u001eLgn\u001a\t\u0003Q%j\u0011!F\u0005\u0003UU\u0011ac\u00117jK:$\b+\u0019:uSRLwN\u001c%b]\u0012dWM]\u0001\u000fe\u0016\fX/Z:u\u0011\u0006tG\r\\3s+\u0005i\u0003C\u0001\u00187\u001b\u0005y#B\u0001\r1\u0015\t\t$'\u0001\u0002le)\u00111\u0007N\u0001\nG>tg\r\\;f]RT\u0011!N\u0001\u0003S>L!aN\u0018\u0003!-\u0013$+Z9vKN$\b*\u00198eY\u0016\u0014\u0018a\u0004:fcV,7\u000f\u001e%b]\u0012dWM\u001d\u0011\u0002\u0011\u0015DXmY;u_J,\u0012a\u000f\t\u0003y\rk\u0011!\u0010\u0006\u0003}}\n!bY8oGV\u0014(/\u001a8u\u0015\t\u0001\u0015)\u0001\u0003vi&d'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\tv\u0012\u0001\"\u0012=fGV$xN]\u0001\nKb,7-\u001e;pe\u0002\nA\u0001^5nKV\t\u0001\n\u0005\u0002J%6\t!J\u0003\u0002%\u0017*\u0011A*T\u0001\u0007G>lWn\u001c8\u000b\u0005aq%BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001eL!a\u0015&\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0019i>\u0004\u0018n\u0019)beRLG/[8o)>LE-T1qa\u0016\u0014\b\u0003\u0002\u000fX3vK!\u0001W\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001.\\\u001b\u0005Y\u0015B\u0001/L\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042\u0001\b0a\u0013\tyVD\u0001\u0004PaRLwN\u001c\t\u00035\u0006L!AY&\u0003\tU+\u0018\u000eZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u00154w\r[5\u0011\u0005!\u0002\u0001\"B\u0016\t\u0001\u0004i\u0003\"B\u001d\t\u0001\u0004Y\u0004\"\u0002$\t\u0001\u0004A\u0005\"B+\t\u0001\u00041\u0016!D+oW:|wO\\(gMN,G/F\u0001m!\taR.\u0003\u0002o;\t!Aj\u001c8h\u00039)fn\u001b8po:|eMZ:fi\u0002\n1cQ8ogR\fg\u000e\u001e'fC\u0012,'/\u00129pG\",\u0012A\u001d\t\u00039ML!\u0001^\u000f\u0003\u0007%sG/\u0001\u000bD_:\u001cH/\u00198u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eI\u0001\u000eM\u0016$8\r['fgN\fw-Z:\u0015\u0015a\\\u0018QBA\u0018\u0003s\tI\u0005\u0005\u0002\u001ds&\u0011!0\b\u0002\u0005+:LG\u000fC\u0003}\u001b\u0001\u0007Q0\u0001\u0004qCJ\fWn\u001d\t\u0004}\u0006%Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0004Y><'\u0002BA\u0003\u0003\u000f\tqa\u001d;pe\u0006<WM\u0003\u0002\u0017\u001b&\u0019\u00111B@\u0003\u0017\u0019+Go\u00195QCJ\fWn\u001d\u0005\b\u0003\u001fi\u0001\u0019AA\t\u0003)1W\r^2i\u0013:4wn\u001d\t\u0007\u0003'\tI\"!\b\u000e\u0005\u0005U!bAA\f;\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0011Q\u0003\u0002\u0004'\u0016\f\bc\u0002\u000f\u0002 \u0005\r\u0012\u0011F\u0005\u0004\u0003Ci\"A\u0002+va2,'\u0007E\u0002[\u0003KI1!a\nL\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eE\u0002)\u0003WI1!!\f\u0016\u0005Y\u0001\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\f\u0007bBA\u0019\u001b\u0001\u0007\u00111G\u0001\u0006cV|G/\u0019\t\u0004Q\u0005U\u0012bAA\u001c+\ta!+\u001a9mS\u000e\f\u0017+^8uC\"9\u00111H\u0007A\u0002\u0005u\u0012\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0015ar+a\u0010y!\u0019\t\u0019\"!\u0007\u0002BA9A$a\b\u0002$\u0005\r\u0003c\u0001@\u0002F%\u0019\u0011qI@\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\b\u0003\u0017j\u0001\u0019AA'\u0003q1W\r^2i!\u0006\u0014H/\u001b;j_:\u0004&/\u001e8j]\u001e,e.\u00192mK\u0012\u00042\u0001HA(\u0013\r\t\t&\b\u0002\b\u0005>|G.Z1o\u00035!W\r\\3uKJ+7m\u001c:egRI\u00010a\u0016\u0002\\\u0005\u0015\u0014q\u0010\u0005\u0007\u00033r\u0001\u0019\u00017\u0002\u000fQLW.Z8vi\"9\u0011Q\f\bA\u0002\u0005}\u0013AE8gMN,G\u000fU3s!\u0006\u0014H/\u001b;j_:\u0004b!a\u0005\u0002bec\u0017\u0002BA2\u0003+\u00111!T1q\u0011\u001d\tYD\u0004a\u0001\u0003O\u0002R\u0001H,\u0002ja\u0004r!a\u0005\u0002be\u000bY\u0007\u0005\u0003\u0002n\u0005ed\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005M4*A\u0004nKN\u001c\u0018mZ3\n\t\u0005]\u0014\u0011O\u0001\u001a\t\u0016dW\r^3SK\u000e|'\u000fZ:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002|\u0005u$\u0001\b#fY\u0016$XMU3d_J$7\u000fU1si&$\u0018n\u001c8SKN,H\u000e\u001e\u0006\u0005\u0003o\n\t\bC\u0005\u0002\u0002:\u0001\n\u00111\u0001\u0002N\u0005Q\u0012\r\u001c7po&sG/\u001a:oC2$v\u000e]5d\t\u0016dW\r^5p]\u00069B-\u001a7fi\u0016\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000fSC!!\u0014\u0002\n.\u0012\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016v\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI*a$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\rgKR\u001c\u0007n\u00144gg\u0016$8OR8s)&lWm\u001d;b[B\u001cHc\u0003=\u0002 \u0006%\u0016QWA]\u0003#Dq!!)\u0011\u0001\u0004\t\u0019+\u0001\bm_>\\W\u000f]'fi\u0006$\u0017\r^1\u0011\u0011\u0005M\u0011\u0011MA\u0012\u0003K\u0003b\u0001HA\u0010\u0003Oc\u0007c\u0001\u000f_e\"9\u00111\u0016\tA\u0002\u00055\u0016AD5t_2\fG/[8o\u0019\u00164X\r\u001c\t\u00059y\u000by\u000bE\u0002[\u0003cK1!a-L\u00059I5o\u001c7bi&|g\u000eT3wK2Dq!a.\u0011\u0001\u0004\ti%A\ngKR\u001c\u0007n\u00148ms\u001a\u0013x.\u001c'fC\u0012,'\u000fC\u0004\u0002<A\u0001\r!a/\u0011\u000bq9\u0016Q\u0018=\u0011\u000f\u0005M\u0011\u0011M-\u0002@B!ADXAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BA\u0001\u0003\u000fTA!!3\u0002L\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003\u000bi\u0015\u0002BAh\u0003\u000b\u0014\u0011DR3uG\",G\rV5nKN$\u0018-\u001c9B]\u0012|eMZ:fi\"1\u00111\u001b\tA\u00021\fq\u0001Z3mCfl5/\u0001\bqe>$WoY3SK\u000e|'\u000fZ:\u0015+a\fI.a7\u0002f\u0006%(1\u0001B\u000b\u0005\u0003\u0012YE!\u0017\u0003h!1\u0011\u0011L\tA\u00021Dq!!8\u0012\u0001\u0004\ty.\u0001\u0007sKF,\u0018N]3e\u0003\u000e\\7\u000fE\u0002\u001d\u0003CL1!a9\u001e\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t9/\u0005a\u0001\u0003\u001b\nQ#\u001b8uKJt\u0017\r\u001c+pa&\u001c7/\u00117m_^,G\rC\u0004\u0002lF\u0001\r!!<\u0002\u001bQ\u0014\u0018M\\:bGRLwN\\%e!\u0011\ty/!@\u000f\t\u0005E\u0018\u0011 \t\u0004\u0003glRBAA{\u0015\r\t90G\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mX$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\u0014\tA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003wl\u0002b\u0002B\u0003#\u0001\u0007!qA\u0001\u0014K:$(/[3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\t\t\u0003'\t\t'a\t\u0003\nA!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010-\u000baA]3d_J$\u0017\u0002\u0002B\n\u0005\u001b\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\bbBA\u001e#\u0001\u0007!q\u0003\t\u00069]\u0013I\u0002\u001f\t\b\u0003'\t\t'\u0017B\u000e!\u0011\u0011iBa\u000f\u000f\t\t}!Q\u0007\b\u0005\u0005C\u0011\tD\u0004\u0003\u0003$\t=b\u0002\u0002B\u0013\u0005[qAAa\n\u0003,9!\u00111\u001fB\u0015\u0013\u0005\t\u0016BA(Q\u0013\tAb*\u0003\u0002M\u001b&\u0019!1G&\u0002\u0011I,\u0017/^3tiNLAAa\u000e\u0003:\u0005y\u0001K]8ek\u000e,'+Z:q_:\u001cXMC\u0002\u00034-KAA!\u0010\u0003@\t\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\t]\"\u0011\b\u0005\b\u0005\u0007\n\u0002\u0019\u0001B#\u0003Y!W\r\\1zK\u0012\u0004&o\u001c3vG\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u0002\u000f\u0003HaL1A!\u0013\u001e\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0003NE\u0001\rAa\u0014\u0002;I,7m\u001c:e-\u0006d\u0017\u000eZ1uS>t7\u000b^1ug\u000e\u000bG\u000e\u001c2bG.\u0004R\u0001H,\u0003Ra\u0004r!a\u0005\u0002be\u0013\u0019\u0006\u0005\u0003\u0003\f\tU\u0013\u0002\u0002B,\u0005\u001b\u0011QCU3d_J$g+\u00197jI\u0006$\u0018n\u001c8Ti\u0006$8\u000fC\u0004\u0003\\E\u0001\rA!\u0018\u0002\u0019I,\u0017/^3ti2{7-\u00197\u0011\t\t}#1M\u0007\u0003\u0005CR1\u0001TA\u0004\u0013\u0011\u0011)G!\u0019\u0003\u0019I+\u0017/^3ti2{7-\u00197\t\u000f\t%\u0014\u00031\u0001\u0003l\u0005iBO]1og\u0006\u001cG/[8o'V\u0004\bo\u001c:uK\u0012|\u0005/\u001a:bi&|g\u000eE\u0002)\u0005[J1Aa\u001c\u0016\u0005u!&/\u00198tC\u000e$\u0018n\u001c8TkB\u0004xN\u001d;fI>\u0003XM]1uS>t\u0017\u0001\u00077bgR|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQR)\u0001P!\u001e\u0003\f\"9!q\u000f\nA\u0002\te\u0014A\u0005:fcV,7\u000f^3e\u000bB|7\r[%oM>\u0004b!a\u0005\u0002\u001a\tm\u0004C\u0002\u000f\u0002 \u0001\u0014i\b\u0005\u0003\u0003\u0000\t\u0015e\u0002BA8\u0005\u0003KAAa!\u0002r\u0005yrJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014V-];fgR$\u0015\r^1\n\t\t\u001d%\u0011\u0012\u0002\u0015\u001f\u001a47/\u001a;G_JdU-\u00193feR{\u0007/[2\u000b\t\t\r\u0015\u0011\u000f\u0005\b\u0003w\u0011\u0002\u0019\u0001BG!\u0015arKa$y!\u0019\t\u0019\"!\u0007\u0003\u0012B!!1\u0013BM\u001d\u0011\tyG!&\n\t\t]\u0015\u0011O\u0001!\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0003\u001c\nu%AG(gMN,GOR8s\u0019\u0016\fG-\u001a:U_BL7MU3tk2$(\u0002\u0002BL\u0003c\na\u0004\\3hC\u000eLh)\u001a;dQ>3gm]3ug\u001a{'\u000fV5nKN$\u0018-\u001c9\u0015\u0019\t\r&Q\u0015BU\u0005[\u0013\tL!.\u0011\u000b\u0005M\u0011\u0011\u00047\t\r\t\u001d6\u00031\u0001Z\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DaAa+\u0014\u0001\u0004a\u0017!\u0003;j[\u0016\u001cH/Y7q\u0011\u0019\u0011yk\u0005a\u0001e\u0006iQ.\u0019=Ok6|eMZ:fiNDqAa-\u0014\u0001\u0004\ti%\u0001\bjg\u001a\u0013x.\\\"p]N,X.\u001a:\t\u000f\u0005]6\u00031\u0001\u0002N\u0001")
public class K2ClientPartitionHandler
implements Logging,
ClientPartitionHandler {
    private final K2RequestHandler requestHandler;
    private final Executor executor;
    private final Time time;
    private final Function1<TopicPartition, Option<Uuid>> topicPartitionToIdMapper;
    private final long UnknownOffset;
    private final int ConstantLeaderEpoch;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        K2ClientPartitionHandler k2ClientPartitionHandler = this;
        synchronized (k2ClientPartitionHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public K2RequestHandler requestHandler() {
        return this.requestHandler;
    }

    public Executor executor() {
        return this.executor;
    }

    public Time time() {
        return this.time;
    }

    private long UnknownOffset() {
        return this.UnknownOffset;
    }

    private int ConstantLeaderEpoch() {
        return this.ConstantLeaderEpoch;
    }

    @Override
    public void fetchMessages(FetchParams params, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchInfos, ReplicaQuota quota, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback, boolean fetchPartitionPruningEnabled) {
        K2RequestConversions.FetchConverters.PartitionRequestFetchData partitionRequestFetchData = K2RequestConversions$FetchConverters$.MODULE$.toPartitionRequestFetchData(fetchInfos, this.topicPartitionToIdMapper);
        List<PartitionRequest<FetchRequestData.FetchPartition>> partitionFetchInfos = partitionRequestFetchData.partitionFetchInfos();
        List<TopicIdPartition> unknownFetchByNamePartitions = partitionRequestFetchData.unknownFetchByNamePartitions();
        boolean wasFetchedByName = partitionRequestFetchData.wasFetchedByName();
        long startTimeNs = this.time().nanoseconds();
        if (partitionFetchInfos.isEmpty()) {
            this.executor().execute(() -> this.processResults$1(Collections.emptyList(), null, unknownFetchByNamePartitions, wasFetchedByName, responseCallback, startTimeNs, fetchInfos));
        } else {
            this.requestHandler().fetch(new FetchRequestData().setMaxBytes(params.maxBytes), partitionFetchInfos).whenCompleteAsyncRaw((completed, throwable) -> this.processResults$1((List)completed, (Throwable)throwable, unknownFetchByNamePartitions, wasFetchedByName, responseCallback, startTimeNs, fetchInfos), this.executor());
        }
    }

    @Override
    public void deleteRecords(long timeout, Map<TopicPartition, Object> offsetPerPartition, Function1<Map<TopicPartition, DeleteRecordsResponseData.DeleteRecordsPartitionResult>, BoxedUnit> responseCallback, boolean allowInternalTopicDeletion) {
        throw new UnsupportedOperationException("DELETE_RECORDS is not yet supported in K2");
    }

    @Override
    public boolean deleteRecords$default$4() {
        return false;
    }

    @Override
    public void fetchOffsetsForTimestamps(Map<TopicIdPartition, Tuple2<Option<Object>, Object>> lookupMetadata, Option<IsolationLevel> isolationLevel, boolean fetchOnlyFromLeader, Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback, long delayMs) {
        Set targetPartitions = lookupMetadata.keySet();
        List<PartitionRequest<Long>> partitionRequests = K2RequestConversions$OffsetsForTimestampConverters$.MODULE$.toPartitionRequestOffsetsForTimestamp(lookupMetadata);
        this.requestHandler().listOffsets(partitionRequests).whenCompleteAsyncRaw((completed, throwable) -> {
            block3: {
                try {
                    if (throwable == null) {
                        scala.collection.mutable.Map<TopicPartition, Option<FetchedTimestampAndOffset>> responses = K2RequestConversions$OffsetsForTimestampConverters$.MODULE$.fromPartitionResponseOffsetsResponseData((List<PartitionResponse<ListOffsetsResponseData.ListOffsetsPartitionResponse>>)completed);
                        this.debug((Function0<String> & Serializable)() -> "response for listOffsets on " + targetPartitions + " is " + responses);
                        responseCallback.apply(responses);
                        break block3;
                    }
                    scala.collection.mutable.Map<TopicPartition, Option<FetchedTimestampAndOffset>> responses = K2RequestConversions$OffsetsForTimestampConverters$.MODULE$.fromThrowable((Throwable)throwable, targetPartitions);
                    this.error((Function0<String> & Serializable)() -> "error response for listOffsets on " + targetPartitions + " is " + responses, (Function0<Throwable> & Serializable)() -> throwable);
                    responseCallback.apply(responses);
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "fetchOffsetsForTimestamp request result ret: " + completed + " throwable: " + throwable + " complete block throwable: " + e);
                }
            }
        }, this.executor());
    }

    @Override
    public void produceRecords(long timeout, short requiredAcks, boolean internalTopicsAllowed, String transactionId, Map<TopicIdPartition, MemoryRecords> entriesPerPartition, Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit> responseCallback, Function0<BoxedUnit> delayedProduceCallback, Function1<Map<TopicPartition, RecordValidationStats>, BoxedUnit> recordValidationStatsCallback, RequestLocal requestLocal, TransactionSupportedOperation transactionSupportedOperation) {
        if (requiredAcks != -1) {
            Set targetPartitions = entriesPerPartition.keySet();
            scala.collection.mutable.Map responses = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
            targetPartitions.foreach((Function1<TopicIdPartition, Option> & Serializable)tpid -> responses.put(tpid.topicPartition(), new ProduceResponse.PartitionResponse(Errors.INVALID_REQUIRED_ACKS)));
            if (this.isDebugEnabled()) {
                this.debug((Function0<String> & Serializable)() -> "response for produce to " + targetPartitions + " is " + responses);
            }
            responseCallback.apply(responses);
            return;
        }
        List<PartitionRequest<MemoryRecords>> partitionData = K2RequestConversions$ProduceConverters$.MODULE$.toPartitionRequestMemoryRecords(entriesPerPartition);
        Set targetPartitions = entriesPerPartition.keySet();
        this.debug((Function0<String> & Serializable)() -> "produceRecords starting request with partitions " + targetPartitions);
        this.requestHandler().produce(partitionData).whenCompleteAsyncRaw((completed, throwable) -> {
            block3: {
                try {
                    if (throwable == null) {
                        scala.collection.mutable.Map<TopicPartition, ProduceResponse.PartitionResponse> responses = K2RequestConversions$ProduceConverters$.MODULE$.fromPartitionProduceResponse((List<PartitionResponse<ProduceResponseData.PartitionProduceResponse>>)completed);
                        this.debug((Function0<String> & Serializable)() -> "response for produce to " + targetPartitions + " is " + responses);
                        responseCallback.apply(responses);
                        break block3;
                    }
                    scala.collection.mutable.Map<TopicPartition, ProduceResponse.PartitionResponse> responses = K2RequestConversions$ProduceConverters$.MODULE$.fromThrowable((Throwable)throwable, targetPartitions);
                    this.error((Function0<String> & Serializable)() -> "error response for produce to " + targetPartitions + " is " + responses, (Function0<Throwable> & Serializable)() -> throwable);
                    responseCallback.apply(responses);
                }
                catch (Throwable e) {
                    this.error((Function0<String> & Serializable)() -> "produceRecords request to " + targetPartitions + " result ret: (" + completed + ", " + throwable + ")", (Function0<Throwable> & Serializable)() -> e);
                }
            }
        }, this.executor());
        delayedProduceCallback.apply$mcV$sp();
    }

    @Override
    public void lastOffsetForLeaderEpoch(Seq<Tuple2<Uuid, OffsetForLeaderEpochRequestData.OffsetForLeaderTopic>> requestedEpochInfo, Function1<Seq<OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult>, BoxedUnit> responseCallback) {
        ArrayList<PartitionRequest<Long>> listOffsetRequests = new ArrayList<PartitionRequest<Long>>();
        requestedEpochInfo.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(K2ClientPartitionHandler.$anonfun$lastOffsetForLeaderEpoch$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$1 -> {
            K2ClientPartitionHandler.$anonfun$lastOffsetForLeaderEpoch$2(listOffsetRequests, x$1);
            return BoxedUnit.UNIT;
        });
        Buffer requestPartitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(listOffsetRequests).asScala().map((Function1<PartitionRequest, TopicIdPartition> & Serializable)x$2 -> x$2.topicIdPartition());
        this.requestHandler().listOffsets(listOffsetRequests).whenCompleteAsyncRaw((result, throwable) -> {
            try {
                scala.collection.mutable.Map responses = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
                if (throwable != null) {
                    requestPartitions.foreach((Function1<TopicIdPartition, Object> & Serializable)tid -> BoxesRunTime.boxToBoolean(K2ClientPartitionHandler.$anonfun$lastOffsetForLeaderEpoch$7(this, responses, throwable, tid)));
                } else {
                    CollectionConverters$.MODULE$.ListHasAsScala(result).asScala().foreach((Function1<PartitionResponse, Object> & Serializable)resp -> BoxesRunTime.boxToBoolean(K2ClientPartitionHandler.$anonfun$lastOffsetForLeaderEpoch$9(this, responses, resp)));
                }
                responseCallback.apply(responses.values().toSeq());
            }
            catch (Throwable e) {
                this.error((Function0<String> & Serializable)() -> "lastOffsetForLeaderEpoch request for " + requestPartitions + " result ret: " + result + " throwable: " + e);
            }
        }, this.executor());
    }

    @Override
    public Seq<Object> legacyFetchOffsetsForTimestamp(TopicPartition topicPartition, long timestamp, int maxNumOffsets, boolean isFromConsumer, boolean fetchOnlyFromLeader) {
        throw new UnsupportedOperationException("LIST_OFFSETS version 0 is not supported in K2");
    }

    private static final void addUnknowns$1(scala.collection.mutable.Map responses, List unknownFetchByNamePartitions$1) {
        FetchPartitionStats fetchStats = new FetchPartitionStats(0L, 0L);
        unknownFetchByNamePartitions$1.forEach(tp -> responses.put(tp, new FetchPartitionData(Errors.UNKNOWN_TOPIC_OR_PARTITION, -1L, -1L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false, fetchStats)));
    }

    private final void processResults$1(List completed, Throwable throwable, List unknownFetchByNamePartitions$1, boolean wasFetchedByName$1, Function1 responseCallback$1, long startTimeNs$1, Seq fetchInfos$1) {
        if (throwable == null) {
            scala.collection.mutable.Map<TopicIdPartition, FetchPartitionData> responses = K2RequestConversions$FetchConverters$.MODULE$.fromPartitionResponseFetchData(completed, wasFetchedByName$1, new FetchPartitionStats(0L, 0L));
            K2ClientPartitionHandler.addUnknowns$1(responses, unknownFetchByNamePartitions$1);
            responseCallback$1.apply(responses.toSeq());
            return;
        }
        FetchPartitionStats fetchStats = new FetchPartitionStats(startTimeNs$1 - this.time().nanoseconds(), 0L);
        scala.collection.mutable.Map<TopicIdPartition, FetchPartitionData> responses = K2RequestConversions$FetchConverters$.MODULE$.fromThrowable(throwable, fetchInfos$1, fetchStats);
        K2ClientPartitionHandler.addUnknowns$1(responses, unknownFetchByNamePartitions$1);
        this.error((Function0<String> & Serializable)() -> "error response for for fetch on " + fetchInfos$1 + " is " + throwable, (Function0<Throwable> & Serializable)() -> throwable);
        responseCallback$1.apply(responses.toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$lastOffsetForLeaderEpoch$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$lastOffsetForLeaderEpoch$3(OffsetForLeaderEpochRequestData.OffsetForLeaderPartition check$ifrefutable$2) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition offsetForLeaderPartition = check$ifrefutable$2;
        return offsetForLeaderPartition != null;
    }

    public static final /* synthetic */ boolean $anonfun$lastOffsetForLeaderEpoch$4(Uuid topicId$1, OffsetForLeaderEpochRequestData.OffsetForLeaderTopic req$1, ArrayList listOffsetRequests$1, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition p) {
        if (topicId$1.equals((Object)Uuid.ZERO_UUID)) {
            throw new IllegalArgumentException("Unknown topicid incorrectly passed to lastOffsetForLeaderEpoch");
        }
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId$1, p.partition(), req$1.topic());
        return listOffsetRequests$1.add(new PartitionRequest<Long>(topicIdPartition, Predef$.MODULE$.long2Long(-1L)));
    }

    public static final /* synthetic */ void $anonfun$lastOffsetForLeaderEpoch$2(ArrayList listOffsetRequests$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Uuid topicId = (Uuid)tuple2._1();
            OffsetForLeaderEpochRequestData.OffsetForLeaderTopic req = (OffsetForLeaderEpochRequestData.OffsetForLeaderTopic)tuple2._2();
            CollectionConverters$.MODULE$.ListHasAsScala(req.partitions()).asScala().withFilter((Function1<OffsetForLeaderEpochRequestData.OffsetForLeaderPartition, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(K2ClientPartitionHandler.$anonfun$lastOffsetForLeaderEpoch$3(check$ifrefutable$2))).foreach((Function1<OffsetForLeaderEpochRequestData.OffsetForLeaderPartition, Object> & Serializable)p -> BoxesRunTime.boxToBoolean(K2ClientPartitionHandler.$anonfun$lastOffsetForLeaderEpoch$4(topicId, req, listOffsetRequests$1, p)));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$lastOffsetForLeaderEpoch$7(K2ClientPartitionHandler $this, scala.collection.mutable.Map responses$7, Throwable throwable$4, TopicIdPartition tid) {
        OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult responseBuilder = (OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult)responses$7.getOrElseUpdate(tid, (Function0<OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult> & Serializable)() -> new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tid.topic()));
        return responseBuilder.partitions().add(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tid.partition()).setLeaderEpoch($this.ConstantLeaderEpoch()).setEndOffset($this.UnknownOffset()).setErrorCode(Errors.forException((Throwable)throwable$4).code()));
    }

    public static final /* synthetic */ boolean $anonfun$lastOffsetForLeaderEpoch$9(K2ClientPartitionHandler $this, scala.collection.mutable.Map responses$7, PartitionResponse resp) {
        TopicIdPartition tid = resp.topicIdPartition();
        OffsetForLeaderEpochResponseData.EpochEndOffset partitionResponse = new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch($this.ConstantLeaderEpoch()).setPartition(tid.partition()).setEndOffset(((ListOffsetsResponseData.ListOffsetsPartitionResponse)resp.response()).offset()).setErrorCode(((ListOffsetsResponseData.ListOffsetsPartitionResponse)resp.response()).errorCode());
        OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult responseBuilder = (OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult)responses$7.getOrElseUpdate(tid, (Function0<OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult> & Serializable)() -> new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tid.topic()));
        return responseBuilder.partitions().add(partitionResponse);
    }

    public K2ClientPartitionHandler(K2RequestHandler requestHandler, Executor executor, Time time, Function1<TopicPartition, Option<Uuid>> topicPartitionToIdMapper) {
        this.requestHandler = requestHandler;
        this.executor = executor;
        this.time = time;
        this.topicPartitionToIdMapper = topicPartitionToIdMapper;
        Logging.$init$(this);
        this.UnknownOffset = -1L;
        this.ConstantLeaderEpoch = 0;
    }
}

