/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.rest.BrokerStartupStatusHandle;
import java.io.Serializable;
import kafka.server.BrokerServer;
import kafka.server.KRaftBrokerStartupHandle$;
import kafka.utils.Logging;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\u000e\u001c\u0001\u0002B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\")!\u000b\u0001C\u0001'\")a\u000b\u0001C!/\")1\f\u0001C\u0005/\")A\f\u0001C\u0005/\")Q\f\u0001C\u0005/\"9a\fAA\u0001\n\u0003y\u0006bB1\u0001#\u0003%\tA\u0019\u0005\b[\u0002\t\t\u0011\"\u0011o\u0011\u001d\u0011\b!!A\u0005\u0002MDqa\u001e\u0001\u0002\u0002\u0013\u0005\u0001\u0010C\u0004\u007f\u0001\u0005\u0005I\u0011I@\t\u0013\u00055\u0001!!A\u0005\u0002\u0005=\u0001\"CA\n\u0001\u0005\u0005I\u0011IA\u000b\u0011%\tI\u0002AA\u0001\n\u0003\nY\u0002C\u0005\u0002\u001e\u0001\t\t\u0011\"\u0011\u0002 !I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00131E\u0004\n\u0003OY\u0012\u0011!E\u0001\u0003S1\u0001BG\u000e\u0002\u0002#\u0005\u00111\u0006\u0005\u0007%R!\t!!\u0011\t\u0013\u0005uA#!A\u0005F\u0005}\u0001\"CA\")\u0005\u0005I\u0011QA#\u0011%\tI\u0005FA\u0001\n\u0003\u000bY\u0005C\u0005\u0002XQ\t\t\u0011\"\u0003\u0002Z\tA2JU1gi\n\u0013xn[3s'R\f'\u000f^;q\u0011\u0006tG\r\\3\u000b\u0005qi\u0012AB:feZ,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019b\u0001A\u0011*gez\u0004C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013\u0001\u0002:fgRT!AL\u0018\u0002\u0013\r|gN\u001a7vK:$(\"\u0001\u0019\u0002\u0005%|\u0017B\u0001\u001a,\u0005e\u0011%o\\6feN#\u0018M\u001d;vaN#\u0018\r^;t\u0011\u0006tG\r\\3\u0011\u0005Q:T\"A\u001b\u000b\u0005Yj\u0012!B;uS2\u001c\u0018B\u0001\u001d6\u0005\u001daunZ4j]\u001e\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\u0011:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t~\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\u001d[\u0014a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aR\u001e\u0002\u0011\u0011,G.Z4bi\u0016,\u0012!\u0014\t\u0003\u001d>k\u0011aG\u0005\u0003!n\u0011AB\u0011:pW\u0016\u00148+\u001a:wKJ\f\u0011\u0002Z3mK\u001e\fG/\u001a\u0011\u0002\rqJg.\u001b;?)\t!V\u000b\u0005\u0002O\u0001!)1j\u0001a\u0001\u001b\u000691\u000f^1si\u0016$G#\u0001-\u0011\u0005iJ\u0016B\u0001.<\u0005\u001d\u0011un\u001c7fC:\fQB^3sS\u001aL8\u000b^1si\u0016$\u0017A\u0006<fe&4\u0017PU3qY&\u001c\u0017m]\"bk\u001eDG/\u00169\u0002)Y,'/\u001b4z\u001d\u0016$xo\u001c:l\u0011\u0016\fG\u000e\u001e5z\u0003\u0011\u0019w\u000e]=\u0015\u0005Q\u0003\u0007bB&\t!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0019'FA'eW\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003%)hn\u00195fG.,GM\u0003\u0002kw\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051<'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001c\t\u0003EAL!!]\u0012\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005!\bC\u0001\u001ev\u0013\t18HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002zyB\u0011!H_\u0005\u0003wn\u00121!\u00118z\u0011\u001diH\"!AA\u0002Q\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0001!\u0015\t\u0019!!\u0003z\u001b\t\t)AC\u0002\u0002\bm\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY!!\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00041\u0006E\u0001bB?\u000f\u0003\u0003\u0005\r!_\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002p\u0003/Aq!`\b\u0002\u0002\u0003\u0007A/\u0001\u0005iCND7i\u001c3f)\u0005!\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003=\fa!Z9vC2\u001cHc\u0001-\u0002&!9QPEA\u0001\u0002\u0004I\u0018\u0001G&SC\u001a$(I]8lKJ\u001cF/\u0019:ukBD\u0015M\u001c3mKB\u0011a\nF\n\u0006)\u00055\u0012\u0011\b\t\u0007\u0003_\t)$\u0014+\u000e\u0005\u0005E\"bAA\u001aw\u00059!/\u001e8uS6,\u0017\u0002BA\u001c\u0003c\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\tY$a\u0010\u000e\u0005\u0005u\"B\u0001\u0019&\u0013\rI\u0015Q\b\u000b\u0003\u0003S\tQ!\u00199qYf$2\u0001VA$\u0011\u0015Yu\u00031\u0001N\u0003\u001d)h.\u00199qYf$B!!\u0014\u0002TA!!(a\u0014N\u0013\r\t\tf\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005U\u0003$!AA\u0002Q\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005\t\u0003")
public class KRaftBrokerStartupHandle
implements BrokerStartupStatusHandle,
Logging,
Product,
Serializable {
    private final BrokerServer delegate;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<BrokerServer> unapply(KRaftBrokerStartupHandle x$0) {
        return KRaftBrokerStartupHandle$.MODULE$.unapply(x$0);
    }

    public static KRaftBrokerStartupHandle apply(BrokerServer delegate) {
        return KRaftBrokerStartupHandle$.MODULE$.apply(delegate);
    }

    public static <A> Function1<BrokerServer, A> andThen(Function1<KRaftBrokerStartupHandle, A> g) {
        return KRaftBrokerStartupHandle$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, KRaftBrokerStartupHandle> compose(Function1<A, BrokerServer> g) {
        return KRaftBrokerStartupHandle$.MODULE$.compose(g);
    }

    @Override
    public Iterator<String> productElementNames() {
        return Product.productElementNames$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KRaftBrokerStartupHandle kRaftBrokerStartupHandle = this;
        synchronized (kRaftBrokerStartupHandle) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerServer delegate() {
        return this.delegate;
    }

    @Override
    public boolean started() {
        return this.verifyStarted() && this.verifyNetworkHealthy() && this.verifyReplicasCaughtUp();
    }

    private boolean verifyStarted() {
        BrokerState currentState;
        BrokerState brokerState = currentState = this.delegate().brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        if (!(brokerState != null ? !((Object)((Object)brokerState)).equals((Object)brokerState2) : brokerState2 != null)) {
            return true;
        }
        this.info((Function0<String> & Serializable)() -> "Broker still starting up, current state: " + currentState);
        return false;
    }

    private boolean verifyReplicasCaughtUp() {
        int brokerId = this.delegate().config().brokerId();
        ImmutableMap<String, TopicImage> topicsImage = this.delegate().metadataCache().currentImage().topics().topicsByName();
        return CollectionConverters$.MODULE$.CollectionHasAsScala(topicsImage.values()).asScala().forall((Function1<TopicImage, Object> & Serializable)topicImage -> BoxesRunTime.boxToBoolean(KRaftBrokerStartupHandle.$anonfun$verifyReplicasCaughtUp$1(this, brokerId, topicImage)));
    }

    private boolean verifyNetworkHealthy() {
        return this.delegate().networkHealthManager() == null || this.delegate().networkHealthManager().isStartupComplete();
    }

    public KRaftBrokerStartupHandle copy(BrokerServer delegate) {
        return new KRaftBrokerStartupHandle(delegate);
    }

    public BrokerServer copy$default$1() {
        return this.delegate();
    }

    @Override
    public String productPrefix() {
        return "KRaftBrokerStartupHandle";
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.delegate();
            }
        }
        return Statics.ioobe(x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof KRaftBrokerStartupHandle;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "delegate";
            }
        }
        return (String)Statics.ioobe(x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KRaftBrokerStartupHandle)) return false;
        boolean bl = true;
        if (!bl) return false;
        KRaftBrokerStartupHandle kRaftBrokerStartupHandle = (KRaftBrokerStartupHandle)x$1;
        BrokerServer brokerServer = this.delegate();
        BrokerServer brokerServer2 = kRaftBrokerStartupHandle.delegate();
        if (brokerServer == null) {
            if (brokerServer2 != null) {
                return false;
            }
        } else if (!brokerServer.equals(brokerServer2)) return false;
        if (!kRaftBrokerStartupHandle.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$verifyReplicasCaughtUp$2(int brokerId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            PartitionRegistration partition = (PartitionRegistration)tuple2._2();
            return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partition.replicas), BoxesRunTime.boxToInteger(brokerId$1)) && !ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.intArrayOps(partition.isr), BoxesRunTime.boxToInteger(brokerId$1));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReplicasCaughtUp$1(KRaftBrokerStartupHandle $this, int brokerId$1, TopicImage topicImage) {
        Map underReplicatedPartitions = (Map)CollectionConverters$.MODULE$.MapHasAsScala(topicImage.partitions()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(KRaftBrokerStartupHandle.$anonfun$verifyReplicasCaughtUp$2(brokerId$1, x0$1)));
        if (underReplicatedPartitions.isEmpty()) {
            return true;
        }
        $this.info((Function0<String> & Serializable)() -> "Broker " + brokerId$1 + " still has replicas not in ISR: " + topicImage.name() + " partitions: " + underReplicatedPartitions);
        return false;
    }

    public KRaftBrokerStartupHandle(BrokerServer delegate) {
        this.delegate = delegate;
        Logging.$init$(this);
        Product.$init$(this);
    }
}

